/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.drools.compiler.builder.impl.classbuilder.BeanClassBuilder;
import org.drools.compiler.builder.impl.classbuilder.BuildUtils;
import org.drools.core.factmodel.AnnotationDefinition;
import org.drools.core.factmodel.ClassDefinition;
import org.drools.core.factmodel.FieldDefinition;
import org.drools.core.factmodel.GeneratedFact;
import org.drools.core.factmodel.traits.Thing;
import org.drools.core.factmodel.traits.TraitFieldTMS;
import org.drools.core.phreak.ReactiveObject;
import org.drools.mvel.asm.AsmUtil;
import org.drools.mvel.asm.ClassGenerator;
import org.kie.api.definition.type.FactField;
import org.kie.internal.definition.GenericTypeDefinition;
import org.mvel2.asm.AnnotationVisitor;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Opcodes;
import org.mvel2.asm.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBeanClassBuilder
implements Opcodes,
BeanClassBuilder,
Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultBeanClassBuilder.class);
    protected boolean debug = false;

    public DefaultBeanClassBuilder() {
        this("true".equalsIgnoreCase(System.getProperty("org.drools.classbuilder.debug")));
    }

    public DefaultBeanClassBuilder(boolean debug) {
        this.debug = debug;
    }

    public byte[] buildClass(ClassDefinition classDef, ClassLoader classLoader) throws IOException, SecurityException, IllegalArgumentException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException, NoSuchFieldException {
        ClassWriter cw = this.buildClassHeader(classLoader, classDef);
        this.buildMetaData(cw, classDef);
        this.buildFields(cw, classDef);
        if (classDef.isTraitable()) {
            this.buildDynamicPropertyMap(cw, classDef);
            this.buildTraitMap(cw, classDef);
            this.buildFieldTMS(cw, classDef);
        }
        this.buildConstructors(cw, classDef);
        this.buildGettersAndSetters(cw, classDef);
        this.buildEqualityMethods(cw, classDef);
        this.buildToString((ClassVisitor)cw, classDef);
        if (classDef.isTraitable()) {
            this.buildSerializationMethods(cw, classDef);
        }
        if (classDef.isReactive()) {
            this.implementReactivity(cw, classDef);
        }
        cw.visitEnd();
        return cw.toByteArray();
    }

    private void buildSerializationMethods(ClassWriter cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "writeExternal", "(Ljava/io/ObjectOutput;)V", null, new String[]{"java/io/IOException"});
        mv.visitCode();
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 0);
            this.visitFieldOrGetter(mv, classDef, field);
            mv.visitMethodInsn(185, "java/io/ObjectOutput", BuildUtils.serializationWriterName((String)field.getTypeName()), "(" + (BuildUtils.isPrimitive((String)field.getTypeName()) ? BuildUtils.getTypeDescriptor((String)BuildUtils.serializationType((String)field.getTypeName())) : "Ljava/lang/Object;") + ")V");
        }
        if (classDef.isTraitable()) {
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getClassName()), "__$$dynamic_properties_map$$", Type.getDescriptor(Map.class));
            mv.visitMethodInsn(185, "java/io/ObjectOutput", "writeObject", "(Ljava/lang/Object;)V");
            mv.visitVarInsn(25, 1);
            mv.visitVarInsn(25, 0);
            mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getClassName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
            mv.visitMethodInsn(185, "java/io/ObjectOutput", "writeObject", "(Ljava/lang/Object;)V");
            if (classDef.isFullTraiting()) {
                mv.visitVarInsn(25, 1);
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getClassName()), "__$$field_Tms$$", Type.getDescriptor(TraitFieldTMS.class));
                mv.visitMethodInsn(185, "java/io/ObjectOutput", "writeObject", "(Ljava/lang/Object;)V");
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "readExternal", "(Ljava/io/ObjectInput;)V", null, new String[]{"java/io/IOException", "java/lang/ClassNotFoundException"});
        mv.visitCode();
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "java/io/ObjectInput", BuildUtils.serializationReaderName((String)field.getTypeName()), "()" + (BuildUtils.isPrimitive((String)field.getTypeName()) ? BuildUtils.getTypeDescriptor((String)field.getTypeName()) : "Ljava/lang/Object;"));
            if (!BuildUtils.isPrimitive((String)field.getTypeName())) {
                mv.visitTypeInsn(192, BuildUtils.getInternalType((String)field.getTypeName()));
            }
            mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getName()), BuildUtils.setterName((String)field.getName()), "(" + BuildUtils.getTypeDescriptor((String)field.getTypeName()) + ")V");
        }
        if (classDef.isTraitable()) {
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "java/io/ObjectInput", "readObject", "()Ljava/lang/Object;");
            mv.visitTypeInsn(192, "java/util/Map");
            mv.visitFieldInsn(181, BuildUtils.getInternalType((String)classDef.getClassName()), "__$$dynamic_properties_map$$", Type.getDescriptor(Map.class));
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(25, 1);
            mv.visitMethodInsn(185, "java/io/ObjectInput", "readObject", "()Ljava/lang/Object;");
            mv.visitTypeInsn(192, "java/util/Map");
            mv.visitFieldInsn(181, BuildUtils.getInternalType((String)classDef.getClassName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
            if (classDef.isFullTraiting()) {
                mv.visitVarInsn(25, 0);
                mv.visitVarInsn(25, 1);
                mv.visitMethodInsn(185, "java/io/ObjectInput", "readObject", "()Ljava/lang/Object;");
                mv.visitTypeInsn(192, Type.getInternalName(TraitFieldTMS.class));
                mv.visitFieldInsn(181, BuildUtils.getInternalType((String)classDef.getClassName()), "__$$field_Tms$$", Type.getDescriptor(TraitFieldTMS.class));
            }
        }
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildGettersAndSetters(ClassWriter cw, ClassDefinition classDef) {
        for (FieldDefinition fieldDef : classDef.getFieldsDefinitions()) {
            if (fieldDef.isInherited() && !fieldDef.hasOverride()) continue;
            this.buildGetMethod((ClassVisitor)cw, classDef, fieldDef);
            this.buildSetMethod((ClassVisitor)cw, classDef, fieldDef);
        }
    }

    protected void buildEqualityMethods(ClassWriter cw, ClassDefinition classDef) {
        boolean hasKey = false;
        for (FieldDefinition fld : classDef.getFieldsDefinitions()) {
            if (!fld.isKey()) continue;
            hasKey = true;
            break;
        }
        if (hasKey) {
            this.buildEquals((ClassVisitor)cw, classDef);
            this.buildHashCode((ClassVisitor)cw, classDef);
        }
    }

    protected void buildMetaData(ClassWriter cw, ClassDefinition classDef) {
        Object serialVersionUID = classDef.getMetaData("serialVersionUID");
        if (serialVersionUID != null) {
            FieldVisitor fv = cw.visitField(26, "serialVersionUID", BuildUtils.getTypeDescriptor((String)"long"), null, (Object)Long.parseLong(serialVersionUID.toString()));
            fv.visitEnd();
        }
    }

    protected void buildFields(ClassWriter cw, ClassDefinition classDef) {
        for (FieldDefinition fieldDef : classDef.getFieldsDefinitions()) {
            if (fieldDef.isInherited()) continue;
            this.buildField((ClassVisitor)cw, fieldDef);
        }
    }

    private void implementReactivity(ClassWriter cw, ClassDefinition classDef) {
        String LEFT_TUPLES_FIELD_NAME = "_lts";
        String TYPE_NAME = BuildUtils.getInternalType((String)classDef.getClassName());
        FieldVisitor fv = cw.visitField(2, "_lts", "Ljava/util/Collection;", "Ljava/util/Collection<Lorg/drools/core/reteoo/Tuple;>;", null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "addLeftTuple", "(Lorg/drools/core/reteoo/Tuple;)V", null, null);
        mv.visitCode();
        Label l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(30, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, TYPE_NAME, "_lts", "Ljava/util/Collection;");
        Label l1 = new Label();
        mv.visitJumpInsn(199, l1);
        Label l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLineNumber(31, l2);
        mv.visitVarInsn(25, 0);
        mv.visitTypeInsn(187, "java/util/HashSet");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/util/HashSet", "<init>", "()V", false);
        mv.visitFieldInsn(181, TYPE_NAME, "_lts", "Ljava/util/Collection;");
        mv.visitLabel(l1);
        mv.visitLineNumber(33, l1);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, TYPE_NAME, "_lts", "Ljava/util/Collection;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "java/util/Collection", "add", "(Ljava/lang/Object;)Z", true);
        mv.visitInsn(87);
        Label l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLineNumber(34, l3);
        mv.visitInsn(177);
        Label l4 = new Label();
        mv.visitLabel(l4);
        mv.visitLocalVariable("this", "L" + TYPE_NAME + ";", null, l0, l4, 0);
        mv.visitLocalVariable("leftTuple", "Lorg/drools/core/reteoo/Tuple;", null, l0, l4, 1);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getLeftTuples", "()Ljava/util/Collection;", "()Ljava/util/Collection<Lorg/drools/core/reteoo/Tuple;>;", null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(37, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, TYPE_NAME, "_lts", "Ljava/util/Collection;");
        l1 = new Label();
        mv.visitJumpInsn(198, l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, TYPE_NAME, "_lts", "Ljava/util/Collection;");
        l2 = new Label();
        mv.visitJumpInsn(167, l2);
        mv.visitLabel(l1);
        mv.visitFrame(3, 0, null, 0, null);
        mv.visitMethodInsn(184, "java/util/Collections", "emptyList", "()Ljava/util/List;", false);
        mv.visitLabel(l2);
        mv.visitFrame(4, 0, null, 1, new Object[]{"java/util/Collection"});
        mv.visitInsn(176);
        l3 = new Label();
        mv.visitLabel(l3);
        mv.visitLocalVariable("this", "L" + TYPE_NAME + ";", null, l0, l3, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(4, "notifyModification", "()V", null, null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(41, l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "org/drools/core/phreak/ReactiveObjectUtil", "notifyModification", "(Lorg/drools/core/phreak/ReactiveObject;)V", false);
        l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(42, l1);
        mv.visitInsn(177);
        l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable("this", "L" + TYPE_NAME + ";", null, l0, l2, 0);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "removeLeftTuple", "(Lorg/drools/core/reteoo/Tuple;)V", null, null);
        mv.visitCode();
        l0 = new Label();
        mv.visitLabel(l0);
        mv.visitLineNumber(46, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, TYPE_NAME, "_lts", "Ljava/util/Collection;");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, "java/util/Collection", "remove", "(Ljava/lang/Object;)Z", true);
        mv.visitInsn(87);
        l1 = new Label();
        mv.visitLabel(l1);
        mv.visitLineNumber(47, l1);
        mv.visitInsn(177);
        l2 = new Label();
        mv.visitLabel(l2);
        mv.visitLocalVariable("this", "Lorg/drools/core/phreak/AbstractReactiveObject;", null, l0, l2, 0);
        mv.visitLocalVariable("leftTuple", "Lorg/drools/core/reteoo/Tuple;", null, l0, l2, 1);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
    }

    protected void buildConstructors(ClassWriter cw, ClassDefinition classDef) {
        try {
            this.buildDefaultConstructor((ClassVisitor)cw, classDef);
        }
        catch (Exception e) {
            LOG.error("Exception", (Throwable)e);
        }
        if (classDef.getFieldsDefinitions().size() > 0 && classDef.getFieldsDefinitions().size() < 120) {
            this.buildConstructorWithFields((ClassVisitor)cw, classDef, classDef.getFieldsDefinitions());
        }
        ArrayList<FieldDefinition> keys = new ArrayList<FieldDefinition>();
        for (FieldDefinition fieldDef : classDef.getFieldsDefinitions()) {
            if (!fieldDef.isKey()) continue;
            keys.add(fieldDef);
        }
        if (!keys.isEmpty() && keys.size() != classDef.getFieldsDefinitions().size()) {
            this.buildConstructorWithFields((ClassVisitor)cw, classDef, keys);
        }
    }

    protected void buildTraitMap(ClassWriter cw, ClassDefinition classDef) {
        FieldVisitor fv = cw.visitField(2, "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class), "Ljava/util/Map<Ljava/lang/String;Lorg/drools/core/factmodel/traits/Thing;>;", null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), "()Ljava/util/Map<Ljava/lang/String;Lorg/drools/factmodel/traits/Thing;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "_setTraitMap", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Map.class)}), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, BuildUtils.getInternalType((String)classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "addTrait", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(String.class), Type.getType(Thing.class)}), "(Ljava/lang/String;Lorg/drools/core/factmodel/traits/Thing;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 2);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "put", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class), Type.getType(Object.class)}));
        mv.visitInsn(87);
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getTrait", Type.getMethodDescriptor((Type)Type.getType(Thing.class), (Type[])new Type[]{Type.getType(String.class)}), Type.getMethodDescriptor((Type)Type.getType(Thing.class), (Type[])new Type[]{Type.getType(String.class)}), null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "get", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(Object.class)}));
        mv.visitTypeInsn(192, Type.getInternalName(Thing.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "hasTrait", Type.getMethodDescriptor((Type)Type.getType(Boolean.TYPE), (Type[])new Type[]{Type.getType(String.class)}), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        Label l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "containsKey", Type.getMethodDescriptor((Type)Type.getType(Boolean.TYPE), (Type[])new Type[]{Type.getType(Object.class)}));
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "hasTraits", Type.getMethodDescriptor((Type)Type.getType(Boolean.TYPE), (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        Label l5 = new Label();
        mv.visitJumpInsn(198, l5);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "isEmpty", Type.getMethodDescriptor((Type)Type.BOOLEAN_TYPE, (Type[])new Type[0]));
        mv.visitJumpInsn(154, l5);
        mv.visitInsn(4);
        Label l4 = new Label();
        mv.visitJumpInsn(167, l4);
        mv.visitLabel(l5);
        mv.visitInsn(3);
        mv.visitLabel(l4);
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "removeTrait", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(String.class)}), Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(String.class)}), null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        mv.visitTypeInsn(192, "org/drools/traits/core/factmodel/TraitTypeMapImpl");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "org/drools/traits/core/factmodel/TraitTypeMapImpl", "removeCascade", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(String.class)}));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "removeTrait", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(BitSet.class)}), Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(BitSet.class)}), null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        mv.visitTypeInsn(192, "org/drools/traits/core/factmodel/TraitTypeMapImpl");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "org/drools/traits/core/factmodel/TraitTypeMapImpl", "removeCascade", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(BitSet.class)}));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getTraits", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[0]), "()Ljava/util/Collection<Ljava/lang/String;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getName()), "_getTraitMap", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]));
        mv.visitMethodInsn(185, Type.getInternalName(Map.class), "keySet", Type.getMethodDescriptor((Type)Type.getType(Set.class), (Type[])new Type[0]));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "_setBottomTypeCode", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(BitSet.class)}), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitTypeInsn(192, "org/drools/traits/core/factmodel/TraitTypeMapImpl");
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "org/drools/traits/core/factmodel/TraitTypeMapImpl", "setBottomCode", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(BitSet.class)}));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getMostSpecificTraits", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[0]), "()Ljava/util/Collection<Lorg/drools/core/factmodel/traits/Thing;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        Label l99 = new Label();
        mv.visitJumpInsn(198, l99);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitTypeInsn(192, "org/drools/traits/core/factmodel/TraitTypeMapImpl");
        mv.visitMethodInsn(182, "org/drools/traits/core/factmodel/TraitTypeMapImpl", "getMostSpecificTraits", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[0]));
        mv.visitInsn(176);
        mv.visitLabel(l99);
        mv.visitMethodInsn(184, Type.getInternalName(Collections.class), "emptySet", Type.getMethodDescriptor((Type)Type.getType(Set.class), (Type[])new Type[0]));
        mv.visitMethodInsn(184, Type.getInternalName(Collections.class), "unmodifiableCollection", Type.getMethodDescriptor((Type)Type.getType(Collection.class), (Type[])new Type[]{Type.getType(Collection.class)}));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "getCurrentTypeCode", Type.getMethodDescriptor((Type)Type.getType(BitSet.class), (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        Label l3 = new Label();
        mv.visitJumpInsn(199, l3);
        mv.visitInsn(1);
        mv.visitInsn(176);
        mv.visitLabel(l3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getName()), "__$$dynamic_traits_map$$", Type.getDescriptor(Map.class));
        mv.visitTypeInsn(192, "org/drools/traits/core/factmodel/TraitTypeMapImpl");
        mv.visitMethodInsn(182, "org/drools/traits/core/factmodel/TraitTypeMapImpl", "getCurrentTypeCode", Type.getMethodDescriptor((Type)Type.getType(BitSet.class), (Type[])new Type[0]));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildDynamicPropertyMap(ClassWriter cw, ClassDefinition def) {
        FieldVisitor fv = cw.visitField(2, "__$$dynamic_properties_map$$", Type.getDescriptor(Map.class), "Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "_getDynamicProperties", Type.getMethodDescriptor((Type)Type.getType(Map.class), (Type[])new Type[0]), "()Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType((String)def.getName()), "__$$dynamic_properties_map$$", Type.getDescriptor(Map.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "_setDynamicProperties", Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getType(Map.class)}), "(Ljava/util/Map<Ljava/lang/String;Ljava/lang/Object;>;)V", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, BuildUtils.getInternalType((String)def.getName()), "__$$dynamic_properties_map$$", Type.getDescriptor(Map.class));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildFieldTMS(ClassWriter cw, ClassDefinition def) {
        FieldVisitor fv = cw.visitField(2, "__$$field_Tms$$", Type.getDescriptor(TraitFieldTMS.class), null, null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(1, "_getFieldTMS", Type.getMethodDescriptor((Type)Type.getType(TraitFieldTMS.class), (Type[])new Type[0]), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType((String)def.getName()), "__$$field_Tms$$", Type.getDescriptor(TraitFieldTMS.class));
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        mv = cw.visitMethod(1, "_setFieldTMS", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(TraitFieldTMS.class)}), null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitFieldInsn(181, BuildUtils.getInternalType((String)def.getName()), "__$$field_Tms$$", Type.getDescriptor(TraitFieldTMS.class));
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected ClassWriter buildClassHeader(ClassLoader classLoader, ClassDefinition classDef) {
        boolean reactive = classDef.isReactive();
        String[] original = classDef.getInterfaces();
        int interfacesNr = original.length + (reactive ? 2 : 1);
        String[] interfaces = new String[interfacesNr];
        for (int i = 0; i < original.length; ++i) {
            interfaces[i] = BuildUtils.getInternalType((String)original[i]);
        }
        interfaces[original.length] = BuildUtils.getInternalType((String)GeneratedFact.class.getName());
        if (reactive) {
            interfaces[original.length + 1] = BuildUtils.getInternalType((String)ReactiveObject.class.getName());
        }
        int classModifiers = 33;
        if (classDef.isAbstrakt()) {
            classModifiers += 1024;
        }
        ClassWriter cw = ClassGenerator.createClassWriter(classLoader, classModifiers, BuildUtils.getInternalType((String)classDef.getClassName()), null, BuildUtils.getInternalType((String)classDef.getSuperClass()), interfaces);
        this.buildClassAnnotations(classDef, (ClassVisitor)cw);
        cw.visitSource(classDef.getClassName() + ".java", null);
        return cw;
    }

    protected void buildField(ClassVisitor cw, FieldDefinition fieldDef) {
        FieldVisitor fv = cw.visitField(4, fieldDef.getName(), BuildUtils.getDescriptor((GenericTypeDefinition)fieldDef.getGenericType()), BuildUtils.getSignature((GenericTypeDefinition)fieldDef.getGenericType()), null);
        this.buildFieldAnnotations(fieldDef, fv);
        fv.visitEnd();
    }

    protected void buildDefaultConstructor(ClassVisitor cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        boolean hasObjects = this.defaultConstructorStart(mv, classDef);
        mv.visitInsn(177);
        Label l1 = null;
        if (this.debug) {
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor((String)classDef.getClassName()), null, l0, l1, 0);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected boolean defaultConstructorStart(MethodVisitor mv, ClassDefinition classDef) {
        mv.visitVarInsn(25, 0);
        String sup = "";
        try {
            sup = Type.getInternalName(Class.forName(classDef.getSuperClass()));
        }
        catch (ClassNotFoundException e) {
            sup = BuildUtils.getInternalType((String)classDef.getSuperClass());
        }
        mv.visitMethodInsn(183, sup, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        boolean hasObjects = false;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            hasObjects = hasObjects || this.initFieldWithDefaultValue(mv, classDef, field);
        }
        if (classDef.isTraitable()) {
            this.initializeDynamicTypeStructures(mv, classDef);
        }
        return hasObjects;
    }

    protected boolean initFieldWithDefaultValue(MethodVisitor mv, ClassDefinition classDef, FieldDefinition field) {
        if (field.getInitExpr() == null && field.isInherited()) {
            return false;
        }
        Object val = BuildUtils.getDefaultValue((FieldDefinition)field);
        boolean hasObjects = false;
        if (val != null) {
            mv.visitVarInsn(25, 0);
            if (BuildUtils.isPrimitive((String)field.getTypeName()) || BuildUtils.isBoxed((String)field.getTypeName()) || String.class.getName().equals(field.getTypeName())) {
                mv.visitLdcInsn(val);
                if (BuildUtils.isBoxed((String)field.getTypeName())) {
                    mv.visitMethodInsn(184, BuildUtils.getInternalType((String)field.getTypeName()), "valueOf", "(" + BuildUtils.unBox((String)field.getTypeName()) + ")" + BuildUtils.getTypeDescriptor((String)field.getTypeName()));
                }
            } else {
                hasObjects = true;
                String type = BuildUtils.getInternalType((String)val.getClass().getName());
                mv.visitTypeInsn(187, type);
                mv.visitInsn(89);
                mv.visitMethodInsn(183, type, "<init>", "()V");
            }
        } else if (field.getInitExpr() != null) {
            mv.visitVarInsn(25, 0);
            mv.visitLdcInsn((Object)field.getInitExpr());
            mv.visitMethodInsn(184, "org/mvel2/MVEL", "eval", "(Ljava/lang/String;)Ljava/lang/Object;");
            mv.visitTypeInsn(192, BuildUtils.getInternalType((String)field.getTypeName()));
            val = field.getInitExpr();
        }
        if (val != null) {
            if (!field.isInherited()) {
                mv.visitFieldInsn(181, BuildUtils.getInternalType((String)classDef.getClassName()), field.getName(), BuildUtils.getTypeDescriptor((String)field.getTypeName()));
            } else {
                mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getClassName()), field.getWriteMethod(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType((String)BuildUtils.getTypeDescriptor((String)field.getTypeName()))}));
            }
        }
        return hasObjects;
    }

    protected void initializeDynamicTypeStructures(MethodVisitor mv, ClassDefinition classDef) {
        if (classDef.isFullTraiting()) {
            mv.visitVarInsn(25, 0);
            mv.visitTypeInsn(187, "org/drools/traits/core/factmodel/TraitFieldTMSImpl");
            mv.visitInsn(89);
            mv.visitMethodInsn(183, "org/drools/traits/core/factmodel/TraitFieldTMSImpl", "<init>", "()V");
            mv.visitFieldInsn(181, BuildUtils.getInternalType((String)classDef.getClassName()), "__$$field_Tms$$", Type.getDescriptor(TraitFieldTMS.class));
            for (FactField hardField : classDef.getFields()) {
                FieldDefinition fld = (FieldDefinition)hardField;
                mv.visitVarInsn(25, 0);
                mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getClassName()), "__$$field_Tms$$", Type.getDescriptor(TraitFieldTMS.class));
                mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor((String)classDef.getClassName())));
                mv.visitLdcInsn((Object)fld.resolveAlias());
                if (BuildUtils.isPrimitive((String)fld.getTypeName())) {
                    mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor((String)BuildUtils.box((String)fld.getTypeName()))));
                } else {
                    mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor((String)fld.getTypeName())));
                }
                mv.visitVarInsn(25, 0);
                mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getClassName()), BuildUtils.getterName((String)fld.getName(), (String)fld.getTypeName()), "()" + BuildUtils.getTypeDescriptor((String)fld.getTypeName()));
                if (BuildUtils.isPrimitive((String)fld.getTypeName())) {
                    mv.visitMethodInsn(184, BuildUtils.getInternalType((String)BuildUtils.box((String)fld.getTypeName())), "valueOf", "(" + BuildUtils.getTypeDescriptor((String)fld.getTypeName()) + ")" + BuildUtils.getTypeDescriptor((String)BuildUtils.box((String)fld.getTypeName())));
                }
                if (fld.getInitExpr() != null) {
                    mv.visitLdcInsn((Object)fld.getInitExpr());
                } else {
                    mv.visitInsn(1);
                }
                mv.visitMethodInsn(185, Type.getInternalName(TraitFieldTMS.class), "registerField", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Class.class), Type.getType(String.class), Type.getType(Class.class), Type.getType(Object.class), Type.getType(String.class)}));
            }
        }
    }

    protected void buildConstructorWithFields(ClassVisitor cw, ClassDefinition classDef, Collection<FieldDefinition> fieldDefs) {
        Type[] params = new Type[fieldDefs.size()];
        int index = 0;
        for (FieldDefinition field : fieldDefs) {
            params[index++] = Type.getType((String)BuildUtils.getTypeDescriptor((String)field.getTypeName()));
        }
        MethodVisitor mv = cw.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])params), null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        this.fieldConstructorStart(mv, classDef, fieldDefs);
        mv.visitInsn(177);
        Label l1 = null;
        if (this.debug) {
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor((String)classDef.getClassName()), null, l0, l1, 0);
            for (FieldDefinition field : classDef.getFieldsDefinitions()) {
                Label l11 = new Label();
                mv.visitLabel(l11);
                mv.visitLocalVariable(field.getName(), BuildUtils.getTypeDescriptor((String)field.getTypeName()), null, l0, l1, 0);
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void fieldConstructorStart(MethodVisitor mv, ClassDefinition classDef, Collection<FieldDefinition> fieldDefs) {
        mv.visitVarInsn(25, 0);
        String sup = "";
        try {
            sup = Type.getInternalName(Class.forName(classDef.getSuperClass()));
        }
        catch (ClassNotFoundException e) {
            sup = BuildUtils.getInternalType((String)classDef.getSuperClass());
        }
        mv.visitMethodInsn(183, sup, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        int index = 1;
        for (FieldDefinition field : fieldDefs) {
            if (this.debug) {
                Label l11 = new Label();
                mv.visitLabel(l11);
            }
            mv.visitVarInsn(25, 0);
            mv.visitVarInsn(Type.getType((String)BuildUtils.getTypeDescriptor((String)field.getTypeName())).getOpcode(21), index++);
            if (field.getTypeName().equals("long") || field.getTypeName().equals("double")) {
                ++index;
            }
            if (!field.isInherited()) {
                mv.visitFieldInsn(181, BuildUtils.getInternalType((String)classDef.getClassName()), field.getName(), BuildUtils.getTypeDescriptor((String)field.getTypeName()));
                continue;
            }
            mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getClassName()), field.getWriteMethod(), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType((String)BuildUtils.getTypeDescriptor((String)field.getTypeName()))}));
        }
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (fieldDefs.contains(field) || field.getInitExpr() == null || "".equals(field.getInitExpr().trim())) continue;
            this.initFieldWithDefaultValue(mv, classDef, field);
        }
        if (classDef.isTraitable()) {
            this.initializeDynamicTypeStructures(mv, classDef);
        }
    }

    protected void buildSetMethod(ClassVisitor cw, ClassDefinition classDef, FieldDefinition fieldDef) {
        MethodVisitor mv = cw.visitMethod(1, fieldDef.getWriteMethod(), "(" + BuildUtils.getDescriptor((GenericTypeDefinition)fieldDef.getGenericType()) + ")V", fieldDef.getGenericType().hasGenerics() ? "(" + BuildUtils.getSignature((GenericTypeDefinition)fieldDef.getGenericType()) + ")V" : null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        if (classDef.isTraitable() && classDef.isFullTraiting()) {
            this.updateTraitableField(mv, classDef, fieldDef);
        } else {
            mv.visitVarInsn(Type.getType((String)BuildUtils.getTypeDescriptor((String)fieldDef.getTypeName())).getOpcode(21), 1);
        }
        if (!fieldDef.hasOverride()) {
            mv.visitFieldInsn(181, BuildUtils.getInternalType((String)classDef.getClassName()), fieldDef.getName(), BuildUtils.getTypeDescriptor((String)fieldDef.getTypeName()));
        } else {
            mv.visitMethodInsn(183, BuildUtils.getInternalType((String)classDef.getSuperClass()), BuildUtils.setterName((String)fieldDef.getName()), Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType((String)BuildUtils.getTypeDescriptor((String)fieldDef.getOverriding()))}), false);
        }
        if (classDef.isReactive()) {
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getClassName()), "notifyModification", "()V", false);
        }
        mv.visitInsn(177);
        Label l1 = null;
        if (this.debug) {
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor((String)classDef.getClassName()), null, l0, l1, 0);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildGetMethod(ClassVisitor cw, ClassDefinition classDef, FieldDefinition fieldDef) {
        MethodVisitor mv = cw.visitMethod(1, fieldDef.getReadMethod(), "()" + Type.getType((String)BuildUtils.getDescriptor((GenericTypeDefinition)fieldDef.getGenericType())), fieldDef.getGenericType().hasGenerics() ? "()" + BuildUtils.getSignature((GenericTypeDefinition)fieldDef.getGenericType()) : null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        if (!fieldDef.hasOverride()) {
            mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getClassName()), fieldDef.getName(), BuildUtils.getTypeDescriptor((String)fieldDef.getTypeName()));
            mv.visitInsn(Type.getType((String)BuildUtils.getTypeDescriptor((String)fieldDef.getTypeName())).getOpcode(172));
        } else {
            mv.visitMethodInsn(183, BuildUtils.getInternalType((String)classDef.getSuperClass()), BuildUtils.getterName((String)fieldDef.getName(), (String)fieldDef.getOverriding()), Type.getMethodDescriptor((Type)Type.getType((String)BuildUtils.getTypeDescriptor((String)fieldDef.getOverriding())), (Type[])new Type[0]), false);
            mv.visitTypeInsn(192, BuildUtils.getInternalType((String)fieldDef.getTypeName()));
            mv.visitInsn(AsmUtil.returnType(fieldDef.getTypeName()));
        }
        Label l1 = null;
        if (this.debug) {
            l1 = new Label();
            mv.visitLabel(l1);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor((String)classDef.getClassName()), null, l0, l1, 0);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildEquals(ClassVisitor cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "equals", "(Ljava/lang/Object;)Z", null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        Label l1 = new Label();
        mv.visitJumpInsn(166, l1);
        mv.visitInsn(4);
        mv.visitInsn(172);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 1);
        Label l2 = new Label();
        mv.visitJumpInsn(199, l2);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]));
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, Type.getInternalName(Object.class), "getClass", Type.getMethodDescriptor((Type)Type.getType(Class.class), (Type[])new Type[0]));
        Label l3 = new Label();
        mv.visitJumpInsn(165, l3);
        mv.visitInsn(3);
        mv.visitInsn(172);
        mv.visitLabel(l3);
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, BuildUtils.getInternalType((String)classDef.getClassName()));
        mv.visitVarInsn(58, 2);
        int count = 0;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            ++count;
            Label goNext = new Label();
            if (BuildUtils.isPrimitive((String)field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitVarInsn(25, 2);
                this.visitFieldOrGetter(mv, classDef, field);
                if (field.getTypeName().equals("long")) {
                    mv.visitInsn(148);
                    mv.visitJumpInsn(153, goNext);
                } else if (field.getTypeName().equals("double")) {
                    mv.visitInsn(151);
                    mv.visitJumpInsn(153, goNext);
                } else if (field.getTypeName().equals("float")) {
                    mv.visitInsn(149);
                    mv.visitJumpInsn(153, goNext);
                } else {
                    mv.visitJumpInsn(159, goNext);
                }
                mv.visitInsn(3);
                mv.visitInsn(172);
            } else {
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                Label secondIfPart = new Label();
                mv.visitJumpInsn(199, secondIfPart);
                mv.visitVarInsn(25, 2);
                this.visitFieldOrGetter(mv, classDef, field);
                Label returnFalse = new Label();
                mv.visitJumpInsn(199, returnFalse);
                mv.visitLabel(secondIfPart);
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitJumpInsn(198, goNext);
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitVarInsn(25, 2);
                this.visitFieldOrGetter(mv, classDef, field);
                if (!BuildUtils.isArray((String)field.getTypeName())) {
                    mv.visitMethodInsn(182, "java/lang/Object", "equals", "(Ljava/lang/Object;)Z");
                } else {
                    mv.visitMethodInsn(184, "java/util/Arrays", "equals", "(" + BuildUtils.arrayType((String)field.getTypeName()) + BuildUtils.arrayType((String)field.getTypeName()) + ")Z");
                }
                mv.visitJumpInsn(154, goNext);
                mv.visitLabel(returnFalse);
                mv.visitInsn(3);
                mv.visitInsn(172);
            }
            mv.visitLabel(goNext);
        }
        if (count > 0) {
            mv.visitInsn(4);
        } else {
            mv.visitInsn(3);
        }
        mv.visitInsn(172);
        Label lastLabel = null;
        if (this.debug) {
            lastLabel = new Label();
            mv.visitLabel(lastLabel);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor((String)classDef.getClassName()), null, l0, lastLabel, 0);
            mv.visitLocalVariable("obj", Type.getDescriptor(Object.class), null, l0, lastLabel, 1);
            mv.visitLocalVariable("other", BuildUtils.getTypeDescriptor((String)classDef.getClassName()), null, l0, lastLabel, 2);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildSystemHashCode(ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "java/lang/System", "identityHashCode", "(Ljava/lang/Object;)I");
        mv.visitInsn(172);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildHashCode(ClassVisitor cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "hashCode", "()I", null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitInsn(4);
        mv.visitVarInsn(54, 1);
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            if (!field.isKey()) continue;
            mv.visitVarInsn(21, 1);
            mv.visitIntInsn(16, 31);
            mv.visitVarInsn(21, 1);
            mv.visitInsn(104);
            mv.visitVarInsn(25, 0);
            this.visitFieldOrGetter(mv, classDef, field);
            if ("boolean".equals(field.getTypeName())) {
                Label blabel1 = new Label();
                mv.visitJumpInsn(153, blabel1);
                mv.visitIntInsn(17, 1231);
                Label blabel2 = new Label();
                mv.visitJumpInsn(167, blabel2);
                mv.visitLabel(blabel1);
                mv.visitIntInsn(17, 1237);
                mv.visitLabel(blabel2);
            } else if ("long".equals(field.getTypeName())) {
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
            } else if ("float".equals(field.getTypeName())) {
                mv.visitMethodInsn(184, Type.getInternalName(Float.class), "floatToIntBits", "(F)I");
            } else if ("double".equals(field.getTypeName())) {
                mv.visitMethodInsn(184, Type.getInternalName(Double.class), "doubleToLongBits", "(D)J");
                mv.visitInsn(92);
                mv.visitIntInsn(16, 32);
                mv.visitInsn(125);
                mv.visitInsn(131);
                mv.visitInsn(136);
            } else if (!BuildUtils.isPrimitive((String)field.getTypeName())) {
                Label olabel1 = new Label();
                mv.visitJumpInsn(199, olabel1);
                mv.visitInsn(3);
                Label olabel2 = new Label();
                mv.visitJumpInsn(167, olabel2);
                mv.visitLabel(olabel1);
                mv.visitVarInsn(25, 0);
                this.visitFieldOrGetter(mv, classDef, field);
                if (!BuildUtils.isArray((String)field.getTypeName())) {
                    mv.visitMethodInsn(182, "java/lang/Object", "hashCode", "()I");
                } else {
                    mv.visitMethodInsn(184, "java/util/Arrays", "hashCode", "(" + BuildUtils.arrayType((String)field.getTypeName()) + ")I");
                }
                mv.visitLabel(olabel2);
            }
            mv.visitInsn(96);
            mv.visitVarInsn(54, 1);
        }
        mv.visitVarInsn(21, 1);
        mv.visitInsn(172);
        Label lastLabel = null;
        if (this.debug) {
            lastLabel = new Label();
            mv.visitLabel(lastLabel);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor((String)classDef.getClassName()), null, l0, lastLabel, 0);
            mv.visitLocalVariable("hash", Type.getDescriptor(Integer.TYPE), null, l0, lastLabel, 1);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected void buildToString(ClassVisitor cw, ClassDefinition classDef) {
        MethodVisitor mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        Label l0 = null;
        if (this.debug) {
            l0 = new Label();
            mv.visitLabel(l0);
        }
        mv.visitTypeInsn(187, Type.getInternalName(StringBuilder.class));
        mv.visitInsn(89);
        mv.visitMethodInsn(183, Type.getInternalName(StringBuilder.class), "<init>", "()V");
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 1);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getClassName()), "getClass", "()Ljava/lang/Class;");
        mv.visitMethodInsn(182, Type.getInternalName(Class.class), "getSimpleName", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        this.appendToStringBuilder(mv, "( ");
        this.buildFieldsToString(classDef, mv, false);
        this.appendToStringBuilder(mv, " )");
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "toString", "()Ljava/lang/String;");
        mv.visitInsn(176);
        Label lastLabel = null;
        if (this.debug) {
            lastLabel = new Label();
            mv.visitLabel(lastLabel);
            mv.visitLocalVariable("this", BuildUtils.getTypeDescriptor((String)classDef.getClassName()), null, l0, lastLabel, 0);
            mv.visitLocalVariable("buf", Type.getDescriptor(StringBuilder.class), null, l0, lastLabel, 1);
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    protected boolean buildFieldsToString(ClassDefinition classDef, MethodVisitor mv, boolean previous) {
        boolean first = true;
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            this.buildFieldToString(field, classDef, mv, first);
            first = false;
        }
        return previous;
    }

    protected void buildFieldToString(FieldDefinition field, ClassDefinition classDef, MethodVisitor mv, boolean first) {
        if (!first) {
            this.appendToStringBuilder(mv, ", ");
        }
        this.appendToStringBuilder(mv, field.getName());
        this.appendToStringBuilder(mv, "=");
        if (field.isRecursive()) {
            this.appendToStringBuilder(mv, field.getTypeName() + " [recursive]");
        } else {
            mv.visitVarInsn(25, 0);
            this.visitFieldOrGetter(mv, classDef, field);
            if (BuildUtils.isPrimitive((String)field.getTypeName())) {
                String type = field.getTypeName().matches("(byte|short)") ? "int" : field.getTypeName();
                mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType((String)BuildUtils.getTypeDescriptor((String)type))}));
            } else if (BuildUtils.isArray((String)field.getTypeName()) && BuildUtils.arrayDimSize((String)field.getTypeName()) == 1) {
                mv.visitMethodInsn(184, "java/util/Arrays", "toString", "(" + BuildUtils.getTypeDescriptor((String)BuildUtils.arrayType((String)field.getTypeName())) + ")Ljava/lang/String;");
                mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/Object;)Ljava/lang/StringBuilder;");
            } else {
                mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", Type.getMethodDescriptor((Type)Type.getType(StringBuilder.class), (Type[])new Type[]{Type.getType(Object.class)}));
            }
        }
    }

    private void appendToStringBuilder(MethodVisitor mv, String s) {
        mv.visitLdcInsn((Object)s);
        mv.visitMethodInsn(182, Type.getInternalName(StringBuilder.class), "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
    }

    protected void buildClassAnnotations(ClassDefinition classDef, ClassVisitor cw) {
        for (AnnotationDefinition ad : classDef.getAnnotations()) {
            AnnotationVisitor av = cw.visitAnnotation("L" + BuildUtils.getInternalType((String)ad.getName()) + ";", true);
            DefaultBeanClassBuilder.addAnnotationAttribute(ad, av);
            av.visitEnd();
        }
    }

    protected void buildFieldAnnotations(FieldDefinition fieldDef, FieldVisitor fv) {
        if (fieldDef.getAnnotations() != null) {
            for (AnnotationDefinition ad : fieldDef.getAnnotations()) {
                AnnotationVisitor av = fv.visitAnnotation("L" + BuildUtils.getInternalType((String)ad.getName()) + ";", true);
                DefaultBeanClassBuilder.addAnnotationAttribute(ad, av);
                av.visitEnd();
            }
        }
    }

    public static void addAnnotationAttribute(AnnotationDefinition ad, AnnotationVisitor av) {
        for (String key : ad.getValues().keySet()) {
            AnnotationDefinition.AnnotationPropertyVal apv = (AnnotationDefinition.AnnotationPropertyVal)ad.getValues().get(key);
            switch (apv.getValType()) {
                case STRINGARRAY: {
                    Object[] array;
                    AnnotationVisitor subAv = av.visitArray(apv.getProperty());
                    for (Object object : array = (Object[])apv.getValue()) {
                        subAv.visit(null, object);
                    }
                    subAv.visitEnd();
                    break;
                }
                case PRIMARRAY: {
                    av.visit(apv.getProperty(), apv.getValue());
                    break;
                }
                case ENUMARRAY: {
                    AnnotationVisitor subEnav = av.visitArray(apv.getProperty());
                    Enum[] enArray = (Enum[])apv.getValue();
                    String aenumType = "L" + BuildUtils.getInternalType((String)enArray[0].getClass().getName()) + ";";
                    for (Enum enumer : enArray) {
                        subEnav.visitEnum(null, aenumType, enumer.name());
                    }
                    subEnav.visitEnd();
                    break;
                }
                case CLASSARRAY: {
                    Class[] klarray;
                    AnnotationVisitor annotationVisitor = av.visitArray(apv.getProperty());
                    for (Class klass : klarray = (Class[])apv.getValue()) {
                        annotationVisitor.visit(null, (Object)Type.getType((String)("L" + BuildUtils.getInternalType((String)klass.getName()) + ";")));
                    }
                    annotationVisitor.visitEnd();
                    break;
                }
                case ENUMERATION: {
                    String enumType = "L" + BuildUtils.getInternalType((String)apv.getType().getName()) + ";";
                    av.visitEnum(apv.getProperty(), enumType, ((Enum)apv.getValue()).name());
                    break;
                }
                case KLASS: {
                    String klassName = BuildUtils.getInternalType((String)((Class)apv.getValue()).getName());
                    av.visit(apv.getProperty(), (Object)Type.getType((String)("L" + klassName + ";")));
                    break;
                }
                case PRIMITIVE: {
                    av.visit(apv.getProperty(), apv.getValue());
                    break;
                }
                case STRING: {
                    av.visit(apv.getProperty(), apv.getValue());
                }
            }
        }
    }

    protected void visitFieldOrGetter(MethodVisitor mv, ClassDefinition classDef, FieldDefinition field) {
        if (!field.isInherited()) {
            mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getClassName()), field.getName(), BuildUtils.getTypeDescriptor((String)field.getTypeName()));
        } else {
            mv.visitMethodInsn(182, BuildUtils.getInternalType((String)classDef.getClassName()), field.getReadMethod(), Type.getMethodDescriptor((Type)Type.getType((String)BuildUtils.getTypeDescriptor((String)field.getTypeName())), (Type[])new Type[0]));
        }
    }

    protected void updateTraitableField(MethodVisitor mv, ClassDefinition classDef, FieldDefinition fieldDef) {
        String fieldType = fieldDef.getTypeName();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, BuildUtils.getInternalType((String)classDef.getClassName()), "__$$field_Tms$$", Type.getDescriptor(TraitFieldTMS.class));
        mv.visitLdcInsn((Object)fieldDef.resolveAlias());
        if (BuildUtils.isPrimitive((String)fieldType)) {
            mv.visitVarInsn(AsmUtil.varType(fieldType), 1);
            mv.visitMethodInsn(184, BuildUtils.getInternalType((String)BuildUtils.box((String)fieldType)), "valueOf", "(" + BuildUtils.getTypeDescriptor((String)fieldType) + ")" + BuildUtils.getTypeDescriptor((String)BuildUtils.box((String)fieldType)));
        } else {
            mv.visitVarInsn(25, 1);
        }
        if (BuildUtils.isPrimitive((String)fieldType)) {
            mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor((String)BuildUtils.box((String)fieldDef.getTypeName()))));
        } else {
            mv.visitLdcInsn((Object)Type.getType((String)BuildUtils.getTypeDescriptor((String)fieldType)));
        }
        mv.visitMethodInsn(185, Type.getInternalName(TraitFieldTMS.class), "set", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[]{Type.getType(String.class), Type.getType(Object.class), Type.getType(Class.class)}));
        if (BuildUtils.isPrimitive((String)fieldType)) {
            mv.visitTypeInsn(192, BuildUtils.getInternalType((String)BuildUtils.box((String)fieldType)));
            mv.visitMethodInsn(182, BuildUtils.getInternalType((String)BuildUtils.box((String)fieldType)), BuildUtils.numericMorph((String)BuildUtils.box((String)fieldType)), "()" + BuildUtils.getTypeDescriptor((String)fieldType));
        } else {
            mv.visitTypeInsn(192, BuildUtils.getInternalType((String)fieldType));
        }
    }
}

