/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.definitions.InternalKnowledgePackage;
import org.drools.core.reteoo.Tuple;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.Pattern;
import org.drools.core.rule.accessor.CompiledInvoker;
import org.drools.mvel.asm.ClassGenerator;
import org.drools.mvel.asm.InvokerDataProvider;
import org.drools.mvel.asm.InvokerStub;
import org.drools.mvel.asm.MethodComparator;
import org.drools.util.ClassTypeResolver;
import org.drools.util.ClassUtils;
import org.drools.util.TypeResolver;
import org.mvel2.asm.Label;
import org.mvel2.asm.MethodVisitor;

public final class GeneratorHelper {
    public static final Long INVOKER_SERIAL_UID = 510L;

    public static List<DeclarationMatcher> matchDeclarationsToTuple(Declaration[] declarations) {
        ArrayList<DeclarationMatcher> matchers = new ArrayList<DeclarationMatcher>();
        for (int i = 0; i < declarations.length; ++i) {
            matchers.add(new DeclarationMatcher(i, declarations[i]));
        }
        Collections.sort(matchers);
        return matchers;
    }

    private static ClassLoader getClassLoader(Object obj, ReteEvaluator reteEvaluator) {
        return obj.getClass().getClassLoader();
    }

    static ClassGenerator createInvokerClassGenerator(InvokerStub stub, ReteEvaluator reteEvaluator) {
        return GeneratorHelper.createInvokerClassGenerator(stub, "", reteEvaluator);
    }

    static ClassGenerator createInvokerClassGenerator(InvokerStub stub, String classSuffix, ReteEvaluator reteEvaluator) {
        String className = stub.getPackageName() + "." + stub.getGeneratedInvokerClassName() + classSuffix;
        ClassLoader classLoader = GeneratorHelper.getClassLoader(stub, reteEvaluator);
        return GeneratorHelper.createInvokerClassGenerator(className, stub, classLoader, GeneratorHelper.getTypeResolver(stub, reteEvaluator, classLoader));
    }

    public static ClassGenerator createInvokerClassGenerator(String className, final InvokerDataProvider data, ClassLoader classLoader, TypeResolver typeResolver) {
        ClassGenerator generator = new ClassGenerator(className, classLoader, typeResolver).addStaticField(18, "serialVersionUID", Long.TYPE, INVOKER_SERIAL_UID).addDefaultConstructor();
        generator.addMethod(1, "hashCode", generator.methodDescr(Integer.TYPE, new Class[0]), new ClassGenerator.MethodBody(){

            @Override
            public void body(MethodVisitor mv) {
                this.push(data.hashCode());
                mv.visitInsn(172);
            }
        }).addMethod(1, "getMethodBytecode", generator.methodDescr(String.class, new Class[0]), new GetMethodBytecodeMethod(data)).addMethod(1, "equals", generator.methodDescr(Boolean.TYPE, Object.class), new EqualsMethod());
        return generator;
    }

    static TypeResolver getTypeResolver(InvokerStub stub, ReteEvaluator reteEvaluator, ClassLoader classLoader) {
        TypeResolver typeResolver;
        InternalKnowledgePackage pkg = reteEvaluator.getKnowledgeBase().getPackage(stub.getPackageName());
        TypeResolver typeResolver2 = typeResolver = pkg == null ? null : pkg.getTypeResolver();
        if (typeResolver == null) {
            HashSet<String> imports = new HashSet<String>();
            for (String imp : stub.getPackageImports()) {
                imports.add(imp);
            }
            typeResolver = new ClassTypeResolver(imports, classLoader, stub.getPackageName());
        }
        return typeResolver;
    }

    public static abstract class EvaluateMethod
    extends DeclarationAccessorMethod {
        protected int objAstorePos;

        protected int[] parseDeclarations(Declaration[] declarations, int declarReg, int tupleReg, int wmReg, boolean readLocalsFromTuple) {
            int[] declarationsParamsPos = new int[declarations.length];
            for (int i = 0; i < declarations.length; ++i) {
                declarationsParamsPos[i] = this.objAstorePos;
                this.mv.visitVarInsn(25, declarReg);
                this.push(i);
                this.mv.visitInsn(50);
                this.mv.visitVarInsn(25, wmReg);
                if (readLocalsFromTuple) {
                    this.mv.visitVarInsn(25, tupleReg);
                    this.mv.visitVarInsn(25, declarReg);
                    this.push(i);
                    this.mv.visitInsn(50);
                    this.invokeInterface(Tuple.class, "get", InternalFactHandle.class, Declaration.class);
                    this.invokeInterface(InternalFactHandle.class, "getObject", Object.class, new Class[0]);
                } else {
                    this.mv.visitVarInsn(25, 1);
                }
                String readMethod = declarations[i].getNativeReadMethodName();
                boolean isObject = readMethod.equals("getValue");
                String declarationType = declarations[i].getTypeName();
                String returnedType = isObject ? "Ljava/lang/Object;" : this.typeDescr(declarationType);
                this.mv.visitMethodInsn(182, Declaration.class.getName().replace('.', '/'), readMethod, "(L" + ReteEvaluator.class.getName().replace('.', '/') + ";Ljava/lang/Object;)" + returnedType);
                if (isObject) {
                    this.mv.visitTypeInsn(192, this.internalName(declarationType));
                }
                this.objAstorePos += this.store(this.objAstorePos, declarationType);
            }
            return declarationsParamsPos;
        }

        protected void parseGlobals(String[] globals, String[] globalTypes, int wmReg, StringBuilder methodDescr) {
            for (int i = 0; i < globals.length; ++i) {
                String globalType = globalTypes[i];
                if (globalType.indexOf(60) > 0) {
                    globalType = globalType.substring(0, globalType.indexOf(60)).trim();
                }
                this.mv.visitVarInsn(25, wmReg);
                this.push(globals[i]);
                this.invokeInterface(ReteEvaluator.class, "getGlobal", Object.class, String.class);
                Class primitiveType = ClassUtils.convertPrimitiveNameToType((String)globalType);
                if (primitiveType != null) {
                    this.cast(ClassUtils.convertFromPrimitiveType((Class)primitiveType), primitiveType);
                } else {
                    this.mv.visitTypeInsn(192, this.internalName(globalType));
                }
                methodDescr.append(this.typeDescr(globalType));
            }
        }

        protected void storeObjectFromDeclaration(Declaration declaration, String declarationType) {
            this.objAstorePos += this.storeObjectFromDeclaration(declaration, declarationType, this.objAstorePos);
        }
    }

    public static abstract class DeclarationAccessorMethod
    extends ClassGenerator.MethodBody {
        protected int storeObjectFromDeclaration(Declaration declaration, int registry) {
            return this.storeObjectFromDeclaration(declaration, declaration.getTypeName(), registry);
        }

        protected int storeObjectFromDeclaration(Declaration declaration, String declarationType, int registry) {
            Class declarationClass;
            String readMethod = declaration.getNativeReadMethodName();
            boolean isObject = readMethod.equals("getValue");
            String expectedTypeDescr = this.typeDescr(declarationType);
            boolean needsPrimitive = !expectedTypeDescr.startsWith("L") && !expectedTypeDescr.startsWith("[");
            String returnedType = isObject ? "Ljava/lang/Object;" : this.typeDescr(declaration.getTypeName());
            this.mv.visitMethodInsn(182, Declaration.class.getName().replace('.', '/'), readMethod, "(L" + ReteEvaluator.class.getName().replace('.', '/') + ";Ljava/lang/Object;)" + returnedType);
            if (isObject && (declarationClass = declaration.getDeclarationClass()) != null) {
                this.cast(declarationClass);
            }
            if (needsPrimitive && isObject) {
                this.castToPrimitive(ClassUtils.convertPrimitiveNameToType((String)declarationType));
            } else if (!needsPrimitive && !isObject) {
                this.castFromPrimitive(ClassUtils.convertPrimitiveNameToType((String)declaration.getExtractor().getExtractToClassName()));
            } else if (needsPrimitive && !isObject && !returnedType.equals(declarationType)) {
                this.castPrimitiveToPrimitive(declaration.getExtractor().getExtractToClass(), ClassUtils.convertPrimitiveNameToType((String)declarationType));
            }
            return this.store(registry, declarationType);
        }

        protected Tuple traverseTuplesUntilDeclaration(Tuple currentTuple, int tupleIndex, int tupleReg) {
            while (currentTuple.getIndex() != tupleIndex) {
                this.mv.visitVarInsn(25, tupleReg);
                this.invokeInterface(Tuple.class, "getParent", Tuple.class, new Class[0]);
                this.mv.visitVarInsn(58, tupleReg);
                currentTuple = currentTuple.getParent();
            }
            return currentTuple;
        }

        protected void traverseTuplesUntilDeclarationWithOr(int declarIndex, int declarReg, int tupleReg, int declarOffsetReg) {
            this.mv.visitVarInsn(25, declarReg);
            this.push(declarIndex);
            this.mv.visitInsn(50);
            this.invokeVirtual(Declaration.class, "getPattern", Pattern.class, new Class[0]);
            this.invokeVirtual(Pattern.class, "getOffset", Integer.TYPE, new Class[0]);
            this.mv.visitVarInsn(54, declarOffsetReg);
            Label whileStart = new Label();
            Label whileExit = new Label();
            this.mv.visitLabel(whileStart);
            this.mv.visitVarInsn(25, tupleReg);
            this.invokeInterface(Tuple.class, "getIndex", Integer.TYPE, new Class[0]);
            this.mv.visitVarInsn(21, declarOffsetReg);
            this.mv.visitJumpInsn(164, whileExit);
            this.mv.visitVarInsn(25, tupleReg);
            this.invokeInterface(Tuple.class, "getParent", Tuple.class, new Class[0]);
            this.mv.visitVarInsn(58, tupleReg);
            this.mv.visitJumpInsn(167, whileStart);
            this.mv.visitLabel(whileExit);
        }
    }

    public static class EqualsMethod
    extends ClassGenerator.MethodBody {
        @Override
        public void body(MethodVisitor mv) {
            Label l1 = new Label();
            Label l2 = new Label();
            mv.visitVarInsn(25, 1);
            mv.visitJumpInsn(198, l1);
            mv.visitVarInsn(25, 1);
            this.instanceOf(CompiledInvoker.class);
            mv.visitJumpInsn(154, l2);
            mv.visitLabel(l1);
            mv.visitInsn(3);
            mv.visitInsn(172);
            mv.visitLabel(l2);
            mv.visitVarInsn(25, 0);
            this.invokeThis("getMethodBytecode", String.class, new Class[0]);
            mv.visitVarInsn(25, 1);
            this.cast(CompiledInvoker.class);
            this.invokeInterface(CompiledInvoker.class, "getMethodBytecode", String.class, new Class[0]);
            this.invokeStatic(MethodComparator.class, "compareBytecode", Boolean.TYPE, String.class, String.class);
            mv.visitInsn(172);
        }
    }

    public static class GetMethodBytecodeMethod
    extends ClassGenerator.MethodBody {
        private InvokerDataProvider data;

        public GetMethodBytecodeMethod(InvokerDataProvider data) {
            this.data = data;
        }

        @Override
        public void body(MethodVisitor mv) {
            mv.visitVarInsn(25, 0);
            this.invokeVirtual(Object.class, "getClass", Class.class, new Class[0]);
            this.push(this.data.getRuleClassName());
            this.push(this.data.getPackageName());
            this.push(this.data.getMethodName());
            this.push(this.data.getInternalRuleClassName() + ".class");
            this.invokeStatic(MethodComparator.class, "getMethodBytecode", String.class, Class.class, String.class, String.class, String.class, String.class);
            mv.visitInsn(176);
        }
    }

    public static class DeclarationMatcher
    implements Comparable {
        private final int matcherIndex;
        private final Declaration declaration;
        private final int tupleIndex;

        public DeclarationMatcher(int matchersIndex, Declaration declaration) {
            this.matcherIndex = matchersIndex;
            this.declaration = declaration;
            this.tupleIndex = declaration.getTupleIndex();
        }

        public int getMatcherIndex() {
            return this.matcherIndex;
        }

        public int getTupleIndex() {
            return this.tupleIndex;
        }

        public Declaration getDeclaration() {
            return this.declaration;
        }

        public int compareTo(Object obj) {
            return ((DeclarationMatcher)obj).tupleIndex - this.tupleIndex;
        }
    }
}

