/*
 * Decompiled with CFR 0.152.
 */
package org.drools.traits.core.factmodel;

import java.io.Serializable;
import org.drools.base.factmodel.AnnotationDefinition;
import org.drools.base.factmodel.ClassDefinition;
import org.drools.base.factmodel.FieldDefinition;
import org.drools.base.factmodel.GeneratedFact;
import org.drools.base.factmodel.traits.Trait;
import org.drools.compiler.builder.impl.classbuilder.BuildUtils;
import org.drools.compiler.builder.impl.classbuilder.ClassBuilder;
import org.drools.mvel.asm.ClassGenerator;
import org.drools.mvel.asm.DefaultBeanClassBuilder;
import org.mvel2.asm.AnnotationVisitor;
import org.mvel2.asm.ClassWriter;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.Opcodes;
import org.mvel2.asm.Type;

public class TraitClassBuilderImpl
implements ClassBuilder,
Opcodes,
Serializable {
    public byte[] buildClass(ClassDefinition classDef, ClassLoader classLoader) {
        String[] tmp;
        this.init(classDef);
        String cName = BuildUtils.getInternalType((String)classDef.getClassName());
        String genericTypes = BuildUtils.getGenericTypes((String[])classDef.getInterfaces());
        String superType = Type.getInternalName(Object.class);
        String[] intfaces = null;
        if (Object.class.getName().equals(classDef.getSuperClass())) {
            tmp = BuildUtils.getInternalTypes((String[])classDef.getInterfaces());
            intfaces = new String[tmp.length + 2];
            System.arraycopy(tmp, 0, intfaces, 0, tmp.length);
            intfaces[tmp.length] = Type.getInternalName(Serializable.class);
            intfaces[tmp.length + 1] = Type.getInternalName(GeneratedFact.class);
        } else {
            tmp = BuildUtils.getInternalTypes((String[])classDef.getInterfaces());
            intfaces = new String[tmp.length + 3];
            System.arraycopy(tmp, 0, intfaces, 0, tmp.length);
            intfaces[tmp.length] = BuildUtils.getInternalType((String)classDef.getSuperClass());
            intfaces[tmp.length + 1] = Type.getInternalName(Serializable.class);
            intfaces[tmp.length + 2] = Type.getInternalName(GeneratedFact.class);
        }
        ClassWriter cw = ClassGenerator.createClassWriter((ClassLoader)classLoader, (int)1537, (String)cName, (String)genericTypes, (String)superType, (String[])intfaces);
        if (classDef.getDefinedClass() == null || classDef.getDefinedClass().getAnnotation(Trait.class) == null) {
            AnnotationVisitor av0 = cw.visitAnnotation(Type.getDescriptor(Trait.class), true);
            for (AnnotationDefinition adef : classDef.getAnnotations()) {
                if (!Trait.class.getName().equals(adef.getName())) continue;
                DefaultBeanClassBuilder.addAnnotationAttribute((AnnotationDefinition)adef, (AnnotationVisitor)av0);
                break;
            }
            av0.visitEnd();
        }
        for (FieldDefinition field : classDef.getFieldsDefinitions()) {
            this.buildField(cw, field);
        }
        this.finalizeCreation(classDef);
        cw.visitEnd();
        return cw.toByteArray();
    }

    protected void init(ClassDefinition classDef) {
    }

    private void buildField(ClassWriter cw, FieldDefinition field) {
        Object name = field.getName();
        name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        String type = field.getTypeName();
        this.buildGetter(cw, field, (String)name, type, null);
        this.buildSetter(cw, field, (String)name, type, null);
    }

    protected void buildSetter(ClassWriter cw, FieldDefinition field, String name, String type, String generic) {
        MethodVisitor mv = cw.visitMethod(1025, BuildUtils.setterName((String)name), "(" + BuildUtils.getTypeDescriptor((String)type) + ")V", generic == null ? null : "(" + BuildUtils.getTypeDescriptor((String)type).replace(";", "<" + BuildUtils.getTypeDescriptor((String)generic) + ">;") + ")V", null);
        mv.visitEnd();
    }

    protected void buildGetter(ClassWriter cw, FieldDefinition field, String name, String type, String generic) {
        name = ((String)name).substring(0, 1).toUpperCase() + ((String)name).substring(1);
        MethodVisitor mv = cw.visitMethod(1025, BuildUtils.getterName((String)name, (String)type), "()" + BuildUtils.getTypeDescriptor((String)type), generic == null ? null : "()" + BuildUtils.getTypeDescriptor((String)type).replace(";", "<" + BuildUtils.getTypeDescriptor((String)generic) + ">;"), null);
        mv.visitEnd();
    }

    protected void finalizeCreation(ClassDefinition trait) {
    }
}

