/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.concurrent.CountDownLatch;
import org.drools.base.facttemplates.Event;
import org.drools.core.base.DroolsQueryImpl;
import org.drools.core.common.DefaultEventHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.PropagationContext;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.WorkingMemoryReteExpireAction;
import org.drools.core.phreak.RuleAgendaItem;
import org.drools.core.phreak.RuntimeSegmentUtilities;
import org.drools.core.reteoo.ClassObjectTypeConf;
import org.drools.core.reteoo.CompositePartitionAwareObjectSinkAdapter;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.ObjectTypeConf;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.PointInTimeTrigger;

public interface PropagationEntry {
    default public void execute(ReteEvaluator reteEvaluator) {
        this.internalExecute(reteEvaluator);
        reteEvaluator.onWorkingMemoryAction(this);
    }

    public void internalExecute(ReteEvaluator var1);

    public PropagationEntry getNext();

    public void setNext(PropagationEntry var1);

    public boolean requiresImmediateFlushing();

    public boolean isCalledFromRHS();

    public boolean isPartitionSplittable();

    public PropagationEntry getSplitForPartition(int var1);

    public boolean defersExpiration();

    public static class PartitionedDelete
    extends AbstractPartitionedPropagationEntry {
        private final InternalFactHandle handle;
        private final PropagationContext context;
        private final ObjectTypeConf objectTypeConf;

        PartitionedDelete(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, int partition) {
            super(partition);
            this.handle = handle;
            this.context = context;
            this.objectTypeConf = objectTypeConf;
        }

        @Override
        public void internalExecute(ReteEvaluator reteEvaluator) {
            ObjectTypeNode[] cachedNodes = this.objectTypeConf.getObjectTypeNodes();
            if (cachedNodes == null) {
                return;
            }
            for (ObjectTypeNode cachedNode : cachedNodes) {
                cachedNode.retractObject(this.handle, this.context, reteEvaluator, this.partition);
            }
            if (this.handle.isEvent() && this.isMainPartition()) {
                ((DefaultEventHandle)this.handle).unscheduleAllJobs(reteEvaluator);
            }
        }

        public String toString() {
            return "Delete of " + this.handle.getObject() + " for partition " + this.partition;
        }
    }

    public static class Delete
    extends AbstractPropagationEntry {
        private final EntryPointNode epn;
        private final InternalFactHandle handle;
        private final PropagationContext context;
        private final ObjectTypeConf objectTypeConf;

        public Delete(EntryPointNode epn, InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf) {
            this.epn = epn;
            this.handle = handle;
            this.context = context;
            this.objectTypeConf = objectTypeConf;
        }

        @Override
        public void internalExecute(ReteEvaluator reteEvaluator) {
            Delete.execute(reteEvaluator, this.epn, this.handle, this.context, this.objectTypeConf);
        }

        public static void execute(ReteEvaluator reteEvaluator, EntryPointNode epn, InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf) {
            epn.propagateRetract(handle, context, objectTypeConf, reteEvaluator);
        }

        @Override
        public boolean isPartitionSplittable() {
            return true;
        }

        @Override
        public PropagationEntry getSplitForPartition(int partitionNr) {
            return new PartitionedDelete(this.handle, this.context, this.objectTypeConf, partitionNr);
        }

        public String toString() {
            return "Delete of " + this.handle.getObject();
        }
    }

    public static class PartitionedUpdate
    extends AbstractPartitionedPropagationEntry {
        private final InternalFactHandle handle;
        private final PropagationContext context;
        private final ObjectTypeConf objectTypeConf;

        PartitionedUpdate(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, int partition) {
            super(partition);
            this.handle = handle;
            this.context = context;
            this.objectTypeConf = objectTypeConf;
        }

        @Override
        public void internalExecute(ReteEvaluator reteEvaluator) {
            ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(this.handle.detachLinkedTuplesForPartition(this.partition));
            ObjectTypeNode[] cachedNodes = this.objectTypeConf.getObjectTypeNodes();
            int length = cachedNodes.length;
            for (int i = 0; i < length; ++i) {
                ObjectTypeNode otn = cachedNodes[i];
                ((CompositePartitionAwareObjectSinkAdapter)otn.getObjectSinkPropagator()).propagateModifyObjectForPartition(this.handle, modifyPreviousTuples, this.context.adaptModificationMaskForObjectType(otn.getObjectType(), reteEvaluator), reteEvaluator, this.partition);
                if (i >= cachedNodes.length - 1) continue;
                EntryPointNode.removeRightTuplesMatchingOTN(this.context, reteEvaluator, modifyPreviousTuples, otn, this.partition);
            }
            modifyPreviousTuples.retractTuples(this.context, reteEvaluator);
        }

        public String toString() {
            return "Update of " + this.handle.getObject() + " for partition " + this.partition;
        }
    }

    public static class Update
    extends AbstractPropagationEntry
    implements Externalizable {
        private InternalFactHandle handle;
        private PropagationContext context;
        private ObjectTypeConf objectTypeConf;

        public Update() {
        }

        public Update(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf) {
            this.handle = handle;
            this.context = context;
            this.objectTypeConf = objectTypeConf;
        }

        @Override
        public void internalExecute(ReteEvaluator reteEvaluator) {
            Update.execute(this.handle, this.context, this.objectTypeConf, reteEvaluator);
        }

        public static void execute(InternalFactHandle handle, PropagationContext pctx, ObjectTypeConf objectTypeConf, ReteEvaluator reteEvaluator) {
            if (objectTypeConf == null) {
                objectTypeConf = handle.getEntryPoint(reteEvaluator).getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(handle.getEntryPointId(), handle.getObject());
            }
            ModifyPreviousTuples modifyPreviousTuples = new ModifyPreviousTuples(handle.detachLinkedTuples());
            ObjectTypeNode[] cachedNodes = objectTypeConf.getObjectTypeNodes();
            int length = cachedNodes.length;
            for (int i = 0; i < length; ++i) {
                cachedNodes[i].modifyObject(handle, modifyPreviousTuples, pctx, reteEvaluator);
                if (i >= cachedNodes.length - 1) continue;
                EntryPointNode.removeRightTuplesMatchingOTN(pctx, reteEvaluator, modifyPreviousTuples, cachedNodes[i], 0);
            }
            modifyPreviousTuples.retractTuples(pctx, reteEvaluator);
        }

        @Override
        public boolean isPartitionSplittable() {
            return true;
        }

        @Override
        public PropagationEntry getSplitForPartition(int partitionNr) {
            return new PartitionedUpdate(this.handle, this.context, this.objectTypeConf, partitionNr);
        }

        public String toString() {
            return "Update of " + this.handle.getObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.next);
            out.writeObject(this.handle);
            out.writeObject(this.context);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.next = (PropagationEntry)in.readObject();
            this.handle = (InternalFactHandle)in.readObject();
            this.context = (PropagationContext)in.readObject();
        }
    }

    public static class Insert
    extends AbstractPropagationEntry
    implements Externalizable {
        private static final ObjectTypeNode.ExpireJob job = new ObjectTypeNode.ExpireJob();
        private InternalFactHandle handle;
        private PropagationContext context;
        private ObjectTypeConf objectTypeConf;

        public Insert() {
        }

        public Insert(InternalFactHandle handle, PropagationContext context, ReteEvaluator reteEvaluator, ObjectTypeConf objectTypeConf) {
            this.handle = handle;
            this.context = context;
            this.objectTypeConf = objectTypeConf;
            if (handle.isEvent()) {
                Insert.scheduleExpiration(reteEvaluator, handle, context, objectTypeConf, reteEvaluator.getTimerService().getCurrentTime());
            }
        }

        public static void execute(InternalFactHandle handle, PropagationContext context, ReteEvaluator reteEvaluator, ObjectTypeConf objectTypeConf) {
            if (handle.isEvent()) {
                Insert.scheduleExpiration(reteEvaluator, handle, context, objectTypeConf, reteEvaluator.getTimerService().getCurrentTime());
            }
            Insert.propagate(handle, context, reteEvaluator, objectTypeConf);
        }

        private static void propagate(InternalFactHandle handle, PropagationContext context, ReteEvaluator reteEvaluator, ObjectTypeConf objectTypeConf) {
            if (objectTypeConf == null) {
                objectTypeConf = handle.getEntryPoint(reteEvaluator).getObjectTypeConfigurationRegistry().getOrCreateObjectTypeConf(handle.getEntryPointId(), handle.getObject());
            }
            for (ObjectTypeNode otn : objectTypeConf.getObjectTypeNodes()) {
                otn.propagateAssert(handle, context, reteEvaluator);
            }
            if (Insert.isOrphanHandle(handle, reteEvaluator)) {
                handle.setDisconnected(true);
                handle.getEntryPoint(reteEvaluator).getObjectStore().removeHandle(handle);
            }
        }

        private static boolean isOrphanHandle(InternalFactHandle handle, ReteEvaluator reteEvaluator) {
            return !handle.hasMatches() && !reteEvaluator.getKnowledgeBase().getKieBaseConfiguration().isMutabilityEnabled();
        }

        @Override
        public void internalExecute(ReteEvaluator reteEvaluator) {
            Insert.propagate(this.handle, this.context, reteEvaluator, this.objectTypeConf);
        }

        private static void scheduleExpiration(ReteEvaluator reteEvaluator, InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, long insertionTime) {
            for (ObjectTypeNode otn : objectTypeConf.getObjectTypeNodes()) {
                long expirationOffset = objectTypeConf.isPrototype() ? ((Event)handle.getObject()).getExpiration() : otn.getExpirationOffset();
                Insert.scheduleExpiration(reteEvaluator, handle, context, otn, insertionTime, expirationOffset);
            }
            if (objectTypeConf.getConcreteObjectTypeNode() == null) {
                long expirationOffset = objectTypeConf.isPrototype() ? ((Event)handle.getObject()).getExpiration() : ((ClassObjectTypeConf)objectTypeConf).getExpirationOffset();
                Insert.scheduleExpiration(reteEvaluator, handle, context, null, insertionTime, expirationOffset);
            }
        }

        private static void scheduleExpiration(ReteEvaluator reteEvaluator, InternalFactHandle handle, PropagationContext context, ObjectTypeNode otn, long insertionTime, long expirationOffset) {
            if (expirationOffset == -1L || expirationOffset == Long.MAX_VALUE || context.getReaderContext() != null) {
                return;
            }
            DefaultEventHandle eventFactHandle = (DefaultEventHandle)handle;
            long nextTimestamp = Insert.getNextTimestamp(insertionTime, expirationOffset, eventFactHandle);
            WorkingMemoryReteExpireAction action = new WorkingMemoryReteExpireAction((DefaultEventHandle)handle, otn);
            if (nextTimestamp <= reteEvaluator.getTimerService().getCurrentTime()) {
                reteEvaluator.addPropagation(action);
            } else {
                ObjectTypeNode.ExpireJobContext jobctx = new ObjectTypeNode.ExpireJobContext(action, reteEvaluator);
                DefaultJobHandle jobHandle = (DefaultJobHandle)reteEvaluator.getTimerService().scheduleJob(job, jobctx, PointInTimeTrigger.createPointInTimeTrigger(nextTimestamp, null));
                jobctx.setJobHandle(jobHandle);
                eventFactHandle.addJob(jobHandle);
            }
        }

        private static long getNextTimestamp(long insertionTime, long expirationOffset, DefaultEventHandle eventFactHandle) {
            long effectiveEnd = eventFactHandle.getEndTimestamp() + expirationOffset;
            return Math.max(insertionTime, effectiveEnd >= 0L ? effectiveEnd : Long.MAX_VALUE);
        }

        public String toString() {
            return "Insert of " + this.handle.getObject();
        }

        public InternalFactHandle getHandle() {
            return this.handle;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.next);
            out.writeObject(this.handle);
            out.writeObject(this.context);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.next = (PropagationEntry)in.readObject();
            this.handle = (InternalFactHandle)in.readObject();
            this.context = (PropagationContext)in.readObject();
        }
    }

    public static class ExecuteQuery
    extends PropagationEntryWithResult<QueryTerminalNode[]> {
        private final String queryName;
        private final DroolsQueryImpl queryObject;
        private final InternalFactHandle handle;
        private final PropagationContext pCtx;
        private final boolean calledFromRHS;

        public ExecuteQuery(String queryName, DroolsQueryImpl queryObject, InternalFactHandle handle, PropagationContext pCtx, boolean calledFromRHS) {
            this.queryName = queryName;
            this.queryObject = queryObject;
            this.handle = handle;
            this.pCtx = pCtx;
            this.calledFromRHS = calledFromRHS;
        }

        @Override
        public void internalExecute(ReteEvaluator reteEvaluator) {
            QueryTerminalNode[] tnodes = reteEvaluator.getKnowledgeBase().getReteooBuilder().getTerminalNodesForQuery(this.queryName);
            if (tnodes == null) {
                throw new RuntimeException("Query '" + this.queryName + "' does not exist");
            }
            QueryTerminalNode tnode = tnodes[0];
            if (this.queryObject.getElements().length != tnode.getQuery().getParameters().length) {
                throw new RuntimeException("Query '" + this.queryName + "' has been invoked with a wrong number of arguments. Expected " + tnode.getQuery().getParameters().length + ", actual " + this.queryObject.getElements().length);
            }
            LeftTupleSource lts = tnode.getLeftTupleSource();
            while (lts.getType() != 120) {
                lts = lts.getLeftTupleSource();
            }
            LeftInputAdapterNode lian = (LeftInputAdapterNode)lts;
            LeftInputAdapterNode.LiaNodeMemory lmem = reteEvaluator.getNodeMemory(lian);
            if (lmem.getSegmentMemory() == null) {
                RuntimeSegmentUtilities.getOrCreateSegmentMemory(lmem, lts, reteEvaluator);
            }
            LeftInputAdapterNode.doInsertObject(this.handle, this.pCtx, lian, reteEvaluator, lmem, false, this.queryObject.isOpen());
            for (PathMemory rm : lmem.getSegmentMemory().getPathMemories()) {
                RuleAgendaItem evaluator = reteEvaluator.getActivationsManager().createRuleAgendaItem(Integer.MAX_VALUE, rm, (TerminalNode)rm.getPathEndNode());
                evaluator.getRuleExecutor().setDirty(true);
                evaluator.getRuleExecutor().evaluateNetworkAndFire(reteEvaluator, null, 0, -1);
            }
            this.done(tnodes);
        }

        @Override
        public boolean isCalledFromRHS() {
            return this.calledFromRHS;
        }
    }

    public static abstract class PropagationEntryWithResult<T>
    extends AbstractPropagationEntry {
        private final CountDownLatch done = new CountDownLatch(1);
        private T result;

        public final T getResult() {
            try {
                this.done.await();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            return this.result;
        }

        protected void done(T result) {
            this.result = result;
            this.done.countDown();
        }

        @Override
        public boolean requiresImmediateFlushing() {
            return true;
        }
    }

    public static abstract class AbstractPartitionedPropagationEntry
    extends AbstractPropagationEntry {
        protected final int partition;

        protected AbstractPartitionedPropagationEntry(int partition) {
            this.partition = partition;
        }

        protected boolean isMainPartition() {
            return this.partition == 0;
        }
    }

    public static abstract class AbstractPropagationEntry
    implements PropagationEntry {
        protected PropagationEntry next;

        @Override
        public void setNext(PropagationEntry next) {
            this.next = next;
        }

        @Override
        public PropagationEntry getNext() {
            return this.next;
        }

        @Override
        public boolean requiresImmediateFlushing() {
            return false;
        }

        @Override
        public boolean isCalledFromRHS() {
            return false;
        }

        @Override
        public boolean isPartitionSplittable() {
            return false;
        }

        @Override
        public boolean defersExpiration() {
            return false;
        }

        @Override
        public PropagationEntry getSplitForPartition(int partitionNr) {
            throw new UnsupportedOperationException();
        }
    }
}

