/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.quarkus.deployment;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.drools.util.IoUtils;
import org.drools.util.io.ByteArrayResource;
import org.drools.util.io.FileSystemResource;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceCollector {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceCollector.class);

    private ResourceCollector() {
    }

    public static Collection<Resource> fromPaths(Path ... paths) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Path path : paths) {
            Collection<Resource> res;
            if (path.toFile().isDirectory()) {
                res = ResourceCollector.fromDirectory(path);
                resources.addAll(res);
                continue;
            }
            if (path.getFileName().toString().endsWith(".jar") || path.getFileName().toString().endsWith(".jar.original")) {
                res = ResourceCollector.fromJarFile(path);
                resources.addAll(res);
                continue;
            }
            if (!path.toFile().exists()) {
                LOGGER.debug("Skipping '{}' because doesn't exist", (Object)path);
                continue;
            }
            throw new IllegalArgumentException("Expected directory or archive, file given: " + path);
        }
        return resources;
    }

    public static Collection<Resource> fromJarFile(Path jarPath) {
        ArrayList<Resource> arrayList;
        ArrayList<Resource> resources = new ArrayList<Resource>();
        ZipFile zipFile = new ZipFile(jarPath.toFile());
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                ResourceType resourceType = ResourceType.determineResourceType((String)entry.getName());
                if (resourceType == null) continue;
                ByteArrayResource resource = new ByteArrayResource(IoUtils.readBytesFromInputStream((InputStream)zipFile.getInputStream(entry)));
                resource.setSourcePath(entry.getName());
                resource.setResourceType(resourceType);
                resources.add((Resource)resource);
            }
            arrayList = resources;
        }
        catch (Throwable throwable) {
            try {
                try {
                    zipFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        zipFile.close();
        return arrayList;
    }

    public static Collection<Resource> fromDirectory(Path path) {
        Collection collection;
        block8: {
            Stream<Path> paths = Files.walk(path, new FileVisitOption[0]);
            try {
                collection = paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).map(Path::toFile).map(f -> ResourceCollector.toResource(f)).filter(Objects::nonNull).collect(Collectors.toList());
                if (paths == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (paths != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            paths.close();
        }
        return collection;
    }

    private static Resource toResource(File file) {
        ResourceType resourceType = ResourceType.determineResourceType((String)file.getName());
        if (resourceType == null) {
            return null;
        }
        FileSystemResource resource = new FileSystemResource(file);
        resource.setResourceType(resourceType);
        return resource;
    }
}

