/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drl.quarkus.deployment;

import io.quarkus.arc.deployment.GeneratedBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.nativeimage.NativeImageResourceBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.vertx.http.deployment.spi.AdditionalStaticResourceBuildItem;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.drools.codegen.common.AppPaths;
import org.drools.codegen.common.DroolsModelBuildContext;
import org.drools.codegen.common.GeneratedFile;
import org.drools.codegen.common.GeneratedFileType;
import org.drools.drl.quarkus.deployment.ResourceCollector;
import org.drools.drl.quarkus.util.deployment.DroolsQuarkusResourceUtils;
import org.drools.drl.quarkus.util.deployment.KmoduleKieBaseModelsBuiltItem;
import org.drools.drl.quarkus.util.deployment.PatternsTypesBuildItem;
import org.drools.model.codegen.execmodel.PackageModel;
import org.drools.model.codegen.project.RuleCodegen;
import org.jboss.jandex.IndexView;
import org.kie.api.io.Resource;
import org.kie.drl.engine.runtime.mapinput.service.KieRuntimeServiceDrlMapInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DroolsAssetsProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DroolsAssetsProcessor.class);
    @Inject
    ArchiveRootBuildItem root;
    @Inject
    LiveReloadBuildItem liveReload;
    @Inject
    CurateOutcomeBuildItem curateOutcomeBuildItem;
    @Inject
    CombinedIndexBuildItem combinedIndexBuildItem;
    @Inject
    OutputTargetBuildItem outputTargetBuildItem;
    private static final String FEATURE = "drools-drl-quarkus-extension";

    @BuildStep
    public FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep
    public void generateSources(BuildProducer<GeneratedBeanBuildItem> generatedBeans, BuildProducer<NativeImageResourceBuildItem> resource, BuildProducer<AdditionalStaticResourceBuildItem> staticResProducer, BuildProducer<GeneratedResourceBuildItem> genResBI, BuildProducer<PatternsTypesBuildItem> otnClasesBI, BuildProducer<KmoduleKieBaseModelsBuiltItem> kbaseModelsBI) {
        DroolsModelBuildContext context = DroolsQuarkusResourceUtils.createDroolsBuildContext((Path)this.outputTargetBuildItem.getOutputDirectory(), (Iterable)this.root.getPaths(), (IndexView)this.combinedIndexBuildItem.getIndex());
        Collection<Resource> resources = ResourceCollector.fromPaths(context.getAppPaths().getPaths());
        RuleCodegen ruleCodegen = RuleCodegen.ofResources((DroolsModelBuildContext)context, resources);
        Collection generatedFiles = ruleCodegen.generate();
        generatedFiles.addAll(DroolsQuarkusResourceUtils.getRuleUnitDefProducerSource((IndexView)this.combinedIndexBuildItem.getIndex()));
        if (!this.liveReload.isLiveReload()) {
            generatedFiles.add(new GeneratedFile(GeneratedFileType.SOURCE, DroolsQuarkusResourceUtils.HOT_RELOAD_SUPPORT_PATH + ".java", DroolsQuarkusResourceUtils.getHotReloadSupportSource()));
        }
        DroolsQuarkusResourceUtils.dumpFilesToDisk((AppPaths)context.getAppPaths(), (Collection)generatedFiles);
        Collection dependencies = this.curateOutcomeBuildItem.getApplicationModel().getRuntimeDependencies();
        Collection generatedBeanBuildItems = DroolsQuarkusResourceUtils.compileGeneratedSources((DroolsModelBuildContext)context, (Collection)dependencies, (Collection)generatedFiles, (boolean)this.liveReload.isLiveReload());
        generatedBeanBuildItems.forEach(arg_0 -> generatedBeans.produce(arg_0));
        DroolsQuarkusResourceUtils.registerResources((Collection)generatedFiles, staticResProducer, resource, genResBI);
        otnClasesBI.produce((BuildItem)new PatternsTypesBuildItem(ruleCodegen.getPackageModels().stream().collect(Collectors.toMap(PackageModel::getName, PackageModel::getOtnsClasses))));
        if (ruleCodegen.getKmoduleKieBaseModels() != null) {
            kbaseModelsBI.produce((BuildItem)new KmoduleKieBaseModelsBuiltItem(ruleCodegen.getKmoduleKieBaseModels()));
        }
    }

    @BuildStep
    public List<ReflectiveClassBuildItem> reflectiveEfestoRules() {
        LOGGER.debug("reflectiveEfestoRules()");
        ArrayList<ReflectiveClassBuildItem> toReturn = new ArrayList<ReflectiveClassBuildItem>();
        toReturn.add(new ReflectiveClassBuildItem(true, true, new Class[]{KieRuntimeServiceDrlMapInput.class}));
        LOGGER.debug("toReturn {}", (Object)toReturn.size());
        return toReturn;
    }
}

