/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.cli.tests;

import java.io.InputStream;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ConversionsUsingCliTest {
    @Test
    public void testDrl2Yaml() throws Exception {
        InputStream generatedResource = this.getClass().getResourceAsStream("/converted.test1.yml");
        Assertions.assertThat((InputStream)generatedResource).isNotNull();
        String ymlContent = this.trimUpToThenAndNoWhitespace(generatedResource.readAllBytes());
        String expectedContent = this.trimUpToThenAndNoWhitespace(this.getClass().getResourceAsStream("/expected/test1.yml").readAllBytes());
        ((AbstractStringAssert)Assertions.assertThat((String)ymlContent).as("the converted Yaml matches the expected content)", new Object[0])).isEqualTo(expectedContent);
    }

    @Test
    public void testYaml2Drl() throws Exception {
        InputStream generatedResource = this.getClass().getResourceAsStream("/converted.test2.drl");
        Assertions.assertThat((InputStream)generatedResource).isNotNull();
        String ymlContent = this.trimUpToThenAndNoWhitespace(generatedResource.readAllBytes());
        String expectedContent = this.trimUpToThenAndNoWhitespace(this.getClass().getResourceAsStream("/expected/test2.drl.txt").readAllBytes());
        ((AbstractStringAssert)Assertions.assertThat((String)ymlContent).as("the converted DRL matches the expected content)", new Object[0])).isEqualTo(expectedContent);
    }

    private String trimUpToThenAndNoWhitespace(byte[] content) {
        String result = new String(content).strip();
        result = result.substring(0, result.indexOf("then"));
        result = result.replaceAll("\\s+", "");
        return result;
    }

    @Test
    public void testBatch2Yaml() {
        Assertions.assertThat((InputStream)this.getClass().getResourceAsStream("/batch_drl_files/test1.drl.yml")).isNotNull();
    }

    @Test
    public void testBatch2Drl() {
        Assertions.assertThat((InputStream)this.getClass().getResourceAsStream("/batch_yml_files/test2.yml.drl")).isNotNull();
    }
}

