/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.drools.core.BaseConfiguration;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.CoreComponentsBuilder;
import org.drools.core.process.WorkItemManagerFactory;
import org.drools.core.util.ConfFileUtils;
import org.kie.api.conf.ConfigurationKey;
import org.kie.api.conf.OptionKey;
import org.kie.api.runtime.KieSessionConfiguration;
import org.kie.api.runtime.conf.KieSessionOption;
import org.kie.api.runtime.conf.MultiValueKieSessionOption;
import org.kie.api.runtime.conf.SingleValueKieSessionOption;
import org.kie.api.runtime.conf.WorkItemHandlerOption;
import org.kie.api.runtime.process.WorkItemHandler;
import org.kie.internal.conf.CompositeConfiguration;

public class FlowSessionConfiguration
extends BaseConfiguration<KieSessionOption, SingleValueKieSessionOption, MultiValueKieSessionOption>
implements KieSessionConfiguration,
Externalizable {
    private static final long serialVersionUID = 510L;
    private Map<String, WorkItemHandler> workItemHandlers;
    private WorkItemManagerFactory workItemManagerFactory;
    public static final ConfigurationKey<FlowSessionConfiguration> KEY = new ConfigurationKey("Flow");

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public FlowSessionConfiguration(CompositeConfiguration<KieSessionOption, SingleValueKieSessionOption, MultiValueKieSessionOption> compConfig) {
        super(compConfig);
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers() {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers(new HashMap<String, Object>());
        }
        return this.workItemHandlers;
    }

    public Map<String, WorkItemHandler> getWorkItemHandlers(Map<String, Object> params) {
        if (this.workItemHandlers == null) {
            this.initWorkItemHandlers(params);
        }
        return this.workItemHandlers;
    }

    private void initWorkItemHandlers(Map<String, Object> params) {
        String[] locations;
        this.workItemHandlers = new HashMap<String, WorkItemHandler>();
        for (String factoryLocation : locations = this.getPropertyValue("drools.workItemHandlers", "").split("\\s")) {
            if ((factoryLocation = factoryLocation.trim()).startsWith("\"")) {
                factoryLocation = factoryLocation.substring(1);
            }
            if (factoryLocation.endsWith("\"")) {
                factoryLocation = factoryLocation.substring(0, factoryLocation.length() - 1);
            }
            if (factoryLocation.equals("")) continue;
            this.loadWorkItemHandlers(factoryLocation, params);
        }
    }

    private void loadWorkItemHandlers(String location, Map<String, Object> params) {
        String content = ConfFileUtils.URLContentsToString(ConfFileUtils.getURL(location, null, RuleBaseConfiguration.class));
        Map workItemHandlers = (Map)CoreComponentsBuilder.get().getMVELExecutor().eval(content, params);
        this.workItemHandlers.putAll(workItemHandlers);
    }

    public WorkItemManagerFactory getWorkItemManagerFactory() {
        if (this.workItemManagerFactory == null) {
            this.initWorkItemManagerFactory();
        }
        return this.workItemManagerFactory;
    }

    public void setWorkItemManagerFactory(WorkItemManagerFactory workItemManagerFactory) {
        this.workItemManagerFactory = workItemManagerFactory;
    }

    private void initWorkItemManagerFactory() {
        String className = this.getPropertyValue("drools.workItemManagerFactory", "org.drools.core.process.impl.DefaultWorkItemManagerFactory");
        Class<?> clazz = null;
        try {
            clazz = this.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (clazz != null) {
            try {
                this.workItemManagerFactory = (WorkItemManagerFactory)clazz.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Unable to instantiate work item manager factory '" + className + "'", e);
            }
        } else {
            throw new IllegalArgumentException("Work item manager factory '" + className + "' not found");
        }
    }

    public String getProcessInstanceManagerFactory() {
        return this.getPropertyValue("drools.processInstanceManagerFactory", "org.jbpm.process.instance.impl.DefaultProcessInstanceManagerFactory");
    }

    public String getSignalManagerFactory() {
        return this.getPropertyValue("drools.processSignalManagerFactory", "org.jbpm.process.instance.event.DefaultSignalManagerFactory");
    }

    @Override
    public final <T extends KieSessionOption> void setOption(T option) {
        switch (option.propertyName()) {
            case "drools.workItemHandlers": {
                this.getWorkItemHandlers().put(((WorkItemHandlerOption)option).getName(), ((WorkItemHandlerOption)option).getHandler());
                break;
            }
            default: {
                this.compConfig.setOption(option);
            }
        }
    }

    @Override
    public final <T extends SingleValueKieSessionOption> T getOption(OptionKey<T> option) {
        return (T)((SingleValueKieSessionOption)this.compConfig.getOption(option));
    }

    @Override
    public final <T extends MultiValueKieSessionOption> T getOption(OptionKey<T> option, String subKey) {
        switch (option.name()) {
            case "drools.workItemHandlers": {
                return (T)WorkItemHandlerOption.get(subKey, this.getWorkItemHandlers().get(subKey));
            }
        }
        return (T)((MultiValueKieSessionOption)this.compConfig.getOption(option, subKey));
    }

    @Override
    public <C extends MultiValueKieSessionOption> Set<String> getOptionSubKeys(OptionKey<C> optionKey) {
        return this.getWorkItemHandlers().keySet();
    }

    @Override
    public final boolean setInternalProperty(String name, String value) {
        return false;
    }

    @Override
    public final String getInternalProperty(String name) {
        return null;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FlowSessionConfiguration that = (FlowSessionConfiguration)o;
        return this.getWorkItemHandlers().equals(that.getWorkItemHandlers());
    }

    public final int hashCode() {
        int result = this.getWorkItemHandlers().hashCode();
        return result;
    }
}

