/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.common.TupleSets;
import org.drools.core.common.TupleSetsImpl;
import org.drools.core.phreak.BuildtimeSegmentUtilities;
import org.drools.core.phreak.RuntimeSegmentUtilities;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.PathEndNode;
import org.drools.core.reteoo.PathMemory;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.ReactiveFromNode;
import org.drools.core.reteoo.RightInputAdapterNode;
import org.drools.core.reteoo.SegmentNodeMemory;
import org.drools.core.reteoo.TimerNode;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMemory
extends LinkedList<SegmentMemory>
implements LinkedListNode<SegmentMemory> {
    protected static final Logger log = LoggerFactory.getLogger(SegmentMemory.class);
    protected static final boolean IS_LOG_TRACE_ENABLED = log.isTraceEnabled();
    private SegmentPrototype proto;
    private Memory[] nodeMemories;
    private final List<PathMemory> pathMemories = new ArrayList<PathMemory>(1);
    private final TupleSets<LeftTuple> stagedLeftTuples = new TupleSetsImpl<LeftTuple>();
    private long linkedNodeMask;
    private long dirtyNodeMask;
    private long allLinkedMaskTest;
    private long segmentPosMaskBit;
    private int pos = -1;
    private boolean active;
    private SegmentMemory previous;
    private SegmentMemory next;
    private transient List<PathMemory> dataDrivenPathMemories;
    private transient List<SegmentMemory> peersWithDataDrivenPathMemories;

    public SegmentMemory() {
    }

    public SegmentMemory(LeftTupleNode rootNode) {
        this.proto = new SegmentPrototype(rootNode, null);
    }

    public <T extends Memory> T createNodeMemory(MemoryFactory<T> memoryFactory, ReteEvaluator reteEvaluator) {
        return reteEvaluator.getNodeMemory(memoryFactory);
    }

    public LeftTupleNode getRootNode() {
        return this.proto.getRootNode();
    }

    public SegmentPrototype getSegmentPrototype() {
        return this.proto;
    }

    public LeftTupleNode getTipNode() {
        return this.proto.getTipNode();
    }

    public void setTipNode(LeftTupleNode tipNode) {
        this.proto.setTipNode(tipNode);
    }

    public LeftTupleSink getSinkFactory() {
        return (LeftTupleSink)this.proto.getRootNode();
    }

    public Memory[] getNodeMemories() {
        return this.nodeMemories;
    }

    public void setNodeMemories(Memory[] nodeMemories) {
        this.nodeMemories = nodeMemories;
    }

    public long getLinkedNodeMask() {
        return this.linkedNodeMask;
    }

    public void setLinkedNodeMask(long linkedNodeMask) {
        this.linkedNodeMask = linkedNodeMask;
    }

    public long getDirtyNodeMask() {
        return this.dirtyNodeMask;
    }

    public void setDirtyNodeMask(long dirtyNodeMask) {
        this.dirtyNodeMask = dirtyNodeMask;
    }

    public void updateDirtyNodeMask(long mask) {
        this.dirtyNodeMask |= mask;
    }

    public void updateCleanNodeMask(long mask) {
        this.dirtyNodeMask &= mask ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public String getRuleNames() {
        StringBuilder sbuilder = new StringBuilder();
        for (int i = 0; i < this.pathMemories.size(); ++i) {
            if (i > 0) {
                sbuilder.append(", ");
            }
            sbuilder.append(this.pathMemories.get(i));
        }
        return sbuilder.toString();
    }

    public boolean linkNode(long mask, ReteEvaluator reteEvaluator) {
        this.linkedNodeMask |= mask;
        this.dirtyNodeMask |= mask;
        if (IS_LOG_TRACE_ENABLED) {
            log.trace("LinkNode notify=true nmask={} smask={} spos={} rules={}", mask, this.linkedNodeMask, this.pos, this.getRuleNames());
        }
        return this.notifyRuleLinkSegment(reteEvaluator);
    }

    public boolean linkNodeWithoutRuleNotify(long mask) {
        this.linkedNodeMask |= mask;
        this.dirtyNodeMask |= mask;
        if (IS_LOG_TRACE_ENABLED) {
            log.trace("LinkNode notify=false nmask={} smask={} spos={} rules={}", mask, this.linkedNodeMask, this.pos, this.getRuleNames());
        }
        return this.linkSegmentWithoutRuleNotify();
    }

    public boolean linkSegmentWithoutRuleNotify(long mask) {
        this.dirtyNodeMask |= mask;
        return this.linkSegmentWithoutRuleNotify();
    }

    private boolean linkSegmentWithoutRuleNotify() {
        boolean dataDrivePmemLinked = false;
        if (this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                PathMemory pmem = this.pathMemories.get(i);
                pmem.linkSegmentWithoutRuleNotify(this.segmentPosMaskBit);
                dataDrivePmemLinked |= pmem.isDataDriven() && pmem.isRuleLinked();
            }
        }
        return dataDrivePmemLinked;
    }

    public boolean notifyRuleLinkSegment(ReteEvaluator reteEvaluator, long mask) {
        this.dirtyNodeMask |= mask;
        return this.notifyRuleLinkSegment(reteEvaluator);
    }

    public boolean notifyRuleLinkSegment(ReteEvaluator reteEvaluator) {
        boolean dataDrivePmemLinked = false;
        if (this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                PathMemory pmem = this.pathMemories.get(i);
                this.notifyRuleLinkSegment(reteEvaluator, pmem);
                dataDrivePmemLinked |= pmem.isDataDriven() && pmem.isRuleLinked();
            }
        }
        return dataDrivePmemLinked;
    }

    public void notifyRuleLinkSegment(ReteEvaluator reteEvaluator, PathMemory pmem) {
        pmem.linkSegment(this.segmentPosMaskBit, reteEvaluator);
    }

    public boolean unlinkNode(long mask, ReteEvaluator reteEvaluator) {
        boolean dataDrivePmemLinked = false;
        boolean linked = this.isSegmentLinked();
        this.linkedNodeMask &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        this.dirtyNodeMask |= mask;
        if (IS_LOG_TRACE_ENABLED) {
            log.trace("UnlinkNode notify=true nmask={} smask={} spos={} rules={}", mask, this.linkedNodeMask, this.pos, this.getRuleNames());
        }
        if (linked && !this.isSegmentLinked()) {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                PathMemory pmem = this.pathMemories.get(i);
                dataDrivePmemLinked |= pmem.isDataDriven() && pmem.isRuleLinked();
                pmem.unlinkedSegment(this.segmentPosMaskBit, reteEvaluator);
            }
        } else {
            int length = this.pathMemories.size();
            for (int i = 0; i < length; ++i) {
                if (!this.pathMemories.get(i).isRuleLinked()) continue;
                this.pathMemories.get(i).doLinkRule(reteEvaluator);
            }
        }
        return dataDrivePmemLinked;
    }

    public void unlinkSegment(ReteEvaluator reteEvaluator) {
        int length = this.pathMemories.size();
        for (int i = 0; i < length; ++i) {
            this.pathMemories.get(i).unlinkedSegment(this.segmentPosMaskBit, reteEvaluator);
        }
    }

    public void unlinkNodeWithoutRuleNotify(long mask) {
        this.linkedNodeMask &= mask ^ 0xFFFFFFFFFFFFFFFFL;
        if (IS_LOG_TRACE_ENABLED) {
            log.trace("UnlinkNode notify=false nmask={} smask={} spos={} rules={}", mask, this.linkedNodeMask, this.pos, this.getRuleNames());
        }
    }

    public long getAllLinkedMaskTest() {
        return this.allLinkedMaskTest;
    }

    public void setAllLinkedMaskTest(long allLinkedTestMask) {
        this.allLinkedMaskTest = allLinkedTestMask;
    }

    public boolean isSegmentLinked() {
        return (this.linkedNodeMask & this.allLinkedMaskTest) == this.allLinkedMaskTest;
    }

    public List<PathMemory> getPathMemories() {
        return this.pathMemories;
    }

    public void addPathMemory(PathMemory pathMemory) {
        if (this.pathMemories.contains(pathMemory)) {
            System.out.println("!!!");
        }
        this.pathMemories.add(pathMemory);
        if (this.getAllLinkedMaskTest() > 0L && this.isSegmentLinked()) {
            pathMemory.linkSegmentWithoutRuleNotify(this.segmentPosMaskBit);
        }
        if (pathMemory.isDataDriven()) {
            if (this.dataDrivenPathMemories == null) {
                this.dataDrivenPathMemories = new ArrayList<PathMemory>();
            }
            this.dataDrivenPathMemories.add(pathMemory);
        }
    }

    public void mergePathMemories(SegmentMemory segmentMemory) {
        for (PathMemory pmem : segmentMemory.getPathMemories()) {
            if (!this.isAssociatedWith(pmem)) continue;
            this.addPathMemory(pmem);
        }
    }

    private boolean isAssociatedWith(PathMemory pmem) {
        if (71 == pmem.getNodeType()) {
            for (PathEndNode endNode : pmem.getPathEndNode().getPathEndNodes()) {
                if (!NodeTypeEnums.isTerminalNode(endNode) || !this.proto.getRootNode().hasAssociatedTerminal(endNode)) continue;
                return true;
            }
            return false;
        }
        return this.proto.getRootNode().hasAssociatedTerminal(pmem.getPathEndNode());
    }

    public void removePathMemory(PathMemory pathMemory) {
        this.pathMemories.remove(pathMemory);
        if (pathMemory.isDataDriven()) {
            this.dataDrivenPathMemories.remove(pathMemory);
            if (this.dataDrivenPathMemories.isEmpty()) {
                this.dataDrivenPathMemories = null;
            }
        }
    }

    public PathMemory getFirstDataDrivenPathMemory() {
        return this.dataDrivenPathMemories == null ? null : this.dataDrivenPathMemories.get(0);
    }

    public boolean hasDataDrivenPathMemories() {
        return this.dataDrivenPathMemories != null;
    }

    public List<PathMemory> getDataDrivenPathMemories() {
        return this.dataDrivenPathMemories;
    }

    public long getSegmentPosMaskBit() {
        return this.segmentPosMaskBit;
    }

    public void setSegmentPosMaskBit(long segmentPosMaskBit) {
        this.segmentPosMaskBit = segmentPosMaskBit;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean evaluating) {
        this.active = evaluating;
    }

    public int getPos() {
        return this.pos;
    }

    public void setPos(int pos) {
        this.pos = pos;
    }

    public TupleSets<LeftTuple> getStagedLeftTuples() {
        return this.stagedLeftTuples;
    }

    @Override
    public void add(SegmentMemory segmentMemory) {
        super.add(segmentMemory);
        if (segmentMemory.hasDataDrivenPathMemories()) {
            if (this.peersWithDataDrivenPathMemories == null) {
                this.peersWithDataDrivenPathMemories = new ArrayList<SegmentMemory>();
            }
            this.peersWithDataDrivenPathMemories.add(segmentMemory);
        }
    }

    @Override
    public void remove(SegmentMemory segmentMemory) {
        super.remove(segmentMemory);
        if (this.peersWithDataDrivenPathMemories != null) {
            this.peersWithDataDrivenPathMemories.remove(segmentMemory);
            if (this.peersWithDataDrivenPathMemories.isEmpty()) {
                this.peersWithDataDrivenPathMemories = null;
            }
        }
    }

    public Iterator<SegmentMemory> getPeersWithDataDrivenPathMemoriesIterator() {
        return this.peersWithDataDrivenPathMemories == null ? Collections.emptyIterator() : this.peersWithDataDrivenPathMemories.iterator();
    }

    @Override
    public SegmentMemory getNext() {
        return this.next;
    }

    @Override
    public void setNext(SegmentMemory next) {
        this.next = next;
        if (this.next == this) {
            throw new RuntimeException();
        }
    }

    @Override
    public SegmentMemory getPrevious() {
        return this.previous;
    }

    @Override
    public void setPrevious(SegmentMemory previous) {
        this.previous = previous;
    }

    @Override
    public void nullPrevNext() {
        this.previous = null;
        this.next = null;
    }

    @Override
    public int hashCode() {
        return this.proto.getRootNode().getId();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof SegmentMemory && this.proto.getRootNode().getId() == ((SegmentMemory)obj).proto.getRootNode().getId() && this.proto.getTipNode().getId() == ((SegmentMemory)obj).proto.getTipNode().getId();
    }

    public void reset(SegmentPrototype segmentPrototype) {
        this.dirtyNodeMask = 0L;
        this.linkedNodeMask = segmentPrototype != null ? segmentPrototype.linkedNodeMask : 0L;
        this.stagedLeftTuples.resetAll();
    }

    public String toString() {
        return "Segment root " + this.proto.getRootNode() + " tip " + this.proto.getTipNode();
    }

    public static class AccumulateMemoryPrototype
    extends MemoryPrototype {
        private final BetaMemoryPrototype betaProto;

        public AccumulateMemoryPrototype(BetaMemoryPrototype betaProto) {
            this.betaProto = betaProto;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory accMemory) {
            this.betaProto.populateMemory(reteEvaluator, ((AccumulateNode.AccumulateMemory)accMemory).getBetaMemory());
        }
    }

    public static class AsyncReceiveMemoryPrototype
    extends MemoryPrototype {
        public AsyncReceiveMemoryPrototype(long nodePosMaskBit) {
            this.nodePosMaskBit = nodePosMaskBit;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory mem) {
            AsyncReceiveNode.AsyncReceiveMemory amem = (AsyncReceiveNode.AsyncReceiveMemory)mem;
            amem.setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class AsyncSendMemoryPrototype
    extends MemoryPrototype {
        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory mem) {
        }
    }

    public static class TimerMemoryPrototype
    extends MemoryPrototype {
        public TimerMemoryPrototype(long nodePosMaskBit) {
            this.nodePosMaskBit = nodePosMaskBit;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory mem) {
            TimerNode.TimerNodeMemory tmem = (TimerNode.TimerNodeMemory)mem;
            tmem.setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class QueryMemoryPrototype
    extends MemoryPrototype {
        private final QueryElementNode queryNode;

        public QueryMemoryPrototype(long nodePosMaskBit, QueryElementNode queryNode) {
            this.nodePosMaskBit = nodePosMaskBit;
            this.queryNode = queryNode;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory mem) {
            QueryElementNode.QueryElementNodeMemory qmem = (QueryElementNode.QueryElementNodeMemory)mem;
            SegmentMemory querySmem = RuntimeSegmentUtilities.getQuerySegmentMemory(reteEvaluator, (LeftTupleSource)qmem.getSegmentMemory().getRootNode(), this.queryNode);
            qmem.setQuerySegmentMemory(querySmem);
            qmem.setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class EvalMemoryPrototype
    extends MemoryPrototype {
        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
        }
    }

    public static class FromMemoryPrototype
    extends MemoryPrototype {
        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
        }
    }

    public static class TerminalPrototype
    extends MemoryPrototype {
        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
        }
    }

    public static class RightInputAdapterPrototype
    extends MemoryPrototype {
        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
        }
    }

    public static class ConditionalBranchMemoryPrototype
    extends MemoryPrototype {
        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
        }
    }

    public static class ReactiveFromMemoryPrototype
    extends MemoryPrototype {
        public ReactiveFromMemoryPrototype(long nodePosMaskBit) {
            this.nodePosMaskBit = nodePosMaskBit;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
            ((ReactiveFromNode.ReactiveFromMemory)memory).setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class LiaMemoryPrototype
    extends MemoryPrototype {
        public LiaMemoryPrototype(long nodePosMaskBit) {
            this.nodePosMaskBit = nodePosMaskBit;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory liaMemory) {
            ((SegmentNodeMemory)liaMemory).setNodePosMaskBit(this.nodePosMaskBit);
        }
    }

    public static class BetaMemoryPrototype
    extends MemoryPrototype {
        private final RightInputAdapterNode riaNode;

        public BetaMemoryPrototype(long nodePosMaskBit, RightInputAdapterNode riaNode) {
            this.nodePosMaskBit = nodePosMaskBit;
            this.riaNode = riaNode;
        }

        @Override
        public void populateMemory(ReteEvaluator reteEvaluator, Memory memory) {
            BetaMemory betaMemory = (BetaMemory)memory;
            betaMemory.setNodePosMaskBit(this.nodePosMaskBit);
            if (this.riaNode != null) {
                RightInputAdapterNode.RiaPathMemory riaMem = (RightInputAdapterNode.RiaPathMemory)reteEvaluator.getNodeMemories().peekNodeMemory(this.riaNode);
                if (riaMem == null) {
                    riaMem = (RightInputAdapterNode.RiaPathMemory)RuntimeSegmentUtilities.initializePathMemory(reteEvaluator, this.riaNode);
                }
                betaMemory.setRiaRuleMemory(riaMem);
            }
        }
    }

    public static abstract class MemoryPrototype {
        protected long nodePosMaskBit;

        public static MemoryPrototype get(Memory memory) {
            if (memory instanceof BetaMemory) {
                BetaMemory betaMemory = (BetaMemory)memory;
                return new BetaMemoryPrototype(betaMemory.getNodePosMaskBit(), betaMemory.getRiaRuleMemory() != null ? betaMemory.getRiaRuleMemory().getRightInputAdapterNode() : null);
            }
            if (memory instanceof LeftInputAdapterNode.LiaNodeMemory) {
                return new LiaMemoryPrototype(((LeftInputAdapterNode.LiaNodeMemory)memory).getNodePosMaskBit());
            }
            if (memory instanceof QueryElementNode.QueryElementNodeMemory) {
                QueryElementNode.QueryElementNodeMemory queryMemory = (QueryElementNode.QueryElementNodeMemory)memory;
                return new QueryMemoryPrototype(queryMemory.getNodePosMaskBit(), queryMemory.getNode());
            }
            if (memory instanceof TimerNode.TimerNodeMemory) {
                return new TimerMemoryPrototype(((TimerNode.TimerNodeMemory)memory).getNodePosMaskBit());
            }
            if (memory instanceof AccumulateNode.AccumulateMemory) {
                BetaMemory betaMemory = ((AccumulateNode.AccumulateMemory)memory).getBetaMemory();
                return new AccumulateMemoryPrototype(new BetaMemoryPrototype(betaMemory.getNodePosMaskBit(), betaMemory.getRiaRuleMemory() != null ? betaMemory.getRiaRuleMemory().getRightInputAdapterNode() : null));
            }
            if (memory instanceof ReactiveFromNode.ReactiveFromMemory) {
                return new ReactiveFromMemoryPrototype(((ReactiveFromNode.ReactiveFromMemory)memory).getNodePosMaskBit());
            }
            return null;
        }

        public abstract void populateMemory(ReteEvaluator var1, Memory var2);

        public void setNodePosMaskBit(long nodePosMaskBit) {
            this.nodePosMaskBit = nodePosMaskBit;
        }

        public long getNodePosMaskBit() {
            return this.nodePosMaskBit;
        }
    }

    public static class SegmentPrototype {
        private LeftTupleNode rootNode;
        private LeftTupleNode tipNode;
        long linkedNodeMask;
        long allLinkedMaskTest;
        long segmentPosMaskBit;
        int pos;
        boolean requiresEager;
        int nodeTypesInSegment = 0;
        MemoryPrototype[] memories;
        LeftTupleNode[] nodesInSegment;
        PathEndNode[] pathEndNodes;

        public SegmentPrototype(LeftTupleNode rootNode, LeftTupleNode tipNode) {
            this.rootNode = rootNode;
            this.tipNode = tipNode;
        }

        public SegmentMemory newSegmentMemory(ReteEvaluator reteEvaluator) {
            SegmentMemory smem = new SegmentMemory();
            this.updateSegmentMemory(smem, reteEvaluator);
            return smem;
        }

        public SegmentMemory shallowNewSegmentMemory() {
            SegmentMemory smem = new SegmentMemory();
            this.shallowUpdateSegmentMemory(smem);
            return smem;
        }

        public void shallowUpdateSegmentMemory(SegmentMemory smem) {
            smem.proto = this;
            smem.allLinkedMaskTest = this.allLinkedMaskTest;
            smem.segmentPosMaskBit = this.segmentPosMaskBit;
            smem.linkedNodeMask = this.linkedNodeMask;
            smem.pos = this.pos;
        }

        public void updateSegmentMemory(SegmentMemory smem, ReteEvaluator reteEvaluator) {
            this.shallowUpdateSegmentMemory(smem);
            Memory[] nodeMemories = new Memory[this.getNodesInSegment().length];
            for (int i = 0; i < this.memories.length; ++i) {
                Memory mem = reteEvaluator.getNodeMemory((MemoryFactory)((Object)this.getNodesInSegment()[i]));
                if (i > 0) {
                    mem.setPrevious((Memory)nodeMemories[i - 1]);
                    nodeMemories[i - 1].setNext(mem);
                }
                nodeMemories[i] = mem;
                mem.setSegmentMemory(smem);
                MemoryPrototype proto = this.memories[i];
                if (proto == null) continue;
                proto.populateMemory(reteEvaluator, mem);
            }
            smem.setNodeMemories(nodeMemories);
        }

        public SegmentPrototype initFromSegmentMemory(SegmentMemory smem) {
            this.linkedNodeMask = smem.linkedNodeMask;
            this.allLinkedMaskTest = smem.allLinkedMaskTest;
            this.segmentPosMaskBit = smem.segmentPosMaskBit;
            this.pos = smem.pos;
            int i = 0;
            this.memories = new MemoryPrototype[smem.nodeMemories.length];
            for (Memory mem : smem.nodeMemories) {
                this.memories[i++] = MemoryPrototype.get(mem);
            }
            return this;
        }

        public LeftTupleNode getRootNode() {
            return this.rootNode;
        }

        public LeftTupleNode getTipNode() {
            return this.tipNode;
        }

        public void setTipNode(LeftTupleNode tipNode) {
            this.tipNode = tipNode;
        }

        public void linkNode(long mask) {
            this.linkedNodeMask |= mask;
        }

        public long getLinkedNodeMask() {
            return this.linkedNodeMask;
        }

        public void setLinkedNodeMask(long linkedNodeMask) {
            this.linkedNodeMask = linkedNodeMask;
        }

        public void setAllLinkedMaskTest(long allLinkedMaskTest) {
            this.allLinkedMaskTest = allLinkedMaskTest;
        }

        public long getAllLinkedMaskTest() {
            return this.allLinkedMaskTest;
        }

        public void setSegmentPosMaskBit(long segmentPosMaskBit) {
            this.segmentPosMaskBit = segmentPosMaskBit;
        }

        public long getSegmentPosMaskBit() {
            return this.segmentPosMaskBit;
        }

        public int getPos() {
            return this.pos;
        }

        public void setPos(int pos) {
            this.pos = pos;
        }

        public MemoryPrototype[] getMemories() {
            return this.memories;
        }

        public void setMemories(MemoryPrototype[] memories) {
            this.memories = memories;
        }

        public LeftTupleNode[] getNodesInSegment() {
            return this.nodesInSegment;
        }

        public void setNodesInSegment(LeftTupleNode[] nodesInSegment) {
            this.nodesInSegment = nodesInSegment;
        }

        public int getNodeTypesInSegment() {
            return this.nodeTypesInSegment;
        }

        public void setNodeTypesInSegment(int nodeTypesInSegment) {
            this.nodeTypesInSegment = nodeTypesInSegment;
            this.requiresEager = BuildtimeSegmentUtilities.requiresAnEagerSegment(nodeTypesInSegment);
        }

        public boolean requiresEager() {
            return this.requiresEager;
        }

        public PathEndNode[] getPathEndNodes() {
            return this.pathEndNodes;
        }

        public void setPathEndNodes(PathEndNode[] pathEndNodes) {
            this.pathEndNodes = pathEndNodes;
        }

        public String toString() {
            StringBuilder sbuilder = new StringBuilder();
            sbuilder.append("SegmentMemory[");
            sbuilder.append("root " + this.rootNode + " tip " + this.tipNode + ", ");
            sbuilder.append("linkedNodeMask " + this.linkedNodeMask + ", ");
            sbuilder.append("allLinkedMaskTest " + this.allLinkedMaskTest + ", ");
            sbuilder.append("segmentPosMaskBit " + this.segmentPosMaskBit + ", ");
            sbuilder.append("pos " + this.pos + ", ");
            sbuilder.append("nodeTypesInSegment " + this.nodeTypesInSegment + " ");
            sbuilder.append("nodes ");
            if (this.nodesInSegment != null) {
                Arrays.stream(this.nodesInSegment).forEach(n -> sbuilder.append(n));
            }
            sbuilder.append("]");
            return sbuilder.toString();
        }
    }
}

