/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.drools.util.IoUtils;
import org.drools.util.PortablePath;

public class ConfFileUtils {
    public static URL getURL(String confName, ClassLoader classLoader, Class cls) {
        ClassLoader confClassLoader;
        URL urlResource;
        String userHome = PortablePath.of(System.getProperty("user.home")).asString();
        URL url = userHome.endsWith("/") ? ConfFileUtils.getURLForFile(userHome + confName) : ConfFileUtils.getURLForFile(userHome + "/" + confName);
        if (url == null) {
            url = ConfFileUtils.getURLForFile(confName);
        }
        if (cls != null && (urlResource = cls.getResource(confName)) != null) {
            url = urlResource;
        }
        if (url == null && classLoader != null) {
            url = classLoader.getResource("META-INF/" + confName);
        }
        if (url == null && (confClassLoader = ConfFileUtils.class.getClassLoader()) != null && confClassLoader != classLoader) {
            url = confClassLoader.getResource("META-INF/" + confName);
        }
        if (url == null && cls != null && (confClassLoader = cls.getClassLoader()) != null && confClassLoader != classLoader) {
            url = confClassLoader.getResource("META-INF/" + confName);
        }
        if (url == null && (confClassLoader = Thread.currentThread().getContextClassLoader()) != null && confClassLoader != classLoader) {
            url = confClassLoader.getResource("META-INF/" + confName);
        }
        if (url == null && (confClassLoader = ClassLoader.getSystemClassLoader()) != null && confClassLoader != classLoader) {
            url = confClassLoader.getResource("META-INF/" + confName);
        }
        return url;
    }

    public static URL getURLForFile(String fileName) {
        File file;
        URL url = null;
        if (fileName != null && (file = new File(fileName)).exists()) {
            try {
                url = file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("file.toURL() failed for '" + file + "'");
            }
        }
        return url;
    }

    public static String URLContentsToString(URL url) {
        StringBuilder builder = new StringBuilder();
        if (url == null) {
            return null;
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream(), IoUtils.UTF8_CHARSET));){
            String line;
            while ((line = reader.readLine()) != null) {
                builder.append(line);
                builder.append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read " + url.toExternalForm());
        }
        return builder.toString();
    }

    public static Properties getProperties(URL url) {
        if (url == null) {
            return null;
        }
        Properties properties = new Properties();
        try {
            properties.load(url.openStream());
        }
        catch (IOException e) {
            return null;
        }
        return properties;
    }
}

