/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.ArrayList;
import java.util.List;
import org.drools.drl.ast.descr.FunctionDescr;
import org.drools.drl.ast.descr.ImportDescr;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.ast.descr.RuleDescr;
import org.drools.drlonyaml.model.Function;
import org.drools.drlonyaml.model.Import;
import org.drools.drlonyaml.model.Rule;

@JsonPropertyOrder(value={"name", "imports", "rules", "functions"})
public class DrlPackage {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private String name = "";
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Import> imports = new ArrayList<Import>();
    private List<Rule> rules = new ArrayList<Rule>();
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    private List<Function> functions = new ArrayList<Function>();

    public static DrlPackage from(PackageDescr o) {
        DrlPackage result = new DrlPackage();
        result.name = o.getName();
        for (ImportDescr i : o.getImports()) {
            result.imports.add(Import.from(i));
        }
        for (RuleDescr r : o.getRules()) {
            result.rules.add(Rule.from(r));
        }
        for (FunctionDescr f : o.getFunctions()) {
            result.functions.add(Function.from(f));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }

    public List<Import> getImports() {
        return this.imports;
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public List<Function> getFunctions() {
        return this.functions;
    }
}

