/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class NumericMinAccumulateFunction
extends AbstractAccumulateFunction<MinData> {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public MinData createContext() {
        return new MinData();
    }

    @Override
    public void init(MinData data) {
        data.min = null;
    }

    @Override
    public void accumulate(MinData data, Object value) {
        if (value != null) {
            Number number = (Number)value;
            data.min = data.min == null || data.min.doubleValue() > number.doubleValue() ? (Number)number : (Number)data.min;
        }
    }

    @Override
    public boolean tryReverse(MinData data, Object value) {
        if (value != null) {
            Number number = (Number)value;
            return data.min.doubleValue() < number.doubleValue();
        }
        return true;
    }

    @Override
    public void reverse(MinData data, Object value) {
    }

    @Override
    public Object getResult(MinData data) {
        return data.min;
    }

    @Override
    public boolean supportsReverse() {
        return false;
    }

    @Override
    public Class<?> getResultType() {
        return Number.class;
    }

    protected static class MinData
    implements Externalizable {
        public Number min = null;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.min = (Double)in.readObject();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.min);
        }

        public String toString() {
            return "min";
        }
    }
}

