/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base.accumulators;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.drools.core.base.accumulators.AbstractAccumulateFunction;

public class VarianceAccumulateFunction
extends AbstractAccumulateFunction<VarianceData> {
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
    }

    @Override
    public VarianceData createContext() {
        return new VarianceData();
    }

    @Override
    public void init(VarianceData data) {
        data.count = 0;
        data.mean = 0.0;
        data.squaredSum = 0.0;
    }

    @Override
    public void accumulate(VarianceData data, Object value) {
        double x = ((Number)value).doubleValue();
        ++data.count;
        double lowerDelta = x - data.mean;
        data.mean += lowerDelta / (double)data.count;
        double higherDelta = x - data.mean;
        data.squaredSum += lowerDelta * higherDelta;
    }

    @Override
    public void reverse(VarianceData data, Object value) {
        double x = ((Number)value).doubleValue();
        double higherDelta = x - data.mean;
        data.mean = data.count == 1 ? 0.0 : data.mean * (double)data.count / ((double)data.count - 1.0) - x / ((double)data.count - 1.0);
        double lowerDelta = x - data.mean;
        --data.count;
        data.squaredSum -= lowerDelta * higherDelta;
    }

    public Double getResult(VarianceData data) {
        return data.squaredSum / (double)data.count;
    }

    @Override
    public boolean supportsReverse() {
        return true;
    }

    @Override
    public Class<?> getResultType() {
        return Double.class;
    }

    protected static class VarianceData
    implements Serializable {
        protected int count;
        protected double mean;
        protected double squaredSum;

        protected VarianceData() {
        }
    }
}

