/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.impl;

import java.io.Externalizable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.drools.base.base.ClassObjectType;
import org.drools.base.common.PartitionsManager;
import org.drools.base.common.RuleBasePartitionId;
import org.drools.base.definitions.InternalKnowledgePackage;
import org.drools.base.definitions.rule.impl.RuleImpl;
import org.drools.base.factmodel.ClassDefinition;
import org.drools.base.rule.DialectRuntimeRegistry;
import org.drools.base.rule.EntryPointId;
import org.drools.base.rule.Function;
import org.drools.base.rule.ImportDeclaration;
import org.drools.base.rule.InvalidPatternException;
import org.drools.base.rule.TypeDeclaration;
import org.drools.base.rule.WindowDeclaration;
import org.drools.base.ruleunit.RuleUnitDescriptionRegistry;
import org.drools.core.KieBaseConfigurationImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.ReteEvaluator;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.impl.KieBaseUpdate;
import org.drools.core.impl.RuleBaseFactory;
import org.drools.core.management.DroolsManagementAgent;
import org.drools.core.phreak.BuildtimeSegmentUtilities;
import org.drools.core.phreak.EagerPhreakBuilder;
import org.drools.core.phreak.PhreakBuilder;
import org.drools.core.reteoo.AsyncReceiveNode;
import org.drools.core.reteoo.CompositePartitionAwareObjectSinkAdapter;
import org.drools.core.reteoo.CoreComponentFactory;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftTupleNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.RuntimeComponentFactory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.TerminalNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.builder.NodeFactory;
import org.drools.core.rule.JavaDialectRuntimeData;
import org.drools.core.rule.accessor.FactHandleFactory;
import org.drools.util.BitMaskUtil;
import org.drools.util.ClassUtils;
import org.drools.wiring.api.classloader.ProjectClassLoader;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.ReleaseId;
import org.kie.api.conf.EventProcessingOption;
import org.kie.api.definition.KiePackage;
import org.kie.api.definition.process.Process;
import org.kie.api.definition.rule.Query;
import org.kie.api.definition.rule.Rule;
import org.kie.api.definition.type.Expires;
import org.kie.api.definition.type.FactType;
import org.kie.api.definition.type.Role;
import org.kie.api.internal.io.ResourceTypePackage;
import org.kie.api.internal.utils.KieService;
import org.kie.api.internal.weaver.KieWeavers;
import org.kie.api.io.Resource;
import org.kie.internal.conf.CompositeBaseConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KnowledgeBaseImpl
implements InternalRuleBase {
    protected static final Logger logger = LoggerFactory.getLogger(KnowledgeBaseImpl.class);
    private Set<EntryPointNode> addedEntryNodeCache;
    private Set<EntryPointNode> removedEntryNodeCache;
    private String id;
    private KieBaseConfiguration config;
    private RuleBaseConfiguration ruleBaseConfig;
    private KieBaseConfigurationImpl kieBaseConfig;
    protected Map<String, InternalKnowledgePackage> pkgs;
    private Map<String, Process> processes;
    private transient ClassLoader rootClassLoader;
    private transient Map<String, Type> globals;
    private final transient Queue<DialectRuntimeRegistry> reloadPackageCompilationData = new ConcurrentLinkedQueue<DialectRuntimeRegistry>();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final transient Map<String, TypeDeclaration> classTypeDeclaration = new ConcurrentHashMap<String, TypeDeclaration>();
    private ClassFieldAccessorCache classFieldAccessorCache;
    private transient Rete rete;
    private ReteooBuilder reteooBuilder;
    private final transient Map<Integer, SegmentMemory.SegmentPrototype> segmentProtos = PhreakBuilder.isEagerSegmentCreation() ? new HashMap() : new ConcurrentHashMap();
    public List<List<String>> jaxbClasses;
    private ReleaseId resolvedReleaseId;
    private String containerId;
    private final RuleUnitDescriptionRegistry ruleUnitDescriptionRegistry = new RuleUnitDescriptionRegistry();
    private SessionConfiguration sessionConfiguration;
    private List<AsyncReceiveNode> receiveNodes;
    private boolean mutable = true;
    private boolean hasMultipleAgendaGroups = false;
    private final PartitionsManager partitionsManager = new PartitionsManager();
    private boolean partitioned;

    public KnowledgeBaseImpl() {
    }

    public KnowledgeBaseImpl(String id, CompositeBaseConfiguration config) {
        this.config = config;
        this.ruleBaseConfig = config.as(RuleBaseConfiguration.KEY);
        this.kieBaseConfig = config.as(KieBaseConfigurationImpl.KEY);
        this.createRulebaseId(id);
        this.rootClassLoader = this.config.getClassLoader();
        this.pkgs = new HashMap<String, InternalKnowledgePackage>();
        this.processes = new HashMap<String, Process>();
        this.globals = new HashMap<String, Type>();
        this.classFieldAccessorCache = new ClassFieldAccessorCache(this.rootClassLoader);
        this.setupRete();
        this.sessionConfiguration = RuleBaseFactory.newKnowledgeSessionConfiguration(config.getProperties(), this.config.getClassLoader()).as(SessionConfiguration.KEY);
        this.mutable = this.kieBaseConfig.isMutabilityEnabled();
    }

    private void createRulebaseId(String id) {
        if (id != null) {
            this.id = id;
        } else {
            String key = "";
            if (this.kieBaseConfig.isMBeansEnabled()) {
                DroolsManagementAgent agent = DroolsManagementAgent.getInstance();
                key = String.valueOf(agent.getNextKnowledgeBaseId());
            }
            this.id = "default" + key;
        }
    }

    @Override
    public SessionConfiguration getSessionConfiguration() {
        return this.sessionConfiguration;
    }

    @Override
    public void removeKiePackage(String packageName) {
        InternalKnowledgePackage pkg = this.pkgs.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
        }
        this.kBaseInternal_removeRules(pkg.getRules(), Collections.emptyList());
        this.kBaseInternal_removePackage(pkg, Collections.emptyList());
    }

    public void kBaseInternal_removePackage(InternalKnowledgePackage pkg, Collection<InternalWorkingMemory> workingMemories) {
        HashSet<String> referencedGlobals = new HashSet<String>();
        for (InternalKnowledgePackage pkgref : this.pkgs.values()) {
            if (pkgref == pkg) continue;
            referencedGlobals.addAll(pkgref.getGlobals().keySet());
        }
        for (String globalName : pkg.getGlobals().keySet()) {
            if (referencedGlobals.contains(globalName)) continue;
            this.globals.remove(globalName);
        }
        for (String processName : new ArrayList<String>(pkg.getRuleFlows().keySet())) {
            this.removeProcess(processName);
        }
        this.pkgs.remove(pkg.getName());
        pkg.getDialectRuntimeRegistry().onRemove();
        pkg.clear();
    }

    @Override
    public Rule getRule(String packageName, String ruleName) {
        InternalKnowledgePackage p = this.getPackage(packageName);
        return p == null ? null : p.getRule(ruleName);
    }

    @Override
    public Query getQuery(String packageName, String queryName) {
        return this.getPackage(packageName).getRule(queryName);
    }

    @Override
    public Collection<KiePackage> getKiePackages() {
        InternalKnowledgePackage[] knowledgePackages = this.getPackages();
        ArrayList<KiePackage> list = new ArrayList<KiePackage>(knowledgePackages.length);
        Collections.addAll(list, knowledgePackages);
        return list;
    }

    @Override
    public KiePackage getKiePackage(String packageName) {
        return this.getPackage(packageName);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public FactHandleFactory newFactHandleFactory() {
        return RuntimeComponentFactory.get().getFactHandleFactoryService().newInstance();
    }

    @Override
    public FactHandleFactory newFactHandleFactory(long id, long counter) {
        return RuntimeComponentFactory.get().getFactHandleFactoryService().newInstance(id, counter);
    }

    @Override
    public Collection<Process> getProcesses() {
        this.readLock();
        try {
            Collection<Process> collection = this.processes.values();
            return collection;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public InternalKnowledgePackage[] getPackages() {
        this.readLock();
        try {
            InternalKnowledgePackage[] internalKnowledgePackageArray = this.pkgs.values().toArray(new InternalKnowledgePackage[this.pkgs.size()]);
            return internalKnowledgePackageArray;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public Map<String, InternalKnowledgePackage> getPackagesMap() {
        return this.pkgs;
    }

    @Override
    public Map<String, Type> getGlobals() {
        return this.globals;
    }

    public void kBaseInternal_lock() {
        this.lock.writeLock().lock();
    }

    public void kBaseInternal_unlock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public void readLock() {
        this.lock.readLock().lock();
    }

    @Override
    public void readUnlock() {
        this.lock.readLock().unlock();
    }

    public ReentrantReadWriteLock kBaseInternal_getLock() {
        return this.lock;
    }

    public void kBaseInternal_writeLock() {
        this.lock.writeLock().lock();
    }

    public boolean kBaseInternal_tryWriteLock() {
        return this.lock.writeLock().tryLock();
    }

    public void kBaseInternal_writeUnlock() {
        this.lock.writeLock().unlock();
    }

    @Override
    public void addPackages(Collection<? extends KiePackage> newPkgs) {
        ArrayList<InternalKnowledgePackage> clonedPkgs = new ArrayList<InternalKnowledgePackage>();
        for (KiePackage kiePackage : newPkgs) {
            clonedPkgs.add(((InternalKnowledgePackage)kiePackage).deepCloneIfAlreadyInUse(this.rootClassLoader));
        }
        clonedPkgs.sort(Comparator.comparing(p -> p.getRules().size()).reversed().thenComparing(KiePackage::getName));
        this.kBaseInternal_addPackages(clonedPkgs, Collections.emptyList());
    }

    @Override
    public Future<KiePackage> addPackage(KiePackage newPkg) {
        InternalKnowledgePackage clonedPkg = ((InternalKnowledgePackage)newPkg).deepCloneIfAlreadyInUse(this.rootClassLoader);
        CompletableFuture<KiePackage> result = new CompletableFuture<KiePackage>();
        this.kBaseInternal_addPackages(Collections.singletonList(clonedPkg), Collections.emptyList());
        result.complete(this.getPackage(newPkg.getName()));
        return result;
    }

    public void kBaseInternal_addPackages(Collection<InternalKnowledgePackage> clonedPkgs, Collection<InternalWorkingMemory> workingMemories) {
        InternalKnowledgePackage pkg;
        for (InternalKnowledgePackage newPkg : clonedPkgs) {
            newPkg.checkValidity();
            newPkg.mergeTraitRegistry(this);
            pkg = this.pkgs.get(newPkg.getName());
            if (pkg == null) {
                pkg = CoreComponentFactory.get().createKnowledgePackage(newPkg.getName());
                pkg.setClassFieldAccessorCache(this.classFieldAccessorCache);
                this.pkgs.put(pkg.getName(), pkg);
            }
            pkg.getDialectRuntimeRegistry().merge(newPkg.getDialectRuntimeRegistry(), this.rootClassLoader, true);
        }
        this.processAllTypesDeclaration(clonedPkgs);
        for (InternalKnowledgePackage newPkg : clonedPkgs) {
            JavaDialectRuntimeData runtime = (JavaDialectRuntimeData)newPkg.getDialectRuntimeRegistry().getDialectData("java");
            for (Function function : newPkg.getFunctions().values()) {
                String string = function.getClassName();
                try {
                    KnowledgeBaseImpl.registerFunctionClassAndInnerClasses(string, runtime, this::registerAndLoadTypeDefinition);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to compile function '" + function.getName() + "'", e);
                }
            }
        }
        for (InternalKnowledgePackage newPkg : clonedPkgs) {
            pkg = this.pkgs.get(newPkg.getName());
            if (newPkg.getFunctions() != null) {
                for (Map.Entry entry : newPkg.getFunctions().entrySet()) {
                    pkg.addFunction((Function)entry.getValue());
                }
            }
            pkg.getDialectRuntimeRegistry().onBeforeExecute();
            pkg.mergeStore(newPkg);
        }
        for (InternalKnowledgePackage newPkg : clonedPkgs) {
            pkg = this.pkgs.get(newPkg.getName());
            this.mergePackage(pkg, newPkg, workingMemories);
            for (WindowDeclaration windowDeclaration : newPkg.getWindowDeclarations().values()) {
                this.reteooBuilder.addNamedWindow(windowDeclaration, workingMemories);
            }
            for (String string : newPkg.getEntryPointIds()) {
                this.reteooBuilder.addEntryPoint(string, workingMemories);
            }
            this.kBaseInternal_addRules(newPkg.getRules(), workingMemories);
            if (newPkg.getRuleFlows() != null) {
                Map<String, Process> flows = newPkg.getRuleFlows();
                for (Process process : flows.values()) {
                    this.kBaseInternal_addProcess(process);
                }
            }
            if (!newPkg.getResourceTypePackages().isEmpty()) {
                KieWeavers weavers = KieService.load(KieWeavers.class);
                for (ResourceTypePackage<?> resourceTypePackage : newPkg.getResourceTypePackages().values()) {
                    weavers.weave(newPkg, resourceTypePackage);
                }
            }
            this.ruleUnitDescriptionRegistry.add(newPkg.getRuleUnitDescriptionLoader());
        }
        if (this.ruleBaseConfig.isParallelEvaluation()) {
            this.setupParallelEvaluation();
        }
    }

    private void setupParallelEvaluation() {
        if (!this.partitionsManager.hasParallelEvaluation()) {
            this.disableParallelEvaluation("The rete network cannot be partitioned: disabling multithread evaluation");
            return;
        }
        this.partitionsManager.init();
        this.partitioned = true;
        if (this.ruleBaseConfig.isParallelExecution()) {
            for (EntryPointNode epn : this.rete.getEntryPointNodes().values()) {
                epn.setupParallelExecution(this);
                for (ObjectTypeNode otn : epn.getObjectTypeNodes().values()) {
                    otn.setupParallelExecution(this);
                }
            }
        }
    }

    @Override
    public void processAllTypesDeclaration(Collection<InternalKnowledgePackage> pkgs) {
        ArrayList<TypeDeclaration> allTypeDeclarations = new ArrayList<TypeDeclaration>();
        for (InternalKnowledgePackage newPkg : pkgs) {
            if (newPkg.getTypeDeclarations() == null) continue;
            allTypeDeclarations.addAll(newPkg.getTypeDeclarations().values());
        }
        Collections.sort(allTypeDeclarations);
        for (TypeDeclaration newDecl : allTypeDeclarations) {
            InternalKnowledgePackage newPkg = null;
            for (InternalKnowledgePackage kpkg : pkgs) {
                if (!kpkg.getTypeDeclarations().containsKey(newDecl.getTypeName())) continue;
                newPkg = kpkg;
                break;
            }
            this.processTypeDeclaration(newDecl, newPkg);
        }
    }

    private void checkParallelEvaluation(RuleImpl rule) {
        if (this.ruleBaseConfig.isParallelEvaluation()) {
            if (!rule.isMainAgendaGroup()) {
                this.disableParallelEvaluation("Agenda-groups are not supported with parallel execution: disabling it");
            } else if (rule.getActivationGroup() != null) {
                this.disableParallelEvaluation("Activation-groups are not supported with parallel execution: disabling it");
            } else if (!rule.getSalience().isDefault() && this.ruleBaseConfig.isParallelExecution()) {
                this.disableParallelEvaluation("Salience is not supported with parallel execution: disabling it");
            } else if (rule.isQuery()) {
                this.disableParallelEvaluation("Queries are not supported with parallel execution: disabling it");
            }
        }
    }

    @Override
    public boolean hasMultipleAgendaGroups() {
        return this.hasMultipleAgendaGroups;
    }

    private void disableParallelEvaluation(String warningMessage) {
        this.ruleBaseConfig.enforceSingleThreadEvaluation();
        logger.warn(warningMessage);
        for (EntryPointNode entryPointNode : this.rete.getEntryPointNodes().values()) {
            for (ObjectTypeNode otn : entryPointNode.getObjectTypeNodes().values()) {
                ObjectSinkPropagator sink = otn.getObjectSinkPropagator();
                if (!(sink instanceof CompositePartitionAwareObjectSinkAdapter)) continue;
                otn.setObjectSinkPropagator(((CompositePartitionAwareObjectSinkAdapter)sink).asNonPartitionedSinkPropagator(this.ruleBaseConfig.getAlphaNodeHashingThreshold(), this.ruleBaseConfig.getAlphaNodeRangeIndexThreshold()));
            }
        }
    }

    public static void registerFunctionClassAndInnerClasses(String functionClassName, JavaDialectRuntimeData runtime, ClassRegister consumer) throws ClassNotFoundException {
        String className = ClassUtils.convertClassToResourcePath(functionClassName);
        String innerClassName = className.substring(0, className.length() - ".class".length()) + "$";
        for (Map.Entry<String, byte[]> entry : runtime.getStore().entrySet()) {
            if (entry.getKey().equals(className)) {
                consumer.register(functionClassName, entry.getValue());
                continue;
            }
            if (!entry.getKey().startsWith(innerClassName)) continue;
            String innerName = functionClassName + entry.getKey().substring(functionClassName.length(), entry.getKey().length() - ".class".length());
            consumer.register(innerName, entry.getValue());
        }
    }

    @Override
    public void registerTypeDeclaration(TypeDeclaration newDecl, InternalKnowledgePackage newPkg) {
        this.classTypeDeclaration.put(newDecl.getTypeClassName(), newDecl);
    }

    protected void processTypeDeclaration(TypeDeclaration newDecl, InternalKnowledgePackage newPkg) {
        JavaDialectRuntimeData runtime = (JavaDialectRuntimeData)newPkg.getDialectRuntimeRegistry().getDialectData("java");
        TypeDeclaration typeDeclaration = this.classTypeDeclaration.get(newDecl.getTypeClassName());
        if (typeDeclaration == null) {
            String className;
            block5: {
                className = newDecl.getTypeClassName();
                byte[] def = runtime != null ? runtime.getClassDefinition(ClassUtils.convertClassToResourcePath(className)) : null;
                try {
                    Class<?> definedKlass = this.registerAndLoadTypeDefinition(className, def);
                    if (newDecl.getTypeClassDef() == null) {
                        newDecl.setTypeClassDef(new ClassDefinition());
                    }
                    newDecl.setTypeClass(definedKlass);
                }
                catch (ClassNotFoundException e) {
                    if (!newDecl.isNovel()) break block5;
                    throw new RuntimeException("unable to resolve Type Declaration class '" + className + "'", e);
                }
            }
            this.classTypeDeclaration.put(className, newDecl);
            typeDeclaration = newDecl;
        } else {
            Class<?> definedKlass = typeDeclaration.getTypeClass();
            newDecl.getTypeClassDef().setDefinedClass(definedKlass);
            newDecl.setTypeClass(definedKlass);
            this.mergeTypeDeclarations(typeDeclaration, newDecl);
        }
        this.updateDependentTypes(typeDeclaration);
    }

    @Override
    public Class<?> registerAndLoadTypeDefinition(String className, byte[] def) throws ClassNotFoundException {
        try {
            return this.rootClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            if (def != null && this.rootClassLoader instanceof ProjectClassLoader) {
                return ((ProjectClassLoader)this.rootClassLoader).defineClass(className, def);
            }
            throw e;
        }
    }

    private void updateDependentTypes(TypeDeclaration typeDeclaration) {
        if (this.ruleBaseConfig.getEventProcessingMode().equals(EventProcessingOption.STREAM)) {
            long exp = typeDeclaration.getExpirationOffset() > -1L ? typeDeclaration.getExpirationOffset() + 1L : -1L;
            for (EntryPointNode ep : this.rete.getEntryPointNodes().values()) {
                for (ObjectTypeNode node : ep.getObjectTypeNodes().values()) {
                    if (!node.getObjectType().equals(typeDeclaration.getObjectType())) continue;
                    node.setExpirationOffset(Math.max(node.getExpirationOffset(), exp));
                }
            }
        }
    }

    private void mergeTypeDeclarations(TypeDeclaration existingDecl, TypeDeclaration newDecl) {
        if (!(Objects.equals((Object)existingDecl.getFormat(), (Object)newDecl.getFormat()) && Objects.equals(existingDecl.getObjectType(), newDecl.getObjectType()) && Objects.equals(existingDecl.getTypeClassName(), newDecl.getTypeClassName()) && Objects.equals(existingDecl.getTypeName(), newDecl.getTypeName()))) {
            throw new RuntimeException("Unable to merge Type Declaration for class '" + existingDecl.getTypeName() + "'");
        }
        existingDecl.setDurationAttribute(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @duration attribute for type declaration of class:", existingDecl.getDurationAttribute(), newDecl.getDurationAttribute(), false));
        existingDecl.setDynamic(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @propertyChangeSupport  (a.k.a. dynamic) attribute for type declaration of class:", existingDecl.isDynamic(), newDecl.isDynamic(), false));
        existingDecl.setPropertyReactive(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @propertyReactive attribute for type declaration of class:", existingDecl.isPropertyReactive(), newDecl.isPropertyReactive(), false));
        if (newDecl.getExpirationPolicy() == Expires.Policy.TIME_HARD) {
            if (existingDecl.getExpirationPolicy() == Expires.Policy.TIME_SOFT || newDecl.getExpirationOffset() > existingDecl.getExpirationOffset()) {
                existingDecl.setExpirationOffset(newDecl.getExpirationOffset());
                existingDecl.setExpirationType(Expires.Policy.TIME_HARD);
            }
        } else if (existingDecl.getExpirationPolicy() == Expires.Policy.TIME_SOFT && newDecl.getExpirationOffset() > existingDecl.getExpirationOffset()) {
            existingDecl.setExpirationOffset(newDecl.getExpirationOffset());
        }
        if (newDecl.getNature().equals((Object)TypeDeclaration.Nature.DEFINITION) && newDecl.isNovel()) {
            existingDecl.setNovel(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @novel attribute for type declaration of class:", existingDecl.isNovel(), newDecl.isNovel(), false));
        }
        if (newDecl.getNature().equals((Object)TypeDeclaration.Nature.DEFINITION) || existingDecl.getResource() == null) {
            existingDecl.setResource(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge resource attribute for type declaration of class:", existingDecl.getResource(), newDecl.getResource(), true));
        }
        existingDecl.setRole(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @role attribute for type declaration of class:", BitMaskUtil.isSet(existingDecl.getSetMask(), 1L) && newDecl.getRole() != Role.Type.FACT ? existingDecl.getRole() : null, newDecl.getRole(), false));
        existingDecl.setTimestampAttribute(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @timestamp attribute for type declaration of class:", existingDecl.getTimestampAttribute(), newDecl.getTimestampAttribute(), false));
        existingDecl.setTypesafe(this.mergeLeft(existingDecl.getTypeName(), "Unable to merge @typesafe attribute for type declaration of class:", existingDecl.isTypesafe(), newDecl.isTypesafe(), false));
    }

    private <T> T mergeLeft(String typeClass, String errorMsg, T leftVal, T rightVal, boolean override) {
        T newValue = leftVal;
        if (!Objects.equals(leftVal, rightVal)) {
            if (leftVal == null) {
                newValue = rightVal;
            } else if (rightVal != null) {
                if (override) {
                    newValue = rightVal;
                } else {
                    throw new RuntimeException(errorMsg + " '" + typeClass + "'");
                }
            }
        }
        return newValue;
    }

    private void mergePackage(InternalKnowledgePackage pkg, InternalKnowledgePackage newPkg, Collection<InternalWorkingMemory> workingMemories) {
        Map<String, ImportDeclaration> imports = pkg.getImports();
        imports.putAll(newPkg.getImports());
        for (String string : newPkg.getStaticImports()) {
            pkg.addStaticImport(string);
        }
        if (newPkg.getGlobals() != null && !newPkg.getGlobals().isEmpty()) {
            Iterator<Externalizable> pkgGlobals = pkg.getGlobals();
            for (Map.Entry<String, Type> entry : newPkg.getGlobals().entrySet()) {
                String identifier = entry.getKey();
                Type type = entry.getValue();
                if (pkgGlobals.containsKey(identifier) && !((Type)pkgGlobals.get(identifier)).equals(type)) {
                    throw new RuntimeException(pkg.getName() + " cannot be integrated");
                }
                pkg.addGlobal(identifier, type);
                this.addGlobal(identifier, type);
            }
        }
        if (newPkg.getEntryPointIds() != null) {
            for (String string : newPkg.getEntryPointIds()) {
                pkg.addEntryPointId(string);
            }
        }
        if (newPkg.getTypeDeclarations() != null) {
            for (TypeDeclaration typeDeclaration : newPkg.getTypeDeclarations().values()) {
                if (pkg.getTypeDeclarations().containsKey(typeDeclaration.getTypeName())) continue;
                pkg.addTypeDeclaration(typeDeclaration);
            }
        }
        if (newPkg.getWindowDeclarations() != null) {
            for (WindowDeclaration windowDeclaration : newPkg.getWindowDeclarations().values()) {
                if (!pkg.getWindowDeclarations().containsKey(windowDeclaration.getName()) || pkg.getWindowDeclarations().get(windowDeclaration.getName()).equals(windowDeclaration)) {
                    pkg.addWindowDeclaration(windowDeclaration);
                    continue;
                }
                throw new RuntimeException("Unable to merge two conflicting window declarations for window named: " + windowDeclaration.getName());
            }
        }
        ArrayList<RuleImpl> rulesToBeRemoved = new ArrayList<RuleImpl>();
        for (Rule rule : newPkg.getRules()) {
            RuleImpl oldRule = pkg.getRule(rule.getName());
            if (oldRule == null) continue;
            rulesToBeRemoved.add(oldRule);
        }
        if (!rulesToBeRemoved.isEmpty()) {
            this.kBaseInternal_removeRules(rulesToBeRemoved, workingMemories);
        }
        for (Rule rule : newPkg.getRules()) {
            pkg.addRule((RuleImpl)rule);
        }
        if (newPkg.getRuleFlows() != null) {
            for (Process process : newPkg.getRuleFlows().values()) {
                pkg.addProcess(process);
            }
        }
        if (!newPkg.getResourceTypePackages().isEmpty()) {
            KieWeavers kieWeavers = KieService.load(KieWeavers.class);
            if (kieWeavers == null) {
                throw new IllegalStateException("Unable to find KieWeavers implementation");
            }
            for (ResourceTypePackage<?> rtkKpg : newPkg.getResourceTypePackages().values()) {
                kieWeavers.merge(pkg, rtkKpg);
            }
        }
    }

    @Override
    public void addGlobal(String identifier, Type type) {
        this.globals.put(identifier, type);
    }

    @Override
    public void removeGlobal(String identifier) {
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            if (pkg.getGlobals().get(identifier) == null) continue;
            return;
        }
        this.globals.remove(identifier);
    }

    protected void setupRete() {
        this.rete = new Rete(this);
        this.reteooBuilder = new ReteooBuilder(this);
        NodeFactory nodeFactory = CoreComponentFactory.get().getNodeFactoryService();
        EntryPointNode epn = nodeFactory.buildEntryPointNode(this.reteooBuilder.getNodeIdsGenerator().getNextId(), RuleBasePartitionId.MAIN_PARTITION, this.rete, EntryPointId.DEFAULT);
        epn.attach();
        BuildContext context = new BuildContext(this, Collections.emptyList());
        context.setCurrentEntryPoint(epn.getEntryPoint());
        context.setTupleMemoryEnabled(true);
        context.setPartitionId(RuleBasePartitionId.MAIN_PARTITION);
        ObjectTypeNode otn = nodeFactory.buildObjectTypeNode(this.reteooBuilder.getNodeIdsGenerator().getNextId(), epn, ClassObjectType.InitialFact_ObjectType, context);
        otn.attach(context);
    }

    @Override
    public void registerAddedEntryNodeCache(EntryPointNode node) {
        if (this.addedEntryNodeCache == null) {
            this.addedEntryNodeCache = new HashSet<EntryPointNode>();
        }
        this.addedEntryNodeCache.add(node);
    }

    @Override
    public Set<EntryPointNode> getAddedEntryNodeCache() {
        return this.addedEntryNodeCache;
    }

    @Override
    public void registeRremovedEntryNodeCache(EntryPointNode node) {
        if (this.removedEntryNodeCache == null) {
            this.removedEntryNodeCache = new HashSet<EntryPointNode>();
        }
        this.removedEntryNodeCache.add(node);
    }

    @Override
    public Set<EntryPointNode> getRemovedEntryNodeCache() {
        return this.removedEntryNodeCache;
    }

    @Override
    public Rete getRete() {
        return this.rete;
    }

    @Override
    public ReteooBuilder getReteooBuilder() {
        return this.reteooBuilder;
    }

    @Override
    public int getNodeCount() {
        return this.reteooBuilder.getNodeIdsGenerator().getLastId() + 1;
    }

    @Override
    public int getMemoryCount() {
        return this.reteooBuilder.getMemoryIdsGenerator().getLastId() + 1;
    }

    @Override
    public boolean hasSegmentPrototypes() {
        return !this.segmentProtos.isEmpty();
    }

    @Override
    public void registerSegmentPrototype(LeftTupleNode tupleSource, SegmentMemory.SegmentPrototype smem) {
        this.segmentProtos.put(tupleSource.getId(), smem);
    }

    @Override
    public void invalidateSegmentPrototype(LeftTupleNode rootNode) {
        this.segmentProtos.remove(rootNode.getId());
    }

    @Override
    public SegmentMemory.SegmentPrototype getSegmentPrototype(LeftTupleNode node) {
        return this.segmentProtos.get(node.getId());
    }

    @Override
    public SegmentMemory createSegmentFromPrototype(ReteEvaluator reteEvaluator, LeftTupleSource tupleSource) {
        SegmentMemory.SegmentPrototype proto = this.segmentProtos.get(tupleSource.getId());
        return this.createSegmentFromPrototype(reteEvaluator, proto);
    }

    @Override
    public SegmentMemory createSegmentFromPrototype(ReteEvaluator reteEvaluator, SegmentMemory.SegmentPrototype proto) {
        return proto.newSegmentMemory(reteEvaluator);
    }

    @Override
    public SegmentMemory.SegmentPrototype getSegmentPrototype(SegmentMemory segment) {
        return this.segmentProtos.get(segment.getRootNode().getId());
    }

    @Override
    public TypeDeclaration getExactTypeDeclaration(Class<?> clazz) {
        return this.classTypeDeclaration.get(clazz.getName());
    }

    @Override
    public TypeDeclaration getOrCreateExactTypeDeclaration(Class<?> clazz) {
        return this.classTypeDeclaration.computeIfAbsent(clazz.getName(), c -> TypeDeclaration.createTypeDeclarationForBean(clazz));
    }

    @Override
    public TypeDeclaration getTypeDeclaration(Class<?> clazz) {
        TypeDeclaration typeDeclaration = this.getExactTypeDeclaration(clazz);
        if (typeDeclaration == null) {
            TypeDeclarationCandidate candidate = this.checkSuperClasses(clazz);
            if ((candidate = this.checkInterfaces(clazz, candidate, 1)) != null) {
                typeDeclaration = candidate.candidate;
            }
        }
        return typeDeclaration;
    }

    private TypeDeclarationCandidate checkSuperClasses(Class<?> clazz) {
        TypeDeclaration typeDeclaration = null;
        int score = 0;
        for (Class<?> current = clazz.getSuperclass(); typeDeclaration == null && current != null; current = current.getSuperclass()) {
            ++score;
            typeDeclaration = this.classTypeDeclaration.get(current.getName());
        }
        TypeDeclarationCandidate candidate = null;
        if (typeDeclaration != null) {
            candidate = new TypeDeclarationCandidate();
            candidate.candidate = typeDeclaration;
            candidate.score = score;
        }
        return candidate;
    }

    private TypeDeclarationCandidate checkInterfaces(Class<?> clazz, TypeDeclarationCandidate baseline, int level) {
        TypeDeclarationCandidate candidate = null;
        if (baseline == null || level < baseline.score) {
            for (Class<?> ifc : clazz.getInterfaces()) {
                TypeDeclaration typeDeclaration = this.classTypeDeclaration.get(ifc.getName());
                if (typeDeclaration != null) {
                    candidate = new TypeDeclarationCandidate();
                    candidate.candidate = typeDeclaration;
                    candidate.score = level;
                    break;
                }
                candidate = this.checkInterfaces(ifc, baseline, level + 1);
            }
        } else {
            candidate = baseline;
        }
        return candidate;
    }

    @Override
    public Collection<TypeDeclaration> getTypeDeclarations() {
        return this.classTypeDeclaration.values();
    }

    @Override
    public void beforeIncrementalUpdate(KieBaseUpdate kieBaseUpdate) {
    }

    @Override
    public void afterIncrementalUpdate(KieBaseUpdate kieBaseUpdate) {
    }

    @Override
    public void addRules(Collection<RuleImpl> rules) throws InvalidPatternException {
        this.kBaseInternal_addRules(rules, Collections.emptyList());
    }

    public void kBaseInternal_addRules(Collection<? extends Rule> rules, Collection<InternalWorkingMemory> wms) {
        ArrayList<TerminalNode> terminalNodes = new ArrayList<TerminalNode>(rules.size() * 2);
        for (Rule rule : rules) {
            RuleImpl rule2 = (RuleImpl)rule;
            this.checkParallelEvaluation(rule2);
            this.hasMultipleAgendaGroups |= !rule2.isMainAgendaGroup();
            terminalNodes.addAll(this.reteooBuilder.addRule(rule2, wms));
        }
        if (PhreakBuilder.isEagerSegmentCreation() && !this.hasSegmentPrototypes()) {
            for (TerminalNode terminalNode : terminalNodes) {
                terminalNode.getPathMemSpec();
                BuildtimeSegmentUtilities.createPathProtoMemories(terminalNode, null, this);
            }
            HashSet visited = new HashSet();
            for (TerminalNode tn : terminalNodes) {
                wms.stream().forEach(wm -> {
                    EagerPhreakBuilder.Add.insertLiaFacts(tn.getPathNodes()[0], wm, visited, true);
                    EagerPhreakBuilder.Add.insertFacts(tn, wm, visited, true);
                });
            }
        }
    }

    @Override
    public void removeQuery(String packageName, String ruleName) {
        this.removeRule(packageName, ruleName);
    }

    @Override
    public void removeRules(Collection<RuleImpl> rules) {
        this.kBaseInternal_removeRules(rules, Collections.emptyList());
    }

    @Override
    public void removeRule(String packageName, String ruleName) {
        InternalKnowledgePackage pkg = this.pkgs.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
        }
        RuleImpl rule = pkg.getRule(ruleName);
        if (rule == null) {
            throw new IllegalArgumentException("Rule name '" + ruleName + "' does not exist in the Package '" + packageName + "'.");
        }
        this.kBaseInternal_removeRule(pkg, rule, Collections.emptyList());
    }

    public void kBaseInternal_removeRule(InternalKnowledgePackage pkg, RuleImpl rule, Collection<InternalWorkingMemory> workingMemories) {
        this.reteooBuilder.removeRules(Collections.singletonList(rule), workingMemories);
        pkg.removeRule(rule);
        this.addReloadDialectDatas(pkg.getDialectRuntimeRegistry());
    }

    public void kBaseInternal_removeRules(Collection<? extends Rule> rules, Collection<InternalWorkingMemory> workingMemories) {
        this.reteooBuilder.removeRules(rules, workingMemories);
    }

    @Override
    public void removeFunction(String packageName, String functionName) {
        InternalKnowledgePackage pkg = this.pkgs.get(packageName);
        if (pkg == null) {
            throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
        }
        this.kBaseInternal_removeFunction(pkg, functionName);
    }

    public void kBaseInternal_removeFunction(InternalKnowledgePackage pkg, String functionName) {
        Function function = pkg.getFunctions().get(functionName);
        if (function == null) {
            throw new IllegalArgumentException("function name '" + functionName + "' does not exist in the Package '" + pkg.getName() + "'.");
        }
        pkg.removeFunction(functionName);
        if (this.rootClassLoader instanceof ProjectClassLoader) {
            ((ProjectClassLoader)this.rootClassLoader).undefineClass(function.getClassName());
        }
        this.addReloadDialectDatas(pkg.getDialectRuntimeRegistry());
    }

    @Override
    public void addProcess(Process process) {
        this.kBaseInternal_lock();
        try {
            this.kBaseInternal_addProcess(process);
        }
        finally {
            this.kBaseInternal_unlock();
        }
    }

    public void kBaseInternal_addProcess(Process process) {
        this.processes.put(process.getId(), process);
    }

    @Override
    public void removeProcess(String id) {
        Process process = this.processes.get(id);
        if (process == null) {
            throw new IllegalArgumentException("Process '" + id + "' does not exist for this Rule Base.");
        }
        this.kBaseInternal_removeProcess(id, process);
    }

    public void kBaseInternal_removeProcess(String id, Process process) {
        this.processes.remove(id);
        this.pkgs.get(process.getPackageName()).removeRuleFlow(id);
    }

    @Override
    public Process getProcess(String id) {
        this.readLock();
        try {
            Process process = this.processes.get(id);
            return process;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public InternalKnowledgePackage getPackage(String name) {
        return this.pkgs.get(name);
    }

    @Override
    public RuleBaseConfiguration getRuleBaseConfiguration() {
        return this.ruleBaseConfig;
    }

    @Override
    public KieBaseConfigurationImpl getKieBaseConfiguration() {
        return this.kieBaseConfig;
    }

    @Override
    public KieBaseConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public ClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    @Override
    public void executeQueuedActions() {
        if (this.mutable) {
            DialectRuntimeRegistry registry;
            while ((registry = this.reloadPackageCompilationData.poll()) != null) {
                registry.onBeforeExecute();
            }
        }
    }

    private void addReloadDialectDatas(DialectRuntimeRegistry registry) {
        this.reloadPackageCompilationData.offer(registry);
    }

    @Override
    public RuleBasePartitionId createNewPartitionId() {
        return this.partitionsManager.createNewPartitionId();
    }

    @Override
    public boolean isPartitioned() {
        return this.partitioned;
    }

    @Override
    public int getParallelEvaluationSlotsCount() {
        return this.partitionsManager.getParallelEvaluationSlotsCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FactType getFactType(String packageName, String typeName) {
        String name = packageName + "." + typeName;
        this.readLock();
        try {
            for (InternalKnowledgePackage pkg : this.pkgs.values()) {
                FactType type = pkg.getFactType(name);
                if (type == null) continue;
                FactType factType = type;
                return factType;
            }
            Iterator<InternalKnowledgePackage> iterator = null;
            return iterator;
        }
        finally {
            this.readUnlock();
        }
    }

    @Override
    public ClassFieldAccessorCache getClassFieldAccessorCache() {
        return this.classFieldAccessorCache;
    }

    @Override
    public Set<String> getEntryPointIds() {
        HashSet<String> entryPointIds = new HashSet<String>();
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            entryPointIds.addAll(pkg.getEntryPointIds());
        }
        return entryPointIds;
    }

    @Override
    public boolean removeObjectsGeneratedFromResource(Resource resource, Collection<InternalWorkingMemory> workingMemories) {
        boolean modified = false;
        for (InternalKnowledgePackage pkg : this.pkgs.values()) {
            Object function2;
            List<RuleImpl> rulesToBeRemoved = pkg.getRulesGeneratedFromResource(resource);
            if (!rulesToBeRemoved.isEmpty()) {
                this.reteooBuilder.removeRules(rulesToBeRemoved, workingMemories);
                for (RuleImpl ruleImpl : rulesToBeRemoved) {
                    pkg.removeRule(ruleImpl);
                }
            }
            List<Function> functionsToBeRemoved = pkg.removeFunctionsGeneratedFromResource(resource);
            for (Object function2 : functionsToBeRemoved) {
                this.kBaseInternal_removeFunction(pkg, ((Function)function2).getName());
            }
            List<Process> list = pkg.removeProcessesGeneratedFromResource(resource);
            function2 = list.iterator();
            while (function2.hasNext()) {
                Process process = (Process)function2.next();
                this.processes.remove(process.getId());
            }
            List<TypeDeclaration> removedTypes = pkg.removeTypesGeneratedFromResource(resource);
            boolean resourceTypePackageSomethingRemoved = pkg.removeFromResourceTypePackageGeneratedFromResource(resource);
            modified |= !rulesToBeRemoved.isEmpty() || !functionsToBeRemoved.isEmpty() || !list.isEmpty() || !removedTypes.isEmpty() || resourceTypePackageSomethingRemoved;
        }
        return modified;
    }

    @Override
    public ReleaseId getResolvedReleaseId() {
        return this.resolvedReleaseId;
    }

    @Override
    public void setResolvedReleaseId(ReleaseId currentReleaseId) {
        this.resolvedReleaseId = currentReleaseId;
    }

    @Override
    public String getContainerId() {
        return this.containerId;
    }

    @Override
    public void setContainerId(String containerId) {
        this.containerId = containerId;
    }

    @Override
    public RuleUnitDescriptionRegistry getRuleUnitDescriptionRegistry() {
        return this.ruleUnitDescriptionRegistry;
    }

    @Override
    public boolean hasUnits() {
        return this.ruleUnitDescriptionRegistry.hasUnits();
    }

    @Override
    public List<AsyncReceiveNode> getReceiveNodes() {
        return this.receiveNodes;
    }

    @Override
    public void addReceiveNode(AsyncReceiveNode node) {
        if (this.receiveNodes == null) {
            this.receiveNodes = new ArrayList<AsyncReceiveNode>();
        }
        this.receiveNodes.add(node);
    }

    public static interface ClassRegister {
        public void register(String var1, byte[] var2) throws ClassNotFoundException;
    }

    private static class TypeDeclarationCandidate {
        public TypeDeclaration candidate = null;
        public int score = Integer.MAX_VALUE;

        private TypeDeclarationCandidate() {
        }
    }
}

