/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.index;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.base.util.FieldIndex;
import org.drools.base.util.index.ConstraintTypeOperator;
import org.drools.core.base.CoercionUtil;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.TupleRBTree;
import org.drools.core.util.index.AbstractTupleIndexTree;
import org.drools.core.util.index.TupleList;

public class TupleIndexRBTree
extends AbstractTupleIndexTree
implements Externalizable,
TupleMemory {
    private TupleRBTree<Comparable<Comparable>> tree;

    public TupleIndexRBTree() {
    }

    public TupleIndexRBTree(ConstraintTypeOperator constraintType, FieldIndex index, boolean left) {
        this.index = index;
        this.constraintType = constraintType;
        this.left = left;
        this.tree = new TupleRBTree();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.tree);
        out.writeObject(this.index);
        out.writeObject((Object)this.constraintType);
        out.writeInt(this.factSize);
        out.writeBoolean(this.left);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.tree = (TupleRBTree)in.readObject();
        this.index = (FieldIndex)in.readObject();
        this.constraintType = (ConstraintTypeOperator)((Object)in.readObject());
        this.factSize = in.readInt();
        this.left = in.readBoolean();
    }

    @Override
    public void add(Tuple tuple) {
        Comparable key = this.getIndexedValue(tuple, this.left);
        TupleRBTree.Node<Comparable<Comparable>> list = this.tree.insert(key);
        list.add(tuple);
        ++this.factSize;
    }

    @Override
    public void remove(Tuple tuple) {
        TupleList list = tuple.getMemory();
        list.remove(tuple);
        if (list.getFirst() == null) {
            this.tree.delete((Comparable<Comparable>)((TupleRBTree.Node)list).key);
        }
        --this.factSize;
    }

    @Override
    public void removeAdd(Tuple tuple) {
        this.remove(tuple);
        this.add(tuple);
    }

    @Override
    public int size() {
        return this.factSize;
    }

    @Override
    public Tuple[] toArray() {
        Iterator<TupleRBTree.Node<Comparable<Comparable>>> it = this.tree.iterator();
        if (it == null) {
            return new Tuple[0];
        }
        ArrayList toBeRemoved = new ArrayList();
        ArrayList<Tuple> result = new ArrayList<Tuple>();
        TupleRBTree.Node<Comparable<Comparable>> list = null;
        while ((list = it.next()) != null) {
            for (Tuple entry = list.getFirst(); entry != null; entry = (Tuple)entry.getNext()) {
                result.add(entry);
            }
        }
        return result.toArray(new Tuple[result.size()]);
    }

    @Override
    public Tuple getFirst(Tuple rightTuple) {
        Comparable key = this.getIndexedValue(rightTuple, !this.left);
        return this.getNext(key, true);
    }

    @Override
    public Iterator<Tuple> iterator() {
        TupleRBTree.Node<Comparable<Comparable>> list = this.tree.first();
        Tuple firstTuple = list != null ? list.getFirst() : null;
        return new FastIterator.IteratorAdapter<Tuple>(this.fastIterator(), firstTuple);
    }

    @Override
    public FastIterator<Tuple> fastIterator() {
        return new TupleFastIterator();
    }

    @Override
    public FastIterator<Tuple> fullFastIterator() {
        return new TupleFastIterator();
    }

    @Override
    public FastIterator<Tuple> fullFastIterator(Tuple leftTuple) {
        FastIterator<Tuple> fastIterator = this.fullFastIterator();
        Comparable key = this.getLeftIndexedValue(leftTuple);
        fastIterator.next(this.getNext(key, true));
        return fastIterator;
    }

    private Tuple getNext(Comparable key, boolean first) {
        return this.left ? this.getNextLeft(key, first) : this.getNextRight(key, first);
    }

    private Tuple getNextLeft(Comparable key, boolean first) {
        TupleRBTree.Node<Comparable<Comparable>> firstNode;
        key = TupleIndexRBTree.coerceType(this.index, this.tree.root != null ? (Comparable)this.tree.root.key : null, key);
        switch (this.constraintType) {
            case LESS_THAN: {
                firstNode = this.tree.findNearestNode(key, false, TupleRBTree.Boundary.LOWER);
                break;
            }
            case LESS_OR_EQUAL: {
                firstNode = this.tree.findNearestNode(key, first, TupleRBTree.Boundary.LOWER);
                break;
            }
            case GREATER_THAN: {
                firstNode = this.tree.findNearestNode(key, false, TupleRBTree.Boundary.UPPER);
                break;
            }
            case GREATER_OR_EQUAL: {
                firstNode = this.tree.findNearestNode(key, first, TupleRBTree.Boundary.UPPER);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot call remove constraint of type: " + this.constraintType);
            }
        }
        return firstNode == null ? null : firstNode.getFirst();
    }

    private Tuple getNextRight(Comparable key, boolean first) {
        TupleRBTree.Node<Comparable<Comparable>> firstNode;
        if (key == null) {
            return null;
        }
        key = TupleIndexRBTree.coerceType(this.index, this.tree.root != null ? (Comparable)this.tree.root.key : null, key);
        switch (this.constraintType) {
            case LESS_THAN: {
                firstNode = this.tree.findNearestNode(key, false, TupleRBTree.Boundary.UPPER);
                break;
            }
            case LESS_OR_EQUAL: {
                firstNode = this.tree.findNearestNode(key, first, TupleRBTree.Boundary.UPPER);
                break;
            }
            case GREATER_THAN: {
                firstNode = this.tree.findNearestNode(key, false, TupleRBTree.Boundary.LOWER);
                break;
            }
            case GREATER_OR_EQUAL: {
                firstNode = this.tree.findNearestNode(key, first, TupleRBTree.Boundary.LOWER);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Cannot call remove constraint of type: " + this.constraintType);
            }
        }
        return firstNode == null ? null : firstNode.getFirst();
    }

    public static Comparable coerceType(FieldIndex index, Comparable treeRootKey, Comparable key) {
        if (index.requiresCoercion() && key != null && treeRootKey != null && !key.getClass().equals(treeRootKey.getClass())) {
            if (treeRootKey instanceof Number && key instanceof Number) {
                key = (Comparable)((Object)CoercionUtil.coerceToNumber((Number)((Object)key), treeRootKey.getClass()));
            } else {
                throw new RuntimeException("Not possible to coerce [" + key + "] from class " + key.getClass() + " to class " + treeRootKey.getClass());
            }
        }
        return key;
    }

    @Override
    public void clear() {
        this.tree = new TupleRBTree();
    }

    @Override
    public TupleMemory.IndexType getIndexType() {
        return TupleMemory.IndexType.COMPARISON;
    }

    public class TupleFastIterator
    implements FastIterator<Tuple> {
        @Override
        public Tuple next(Tuple tuple) {
            if (tuple == null) {
                TupleRBTree.Node<Comparable<Comparable>> firstNode = TupleIndexRBTree.this.tree.first();
                return firstNode == null ? null : firstNode.getFirst();
            }
            Tuple next = (Tuple)tuple.getNext();
            if (next != null) {
                return next;
            }
            Comparable key = TupleIndexRBTree.this.getLeftIndexedValue(tuple);
            return TupleIndexRBTree.this.getNext(key, false);
        }

        @Override
        public boolean isFullIterator() {
            return false;
        }
    }
}

