/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.cli;

import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.drools.drlonyaml.cli.Drl2Yaml;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import picocli.CommandLine;

@CommandLine.Command(name="batch2yaml", description={"Converts all .drl files to YAML from the given directory, recursively. Converted files will get postfixed with .yml in their names."})
public class Batch2Yaml
implements Callable<Integer> {
    private static final Logger LOG = LoggerFactory.getLogger(Batch2Yaml.class);
    @CommandLine.Parameters(index="0", paramLabel="INPUT_DIR", description={"The directory containing .yml files; the directory is walked recursively."})
    private File inputDir;

    @Override
    public Integer call() throws Exception {
        this.inputDir.toPath();
        try (Stream<Path> walk = Files.walk(this.inputDir.toPath().toAbsolutePath(), new FileVisitOption[0]);){
            walk.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.getFileName().toString().endsWith(".drl")).forEach(p -> Batch2Yaml.convertFile(p.toAbsolutePath()));
        }
        return 0;
    }

    public static void convertFile(Path drlFile) {
        try {
            String drlTxt = Files.readAllLines(drlFile).stream().collect(Collectors.joining("\n"));
            Path to = Path.of(drlFile.toString() + ".yml", new String[0]);
            LOG.info("writing to: {}", (Object)to);
            String fileContent = "# Automatically generated from: " + drlFile.toFile().getName().toString() + "\n" + Drl2Yaml.drl2yaml(drlTxt);
            Files.writeString(to, (CharSequence)fileContent, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

