/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfig;
import com.github.victools.jsonschema.generator.SchemaKeyword;
import com.github.victools.jsonschema.generator.TypeContext;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import com.github.victools.jsonschema.generator.impl.DefinitionKey;
import com.github.victools.jsonschema.generator.impl.SchemaCleanUpUtils;
import com.github.victools.jsonschema.generator.impl.SchemaGenerationContextImpl;
import com.github.victools.jsonschema.generator.naming.CleanSchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.generator.naming.DefaultSchemaDefinitionNamingStrategy;
import com.github.victools.jsonschema.generator.naming.SchemaDefinitionNamingStrategy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class SchemaBuilder {
    private final SchemaGeneratorConfig config;
    private final TypeContext typeContext;
    private final SchemaGenerationContextImpl generationContext;
    private final List<ObjectNode> schemaNodes;
    private final CleanSchemaDefinitionNamingStrategy definitionNamingStrategy;

    static ObjectNode createSingleTypeSchema(SchemaGeneratorConfig config, TypeContext typeContext, Type mainTargetType, Type ... typeParameters) {
        SchemaBuilder instance = new SchemaBuilder(config, typeContext);
        return instance.createSchemaForSingleType(mainTargetType, typeParameters);
    }

    static SchemaBuilder forMultipleTypes(SchemaGeneratorConfig config, TypeContext typeContext) {
        return new SchemaBuilder(config, typeContext);
    }

    SchemaBuilder(SchemaGeneratorConfig config, TypeContext typeContext) {
        this.config = config;
        this.typeContext = typeContext;
        this.generationContext = new SchemaGenerationContextImpl(this.config, this.typeContext);
        this.schemaNodes = new ArrayList<ObjectNode>();
        SchemaDefinitionNamingStrategy baseNamingStrategy = config.getDefinitionNamingStrategy();
        if (baseNamingStrategy == null) {
            baseNamingStrategy = new DefaultSchemaDefinitionNamingStrategy();
        }
        SchemaCleanUpUtils cleanupUtils = new SchemaCleanUpUtils(config);
        Function<String, String> definitionCleanUpTask = config.shouldUsePlainDefinitionKeys() ? cleanupUtils::ensureDefinitionKeyIsPlain : cleanupUtils::ensureDefinitionKeyIsUriCompatible;
        this.definitionNamingStrategy = new CleanSchemaDefinitionNamingStrategy(baseNamingStrategy, definitionCleanUpTask);
    }

    private ObjectNode createSchemaForSingleType(Type mainTargetType, Type ... typeParameters) {
        String definitionsTagName;
        ObjectNode definitionsNode;
        boolean createDefinitionForMainSchema;
        ResolvedType mainType = this.typeContext.resolve(mainTargetType, typeParameters);
        DefinitionKey mainKey = this.generationContext.parseType(mainType);
        ObjectNode jsonSchemaResult = this.config.createObjectNode();
        if (this.config.shouldIncludeSchemaVersionIndicator()) {
            jsonSchemaResult.put(this.config.getKeyword(SchemaKeyword.TAG_SCHEMA), this.config.getKeyword(SchemaKeyword.TAG_SCHEMA_VALUE));
        }
        if (createDefinitionForMainSchema = this.config.shouldCreateDefinitionForMainSchema()) {
            this.generationContext.addReference(mainType, jsonSchemaResult, null, false);
        }
        if ((definitionsNode = this.buildDefinitionsAndResolveReferences(definitionsTagName = this.config.getKeyword(SchemaKeyword.TAG_DEFINITIONS), mainKey, this.generationContext)).size() > 0) {
            jsonSchemaResult.set(definitionsTagName, definitionsNode);
        }
        if (!createDefinitionForMainSchema) {
            ObjectNode mainSchemaNode = this.generationContext.getDefinition(mainKey);
            jsonSchemaResult.setAll(mainSchemaNode);
            this.schemaNodes.add(jsonSchemaResult);
        }
        this.performCleanup();
        this.config.resetAfterSchemaGenerationFinished();
        return jsonSchemaResult;
    }

    public ObjectNode createSchemaReference(Type targetType, Type ... typeParameters) {
        ResolvedType resolvedTargetType = this.typeContext.resolve(targetType, typeParameters);
        ObjectNode node = this.generationContext.createDefinitionReference(resolvedTargetType);
        this.schemaNodes.add(node);
        this.config.resetAfterSchemaGenerationFinished();
        return node;
    }

    public ObjectNode collectDefinitions(String designatedDefinitionPath) {
        ObjectNode definitionsNode = this.buildDefinitionsAndResolveReferences(designatedDefinitionPath, null, this.generationContext);
        this.performCleanup();
        return definitionsNode;
    }

    private void performCleanup() {
        SchemaCleanUpUtils cleanUpUtils = new SchemaCleanUpUtils(this.config);
        if (this.config.shouldCleanupUnnecessaryAllOfElements()) {
            cleanUpUtils.reduceAllOfNodes(this.schemaNodes);
        }
        cleanUpUtils.reduceAnyOfNodes(this.schemaNodes);
        if (this.config.shouldIncludeStrictTypeInfo()) {
            cleanUpUtils.setStrictTypeInfo(this.schemaNodes, true);
        }
    }

    private ObjectNode buildDefinitionsAndResolveReferences(String designatedDefinitionPath, DefinitionKey mainSchemaKey, SchemaGenerationContextImpl generationContext) {
        ObjectNode definitionsNode = this.config.createObjectNode();
        boolean createDefinitionsForAll = this.config.shouldCreateDefinitionsForAllObjects();
        boolean inlineAllSchemas = this.config.shouldInlineAllSchemas();
        AtomicBoolean considerOnlyDirectReferences = new AtomicBoolean(false);
        Predicate<DefinitionKey> shouldProduceDefinition = this.getShouldProduceDefinitionCheck(mainSchemaKey, considerOnlyDirectReferences, createDefinitionsForAll, inlineAllSchemas);
        Map<DefinitionKey, String> baseReferenceKeys = this.getReferenceKeys(mainSchemaKey, shouldProduceDefinition, generationContext);
        considerOnlyDirectReferences.set(true);
        boolean createDefinitionForMainSchema = this.config.shouldCreateDefinitionForMainSchema();
        for (Map.Entry<DefinitionKey, String> entry : baseReferenceKeys.entrySet()) {
            String referenceKey;
            ObjectNode definition;
            boolean referenceInline;
            String definitionName = entry.getValue();
            DefinitionKey definitionKey = entry.getKey();
            List<ObjectNode> references = generationContext.getReferences(definitionKey);
            List<ObjectNode> nullableReferences = generationContext.getNullableReferences(definitionKey);
            boolean bl = referenceInline = !shouldProduceDefinition.test(definitionKey);
            if (referenceInline) {
                definition = generationContext.getDefinition(definitionKey);
                references.forEach(node -> AttributeCollector.mergeMissingAttributes(node, definition));
                referenceKey = null;
            } else {
                if (createDefinitionForMainSchema || !definitionKey.equals(mainSchemaKey)) {
                    definitionsNode.set(definitionName, generationContext.getDefinition(definitionKey));
                    referenceKey = this.config.getKeyword(SchemaKeyword.TAG_REF_MAIN) + '/' + designatedDefinitionPath + '/' + definitionName;
                } else {
                    referenceKey = this.config.getKeyword(SchemaKeyword.TAG_REF_MAIN);
                }
                references.forEach(node -> node.put(this.config.getKeyword(SchemaKeyword.TAG_REF), referenceKey));
            }
            if (nullableReferences.isEmpty()) continue;
            definition = referenceInline ? generationContext.getDefinition(definitionKey) : this.config.createObjectNode().put(this.config.getKeyword(SchemaKeyword.TAG_REF), referenceKey);
            generationContext.makeNullable(definition);
            if (generationContext.shouldNeverInlineDefinition(definitionKey) || !inlineAllSchemas && (createDefinitionsForAll || nullableReferences.size() > 1)) {
                String nullableDefinitionName = this.definitionNamingStrategy.adjustNullableName(definitionKey, definitionName, generationContext);
                definitionsNode.set(nullableDefinitionName, definition);
                nullableReferences.forEach(node -> node.put(this.config.getKeyword(SchemaKeyword.TAG_REF), this.config.getKeyword(SchemaKeyword.TAG_REF_MAIN) + '/' + designatedDefinitionPath + '/' + nullableDefinitionName));
                continue;
            }
            nullableReferences.forEach(node -> AttributeCollector.mergeMissingAttributes(node, definition));
        }
        definitionsNode.forEach(node -> this.schemaNodes.add((ObjectNode)node));
        return definitionsNode;
    }

    private Predicate<DefinitionKey> getShouldProduceDefinitionCheck(DefinitionKey mainSchemaKey, AtomicBoolean considerOnlyDirectReferences, boolean createDefinitionsForAll, boolean inlineAllSchemas) {
        return definitionKey -> {
            if (this.generationContext.shouldNeverInlineDefinition((DefinitionKey)definitionKey)) {
                return true;
            }
            if (inlineAllSchemas) {
                return false;
            }
            if (definitionKey.equals(mainSchemaKey)) {
                return true;
            }
            List<ObjectNode> references = this.generationContext.getReferences((DefinitionKey)definitionKey);
            if (considerOnlyDirectReferences.get() && references.isEmpty()) {
                return false;
            }
            if (createDefinitionsForAll || references.size() > 1) {
                return true;
            }
            List<ObjectNode> nullableReferences = this.generationContext.getNullableReferences((DefinitionKey)definitionKey);
            return references.size() + nullableReferences.size() > 1;
        };
    }

    private Map<DefinitionKey, String> getReferenceKeys(DefinitionKey mainSchemaKey, Predicate<DefinitionKey> shouldProduceDefinition, SchemaGenerationContextImpl generationContext) {
        boolean createDefinitionForMainSchema = this.config.shouldCreateDefinitionForMainSchema();
        Function<DefinitionKey, String> definitionNamesForKey = key -> this.definitionNamingStrategy.getDefinitionNameForKey((DefinitionKey)key, generationContext);
        Map aliases = generationContext.getDefinedTypes().stream().collect(Collectors.groupingBy(definitionNamesForKey, TreeMap::new, Collectors.toList()));
        LinkedHashMap<DefinitionKey, String> referenceKeys = new LinkedHashMap<DefinitionKey, String>();
        for (Map.Entry group : aliases.entrySet()) {
            ((List)group.getValue()).forEach(key -> referenceKeys.put((DefinitionKey)key, ""));
            List<DefinitionKey> definitionKeys = ((List)group.getValue()).stream().filter(shouldProduceDefinition).collect(Collectors.toList());
            if (definitionKeys.size() == 1 || definitionKeys.size() == 2 && !createDefinitionForMainSchema && definitionKeys.contains(mainSchemaKey)) {
                definitionKeys.forEach(key -> referenceKeys.put((DefinitionKey)key, (String)group.getKey()));
                continue;
            }
            Map referenceKeyGroup = definitionKeys.stream().collect(Collectors.toMap(key -> key, _key -> (String)group.getKey(), (val1, _val2) -> val1, LinkedHashMap::new));
            this.definitionNamingStrategy.adjustDuplicateNames(referenceKeyGroup, generationContext);
            if (definitionKeys.size() != referenceKeyGroup.size()) {
                throw new IllegalStateException(SchemaDefinitionNamingStrategy.class.getSimpleName() + " of type " + this.definitionNamingStrategy.getClass().getSimpleName() + " altered list of subschemas with duplicate names.");
            }
            referenceKeys.putAll(referenceKeyGroup);
        }
        String remainingDuplicateKeys = referenceKeys.values().stream().filter(value -> !value.isEmpty()).collect(Collectors.groupingBy(key -> key, Collectors.counting())).entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.joining(", "));
        if (!remainingDuplicateKeys.isEmpty()) {
            throw new IllegalStateException(SchemaDefinitionNamingStrategy.class.getSimpleName() + " of type " + this.definitionNamingStrategy.getClass().getSimpleName() + " produced duplicate keys: " + remainingDuplicateKeys);
        }
        return referenceKeys;
    }
}

