/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.module.jackson;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.jackson.annotation.JsonIdentityInfo;
import com.fasterxml.jackson.annotation.JsonIdentityReference;
import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProviderV2;
import com.github.victools.jsonschema.generator.CustomPropertyDefinition;
import com.github.victools.jsonschema.generator.MemberScope;
import com.github.victools.jsonschema.generator.SchemaGenerationContext;
import com.github.victools.jsonschema.generator.TypeContext;
import java.lang.reflect.Type;
import java.util.Optional;
import java.util.stream.Stream;

public class JsonIdentityReferenceDefinitionProvider
implements CustomDefinitionProviderV2 {
    @Override
    public CustomDefinition provideCustomSchemaDefinition(ResolvedType javaType, SchemaGenerationContext context) {
        return this.getIdentityReferenceType(javaType, context.getTypeContext()).map(context::createDefinitionReference).map(CustomDefinition::new).orElse(null);
    }

    public CustomPropertyDefinition provideCustomPropertySchemaDefinition(MemberScope<?, ?> scope, SchemaGenerationContext context) {
        return this.getIdentityReferenceType(scope).map(context::createDefinitionReference).map(CustomPropertyDefinition::new).orElse(null);
    }

    public Optional<ResolvedType> getIdentityReferenceType(ResolvedType javaType, TypeContext typeContext) {
        JsonIdentityReference referenceAnnotation = javaType.getErasedType().getAnnotation(JsonIdentityReference.class);
        return this.getIdentityReferenceType(referenceAnnotation, javaType, typeContext);
    }

    public Optional<ResolvedType> getIdentityReferenceType(MemberScope<?, ?> scope) {
        JsonIdentityReference referenceAnnotation = scope.getContainerItemAnnotationConsideringFieldAndGetterIfSupported(JsonIdentityReference.class);
        if (referenceAnnotation == null) {
            referenceAnnotation = scope.getAnnotationConsideringFieldAndGetter(JsonIdentityReference.class);
        }
        return this.getIdentityReferenceType(referenceAnnotation, scope.getType(), scope.getContext());
    }

    private Optional<ResolvedType> getIdentityReferenceType(JsonIdentityReference referenceAnnotation, ResolvedType javaType, TypeContext typeContext) {
        if (referenceAnnotation == null || !referenceAnnotation.alwaysAsId()) {
            return Optional.empty();
        }
        ResolvedType typeWithIdentityInfoAnnotation = typeContext.getTypeWithAnnotation(javaType, JsonIdentityInfo.class);
        if (typeWithIdentityInfoAnnotation == null) {
            return Optional.empty();
        }
        JsonIdentityInfo identityInfoAnnotation = typeWithIdentityInfoAnnotation.getErasedType().getAnnotation(JsonIdentityInfo.class);
        ResolvedType identityTypeFromGenerator = typeContext.getTypeParameterFor(typeContext.resolve(identityInfoAnnotation.generator(), new Type[0]), ObjectIdGenerator.class, 0);
        if (identityTypeFromGenerator == null || identityTypeFromGenerator.getErasedType() == Object.class) {
            String idPropertyName = identityInfoAnnotation.property();
            ResolvedField[] eligibleFields = typeContext.resolveWithMembers(typeWithIdentityInfoAnnotation).getMemberFields();
            Optional<ResolvedType> identityTypeFromProperty = Stream.of(eligibleFields).filter(field -> field.getName().equals(idPropertyName)).map(ResolvedMember::getType).findFirst();
            if (identityTypeFromProperty.isPresent()) {
                return identityTypeFromProperty;
            }
        }
        return Optional.ofNullable(identityTypeFromGenerator);
    }
}

