/*
 * Decompiled with CFR 0.152.
 */
package org.drools.drlonyaml.todrl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.drools.drl.ast.descr.PackageDescr;
import org.drools.drl.parser.DrlParser;
import org.drools.drlonyaml.model.DrlPackage;
import org.drools.drlonyaml.todrl.YAMLtoDrlDumper;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YAMLtoDRLTest {
    private static final Logger LOG = LoggerFactory.getLogger(YAMLtoDRLTest.class);
    private static final DrlParser drlParser = new DrlParser();
    private static final ObjectMapper mapper;

    private void assertDumpingYAMLtoDRLisValid(String filename) {
        try {
            String yamlText = Files.readString(Paths.get(YAMLtoDRLTest.class.getResource(filename).toURI()));
            ((AbstractStringAssert)Assertions.assertThat((String)yamlText).as("Failed to read test resource", new Object[0])).isNotNull();
            DrlPackage readValue = (DrlPackage)mapper.readValue(yamlText, DrlPackage.class);
            ((ObjectAssert)Assertions.assertThat((Object)readValue).as("Failed to parse YAML as model", new Object[0])).isNotNull();
            String drlText = YAMLtoDrlDumper.dumpDRL((DrlPackage)readValue);
            LOG.debug(drlText);
            ((AbstractStringAssert)((AbstractStringAssert)Assertions.assertThat((String)drlText).as("result of DRL dumper shall not be null or empty", new Object[0])).isNotNull()).isNotEmpty();
            PackageDescr parseResult = drlParser.parse((Reader)new StringReader(drlText));
            ((ObjectAssert)Assertions.assertThat((Object)parseResult).as("The result of DRL dumper must be syntactically valid DRL", new Object[0])).isNotNull();
        }
        catch (Exception e) {
            Assertions.fail((String)"Failed to generate a valid DRL while processing YAML", (Throwable)e);
        }
    }

    @Test
    public void smokeTestFromYAML2() {
        this.assertDumpingYAMLtoDRLisValid("/smoketests/yaml2.yml");
    }

    @Test
    public void smokeTestFromYAML3() {
        this.assertDumpingYAMLtoDRLisValid("/smoketests/yaml3.yml");
    }

    @Test
    public void smokeTestFromYAML4() {
        this.assertDumpingYAMLtoDRLisValid("/smoketests/yaml4.yml");
    }

    @Test
    public void smokeTestFromYAML5() {
        this.assertDumpingYAMLtoDRLisValid("/smoketests/yaml5.yml");
    }

    @Test
    public void smokeTestFromYAML6() {
        this.assertDumpingYAMLtoDRLisValid("/smoketests/yaml6.yml");
    }

    @Test
    public void smokeTestFromYAML7() {
        this.assertDumpingYAMLtoDRLisValid("/smoketests/yaml7.yml");
    }

    @Test
    public void smokeTestFromYAML8() {
        this.assertDumpingYAMLtoDRLisValid("/smoketests/yaml8.yml");
    }

    @Test
    public void smokeTestFromYAML9() {
        this.assertDumpingYAMLtoDRLisValid("/smoketests/yaml9.yml");
    }

    @Test
    public void smokeTestFromYAML10() {
        this.assertDumpingYAMLtoDRLisValid("/smoketests/yaml10.yml");
    }

    @Test
    public void smokeTestFromYAML11() {
        this.assertDumpingYAMLtoDRLisValid("/smoketests/yaml11.yml");
    }

    static {
        YAMLFactory yamlFactory = YAMLFactory.builder().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).build();
        mapper = new ObjectMapper((JsonFactory)yamlFactory);
    }
}

