/*
 * Decompiled with CFR 0.152.
 */
package org.drools.fastutil;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.drools.base.util.FieldIndex;
import org.drools.core.reteoo.Tuple;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.index.TupleList;
import org.drools.fastutil.FastUtilMergableHashSet;

public class FastUtilHashTupleMemory
implements TupleMemory {
    public static final int PRIME = 31;
    private int startResult;
    private int factSize;
    private FastUtilMergableHashSet<AbstractHashTable.HashEntry> set = new FastUtilMergableHashSet(HashStrategy.get());
    private transient FullFastIterator fullFastIterator;
    private boolean left;
    private AbstractHashTable.Index index;

    public FastUtilHashTupleMemory(FieldIndex[] index, boolean left) {
        this.left = left;
        this.fullFastIterator = new FullFastIterator(this.set);
        this.startResult = 31;
        for (FieldIndex i : index) {
            this.startResult += 31 * this.startResult + i.getRightExtractor().getIndex();
        }
        switch (index.length) {
            case 0: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  0");
            }
            case 1: {
                this.index = new AbstractHashTable.SingleIndex(index, this.startResult);
                break;
            }
            case 2: {
                this.index = new AbstractHashTable.DoubleCompositeIndex(index, this.startResult);
                break;
            }
            case 3: {
                this.index = new AbstractHashTable.TripleCompositeIndex(index, this.startResult);
                break;
            }
            default: {
                throw new IllegalArgumentException("FieldIndexHashTable cannot use an index[] of length  great than 3");
            }
        }
    }

    public Tuple getFirst(Tuple tuple) {
        TupleList bucket = this.get(tuple, !this.left);
        return bucket != null ? bucket.getFirst() : null;
    }

    private TupleList get(Tuple tuple, boolean left) {
        AbstractHashTable.HashEntry hashEntry = this.index.hashCodeOf(tuple, left);
        TupleList tupleList = (TupleList)this.set.get(hashEntry);
        return tupleList;
    }

    public void removeAdd(Tuple tuple) {
        IndexTupleList tupleList = (IndexTupleList)tuple.getMemory();
        tupleList.remove(tuple);
        AbstractHashTable.HashEntry hashEntry = this.index.hashCodeOf(tuple, this.left);
        if (hashEntry.hashCode() == tupleList.hashCode()) {
            tupleList.add(tuple);
            return;
        }
        if (tupleList.getFirst() == null) {
            this.set.remove(tupleList.hashEntry);
        }
        tupleList = this.getOrCreate(hashEntry);
        tupleList.add(tuple);
    }

    public void add(Tuple tuple) {
        AbstractHashTable.HashEntry hashEntry = this.index.hashCodeOf(tuple, this.left);
        IndexTupleList entry = this.getOrCreate(hashEntry);
        entry.add(tuple);
        ++this.factSize;
    }

    private IndexTupleList getOrCreate(AbstractHashTable.HashEntry hashEntry) {
        IndexTupleList returned = (IndexTupleList)this.set.compute(hashEntry, (key, value) -> {
            if (value == null) {
                value = new IndexTupleList(key.clone());
            }
            return value;
        });
        return returned;
    }

    public void remove(Tuple tuple) {
        IndexTupleList memory = (IndexTupleList)tuple.getMemory();
        memory.remove(tuple);
        --this.factSize;
        if (memory.getFirst() == null) {
            this.set.remove(memory.hashEntry());
        }
        tuple.clear();
    }

    public boolean isIndexed() {
        return true;
    }

    public int size() {
        return this.factSize;
    }

    public Iterator iterator() {
        return new FullIterator(new FullFastIterator(this.set));
    }

    public FastIterator<Tuple> fastIterator() {
        return LinkedList.fastIterator;
    }

    public FastIterator<Tuple> fullFastIterator() {
        this.fullFastIterator.reset();
        return this.fullFastIterator;
    }

    public FastIterator<Tuple> fullFastIterator(Tuple tuple) {
        this.fullFastIterator.resume(tuple);
        return this.fullFastIterator;
    }

    public Tuple[] toArray() {
        Tuple[] result = new Tuple[this.size()];
        int index = 0;
        ObjectIterator objectIterator = this.set.iterator();
        while (objectIterator.hasNext()) {
            AbstractHashTable.HashEntry hash = (AbstractHashTable.HashEntry)objectIterator.next();
            for (Tuple tuple = ((TupleList)hash).getFirst(); tuple != null; tuple = (Tuple)tuple.getNext()) {
                result[index++] = tuple;
            }
        }
        return result;
    }

    public AbstractHashTable.Index getIndex() {
        return this.index;
    }

    public TupleMemory.IndexType getIndexType() {
        return TupleMemory.IndexType.EQUAL;
    }

    public void clear() {
        this.set.clear();
        this.startResult = 31;
        this.factSize = 0;
    }

    public static class HashStrategy
    implements Hash.Strategy<AbstractHashTable.HashEntry> {
        public static HashStrategy INSTANCE = new HashStrategy();

        public static HashStrategy get() {
            return INSTANCE;
        }

        public int hashCode(AbstractHashTable.HashEntry a) {
            return a.hashCode();
        }

        public boolean equals(AbstractHashTable.HashEntry a, AbstractHashTable.HashEntry b) {
            return a.equals(b != null ? ((IndexTupleList)b).hashEntry : null);
        }
    }

    public static class FullFastIterator
    implements FastIterator<Tuple> {
        private FastUtilMergableHashSet<AbstractHashTable.HashEntry> set;
        private ObjectIterator<AbstractHashTable.HashEntry> it;

        public FullFastIterator(FastUtilMergableHashSet<AbstractHashTable.HashEntry> set) {
            this.set = set;
        }

        public void resume(Tuple target) {
            this.reset();
            TupleList targetMemory = target.getMemory();
            while (this.it.hasNext()) {
                TupleList c = (TupleList)this.it.next();
                if (c != targetMemory) continue;
                return;
            }
        }

        public Tuple next(Tuple tuple) {
            Tuple next = null;
            if (tuple != null && (next = (Tuple)tuple.getNext()) != null) {
                return next;
            }
            if (this.it.hasNext()) {
                next = ((TupleList)this.it.next()).getFirst();
            }
            return next;
        }

        public boolean isFullIterator() {
            return true;
        }

        public void reset() {
            this.it = this.set.iterator();
        }
    }

    public static class IndexTupleList
    extends TupleList
    implements AbstractHashTable.HashEntry {
        private AbstractHashTable.HashEntry hashEntry;

        public IndexTupleList(AbstractHashTable.HashEntry hashEntry) {
            this.hashEntry = hashEntry;
        }

        public AbstractHashTable.HashEntry hashEntry() {
            return this.hashEntry;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            IndexTupleList that = (IndexTupleList)((Object)o);
            return this.hashEntry.equals(that.hashEntry);
        }

        public int hashCode() {
            return this.hashEntry.hashCode();
        }

        public AbstractHashTable.HashEntry clone() {
            throw new UnsupportedOperationException();
        }
    }

    public static class FullIterator
    implements Iterator<Tuple> {
        private FullFastIterator fullFastIterator;
        private Tuple tuple;

        public FullIterator(FullFastIterator fullFastIterator) {
            this.fullFastIterator = fullFastIterator;
        }

        public Tuple next() {
            this.tuple = this.fullFastIterator.next(this.tuple);
            return this.tuple;
        }
    }
}

