/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.models.guided.dtable.backend;

import java.util.List;
import org.drools.guvnor.models.guided.dtable.backend.util.GuidedDecisionTableUpgradeHelper1;
import org.drools.guvnor.models.guided.dtable.shared.model.ActionInsertFactCol52;
import org.drools.guvnor.models.guided.dtable.shared.model.ActionRetractFactCol52;
import org.drools.guvnor.models.guided.dtable.shared.model.ActionSetFieldCol52;
import org.drools.guvnor.models.guided.dtable.shared.model.AttributeCol52;
import org.drools.guvnor.models.guided.dtable.shared.model.ConditionCol52;
import org.drools.guvnor.models.guided.dtable.shared.model.DTCellValue52;
import org.drools.guvnor.models.guided.dtable.shared.model.GuidedDecisionTable52;
import org.drools.guvnor.models.guided.dtable.shared.model.MetadataCol52;
import org.drools.guvnor.models.guided.dtable.shared.model.legacy.ActionInsertFactCol;
import org.drools.guvnor.models.guided.dtable.shared.model.legacy.ActionRetractFactCol;
import org.drools.guvnor.models.guided.dtable.shared.model.legacy.ActionSetFieldCol;
import org.drools.guvnor.models.guided.dtable.shared.model.legacy.AttributeCol;
import org.drools.guvnor.models.guided.dtable.shared.model.legacy.ConditionCol;
import org.drools.guvnor.models.guided.dtable.shared.model.legacy.GuidedDecisionTable;
import org.drools.guvnor.models.guided.dtable.shared.model.legacy.MetadataCol;
import org.junit.Assert;
import org.junit.Test;

public class GuidedDTModelConversionTest {
    private GuidedDecisionTableUpgradeHelper1 upgrader = new GuidedDecisionTableUpgradeHelper1();

    @Test
    public void testConversion() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        dt.tableName = "michael";
        MetadataCol md = new MetadataCol();
        md.attr = "legacy";
        md.defaultValue = "yes";
        dt.metadataCols.add(md);
        AttributeCol attr = new AttributeCol();
        attr.attr = "salience";
        attr.defaultValue = "66";
        dt.attributeCols.add(attr);
        ConditionCol con = new ConditionCol();
        con.boundName = "f1";
        con.constraintValueType = 1;
        con.factField = "age";
        con.factType = "Driver";
        con.header = "Driver f1 age";
        con.operator = "==";
        dt.conditionCols.add(con);
        ConditionCol con2 = new ConditionCol();
        con2.boundName = "f1";
        con2.constraintValueType = 1;
        con2.factField = "name";
        con2.factType = "Driver";
        con2.header = "Driver f1 name";
        con2.operator = "==";
        dt.conditionCols.add(con2);
        ConditionCol con3 = new ConditionCol();
        con3.boundName = "f1";
        con3.constraintValueType = 3;
        con3.factField = "rating";
        con3.factType = "Driver";
        con3.header = "Driver rating";
        con3.operator = "==";
        dt.conditionCols.add(con3);
        ConditionCol con4 = new ConditionCol();
        con4.boundName = "f2";
        con4.constraintValueType = 5;
        con4.factType = "Driver";
        con4.header = "Driver 2 pimp";
        con4.factField = "(not needed)";
        dt.conditionCols.add(con4);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.boundName = "ins";
        ins.factType = "Cheese";
        ins.factField = "price";
        ins.type = "Integer";
        dt.actionCols.add(ins);
        ActionRetractFactCol ret = new ActionRetractFactCol();
        ret.boundName = "ret1";
        dt.actionCols.add(ret);
        ActionSetFieldCol set = new ActionSetFieldCol();
        set.boundName = "f1";
        set.factField = "goo1";
        set.type = "String";
        dt.actionCols.add(set);
        ActionSetFieldCol set2 = new ActionSetFieldCol();
        set2.boundName = "f1";
        set2.factField = "goo2";
        set2.defaultValue = "whee";
        set2.type = "String";
        dt.actionCols.add(set2);
        dt.data = new String[][]{{"1", "desc", "metar1", "saliencer1", "c1r1", "c2r1", "c3r1", "c4r1", "a1r1", "a2r1", "a3r1", "a4r1"}, {"2", "desc", "metar2", "saliencer2", "c1r2", "c2r2", "c3r2", "c4r2", "a1r2", "a2r2", "a3r2", "a4r2"}};
        String[][] expected = new String[][]{{"1", "desc", "metar1", "saliencer1", "c1r1", "c2r1", "c3r1", "c4r1", "a1r1", "ret1", "a3r1", "a4r1"}, {"2", "desc", "metar2", "saliencer2", "c1r2", "c2r2", "c3r2", "c4r2", "a1r2", "ret1", "a3r2", "a4r2"}};
        GuidedDecisionTable52 tsdt = this.upgrader.upgrade(dt);
        Assert.assertEquals((Object)"michael", (Object)tsdt.getTableName());
        Assert.assertEquals((Object)GuidedDecisionTable52.TableFormat.EXTENDED_ENTRY, (Object)tsdt.getTableFormat());
        Assert.assertEquals((long)1L, (long)tsdt.getMetadataCols().size());
        Assert.assertEquals((Object)"legacy", (Object)((MetadataCol52)tsdt.getMetadataCols().get(0)).getMetadata());
        Assert.assertEquals((Object)"yes", (Object)((MetadataCol52)tsdt.getMetadataCols().get(0)).getDefaultValue().getStringValue());
        Assert.assertEquals((long)1L, (long)tsdt.getAttributeCols().size());
        Assert.assertEquals((Object)"salience", (Object)((AttributeCol52)tsdt.getAttributeCols().get(0)).getAttribute());
        Assert.assertEquals((Object)"66", (Object)((AttributeCol52)tsdt.getAttributeCols().get(0)).getDefaultValue().getStringValue());
        Assert.assertEquals((long)2L, (long)tsdt.getConditions().size());
        Assert.assertEquals((Object)"f1", (Object)tsdt.getConditionPattern("f1").getBoundName());
        Assert.assertEquals((Object)"Driver", (Object)tsdt.getConditionPattern("f1").getFactType());
        Assert.assertEquals((Object)"f2", (Object)tsdt.getConditionPattern("f2").getBoundName());
        Assert.assertEquals((Object)"Driver", (Object)tsdt.getConditionPattern("f2").getFactType());
        Assert.assertEquals((long)3L, (long)tsdt.getConditionPattern("f1").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)tsdt.getConditionPattern("f2").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getConstraintValueType());
        Assert.assertEquals((Object)"age", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getFactField());
        Assert.assertEquals((Object)"Driver", (Object)tsdt.getPattern((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getFactType());
        Assert.assertEquals((Object)"Driver f1 age", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getHeader());
        Assert.assertEquals((Object)"==", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getOperator());
        Assert.assertEquals((long)1L, (long)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(1)).getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(1)).getFactField());
        Assert.assertEquals((Object)"Driver", (Object)tsdt.getPattern((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(1)).getFactType());
        Assert.assertEquals((Object)"Driver f1 name", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(1)).getHeader());
        Assert.assertEquals((Object)"==", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(1)).getOperator());
        Assert.assertEquals((long)3L, (long)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(2)).getConstraintValueType());
        Assert.assertEquals((Object)"rating", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(2)).getFactField());
        Assert.assertEquals((Object)"Driver", (Object)tsdt.getPattern((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(2)).getFactType());
        Assert.assertEquals((Object)"Driver rating", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(2)).getHeader());
        Assert.assertEquals((Object)"==", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(2)).getOperator());
        Assert.assertEquals((long)5L, (long)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getConstraintValueType());
        Assert.assertEquals((Object)"(not needed)", (Object)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getFactField());
        Assert.assertEquals((Object)"Driver", (Object)tsdt.getPattern((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getFactType());
        Assert.assertEquals((Object)"Driver 2 pimp", (Object)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getHeader());
        Assert.assertEquals((long)4L, (long)tsdt.getActionCols().size());
        ActionInsertFactCol52 a1 = (ActionInsertFactCol52)tsdt.getActionCols().get(0);
        Assert.assertEquals((Object)"ins", (Object)a1.getBoundName());
        Assert.assertEquals((Object)"Cheese", (Object)a1.getFactType());
        Assert.assertEquals((Object)"price", (Object)a1.getFactField());
        Assert.assertEquals((Object)"Integer", (Object)a1.getType());
        ActionRetractFactCol52 a2 = (ActionRetractFactCol52)tsdt.getActionCols().get(1);
        Assert.assertNotNull((Object)a2);
        ActionSetFieldCol52 a3 = (ActionSetFieldCol52)tsdt.getActionCols().get(2);
        Assert.assertEquals((Object)"f1", (Object)a3.getBoundName());
        Assert.assertEquals((Object)"goo1", (Object)a3.getFactField());
        Assert.assertEquals((Object)"String", (Object)a3.getType());
        ActionSetFieldCol52 a4 = (ActionSetFieldCol52)tsdt.getActionCols().get(3);
        Assert.assertEquals((Object)"f1", (Object)a4.getBoundName());
        Assert.assertEquals((Object)"goo2", (Object)a4.getFactField());
        Assert.assertEquals((Object)"whee", (Object)a4.getDefaultValue().getStringValue());
        Assert.assertEquals((Object)"String", (Object)a4.getType());
        Assert.assertEquals((long)2L, (long)tsdt.getData().size());
        this.isRowEquivalent((List)tsdt.getData().get(0), expected[0]);
        this.isRowEquivalent((List)tsdt.getData().get(1), expected[1]);
    }

    @Test
    public void testConversionPatternGrouping() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        dt.tableName = "michael";
        MetadataCol md = new MetadataCol();
        md.attr = "legacy";
        md.defaultValue = "yes";
        dt.metadataCols.add(md);
        AttributeCol attr = new AttributeCol();
        attr.attr = "salience";
        attr.defaultValue = "66";
        dt.attributeCols.add(attr);
        ConditionCol con = new ConditionCol();
        con.boundName = "f1";
        con.constraintValueType = 1;
        con.factField = "age";
        con.factType = "Driver";
        con.header = "Driver f1 age";
        con.operator = "==";
        dt.conditionCols.add(con);
        ConditionCol con2 = new ConditionCol();
        con2.boundName = "f2";
        con2.constraintValueType = 1;
        con2.factField = "name";
        con2.factType = "Person";
        con2.header = "Person f2 name";
        con2.operator = "==";
        dt.conditionCols.add(con2);
        ConditionCol con3 = new ConditionCol();
        con3.boundName = "f1";
        con3.constraintValueType = 3;
        con3.factField = "rating";
        con3.factType = "Driver";
        con3.header = "Driver rating";
        con3.operator = "==";
        dt.conditionCols.add(con3);
        ConditionCol con4 = new ConditionCol();
        con4.boundName = "f2";
        con4.constraintValueType = 5;
        con4.factType = "Person";
        con4.header = "Person f2 not needed";
        con4.factField = "(not needed)";
        dt.conditionCols.add(con4);
        ActionInsertFactCol ins = new ActionInsertFactCol();
        ins.boundName = "ins";
        ins.factType = "Cheese";
        ins.factField = "price";
        ins.type = "Integer";
        dt.actionCols.add(ins);
        ActionRetractFactCol ret = new ActionRetractFactCol();
        ret.boundName = "ret1";
        dt.actionCols.add(ret);
        ActionSetFieldCol set = new ActionSetFieldCol();
        set.boundName = "f1";
        set.factField = "goo1";
        set.type = "String";
        dt.actionCols.add(set);
        ActionSetFieldCol set2 = new ActionSetFieldCol();
        set2.boundName = "f1";
        set2.factField = "goo2";
        set2.defaultValue = "whee";
        set2.type = "String";
        dt.actionCols.add(set2);
        dt.data = new String[][]{{"1", "desc", "metar1", "saliencer1", "f1c1r1", "f2c1r1", "f1c2r1", "f2c2r1", "a1r1", "a2r1", "a3r1", "a4r1"}, {"2", "desc", "metar2", "saliencer2", "f1c1r2", "f2c1r2", "f1c2r2", "f2c2r2", "a1r2", "a2r2", "a3r2", "a4r2"}};
        String[][] expected = new String[][]{{"1", "desc", "metar1", "saliencer1", "f1c1r1", "f1c2r1", "f2c1r1", "f2c2r1", "a1r1", "ret1", "a3r1", "a4r1"}, {"2", "desc", "metar2", "saliencer2", "f1c1r2", "f1c2r2", "f2c1r2", "f2c2r2", "a1r2", "ret1", "a3r2", "a4r2"}};
        GuidedDecisionTable52 tsdt = this.upgrader.upgrade(dt);
        Assert.assertEquals((Object)"michael", (Object)tsdt.getTableName());
        Assert.assertEquals((long)1L, (long)tsdt.getMetadataCols().size());
        Assert.assertEquals((Object)"legacy", (Object)((MetadataCol52)tsdt.getMetadataCols().get(0)).getMetadata());
        Assert.assertEquals((Object)"yes", (Object)((MetadataCol52)tsdt.getMetadataCols().get(0)).getDefaultValue().getStringValue());
        Assert.assertEquals((long)1L, (long)tsdt.getAttributeCols().size());
        Assert.assertEquals((Object)"salience", (Object)((AttributeCol52)tsdt.getAttributeCols().get(0)).getAttribute());
        Assert.assertEquals((Object)"66", (Object)((AttributeCol52)tsdt.getAttributeCols().get(0)).getDefaultValue().getStringValue());
        Assert.assertEquals((long)2L, (long)tsdt.getConditions().size());
        Assert.assertEquals((Object)"f1", (Object)tsdt.getConditionPattern("f1").getBoundName());
        Assert.assertEquals((Object)"Driver", (Object)tsdt.getConditionPattern("f1").getFactType());
        Assert.assertEquals((Object)"f2", (Object)tsdt.getConditionPattern("f2").getBoundName());
        Assert.assertEquals((Object)"Person", (Object)tsdt.getConditionPattern("f2").getFactType());
        Assert.assertEquals((long)2L, (long)tsdt.getConditionPattern("f1").getChildColumns().size());
        Assert.assertEquals((long)2L, (long)tsdt.getConditionPattern("f2").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getConstraintValueType());
        Assert.assertEquals((Object)"age", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getFactField());
        Assert.assertEquals((Object)"Driver", (Object)tsdt.getPattern((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getFactType());
        Assert.assertEquals((Object)"Driver f1 age", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getHeader());
        Assert.assertEquals((Object)"==", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getOperator());
        Assert.assertEquals((long)3L, (long)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(1)).getConstraintValueType());
        Assert.assertEquals((Object)"rating", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(1)).getFactField());
        Assert.assertEquals((Object)"Driver", (Object)tsdt.getPattern((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(1)).getFactType());
        Assert.assertEquals((Object)"Driver rating", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(1)).getHeader());
        Assert.assertEquals((Object)"==", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(1)).getOperator());
        Assert.assertEquals((long)1L, (long)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getFactField());
        Assert.assertEquals((Object)"Person", (Object)tsdt.getPattern((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getFactType());
        Assert.assertEquals((Object)"Person f2 name", (Object)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getHeader());
        Assert.assertEquals((Object)"==", (Object)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getOperator());
        Assert.assertEquals((long)5L, (long)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(1)).getConstraintValueType());
        Assert.assertEquals((Object)"(not needed)", (Object)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(1)).getFactField());
        Assert.assertEquals((Object)"Person", (Object)tsdt.getPattern((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(1)).getFactType());
        Assert.assertEquals((Object)"Person f2 not needed", (Object)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(1)).getHeader());
        Assert.assertEquals(null, (Object)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(1)).getOperator());
        Assert.assertEquals((long)4L, (long)tsdt.getActionCols().size());
        ActionInsertFactCol52 a1 = (ActionInsertFactCol52)tsdt.getActionCols().get(0);
        Assert.assertEquals((Object)"ins", (Object)a1.getBoundName());
        Assert.assertEquals((Object)"Cheese", (Object)a1.getFactType());
        Assert.assertEquals((Object)"price", (Object)a1.getFactField());
        Assert.assertEquals((Object)"Integer", (Object)a1.getType());
        ActionRetractFactCol52 a2 = (ActionRetractFactCol52)tsdt.getActionCols().get(1);
        Assert.assertNotNull((Object)a2);
        ActionSetFieldCol52 a3 = (ActionSetFieldCol52)tsdt.getActionCols().get(2);
        Assert.assertEquals((Object)"f1", (Object)a3.getBoundName());
        Assert.assertEquals((Object)"goo1", (Object)a3.getFactField());
        Assert.assertEquals((Object)"String", (Object)a3.getType());
        ActionSetFieldCol52 a4 = (ActionSetFieldCol52)tsdt.getActionCols().get(3);
        Assert.assertEquals((Object)"f1", (Object)a4.getBoundName());
        Assert.assertEquals((Object)"goo2", (Object)a4.getFactField());
        Assert.assertEquals((Object)"whee", (Object)a4.getDefaultValue().getStringValue());
        Assert.assertEquals((Object)"String", (Object)a4.getType());
        Assert.assertEquals((long)2L, (long)tsdt.getData().size());
        for (int i = 0; i < 2; ++i) {
            System.out.println("Row-" + i);
            StringBuilder sb = new StringBuilder();
            for (DTCellValue52 c : (List)tsdt.getData().get(i)) {
                sb.append(c.getStringValue() + ", ");
            }
            sb.delete(sb.lastIndexOf(","), sb.length());
            System.out.println(sb.toString());
        }
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)((DTCellValue52)((List)tsdt.getData().get(0)).get(0)).getNumericValue()));
        Assert.assertEquals((Object)"desc", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(1)).getStringValue());
        Assert.assertEquals((Object)"metar1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(2)).getStringValue());
        Assert.assertEquals((Object)"saliencer1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"f1c1r1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((Object)"f1c2r1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((Object)"f2c1r1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(6)).getStringValue());
        Assert.assertEquals((Object)"f2c2r1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(7)).getStringValue());
        Assert.assertEquals((Object)"a1r1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(8)).getStringValue());
        Assert.assertEquals((Object)"ret1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(9)).getStringValue());
        Assert.assertEquals((Object)"a3r1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(10)).getStringValue());
        Assert.assertEquals((Object)"a4r1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(11)).getStringValue());
        Assert.assertEquals((Object)new Integer(2), (Object)((Integer)((DTCellValue52)((List)tsdt.getData().get(1)).get(0)).getNumericValue()));
        Assert.assertEquals((Object)"desc", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(1)).getStringValue());
        Assert.assertEquals((Object)"metar2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(2)).getStringValue());
        Assert.assertEquals((Object)"saliencer2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(3)).getStringValue());
        Assert.assertEquals((Object)"f1c1r2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(4)).getStringValue());
        Assert.assertEquals((Object)"f1c2r2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(5)).getStringValue());
        Assert.assertEquals((Object)"f2c1r2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(6)).getStringValue());
        Assert.assertEquals((Object)"f2c2r2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(7)).getStringValue());
        Assert.assertEquals((Object)"a1r2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(8)).getStringValue());
        Assert.assertEquals((Object)"ret1", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(9)).getStringValue());
        Assert.assertEquals((Object)"a3r2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(10)).getStringValue());
        Assert.assertEquals((Object)"a4r2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(11)).getStringValue());
        this.isRowEquivalent((List)tsdt.getData().get(0), expected[0]);
        this.isRowEquivalent((List)tsdt.getData().get(1), expected[1]);
    }

    private void isRowEquivalent(List<DTCellValue52> row, String[] array) {
        Assert.assertEquals((long)row.size(), (long)array.length);
        int newRowNum = (Integer)row.get(0).getNumericValue();
        int oldRowNum = Integer.valueOf(array[0]);
        Assert.assertEquals((long)newRowNum, (long)oldRowNum);
        for (int iCol = 1; iCol < row.size(); ++iCol) {
            DTCellValue52 cell = row.get(iCol);
            String v1 = cell.getStringValue();
            String v2 = array[iCol];
            Assert.assertTrue((boolean)this.isEqualOrNull(v1, v2));
            Assert.assertEquals((Object)v1, (Object)v2);
        }
    }

    @Test
    public void testConversionPatternGrouping2() {
        GuidedDecisionTable dt = new GuidedDecisionTable();
        dt.tableName = "michael";
        ConditionCol con = new ConditionCol();
        con.boundName = "z1";
        con.constraintValueType = 1;
        con.factField = "age";
        con.factType = "Driver";
        con.header = "Driver z1 age";
        con.operator = "==";
        dt.conditionCols.add(con);
        ConditionCol con2 = new ConditionCol();
        con2.boundName = "f1";
        con2.constraintValueType = 1;
        con2.factField = "name";
        con2.factType = "Person";
        con2.header = "Person f1 name";
        con2.operator = "==";
        dt.conditionCols.add(con2);
        ConditionCol con3 = new ConditionCol();
        con3.boundName = "z1";
        con3.constraintValueType = 3;
        con3.factField = "rating";
        con3.factType = "Driver";
        con3.header = "Driver rating";
        con3.operator = "==";
        dt.conditionCols.add(con3);
        ConditionCol con4 = new ConditionCol();
        con4.boundName = "f2";
        con4.constraintValueType = 5;
        con4.factType = "Person2";
        con4.header = "Person2 f2 not needed";
        con4.factField = "(not needed)";
        dt.conditionCols.add(con4);
        dt.data = new String[][]{{"1", "desc", "z1c1r1", "f1c1r1", "z1c2r1", "f2c1r1"}, {"2", "desc", "z1c1r2", "f1c1r2", "z1c2r2", "f2c1r2"}};
        String[][] expected = new String[][]{{"1", "desc", "z1c1r1", "z1c2r1", "f1c1r1", "f2c1r1"}, {"2", "desc", "z1c1r2", "z1c2r2", "f1c1r2", "f2c1r2"}};
        GuidedDecisionTable52 tsdt = this.upgrader.upgrade(dt);
        Assert.assertEquals((Object)"michael", (Object)tsdt.getTableName());
        Assert.assertEquals((long)0L, (long)tsdt.getMetadataCols().size());
        Assert.assertEquals((long)0L, (long)tsdt.getAttributeCols().size());
        Assert.assertEquals((long)3L, (long)tsdt.getConditions().size());
        Assert.assertEquals((Object)"z1", (Object)tsdt.getConditionPattern("z1").getBoundName());
        Assert.assertEquals((Object)"Driver", (Object)tsdt.getConditionPattern("z1").getFactType());
        Assert.assertEquals((Object)"f1", (Object)tsdt.getConditionPattern("f1").getBoundName());
        Assert.assertEquals((Object)"Person", (Object)tsdt.getConditionPattern("f1").getFactType());
        Assert.assertEquals((Object)"f2", (Object)tsdt.getConditionPattern("f2").getBoundName());
        Assert.assertEquals((Object)"Person2", (Object)tsdt.getConditionPattern("f2").getFactType());
        Assert.assertEquals((long)2L, (long)tsdt.getConditionPattern("z1").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)tsdt.getConditionPattern("f1").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)tsdt.getConditionPattern("f2").getChildColumns().size());
        Assert.assertEquals((long)1L, (long)((ConditionCol52)tsdt.getConditionPattern("z1").getChildColumns().get(0)).getConstraintValueType());
        Assert.assertEquals((Object)"age", (Object)((ConditionCol52)tsdt.getConditionPattern("z1").getChildColumns().get(0)).getFactField());
        Assert.assertEquals((Object)"Driver", (Object)tsdt.getPattern((ConditionCol52)tsdt.getConditionPattern("z1").getChildColumns().get(0)).getFactType());
        Assert.assertEquals((Object)"Driver z1 age", (Object)((ConditionCol52)tsdt.getConditionPattern("z1").getChildColumns().get(0)).getHeader());
        Assert.assertEquals((Object)"==", (Object)((ConditionCol52)tsdt.getConditionPattern("z1").getChildColumns().get(0)).getOperator());
        Assert.assertEquals((long)3L, (long)((ConditionCol52)tsdt.getConditionPattern("z1").getChildColumns().get(1)).getConstraintValueType());
        Assert.assertEquals((Object)"rating", (Object)((ConditionCol52)tsdt.getConditionPattern("z1").getChildColumns().get(1)).getFactField());
        Assert.assertEquals((Object)"Driver", (Object)tsdt.getPattern((ConditionCol52)tsdt.getConditionPattern("z1").getChildColumns().get(1)).getFactType());
        Assert.assertEquals((Object)"Driver rating", (Object)((ConditionCol52)tsdt.getConditionPattern("z1").getChildColumns().get(1)).getHeader());
        Assert.assertEquals((Object)"==", (Object)((ConditionCol52)tsdt.getConditionPattern("z1").getChildColumns().get(1)).getOperator());
        Assert.assertEquals((long)1L, (long)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getConstraintValueType());
        Assert.assertEquals((Object)"name", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getFactField());
        Assert.assertEquals((Object)"Person", (Object)tsdt.getPattern((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getFactType());
        Assert.assertEquals((Object)"Person f1 name", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getHeader());
        Assert.assertEquals((Object)"==", (Object)((ConditionCol52)tsdt.getConditionPattern("f1").getChildColumns().get(0)).getOperator());
        Assert.assertEquals((long)5L, (long)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getConstraintValueType());
        Assert.assertEquals((Object)"(not needed)", (Object)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getFactField());
        Assert.assertEquals((Object)"Person2", (Object)tsdt.getPattern((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getFactType());
        Assert.assertEquals((Object)"Person2 f2 not needed", (Object)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getHeader());
        Assert.assertEquals(null, (Object)((ConditionCol52)tsdt.getConditionPattern("f2").getChildColumns().get(0)).getOperator());
        Assert.assertEquals((long)2L, (long)tsdt.getData().size());
        for (int i = 0; i < 2; ++i) {
            System.out.println("Row-" + i);
            StringBuilder sb = new StringBuilder();
            for (DTCellValue52 c : (List)tsdt.getData().get(i)) {
                sb.append(c.getStringValue() + ", ");
            }
            sb.delete(sb.lastIndexOf(","), sb.length());
            System.out.println(sb.toString());
        }
        Assert.assertEquals((Object)new Integer(1), (Object)((Integer)((DTCellValue52)((List)tsdt.getData().get(0)).get(0)).getNumericValue()));
        Assert.assertEquals((Object)"desc", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(1)).getStringValue());
        Assert.assertEquals((Object)"z1c1r1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(2)).getStringValue());
        Assert.assertEquals((Object)"z1c2r1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(3)).getStringValue());
        Assert.assertEquals((Object)"f1c1r1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(4)).getStringValue());
        Assert.assertEquals((Object)"f2c1r1", (Object)((DTCellValue52)((List)tsdt.getData().get(0)).get(5)).getStringValue());
        Assert.assertEquals((Object)new Integer(2), (Object)((Integer)((DTCellValue52)((List)tsdt.getData().get(1)).get(0)).getNumericValue()));
        Assert.assertEquals((Object)"desc", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(1)).getStringValue());
        Assert.assertEquals((Object)"z1c1r2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(2)).getStringValue());
        Assert.assertEquals((Object)"z1c2r2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(3)).getStringValue());
        Assert.assertEquals((Object)"f1c1r2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(4)).getStringValue());
        Assert.assertEquals((Object)"f2c1r2", (Object)((DTCellValue52)((List)tsdt.getData().get(1)).get(5)).getStringValue());
        this.isRowEquivalent((List)tsdt.getData().get(0), expected[0]);
        this.isRowEquivalent((List)tsdt.getData().get(1), expected[1]);
    }

    private boolean isEqualOrNull(Object v1, Object v2) {
        if (v1 == null && v2 == null) {
            return true;
        }
        if (v1 != null && v2 == null) {
            return false;
        }
        if (v1 == null && v2 != null) {
            return false;
        }
        return v1.equals(v2);
    }
}

