/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.brl.DSLSentence;
import org.drools.guvnor.client.modeldriven.ui.DSLSentenceWidget;

public class DSLSentenceWidget
extends Composite {
    private static final String ENUM_TAG = "ENUM";
    private static final String DATE_TAG = "DATE";
    private static final String BOOLEAN_TAG = "BOOLEAN";
    private final List widgets = new ArrayList();
    private final DSLSentence sentence;
    private SuggestionCompletionEngine completions;
    private final VerticalPanel layout;
    private HorizontalPanel currentRow;

    public DSLSentenceWidget(DSLSentence sentence, SuggestionCompletionEngine completions) {
        this.sentence = sentence;
        this.completions = completions;
        this.layout = new VerticalPanel();
        this.currentRow = new HorizontalPanel();
        this.layout.add((Widget)this.currentRow);
        this.layout.setCellWidth((Widget)this.currentRow, "100%");
        this.layout.setWidth("100%");
        this.init();
    }

    private void init() {
        this.makeWidgets(this.sentence.sentence);
        this.initWidget((Widget)this.layout);
    }

    public void makeWidgets(String dslLine) {
        int startVariable = dslLine.indexOf("{");
        ArrayList<Object> lineWidgets = new ArrayList<Object>();
        boolean firstOneIsBracket = dslLine.indexOf("{") == 0;
        String startLabel = "";
        if (startVariable > 0) {
            startLabel = dslLine.substring(0, startVariable);
        } else if (!firstOneIsBracket) {
            startLabel = dslLine;
        }
        Widget label = this.getLabel(startLabel);
        lineWidgets.add(label);
        while (startVariable > 0 || firstOneIsBracket) {
            firstOneIsBracket = false;
            int endVariable = dslLine.indexOf("}", startVariable);
            String string = dslLine.substring(startVariable + 1, endVariable);
            Widget varWidget = this.processVariable(string);
            lineWidgets.add(varWidget);
            startVariable = dslLine.indexOf("{", endVariable);
            String lbl = startVariable > 0 ? dslLine.substring(endVariable + 1, startVariable) : dslLine.substring(endVariable + 1, dslLine.length());
            if (lbl.indexOf("\\n") > -1) {
                String[] lines = lbl.split("\\\\n");
                for (int i = 0; i < lines.length; ++i) {
                    lineWidgets.add(new NewLine(this));
                    lineWidgets.add(this.getLabel(lines[i]));
                }
                continue;
            }
            Widget currLabel = this.getLabel(lbl);
            lineWidgets.add(currLabel);
        }
        for (Widget widget : lineWidgets) {
            this.addWidget(widget);
        }
        this.updateSentence();
    }

    public Widget processVariable(String currVariable) {
        Widget result = null;
        int colonIndex = currVariable.indexOf(":");
        if (colonIndex > 0) {
            String definition = currVariable.substring(colonIndex + 1, currVariable.length());
            int secondColonIndex = definition.indexOf(":");
            if (secondColonIndex > 0) {
                String type = currVariable.substring(colonIndex + 1, colonIndex + secondColonIndex + 1);
                if (type.equalsIgnoreCase(ENUM_TAG)) {
                    result = this.getEnumDropdown(currVariable);
                } else if (type.equalsIgnoreCase(DATE_TAG)) {
                    result = this.getDateSelector(currVariable);
                } else if (type.equalsIgnoreCase(BOOLEAN_TAG)) {
                    result = this.getCheckbox(currVariable);
                }
            } else {
                String regex = currVariable.substring(colonIndex + 1, currVariable.length());
                result = this.getBox(currVariable, regex);
            }
        } else {
            result = this.getBox(currVariable, "");
        }
        return result;
    }

    public Widget getEnumDropdown(String variableDef) {
        DSLDropDown resultWidget = new DSLDropDown(this, variableDef);
        return resultWidget;
    }

    public Widget getBox(String variableDef, String regex) {
        int colonIndex = variableDef.indexOf(":");
        if (colonIndex > 0) {
            variableDef = variableDef.substring(0, colonIndex);
        }
        FieldEditor currentBox = new FieldEditor(this);
        currentBox.setVisibleLength(variableDef.length() + 1);
        currentBox.setText(variableDef);
        currentBox.setRestriction(regex);
        return currentBox;
    }

    public Widget getCheckbox(String variableDef) {
        return new DSLCheckBox(this, variableDef);
    }

    public Widget getDateSelector(String variableDef) {
        return new DSLDateSelector(this, variableDef);
    }

    public Widget getLabel(String labelDef) {
        SmallLabel label = new SmallLabel();
        label.setText(labelDef + " ");
        return label;
    }

    private void addWidget(Widget currentBox) {
        if (currentBox instanceof NewLine) {
            this.currentRow = new HorizontalPanel();
            this.layout.add((Widget)this.currentRow);
            this.layout.setCellWidth((Widget)this.currentRow, "100%");
        } else {
            this.currentRow.add(currentBox);
        }
        this.widgets.add(currentBox);
    }

    protected void updateSentence() {
        String newSentence = "";
        for (Widget wid : this.widgets) {
            if (wid instanceof Label) {
                newSentence = newSentence + ((Label)wid).getText();
                continue;
            }
            if (wid instanceof FieldEditor) {
                FieldEditor editor = (FieldEditor)wid;
                String varString = editor.getText();
                String restriction = editor.getRestriction();
                if (!restriction.equals("")) {
                    varString = varString + ":" + restriction;
                }
                newSentence = newSentence + " {" + varString + "} ";
                continue;
            }
            if (wid instanceof DSLDropDown) {
                DSLDropDown drop = (DSLDropDown)wid;
                ListBox box = drop.getListBox();
                String type = drop.getType();
                String factAndField = drop.getFactAndField();
                newSentence = newSentence + "{" + box.getValue(box.getSelectedIndex()) + ":" + type + ":" + factAndField + "} ";
                continue;
            }
            if (wid instanceof DSLCheckBox) {
                DSLCheckBox check = (DSLCheckBox)wid;
                String checkValue = check.getCheckedValue();
                newSentence = newSentence + "{" + checkValue + ":" + check.getType() + ":" + checkValue + "} ";
                continue;
            }
            if (wid instanceof DSLDateSelector) {
                DSLDateSelector dateSel = (DSLDateSelector)wid;
                String dateString = dateSel.getDateString();
                String format = dateSel.getJavascriptFormat();
                newSentence = newSentence + "{" + dateString + ":" + dateSel.getType() + ":" + format + "} ";
                continue;
            }
            if (!(wid instanceof NewLine)) continue;
            newSentence = newSentence + "\\n";
        }
        this.sentence.sentence = newSentence.trim();
    }

    static /* synthetic */ SuggestionCompletionEngine access$400(DSLSentenceWidget x0) {
        return x0.completions;
    }
}

