/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.PackageHeaderHelper;
import org.drools.guvnor.client.packages.PackageHeaderWidget;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;

public class PackageHeaderWidget
extends Composite {
    private PackageConfigData conf;
    private SimplePanel layout;
    private ListBox importList;
    private ListBox globalList;
    private Constants constants;

    public PackageHeaderWidget(PackageConfigData conf) {
        this.conf = conf;
        this.layout = new SimplePanel();
        this.render();
        this.initWidget((Widget)this.layout);
    }

    private void render() {
        Types t = PackageHeaderHelper.parseHeader((String)this.conf.header);
        if (t == null) {
            this.textEditorVersion();
        } else {
            this.layout.clear();
            HorizontalPanel main = new HorizontalPanel();
            VerticalPanel imports = new VerticalPanel();
            this.constants = (Constants)GWT.create(Constants.class);
            imports.add((Widget)new Label(this.constants.ImportedTypes()));
            this.importList = new ListBox(true);
            this.doImports(t);
            HorizontalPanel importCols = new HorizontalPanel();
            importCols.add((Widget)this.importList);
            VerticalPanel importActions = new VerticalPanel();
            importActions.add((Widget)new /* Unavailable Anonymous Inner Class!! */);
            importActions.add((Widget)new /* Unavailable Anonymous Inner Class!! */);
            importCols.add((Widget)importActions);
            imports.add((Widget)importCols);
            VerticalPanel globals = new VerticalPanel();
            globals.add((Widget)new Label(this.constants.Globals()));
            this.globalList = new ListBox(true);
            this.doGlobals(t);
            HorizontalPanel globalCols = new HorizontalPanel();
            globalCols.add((Widget)this.globalList);
            VerticalPanel globalActions = new VerticalPanel();
            globalActions.add((Widget)new /* Unavailable Anonymous Inner Class!! */);
            globalActions.add((Widget)new /* Unavailable Anonymous Inner Class!! */);
            globalCols.add((Widget)globalActions);
            globals.add((Widget)globalCols);
            main.add((Widget)imports);
            main.add((Widget)new HTML("&nbsp;"));
            main.add((Widget)globals);
            5 advanced = new /* Unavailable Anonymous Inner Class!! */;
            main.add((Widget)advanced);
            this.layout.add((Widget)main);
        }
    }

    private void textEditorVersion() {
        this.layout.clear();
        TextArea area = new TextArea();
        area.setWidth("100%");
        area.setVisibleLines(8);
        area.setCharacterWidth(100);
        area.setText(this.conf.header);
        area.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.layout.add((Widget)area);
    }

    private void showTypeQuestion(Widget w, Types t, boolean global, String headerMessage) {
        FormStylePopup pop = new FormStylePopup("images/home_icon.gif", this.constants.ChooseAFactType());
        pop.addRow((Widget)new HTML("<small><i>" + headerMessage + " </i></small>"));
        ListBox factList = new ListBox();
        factList.addItem(this.constants.loadingList());
        RepositoryServiceFactory.getService().listTypesInPackage(this.conf.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        InfoPopup info = new InfoPopup(this.constants.TypesInThePackage(), this.constants.IfNoTypesTip());
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)factList);
        h.add((Widget)info);
        pop.addAttribute(this.constants.ChooseClassType(), (Widget)h);
        TextBox globalName = new TextBox();
        if (global) {
            pop.addAttribute(this.constants.GlobalName(), (Widget)globalName);
        }
        TextBox className = new TextBox();
        InfoPopup infoClass = new InfoPopup(this.constants.EnteringATypeClassName(), this.constants.EnterTypeNameTip());
        h = new HorizontalPanel();
        h.add((Widget)className);
        h.add((Widget)infoClass);
        pop.addAttribute(this.constants.advancedClassName(), (Widget)h);
        8 ok = new /* Unavailable Anonymous Inner Class!! */;
        pop.addAttribute("", (Widget)ok);
        pop.show();
    }

    private void updateHeader(Types t) {
        this.conf.header = PackageHeaderHelper.renderTypes((Types)t);
    }

    private void doGlobals(Types t) {
        this.globalList.clear();
        for (Global g : t.globals) {
            this.globalList.addItem(g.type + " [" + g.name + "]");
        }
    }

    private void doImports(Types t) {
        this.importList.clear();
        for (Import i : t.imports) {
            this.importList.addItem(i.type);
        }
    }

    static /* synthetic */ Constants access$000(PackageHeaderWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ void access$100(PackageHeaderWidget x0, Widget x1, Types x2, boolean x3, String x4) {
        x0.showTypeQuestion(x1, x2, x3, x4);
    }

    static /* synthetic */ ListBox access$200(PackageHeaderWidget x0) {
        return x0.importList;
    }

    static /* synthetic */ void access$300(PackageHeaderWidget x0, Types x1) {
        x0.updateHeader(x1);
    }

    static /* synthetic */ ListBox access$400(PackageHeaderWidget x0) {
        return x0.globalList;
    }

    static /* synthetic */ void access$500(PackageHeaderWidget x0) {
        x0.textEditorVersion();
    }

    static /* synthetic */ PackageConfigData access$600(PackageHeaderWidget x0) {
        return x0.conf;
    }

    static /* synthetic */ void access$700(PackageHeaderWidget x0, Types x1) {
        x0.doImports(x1);
    }

    static /* synthetic */ void access$800(PackageHeaderWidget x0, Types x1) {
        x0.doGlobals(x1);
    }
}

