/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.Collection;
import org.drools.definition.process.Node;
import org.drools.guvnor.client.rulefloweditor.ElementContainerTransferNode;
import org.drools.guvnor.client.rulefloweditor.HumanTaskTransferNode;
import org.drools.guvnor.client.rulefloweditor.SplitNode;
import org.drools.guvnor.client.rulefloweditor.SplitTransferNode;
import org.drools.guvnor.client.rulefloweditor.TransferNode;
import org.drools.guvnor.client.rulefloweditor.WorkItemTransferNode;
import org.drools.process.core.Work;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.workflow.core.Constraint;
import org.drools.workflow.core.node.CompositeNode;
import org.drools.workflow.core.node.ForEachNode;
import org.drools.workflow.core.node.HumanTaskNode;
import org.drools.workflow.core.node.Split;
import org.drools.workflow.core.node.WorkItemNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class RuleFlowProcessBuilder {
    public static void updateProcess(RuleFlowProcess process, Collection<TransferNode> contentNodes) {
        for (TransferNode tn : contentNodes) {
            Node node = process.getNode(tn.getId());
            RuleFlowProcessBuilder.updateNode((TransferNode)tn, (Node)node);
        }
    }

    private static void updateNode(TransferNode tn, Node node) {
        if (tn instanceof HumanTaskTransferNode) {
            RuleFlowProcessBuilder.updateHumanTask((HumanTaskTransferNode)((HumanTaskTransferNode)tn), (HumanTaskNode)((HumanTaskNode)node));
        } else if (tn instanceof WorkItemTransferNode) {
            RuleFlowProcessBuilder.updateWorkItem((WorkItemTransferNode)((WorkItemTransferNode)tn), (WorkItemNode)((WorkItemNode)node));
        } else if (tn instanceof SplitTransferNode) {
            RuleFlowProcessBuilder.updateSplitNode((SplitTransferNode)((SplitTransferNode)tn), (Split)((Split)node));
        } else if (tn instanceof ElementContainerTransferNode) {
            if (tn.getType() == TransferNode.Type.FOR_EACH) {
                RuleFlowProcessBuilder.updateForEach((ElementContainerTransferNode)((ElementContainerTransferNode)tn), (ForEachNode)((ForEachNode)node));
            } else if (tn.getType() == TransferNode.Type.COMPOSITE) {
                RuleFlowProcessBuilder.updateComposite((ElementContainerTransferNode)((ElementContainerTransferNode)tn), (CompositeNode)((CompositeNode)node));
            }
        }
    }

    private static void updateHumanTask(HumanTaskTransferNode httn, HumanTaskNode humanTaskNode) {
        Work work = humanTaskNode.getWork();
        if (work != null) {
            for (String key : work.getParameters().keySet()) {
                work.setParameter(key, httn.getParameters().get(key));
            }
        }
    }

    private static void updateWorkItem(WorkItemTransferNode witn, WorkItemNode workItemNode) {
        Work work = workItemNode.getWork();
        if (work != null) {
            for (String key : work.getParameters().keySet()) {
                work.setParameter(key, witn.getParameters().get(key));
            }
        }
    }

    private static void updateSplitNode(SplitTransferNode stn, Split splitNode) {
        for (Split.ConnectionRef connection : splitNode.getConstraints().keySet()) {
            Split.ConnectionRef ref1 = new Split.ConnectionRef(connection.getNodeId(), connection.getToType());
            SplitNode.ConnectionRef ref2 = new SplitNode.ConnectionRef();
            ref2.setNodeId(connection.getNodeId());
            ref2.setToType(connection.getToType());
            Constraint c1 = splitNode.internalGetConstraint(ref1);
            SplitNode.Constraint c2 = (SplitNode.Constraint)stn.getConstraints().get(ref2);
            RuleFlowProcessBuilder.updateConstraint((Constraint)c1, (SplitNode.Constraint)c2);
        }
    }

    private static void updateForEach(ElementContainerTransferNode tn, ForEachNode foreachNode) {
        for (TransferNode subTn : tn.getContentModel().getNodes()) {
            Node subNode = foreachNode.getNode(subTn.getId());
            RuleFlowProcessBuilder.updateNode((TransferNode)subTn, (Node)subNode);
        }
    }

    private static void updateComposite(ElementContainerTransferNode tn, CompositeNode compositeNode) {
        for (TransferNode subTn : tn.getContentModel().getNodes()) {
            Node subNode = compositeNode.getNode(subTn.getId());
            RuleFlowProcessBuilder.updateNode((TransferNode)subTn, (Node)subNode);
        }
    }

    private static void updateConstraint(Constraint to, SplitNode.Constraint from) {
        to.setConstraint(from.getConstraint());
        to.setDialect(from.getDialect());
        to.setName(from.getName());
        to.setPriority(from.getPriority());
        to.setType(from.getType());
    }
}

