/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.files;

import com.google.gwt.user.client.rpc.SerializableException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.client.rpc.BulkTestRunResult;
import org.drools.guvnor.client.rpc.DetailedSerializableException;
import org.drools.guvnor.server.RepositoryServiceServlet;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.files.FileManagerUtils;
import org.drools.guvnor.server.files.PackageDeploymentURIHelper;
import org.drools.guvnor.server.files.RepositoryServlet;
import org.drools.guvnor.server.util.FormData;
import org.drools.repository.PackageItem;
import org.drools.repository.RulesRepositoryException;

public class PackageDeploymentServlet
extends RepositoryServlet {
    private static final long serialVersionUID = 400L;

    protected void doHead(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getMethod().equals("HEAD")) {
            PackageDeploymentURIHelper helper = new PackageDeploymentURIHelper(request.getRequestURI());
            FileManagerUtils fm = this.getFileManager();
            long mod = fm.getLastModified(helper.getPackageName(), helper.getVersion());
            response.addHeader("lastModified", "" + mod);
        } else {
            super.doHead(request, response);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType("text/html");
        FormData data = FileManagerUtils.getFormData((HttpServletRequest)request);
        try {
            this.getFileManager().importClassicDRL(data.getFile().getInputStream());
            response.getWriter().write("OK");
        }
        catch (DroolsParserException e) {
            response.getWriter().write("Unable to process import: " + e.getMessage());
        }
        catch (RulesRepositoryException e) {
            response.getWriter().write("Unable to process import: " + e.getMessage());
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse response) throws ServletException, IOException {
        PackageDeploymentURIHelper helper = new PackageDeploymentURIHelper(req.getRequestURI());
        System.out.println("PackageName: " + helper.getPackageName());
        System.out.println("PackageVersion: " + helper.getVersion());
        System.out.println("PackageIsLatest: " + helper.isLatest());
        System.out.println("PackageIsSource: " + helper.isSource());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        FileManagerUtils fm = this.getFileManager();
        String fileName = null;
        if (helper.isSource()) {
            fileName = helper.isAsset() ? fm.loadSourceAsset(helper.getPackageName(), helper.getVersion(), helper.isLatest(), helper.getAssetName(), out) : fm.loadSourcePackage(helper.getPackageName(), helper.getVersion(), helper.isLatest(), (OutputStream)out);
        } else if (req.getRequestURI().endsWith("SCENARIOS")) {
            this.doRunScenarios(helper, out);
        } else {
            fileName = fm.loadBinaryPackage(helper.getPackageName(), helper.getVersion(), helper.isLatest(), (OutputStream)out);
        }
        response.setContentType("application/x-download");
        response.setHeader("Content-Disposition", "attachment; filename=" + fileName + ";");
        response.setContentLength(out.size());
        response.getOutputStream().write(out.toByteArray());
        response.getOutputStream().flush();
    }

    private void doRunScenarios(PackageDeploymentURIHelper helper, ByteArrayOutputStream out) throws IOException {
        ServiceImplementation serv = RepositoryServiceServlet.getService();
        PackageItem pkg = helper.isLatest() ? serv.repository.loadPackage(helper.getPackageName()) : serv.repository.loadPackageSnapshot(helper.getPackageName(), helper.getVersion());
        try {
            BulkTestRunResult result = serv.runScenariosInPackage(pkg);
            out.write(result.toString().getBytes());
        }
        catch (DetailedSerializableException e) {
            log.error((Object)e);
            out.write(e.getMessage().getBytes());
        }
        catch (SerializableException e) {
            log.error((Object)e);
            out.write(e.getMessage().getBytes());
        }
    }
}

