/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.packages;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextArea;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.packages.PackageHeaderHelper;
import org.drools.guvnor.client.packages.PackageHeaderWidget;
import org.drools.guvnor.client.rpc.PackageConfigData;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;

public class PackageHeaderWidget
extends Composite {
    private PackageConfigData conf;
    private SimplePanel layout;
    private ListBox importList;
    private ListBox globalList;

    public PackageHeaderWidget(PackageConfigData conf) {
        this.conf = conf;
        this.layout = new SimplePanel();
        this.render();
        this.initWidget((Widget)this.layout);
    }

    private void render() {
        Types t = PackageHeaderHelper.parseHeader((String)this.conf.header);
        if (t == null) {
            this.textEditorVersion();
        } else {
            this.layout.clear();
            HorizontalPanel main = new HorizontalPanel();
            VerticalPanel imports = new VerticalPanel();
            imports.add((Widget)new Label("Imported types"));
            this.importList = new ListBox(true);
            this.doImports(t);
            HorizontalPanel importCols = new HorizontalPanel();
            importCols.add((Widget)this.importList);
            VerticalPanel importActions = new VerticalPanel();
            importActions.add((Widget)new /* Unavailable Anonymous Inner Class!! */);
            importActions.add((Widget)new /* Unavailable Anonymous Inner Class!! */);
            importCols.add((Widget)importActions);
            imports.add((Widget)importCols);
            VerticalPanel globals = new VerticalPanel();
            globals.add((Widget)new Label("Globals"));
            this.globalList = new ListBox(true);
            this.doGlobals(t);
            HorizontalPanel globalCols = new HorizontalPanel();
            globalCols.add((Widget)this.globalList);
            VerticalPanel globalActions = new VerticalPanel();
            globalActions.add((Widget)new /* Unavailable Anonymous Inner Class!! */);
            globalActions.add((Widget)new /* Unavailable Anonymous Inner Class!! */);
            globalCols.add((Widget)globalActions);
            globals.add((Widget)globalCols);
            main.add((Widget)imports);
            main.add((Widget)new HTML("&nbsp;"));
            main.add((Widget)globals);
            5 advanced = new /* Unavailable Anonymous Inner Class!! */;
            main.add((Widget)advanced);
            this.layout.add((Widget)main);
        }
    }

    private void textEditorVersion() {
        this.layout.clear();
        TextArea area = new TextArea();
        area.setWidth("100%");
        area.setVisibleLines(8);
        area.setCharacterWidth(100);
        area.setText(this.conf.header);
        area.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        this.layout.add((Widget)area);
    }

    private void showTypeQuestion(Widget w, Types t, boolean global, String headerMessage) {
        FormStylePopup pop = new FormStylePopup("images/home_icon.gif", "Choose a fact type");
        pop.addRow((Widget)new HTML("<small><i>" + headerMessage + " </i></small>"));
        ListBox factList = new ListBox();
        factList.addItem("loading list ....");
        RepositoryServiceFactory.getService().listTypesInPackage(this.conf.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        InfoPopup info = new InfoPopup("Types in the package", "If no types appear in the list, create a model asset, and upload a jar file to it for this package. The jar file should contain the .class files for the types needed by the rules only.");
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)factList);
        h.add((Widget)info);
        pop.addAttribute("Choose class type:", (Widget)h);
        TextBox globalName = new TextBox();
        if (global) {
            pop.addAttribute("Global name:", (Widget)globalName);
        }
        TextBox className = new TextBox();
        InfoPopup infoClass = new InfoPopup("Entering a type class name", "You should only need to do this if a fact class is on the BRMS classpath itself. Otherwise it should be in the list above.");
        h = new HorizontalPanel();
        h.add((Widget)className);
        h.add((Widget)infoClass);
        pop.addAttribute("(advanced) class name:", (Widget)h);
        8 ok = new /* Unavailable Anonymous Inner Class!! */;
        pop.addAttribute("", (Widget)ok);
        pop.show();
    }

    private void updateHeader(Types t) {
        this.conf.header = PackageHeaderHelper.renderTypes((Types)t);
    }

    private void doGlobals(Types t) {
        this.globalList.clear();
        for (Global g : t.globals) {
            this.globalList.addItem(g.type + " [" + g.name + "]");
        }
    }

    private void doImports(Types t) {
        this.importList.clear();
        for (Import i : t.imports) {
            this.importList.addItem(i.type);
        }
    }

    static /* synthetic */ void access$000(PackageHeaderWidget x0, Widget x1, Types x2, boolean x3, String x4) {
        x0.showTypeQuestion(x1, x2, x3, x4);
    }

    static /* synthetic */ ListBox access$100(PackageHeaderWidget x0) {
        return x0.importList;
    }

    static /* synthetic */ void access$200(PackageHeaderWidget x0, Types x1) {
        x0.updateHeader(x1);
    }

    static /* synthetic */ ListBox access$300(PackageHeaderWidget x0) {
        return x0.globalList;
    }

    static /* synthetic */ void access$400(PackageHeaderWidget x0) {
        x0.textEditorVersion();
    }

    static /* synthetic */ PackageConfigData access$500(PackageHeaderWidget x0) {
        return x0.conf;
    }

    static /* synthetic */ void access$600(PackageHeaderWidget x0, Types x1) {
        x0.doImports(x1);
    }

    static /* synthetic */ void access$700(PackageHeaderWidget x0, Types x1) {
        x0.doGlobals(x1);
    }
}

