/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa;

import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.modeldriven.DropDownData;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.testing.ExecutionTrace;
import org.drools.guvnor.client.modeldriven.testing.Fixture;
import org.drools.guvnor.client.modeldriven.testing.Scenario;
import org.drools.guvnor.client.modeldriven.testing.VerifyFact;
import org.drools.guvnor.client.modeldriven.testing.VerifyRuleFired;
import org.drools.guvnor.client.modeldriven.ui.ActionValueEditor;
import org.drools.guvnor.client.modeldriven.ui.ConstraintValueEditor;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.qa.ConfigWidget;
import org.drools.guvnor.client.qa.DataInputWidget;
import org.drools.guvnor.client.qa.ExecutionWidget;
import org.drools.guvnor.client.qa.RetractWidget;
import org.drools.guvnor.client.qa.RuleSelectionEvent;
import org.drools.guvnor.client.qa.ScenarioHelper;
import org.drools.guvnor.client.qa.TestRunnerWidget;
import org.drools.guvnor.client.qa.VerifyFactWidget;
import org.drools.guvnor.client.qa.VerifyRulesFiredWidget;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.RuleViewer;

/*
 * Exception performing whole class analysis ignored.
 */
public class ScenarioWidget
extends Composite {
    private ListBox availableRules;
    private SuggestionCompletionEngine sce;
    private ChangeListener ruleSelectionCL;
    RuleAsset asset;
    VerticalPanel layout;
    boolean showResults;

    public ScenarioWidget(RuleAsset asset, RuleViewer viewer) {
        this(asset);
    }

    public ScenarioWidget(RuleAsset asset) {
        this.asset = asset;
        this.layout = new VerticalPanel();
        this.showResults = false;
        this.sce = SuggestionCompletionCache.getInstance().getEngineFromCache(asset.metaData.packageName);
        Scenario scenario = (Scenario)asset.content;
        if (scenario.fixtures.size() == 0) {
            scenario.fixtures.add(new ExecutionTrace());
        }
        if (!asset.isreadonly) {
            this.layout.add((Widget)new TestRunnerWidget(this, asset.metaData.packageName));
        }
        this.renderEditor();
        this.initWidget((Widget)this.layout);
        this.setStyleName("scenario-Viewer");
        this.layout.setWidth("100%");
    }

    void renderEditor() {
        if (this.layout.getWidgetCount() == 2) {
            this.layout.remove(1);
        }
        Scenario scenario = (Scenario)this.asset.content;
        DirtyableFlexTable editorLayout = new DirtyableFlexTable();
        editorLayout.clear();
        editorLayout.setWidth("100%");
        editorLayout.setStyleName("model-builder-Background");
        this.layout.add((Widget)editorLayout);
        ScenarioHelper hlp = new ScenarioHelper();
        List fixtures = hlp.lumpyMap(scenario.fixtures);
        int layoutRow = 1;
        ExecutionTrace previousEx = null;
        for (int i = 0; i < fixtures.size(); ++i) {
            HorizontalPanel h;
            Object f = fixtures.get(i);
            if (f instanceof ExecutionTrace) {
                previousEx = (ExecutionTrace)f;
                h = new HorizontalPanel();
                h.add(this.getNewExpectationButton(previousEx, scenario));
                h.add((Widget)new SmallLabel("EXPECT"));
                editorLayout.setWidget(layoutRow, 0, (Widget)h);
                ExecutionTrace et = previousEx;
                ImageButton del = new ImageButton("images/delete_item_small.gif", "Delete item.", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                h.add((Widget)del);
                editorLayout.setWidget(layoutRow, 1, (Widget)new ExecutionWidget(previousEx, this.showResults));
                editorLayout.getFlexCellFormatter().setHorizontalAlignment(layoutRow, 2, HasHorizontalAlignment.ALIGN_LEFT);
            } else if (f instanceof Map) {
                h = new HorizontalPanel();
                h.add(this.getNewDataButton(previousEx, scenario));
                h.add((Widget)new SmallLabel("GIVEN"));
                editorLayout.setWidget(layoutRow, 0, (Widget)h);
                ++layoutRow;
                Map facts = (Map)f;
                VerticalPanel vert = new VerticalPanel();
                for (Map.Entry e : facts.entrySet()) {
                    List factList = (List)facts.get(e.getKey());
                    if (e.getKey().equals("retract")) {
                        vert.add((Widget)new RetractWidget(factList, scenario));
                        continue;
                    }
                    vert.add((Widget)new DataInputWidget((String)e.getKey(), factList, false, scenario, this.sce, this));
                }
                if (facts.size() > 0) {
                    editorLayout.setWidget(layoutRow, 1, (Widget)vert);
                } else {
                    editorLayout.setWidget(layoutRow, 1, (Widget)new HTML("<i><small>Add input data and expectations here.</small></i>"));
                }
            } else {
                List l = (List)f;
                Fixture first = (Fixture)l.get(0);
                if (first instanceof VerifyFact) {
                    this.doVerifyFacts(l, (FlexTable)editorLayout, layoutRow, scenario);
                } else if (first instanceof VerifyRuleFired) {
                    editorLayout.setWidget(layoutRow, 1, (Widget)new VerifyRulesFiredWidget(l, scenario, this.showResults));
                }
            }
            ++layoutRow;
        }
        Button addExecute = new Button("More...");
        addExecute.setTitle("Add another section of data and expectations.");
        addExecute.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        editorLayout.setWidget(layoutRow, 0, (Widget)addExecute);
        editorLayout.setWidget(++layoutRow, 0, (Widget)new SmallLabel("(configuration)"));
        ConfigWidget conf = new ConfigWidget(scenario, this.asset.metaData.packageName, this);
        editorLayout.setWidget(layoutRow, 1, (Widget)conf);
        ++layoutRow;
        Map globals = hlp.lumpyMapGlobals(scenario.globals);
        VerticalPanel globalPanel = new VerticalPanel();
        for (Map.Entry e : globals.entrySet()) {
            globalPanel.add((Widget)new DataInputWidget((String)e.getKey(), (List)globals.get(e.getKey()), true, scenario, this.sce, this));
        }
        HorizontalPanel h = new HorizontalPanel();
        h.add(this.getNewGlobalButton(scenario));
        h.add((Widget)new SmallLabel("(globals)"));
        editorLayout.setWidget(layoutRow, 0, (Widget)h);
        editorLayout.setWidget(layoutRow, 1, (Widget)globalPanel);
    }

    private Widget getNewGlobalButton(Scenario scenario) {
        ImageButton newItem = new ImageButton("images/new_item.gif", "Add a new global to this scenario.", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return newItem;
    }

    private Widget getNewDataButton(ExecutionTrace previousEx, Scenario scenario) {
        ImageButton newItem = new ImageButton("images/new_item.gif", "Add a new data input to this scenario.", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return newItem;
    }

    private Widget getNewExpectationButton(ExecutionTrace ex, Scenario sc) {
        ImageButton add = new ImageButton("images/new_item.gif", "Add a new expectation.", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return add;
    }

    private void doVerifyFacts(List l, FlexTable layout, int layoutRow, Scenario scenario) {
        VerticalPanel vert = new VerticalPanel();
        for (VerifyFact f : l) {
            HorizontalPanel h = new HorizontalPanel();
            h.add((Widget)new VerifyFactWidget(f, scenario, this.sce, this.showResults));
            ImageButton del = new ImageButton("images/delete_item_small.gif", "Delete the expectation for this fact.", (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            h.add((Widget)del);
            vert.add((Widget)h);
        }
        layout.setWidget(layoutRow, 1, (Widget)vert);
    }

    public Widget getRuleSelectionWidget(String packageName, RuleSelectionEvent selected) {
        HorizontalPanel h = new HorizontalPanel();
        TextBox t = new TextBox();
        t.setTitle("Enter name of rule, or pick from a list. If there are a very large number of rules, you will need to type in the name.");
        h.add((Widget)t);
        if (this.availableRules != null) {
            this.availableRules.setSelectedIndex(0);
            this.availableRules.removeChangeListener(this.ruleSelectionCL);
            this.ruleSelectionCL = new /* Unavailable Anonymous Inner Class!! */;
            this.availableRules.addChangeListener(this.ruleSelectionCL);
            h.add((Widget)this.availableRules);
        } else {
            Button showList = new Button("(show list)");
            h.add((Widget)showList);
            showList.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        Button ok = new Button("OK");
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        h.add((Widget)ok);
        return h;
    }

    public static Widget editableCell(ValueChanged changeEvent, String factType, String fieldName, String initialValue, SuggestionCompletionEngine sce) {
        String key = factType + "." + fieldName;
        String flType = (String)sce.fieldTypes.get(key);
        if (flType.equals("Numeric")) {
            TextBox box = ScenarioWidget.editableTextBox((ValueChanged)changeEvent, (String)fieldName, (String)initialValue);
            box.addKeyboardListener(ActionValueEditor.getNumericFilter((TextBox)box));
            return box;
        }
        if (flType.equals("Boolean")) {
            String[] c = new String[]{"true", "false"};
            return ConstraintValueEditor.enumDropDown((String)initialValue, (ValueChanged)changeEvent, (DropDownData)DropDownData.create((String[])c));
        }
        String[] enums = (String[])sce.dataEnumLists.get(key);
        if (enums != null) {
            return ConstraintValueEditor.enumDropDown((String)initialValue, (ValueChanged)changeEvent, (DropDownData)DropDownData.create((String[])enums));
        }
        return ScenarioWidget.editableTextBox((ValueChanged)changeEvent, (String)fieldName, (String)initialValue);
    }

    private static TextBox editableTextBox(ValueChanged changed, String fieldName, String initialValue) {
        TextBox tb = new TextBox();
        tb.setText(initialValue);
        tb.setTitle("Value for: " + fieldName);
        tb.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return tb;
    }

    public static Widget getBar(String colour, int width, float percent) {
        int pixels = (int)((float)width * (percent / 100.0f));
        String h = "<div class=\"smallish-progress-wrapper\" style=\"width: " + width + "px\">" + "<div class=\"smallish-progress-bar\" style=\"width: " + pixels + "px; background-color: " + colour + ";\"></div>" + "<div class=\"smallish-progress-text\" style=\"width: " + width + "px\">" + (int)percent + "%</div></div>";
        return new HTML(h);
    }

    public static Widget getBar(String colour, int width, int numerator, int denominator) {
        int percent = 0;
        if (denominator != 0) {
            percent = (int)(((float)denominator - (float)numerator) / (float)denominator * 100.0f);
        }
        return ScenarioWidget.getBar((String)colour, (int)width, (float)percent);
    }

    static /* synthetic */ SuggestionCompletionEngine access$000(ScenarioWidget x0) {
        return x0.sce;
    }

    static /* synthetic */ ListBox access$100(ScenarioWidget x0) {
        return x0.availableRules;
    }

    static /* synthetic */ ListBox access$102(ScenarioWidget x0, ListBox x1) {
        x0.availableRules = x1;
        return x0.availableRules;
    }

    static /* synthetic */ ChangeListener access$202(ScenarioWidget x0, ChangeListener x1) {
        x0.ruleSelectionCL = x1;
        return x0.ruleSelectionCL;
    }

    static /* synthetic */ ChangeListener access$200(ScenarioWidget x0) {
        return x0.ruleSelectionCL;
    }
}

