/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListener;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.packages.PackageBuilderWidget;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.SaveEventListener;

public class RuleValidatorWrapper
extends DirtyableComposite
implements SaveEventListener {
    private RuleAsset asset;
    private VerticalPanel layout = new VerticalPanel();
    private Widget editor;

    public RuleValidatorWrapper(Widget editor, RuleAsset asset) {
        this.asset = asset;
        this.editor = editor;
        this.layout.add(editor);
        if (!asset.isreadonly) {
            this.validatorActions();
        }
        this.layout.setWidth("100%");
        this.layout.setHeight("100%");
        this.initWidget((Widget)this.layout);
    }

    private void validatorActions() {
        Toolbar tb = new Toolbar();
        this.layout.setCellHeight(this.editor, "95%");
        this.layout.add((Widget)tb);
        ToolbarButton viewSource = new ToolbarButton();
        viewSource.setText("View source");
        viewSource.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        tb.addButton(viewSource);
        tb.addSeparator();
        ToolbarButton validate = new ToolbarButton();
        validate.setText("Validate");
        validate.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        tb.addButton(validate);
    }

    private void doValidate() {
        this.onSave();
        LoadingPopup.showMessage((String)"Validating item, please wait...");
        RepositoryServiceFactory.getService().buildAsset(this.asset, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doViewsource() {
        this.onSave();
        LoadingPopup.showMessage((String)"Calculating source...");
        RepositoryServiceFactory.getService().buildAssetSource(this.asset, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showSource(String src) {
        PackageBuilderWidget.showSource((String)src, (String)this.asset.metaData.name);
        LoadingPopup.close();
    }

    public static void showBuilderErrors(BuilderResult[] results) {
        if (results == null || results.length == 0) {
            FormStylePopup pop = new FormStylePopup();
            pop.setWidth(200);
            pop.setTitle("Validation results...");
            HorizontalPanel h = new HorizontalPanel();
            h.add((Widget)new SmallLabel("<img src='images/tick_green.gif'/><i>Item validated successfully.</i>"));
            pop.addRow((Widget)h);
            pop.show();
        } else {
            FormStylePopup pop = new FormStylePopup("images/package_builder.png", "Validation results");
            FlexTable errTable = new FlexTable();
            errTable.setStyleName("build-Results");
            for (int i = 0; i < results.length; ++i) {
                int row = i;
                BuilderResult res = results[i];
                errTable.setWidget(row, 0, (Widget)new Image("images/error.gif"));
                if (res.assetFormat.equals("package")) {
                    errTable.setText(row, 1, "[package configuration problem] " + res.message);
                    continue;
                }
                errTable.setText(row, 1, "[" + res.assetName + "] " + res.message);
            }
            ScrollPanel scroll = new ScrollPanel((Widget)errTable);
            scroll.setWidth("100%");
            pop.addRow((Widget)scroll);
            pop.show();
        }
        LoadingPopup.close();
    }

    public void onSave() {
        if (this.editor instanceof SaveEventListener) {
            SaveEventListener el = (SaveEventListener)this.editor;
            el.onSave();
        }
    }

    public void onAfterSave() {
        if (this.editor instanceof SaveEventListener) {
            SaveEventListener el = (SaveEventListener)this.editor;
            el.onAfterSave();
        }
    }

    static /* synthetic */ void access$000(RuleValidatorWrapper x0) {
        x0.doViewsource();
    }

    static /* synthetic */ void access$100(RuleValidatorWrapper x0) {
        x0.doValidate();
    }

    static /* synthetic */ void access$200(RuleValidatorWrapper x0, String x1) {
        x0.showSource(x1);
    }
}

