/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.AssetFormats;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.ActionToolbar;
import org.drools.guvnor.client.ruleeditor.EditorLauncher;
import org.drools.guvnor.client.ruleeditor.MetaDataWidget;
import org.drools.guvnor.client.ruleeditor.RuleDocumentWidget;

public class RuleViewer
extends Composite {
    private Command closeCommand;
    protected RuleAsset asset;
    private boolean readOnly;
    private MetaDataWidget metaWidget;
    private RuleDocumentWidget doco;
    private Widget editor;
    private ActionToolbar toolbar;
    private VerticalPanel layout;
    private HorizontalPanel hsp;
    private long lastSaved = System.currentTimeMillis();

    public RuleViewer(RuleAsset asset) {
        this(asset, false);
    }

    public RuleViewer(RuleAsset asset, boolean historicalReadOnly) {
        this.asset = asset;
        this.readOnly = historicalReadOnly && asset.isreadonly;
        this.layout = new VerticalPanel();
        this.layout.setWidth("100%");
        this.layout.setHeight("100%");
        this.initWidget((Widget)this.layout);
        this.doWidgets();
        LoadingPopup.close();
    }

    public boolean isDirty() {
        if (this.readOnly) {
            return false;
        }
        return System.currentTimeMillis() - this.lastSaved > 3600000L;
    }

    private void doWidgets() {
        this.layout.clear();
        this.editor = EditorLauncher.getEditorViewer((RuleAsset)this.asset, (RuleViewer)this);
        this.toolbar = new ActionToolbar(this.asset, (ActionToolbar.CheckinAction)new /* Unavailable Anonymous Inner Class!! */, (ActionToolbar.CheckinAction)new /* Unavailable Anonymous Inner Class!! */, (Command)new /* Unavailable Anonymous Inner Class!! */, this.readOnly);
        this.layout.add((Widget)this.toolbar);
        this.layout.setCellHeight((Widget)this.toolbar, "30px");
        this.layout.setCellHorizontalAlignment((Widget)this.toolbar, HasHorizontalAlignment.ALIGN_LEFT);
        this.layout.setCellWidth((Widget)this.toolbar, "100%");
        this.doMetaWidget();
        this.hsp = new HorizontalPanel();
        this.layout.add((Widget)this.hsp);
        this.doco = new RuleDocumentWidget(this.asset.metaData);
        VerticalPanel vert = new VerticalPanel();
        vert.add(this.editor);
        this.editor.setHeight("100%");
        vert.add((Widget)this.doco);
        vert.setWidth("100%");
        vert.setHeight("100%");
        this.hsp.add((Widget)vert);
        this.hsp.add((Widget)this.metaWidget);
        this.hsp.setCellWidth((Widget)this.metaWidget, "25%");
        this.hsp.setHeight("100%");
    }

    private void doMetaWidget() {
        this.metaWidget = new MetaDataWidget(this.asset.metaData, this.readOnly, this.asset.uuid, (Command)new /* Unavailable Anonymous Inner Class!! */);
    }

    protected boolean hasDirty() {
        return false;
    }

    void doDelete() {
        RepositoryServiceFactory.getService().deleteUncheckedRule(this.asset.uuid, this.asset.metaData.packageName, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doArchive(String comment) {
        this.asset.archived = true;
        this.performCheckIn(comment);
        this.closeCommand.execute();
    }

    private void performCheckIn(String comment) {
        this.asset.metaData.checkinComment = comment;
        LoadingPopup.showMessage((String)"Saving, please wait...");
        RepositoryServiceFactory.getService().checkinVersion(this.asset, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void flushSuggestionCompletionCache() {
        if (AssetFormats.isPackageDependency((String)this.asset.metaData.format)) {
            LoadingPopup.showMessage((String)"Refreshing content assistance...");
            SuggestionCompletionCache.getInstance().refreshPackage(this.asset.metaData.packageName, (Command)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void refreshDataAndView() {
        LoadingPopup.showMessage((String)"Refreshing item...");
        RepositoryServiceFactory.getService().loadRuleAsset(this.asset.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void refreshMetaWidgetOnly() {
        LoadingPopup.showMessage((String)"Refreshing item...");
        RepositoryServiceFactory.getService().loadRuleAsset(this.asset.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setCloseCommand(Command c) {
        this.closeCommand = c;
    }

    protected void doCloseUnsavedWarning() {
        FormStylePopup pop = new FormStylePopup("images/warning-large.png", "WARNING: Un-committed changes.");
        Button dis = new Button("Discard");
        Button can = new Button("Cancel");
        HorizontalPanel hor = new HorizontalPanel();
        hor.add((Widget)dis);
        hor.add((Widget)can);
        pop.addRow((Widget)new HTML("Are you sure you want to discard changes?"));
        pop.addRow((Widget)hor);
        dis.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        can.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    static /* synthetic */ Widget access$000(RuleViewer x0) {
        return x0.editor;
    }

    static /* synthetic */ void access$100(RuleViewer x0, String x1) {
        x0.performCheckIn(x1);
    }

    static /* synthetic */ long access$202(RuleViewer x0, long x1) {
        x0.lastSaved = x1;
        return x0.lastSaved;
    }

    static /* synthetic */ void access$300(RuleViewer x0, String x1) {
        x0.doArchive(x1);
    }

    static /* synthetic */ Command access$400(RuleViewer x0) {
        return x0.closeCommand;
    }

    static /* synthetic */ RuleDocumentWidget access$500(RuleViewer x0) {
        return x0.doco;
    }

    static /* synthetic */ void access$600(RuleViewer x0) {
        x0.doWidgets();
    }

    static /* synthetic */ MetaDataWidget access$700(RuleViewer x0) {
        return x0.metaWidget;
    }

    static /* synthetic */ HorizontalPanel access$800(RuleViewer x0) {
        return x0.hsp;
    }

    static /* synthetic */ void access$900(RuleViewer x0) {
        x0.doMetaWidget();
    }
}

