/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server;

import com.google.gwt.user.server.rpc.RemoteServiceServlet;
import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import org.drools.guvnor.client.rpc.SecurityService;
import org.drools.guvnor.client.rpc.UserSecurityContext;
import org.drools.guvnor.client.security.Capabilities;
import org.drools.guvnor.server.security.SecurityServiceImpl;
import org.drools.guvnor.server.util.LoggingHelper;
import org.jboss.seam.security.AuthorizationException;

public class SecurityServiceServlet
extends RemoteServiceServlet
implements SecurityService {
    private static final Logger log = LoggingHelper.getLogger();
    SecurityService service = new SecurityServiceImpl();

    protected void doUnexpectedFailure(Throwable e) {
        if (e.getCause() instanceof AuthorizationException) {
            log.info((Object)e);
            HttpServletResponse response = this.getThreadLocalResponse();
            try {
                response.setContentType("text/plain");
                response.setStatus(401);
                response.getWriter().write(e.getCause().getMessage());
            }
            catch (IOException ex) {
                this.getServletContext().log("respondWithUnexpectedFailure failed while sending the previous failure to the client", (Throwable)ex);
            }
        } else {
            log.error((Object)e.getCause());
            super.doUnexpectedFailure(e);
        }
    }

    public UserSecurityContext getCurrentUser() {
        return this.service.getCurrentUser();
    }

    public Capabilities getUserCapabilities() {
        return this.service.getUserCapabilities();
    }

    public boolean login(String userName, String password) {
        return this.service.login(userName, password);
    }
}

