/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.builder;

import java.util.ArrayList;
import java.util.List;
import org.drools.WorkingMemory;
import org.drools.WorkingMemoryEventManager;
import org.drools.audit.WorkingMemoryInMemoryLogger;
import org.drools.audit.event.ActivationLogEvent;
import org.drools.audit.event.LogEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuditLogReporter
extends WorkingMemoryInMemoryLogger {
    public AuditLogReporter(WorkingMemory wm) {
        super((WorkingMemoryEventManager)wm);
    }

    public List<String[]> buildReport() {
        List evs = this.getLogEvents();
        int resultSize = Math.min(1000, evs.size());
        ArrayList<String[]> ls = new ArrayList<String[]>(resultSize);
        for (int i = 0; i < resultSize; ++i) {
            this.mapLogEvent(ls, (LogEvent)evs.get(i));
        }
        return ls;
    }

    private void mapLogEvent(List<String[]> ls, LogEvent logEvent) {
        switch (logEvent.getType()) {
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                ActivationLogEvent ae = (ActivationLogEvent)logEvent;
                String msg = "FIRING rule: [" + ae.getRule() + "] activationId:" + ae.getActivationId() + " declarations: " + ae.getDeclarations() + (ae.getRuleFlowGroup() == null ? "" : " ruleflow-group: " + ae.getRuleFlowGroup());
                ls.add(new String[]{Integer.toString(logEvent.getType()), msg});
                break;
            }
            default: {
                ls.add(new String[]{Integer.toString(logEvent.getType()), logEvent.toString()});
            }
        }
    }
}

