/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.common;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.WindowListener;
import com.gwtext.client.widgets.layout.ContainerLayout;
import com.gwtext.client.widgets.layout.VerticalLayout;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.DetailedSerializableException;

public class ErrorPopup {
    public static ErrorPopup instance = null;
    private Constants constants = (Constants)GWT.create(Constants.class);
    private VerticalPanel body;

    private ErrorPopup(String message, String longMessage) {
        Window w = new Window();
        w.setTitle(this.constants.Error());
        w.setWidth(400);
        w.setModal(true);
        w.setShadow(true);
        w.setClosable(true);
        w.setPlain(true);
        w.setLayout((ContainerLayout)new VerticalLayout());
        this.body = new VerticalPanel();
        this.addMessage(message, longMessage);
        this.body.setWidth("100%");
        w.add((Widget)this.body);
        w.show();
        w.addListener((WindowListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void addMessage(String message, String longMessage) {
        if (message.contains("ItemExistsException")) {
            longMessage = message;
            message = this.constants.SorryAnItemOfThatNameAlreadyExistsInTheRepositoryPleaseChooseAnother();
        }
        String longDescription = longMessage;
        HorizontalPanel hp = new HorizontalPanel();
        hp.add((Widget)new Image("images/validation_error.gif"));
        Label msg = new Label(message);
        msg.setStyleName("error-title");
        hp.add((Widget)msg);
        this.body.add((Widget)hp);
        SimplePanel detailPanel = new SimplePanel();
        if (longMessage != null && !"".equals(longMessage)) {
            Button showD = new Button(this.constants.ShowDetail());
            showD.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
            detailPanel.add((Widget)showD);
        }
        detailPanel.setWidth("100%");
        this.body.add((Widget)detailPanel);
    }

    public static void showMessage(String message) {
        if (instance != null) {
            instance.addMessage(message, null);
        } else {
            instance = new ErrorPopup(message, null);
        }
        LoadingPopup.close();
    }

    public static void showMessage(DetailedSerializableException exception) {
        if (instance != null) {
            instance.addMessage(exception.getMessage(), exception.getLongDescription());
        } else {
            instance = new ErrorPopup(exception.getMessage(), exception.getLongDescription());
        }
        LoadingPopup.close();
    }
}

