/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.DropDownData;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.MethodInfo;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.brl.ActionCallMethod;
import org.drools.guvnor.client.modeldriven.brl.ActionFieldFunction;
import org.drools.guvnor.client.modeldriven.brl.ActionInsertFact;
import org.drools.guvnor.client.modeldriven.brl.FactPattern;
import org.drools.guvnor.client.modeldriven.ui.MethodParameterValueEditor;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;

public class ActionCallMethodWidget
extends DirtyableComposite {
    private final ActionCallMethod model;
    private final SuggestionCompletionEngine completions;
    private final DirtyableFlexTable layout;
    private boolean isBoundFact = false;
    private String[] fieldCompletionTexts;
    private String[] fieldCompletionValues;
    private final RuleModeller modeller;
    private String variableClass;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public ActionCallMethodWidget(RuleModeller mod, ActionCallMethod set, SuggestionCompletionEngine com) {
        this.model = set;
        this.completions = com;
        this.layout = new DirtyableFlexTable();
        this.modeller = mod;
        this.layout.setStyleName("model-builderInner-Background");
        if (this.completions.isGlobalVariable(set.variable)) {
            List infos = this.completions.getMethodInfosForGlobalVariable(set.variable);
            this.fieldCompletionTexts = new String[infos.size()];
            this.fieldCompletionValues = new String[infos.size()];
            int i = 0;
            for (MethodInfo info : infos) {
                this.fieldCompletionTexts[i] = info.getName();
                this.fieldCompletionValues[i] = info.getNameWithParameters();
                ++i;
            }
            this.variableClass = (String)this.completions.globalTypes.get(set.variable);
        } else {
            FactPattern pattern = mod.getModel().getBoundFact(set.variable);
            if (pattern != null) {
                List methodList = this.completions.getMethodNames(pattern.factType);
                this.fieldCompletionTexts = new String[methodList.size()];
                this.fieldCompletionValues = new String[methodList.size()];
                int i = 0;
                Iterator i$ = methodList.iterator();
                while (i$.hasNext()) {
                    String methodName;
                    this.fieldCompletionTexts[i] = methodName = (String)i$.next();
                    this.fieldCompletionValues[i] = methodName;
                    ++i;
                }
                this.variableClass = pattern.factType;
                this.isBoundFact = true;
            } else {
                ActionInsertFact patternRhs = mod.getModel().getRhsBoundFact(set.variable);
                if (patternRhs != null) {
                    List methodList = this.completions.getMethodNames(patternRhs.factType);
                    this.fieldCompletionTexts = new String[methodList.size()];
                    this.fieldCompletionValues = new String[methodList.size()];
                    int i = 0;
                    Iterator i$ = methodList.iterator();
                    while (i$.hasNext()) {
                        String methodName;
                        this.fieldCompletionTexts[i] = methodName = (String)i$.next();
                        this.fieldCompletionValues[i] = methodName;
                        ++i;
                    }
                    this.variableClass = patternRhs.factType;
                    this.isBoundFact = true;
                }
            }
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    private void doLayout() {
        this.layout.clear();
        this.layout.setWidget(0, 0, this.getSetterLabel());
        DirtyableFlexTable inner = new DirtyableFlexTable();
        int i = 0;
        while (i < this.model.fieldValues.length) {
            ActionFieldFunction val = this.model.getFieldValue(i);
            inner.setWidget(i, 0, this.fieldSelector(val));
            inner.setWidget(i, 1, this.valueEditor(val));
            int idx = i++;
        }
        this.layout.setWidget(0, 1, (Widget)inner);
    }

    private Widget getSetterLabel() {
        HorizontalPanel horiz = new HorizontalPanel();
        if (this.model.state == 0) {
            ImageButton edit = new ImageButton("images/add_field_to_fact.gif");
            edit.setTitle(this.constants.AddAnotherFieldToThisSoYouCanSetItsValue());
            edit.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            horiz.add((Widget)new SmallLabel(HumanReadable.getActionDisplayName((String)"call") + " [" + this.model.variable + "]"));
            horiz.add((Widget)edit);
        } else {
            horiz.add((Widget)new SmallLabel(HumanReadable.getActionDisplayName((String)"call") + " [" + this.model.variable + "." + this.model.methodName + "]"));
        }
        return horiz;
    }

    protected void showAddFieldPopup(Widget w) {
        FormStylePopup popup = new FormStylePopup("images/newex_wiz.gif", this.constants.ChooseAMethodToInvoke());
        ListBox box = new ListBox();
        box.addItem("...");
        for (int i = 0; i < this.fieldCompletionTexts.length; ++i) {
            box.addItem(this.fieldCompletionTexts[i], this.fieldCompletionValues[i]);
        }
        box.setSelectedIndex(0);
        popup.addAttribute(this.constants.ChooseAMethodToInvoke(), (Widget)box);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        popup.setPopupPosition(w.getAbsoluteLeft(), w.getAbsoluteTop());
        popup.show();
    }

    private Widget valueEditor(ActionFieldFunction val) {
        String type = "";
        if (this.completions.isGlobalVariable(this.model.variable)) {
            type = (String)this.completions.globalTypes.get(this.model.variable);
        } else if (this.modeller.getModel().getBoundFact(this.model.variable) != null) {
            type = this.modeller.getModel().getBoundFact((String)this.model.variable).factType;
        } else if (this.modeller.getModel().getRhsBoundFact(this.model.variable) != null) {
            type = this.modeller.getModel().getRhsBoundFact((String)this.model.variable).factType;
        }
        DropDownData enums = this.completions.getEnums(type, this.model.fieldValues, val.field);
        return new MethodParameterValueEditor(val, enums, this.modeller, val.type);
    }

    public static KeyboardListener getNumericFilter(TextBox box) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private Widget fieldSelector(ActionFieldFunction val) {
        return new SmallLabel(val.type);
    }

    private Widget actionSelector(ActionFieldFunction val) {
        ListBox box = new ListBox();
        Map modMap = this.completions.modifiers;
        String fieldType = val.type;
        String[] modifiers = (String[])modMap.get(fieldType);
        if (modifiers != null) {
            for (int i = 0; i < modifiers.length; ++i) {
                box.addItem(modifiers[i]);
            }
        }
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    public boolean isBoundFact() {
        return this.isBoundFact;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    static /* synthetic */ ActionCallMethod access$000(ActionCallMethodWidget x0) {
        return x0.model;
    }

    static /* synthetic */ String access$100(ActionCallMethodWidget x0) {
        return x0.variableClass;
    }

    static /* synthetic */ SuggestionCompletionEngine access$200(ActionCallMethodWidget x0) {
        return x0.completions;
    }

    static /* synthetic */ RuleModeller access$300(ActionCallMethodWidget x0) {
        return x0.modeller;
    }
}

