/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.DeferredCommand;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.FieldEditListener;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.DropDownData;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.brl.FactPattern;
import org.drools.guvnor.client.modeldriven.brl.ISingleFieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.RuleModel;
import org.drools.guvnor.client.modeldriven.ui.ConstraintValueEditorHelper;
import org.drools.guvnor.client.modeldriven.ui.DatePicker;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;

/*
 * Exception performing whole class analysis ignored.
 */
public class ConstraintValueEditor
extends DirtyableComposite {
    private final ISingleFieldConstraint constraint;
    private final Panel panel;
    private final RuleModel model;
    private final boolean numericValue;
    private DropDownData dropDownData;
    private Constants constants = (Constants)GWT.create(Constants.class);
    private String fieldType;

    public ConstraintValueEditor(FactPattern pattern, String fieldName, ISingleFieldConstraint con, RuleModeller modeller, String valueType) {
        this.constraint = con;
        this.fieldType = valueType = modeller.getSuggestionCompletions().getFieldType(pattern.factType, fieldName);
        SuggestionCompletionEngine sce = modeller.getSuggestionCompletions();
        this.numericValue = "Numeric".equals(valueType);
        this.dropDownData = "Boolean".equals(valueType) ? DropDownData.create((String[])new String[]{"true", "false"}) : sce.getEnums(pattern, fieldName);
        this.model = modeller.getModel();
        this.panel = new SimplePanel();
        this.refreshEditor();
        this.initWidget((Widget)this.panel);
    }

    private void refreshEditor() {
        this.panel.clear();
        if (this.constraint.constraintValueType == 0) {
            Image clickme = new Image("images/edit.gif");
            clickme.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            this.panel.add((Widget)clickme);
        } else {
            switch (this.constraint.constraintValueType) {
                case 1: {
                    this.panel.add(this.literalEditor());
                    break;
                }
                case 3: {
                    this.panel.add(this.returnValueEditor());
                    break;
                }
                case 2: {
                    this.panel.add(this.variableEditor());
                    break;
                }
            }
        }
    }

    private Widget variableEditor() {
        List vars = this.model.getBoundVariablesInScope(this.constraint);
        ListBox box = new ListBox();
        if (this.constraint.value == null) {
            box.addItem(this.constants.Choose());
        }
        for (int i = 0; i < vars.size(); ++i) {
            String var = (String)vars.get(i);
            FactPattern f = this.model.getBoundFact(var);
            if (!f.factType.equals(this.fieldType)) continue;
            box.addItem(var);
            if (this.constraint.value == null || !this.constraint.value.equals(var)) continue;
            box.setSelectedIndex(i);
        }
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private Widget returnValueEditor() {
        TextBox box = this.boundTextBox(this.constraint);
        String msg = this.constants.FormulaEvaluateToAValue();
        Image img = new Image("images/function_assets.gif");
        img.setTitle(msg);
        box.setTitle(msg);
        Panel ed = this.widgets((Widget)img, (Widget)box);
        return ed;
    }

    private Widget literalEditor() {
        if (this.dropDownData != null) {
            return ConstraintValueEditor.enumDropDown((String)this.constraint.value, (ValueChanged)new /* Unavailable Anonymous Inner Class!! */, (DropDownData)this.dropDownData);
        }
        if ("Date".equals(this.fieldType)) {
            DatePicker datePicker = new DatePicker(this.constraint.value);
            this.constraint.value = datePicker.getDateString();
            datePicker.addValueChanged((ValueChanged)new /* Unavailable Anonymous Inner Class!! */);
            return datePicker;
        }
        TextBox box = this.boundTextBox(this.constraint);
        if (this.numericValue) {
            box.addKeyboardListener((KeyboardListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        box.setTitle(this.constants.LiteralValueTip());
        return box;
    }

    public static Widget enumDropDown(String currentValue, ValueChanged valueChanged, DropDownData dropData) {
        int ix;
        ListBox box = new ListBox();
        Constants cs = (Constants)GWT.create(Constants.class);
        if (dropData.fixedList == null && dropData.queryExpression != null) {
            DeferredCommand.addCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            ConstraintValueEditor.doDropDown((String)currentValue, (String[])dropData.fixedList, (ListBox)box);
        }
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        if ((currentValue == null || "".equals(currentValue)) && (ix = box.getSelectedIndex()) > -1) {
            String val = box.getValue(ix);
            valueChanged.valueChanged(val);
        }
        return box;
    }

    private static void doDropDown(String currentValue, String[] enumeratedValues, ListBox box) {
        boolean selected = false;
        box.clear();
        for (int i = 0; i < enumeratedValues.length; ++i) {
            String val;
            String v = enumeratedValues[i];
            if (v.indexOf(61) > 0) {
                String[] splut = ConstraintValueEditorHelper.splitValue((String)v);
                String realValue = splut[0];
                String display = splut[1];
                val = realValue;
                box.addItem(display, realValue);
            } else {
                box.addItem(v, v);
                val = v;
            }
            if (currentValue == null || !currentValue.equals(val)) continue;
            box.setSelectedIndex(i);
            selected = true;
        }
        if (currentValue != null && !"".equals(currentValue) && !selected) {
            box.addItem(currentValue, currentValue);
            box.setSelectedIndex(enumeratedValues.length);
        }
    }

    private TextBox boundTextBox(ISingleFieldConstraint c) {
        TextBox box = new TextBox();
        box.setStyleName("constraint-value-Editor");
        if (c.value == null) {
            box.setText("");
        } else {
            box.setText(c.value);
        }
        String v = c.value;
        if (c.value == null || v.length() < 7) {
            box.setVisibleLength(8);
        } else {
            box.setVisibleLength(v.length() + 1);
        }
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        box.addKeyboardListener((KeyboardListener)new FieldEditListener((Command)new /* Unavailable Anonymous Inner Class!! */));
        return box;
    }

    private void showTypeChoice(Widget w, ISingleFieldConstraint con) {
        FormStylePopup form = new FormStylePopup("images/newex_wiz.gif", this.constants.FieldValue());
        Button lit = new Button(this.constants.LiteralValue());
        lit.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.LiteralValue() + ":", (Widget)this.widgets((Widget)lit, (Widget)new InfoPopup(this.constants.LiteralValue(), this.constants.LiteralValTip())));
        form.addRow((Widget)new HTML("<hr/>"));
        form.addRow((Widget)new SmallLabel(this.constants.AdvancedOptions()));
        if (this.model.getBoundVariablesInScope(this.constraint).size() > 0) {
            List vars = this.model.getBoundFacts();
            boolean foundABouncVariableThatMatches = false;
            for (int i = 0; i < vars.size(); ++i) {
                String var = (String)vars.get(i);
                FactPattern f = this.model.getBoundFact(var);
                if (!f.factType.equals(this.fieldType)) continue;
                foundABouncVariableThatMatches = true;
                break;
            }
            if (foundABouncVariableThatMatches) {
                Button variable = new Button(this.constants.BoundVariable());
                variable.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                form.addAttribute(this.constants.AVariable(), (Widget)this.widgets((Widget)variable, (Widget)new InfoPopup(this.constants.ABoundVariable(), this.constants.BoundVariableTip())));
            }
        }
        Button formula = new Button(this.constants.NewFormula());
        formula.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.AFormula() + ":", (Widget)this.widgets((Widget)formula, (Widget)new InfoPopup(this.constants.AFormula(), this.constants.FormulaExpressionTip())));
        form.show();
    }

    private void doTypeChosen(FormStylePopup form) {
        this.refreshEditor();
        form.hide();
    }

    private Panel widgets(Widget left, Widget right) {
        HorizontalPanel panel = new HorizontalPanel();
        panel.add(left);
        panel.add(right);
        panel.setWidth("100%");
        return panel;
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    static /* synthetic */ ISingleFieldConstraint access$000(ConstraintValueEditor x0) {
        return x0.constraint;
    }

    static /* synthetic */ void access$100(ConstraintValueEditor x0, Widget x1, ISingleFieldConstraint x2) {
        x0.showTypeChoice(x1, x2);
    }

    static /* synthetic */ void access$200(String x0, String[] x1, ListBox x2) {
        ConstraintValueEditor.doDropDown((String)x0, (String[])x1, (ListBox)x2);
    }

    static /* synthetic */ void access$300(ConstraintValueEditor x0, FormStylePopup x1) {
        x0.doTypeChosen(x1);
    }
}

