/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui.factPattern;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.brl.ConnectiveConstraint;
import org.drools.guvnor.client.modeldriven.brl.FactPattern;
import org.drools.guvnor.client.modeldriven.brl.ISingleFieldConstraint;
import org.drools.guvnor.client.modeldriven.brl.SingleFieldConstraint;
import org.drools.guvnor.client.modeldriven.ui.ConstraintValueEditor;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;

public class Connectives {
    private FactPattern pattern;
    private SuggestionCompletionEngine completions;
    private RuleModeller modeller;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public FactPattern getPattern() {
        return this.pattern;
    }

    public void setPattern(FactPattern pattern) {
        this.pattern = pattern;
    }

    public SuggestionCompletionEngine getCompletions() {
        return this.completions;
    }

    public void setCompletions(SuggestionCompletionEngine completions) {
        this.completions = completions;
    }

    public RuleModeller getModeller() {
        return this.modeller;
    }

    public void setModeller(RuleModeller modeller) {
        this.modeller = modeller;
    }

    public Widget connectives(SingleFieldConstraint c, String factClass) {
        if (c.connectives != null && c.connectives.length > 0) {
            DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
            for (int i = 0; i < c.connectives.length; ++i) {
                ConnectiveConstraint con = c.connectives[i];
                horiz.add(this.connectiveOperatorDropDown(con, c.fieldName));
                horiz.add(this.connectiveValueEditor((ISingleFieldConstraint)con, factClass, c.fieldName));
            }
            return horiz;
        }
        return null;
    }

    private Widget connectiveValueEditor(ISingleFieldConstraint con, String factClass, String fieldName) {
        String typeNumeric = this.modeller.getSuggestionCompletions().getFieldType(factClass, fieldName);
        return new ConstraintValueEditor(this.pattern, fieldName, con, this.modeller, typeNumeric);
    }

    private Widget connectiveOperatorDropDown(ConnectiveConstraint con, String fieldName) {
        String[] ops = this.completions.getConnectiveOperatorCompletions(this.pattern.factType, fieldName);
        ListBox box = new ListBox();
        box.addItem(this.constants.pleaseChoose());
        for (int i = 0; i < ops.length; ++i) {
            String op = ops[i];
            box.addItem(HumanReadable.getOperatorDisplayName((String)op), op);
            if (!op.equals(con.operator)) continue;
            box.setSelectedIndex(i + 1);
        }
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }
}

