/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HasHorizontalAlignment;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.client.modeldriven.testing.FactData;
import org.drools.guvnor.client.modeldriven.testing.FieldData;
import org.drools.guvnor.client.modeldriven.testing.Scenario;
import org.drools.guvnor.client.qa.ScenarioWidget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataInputWidget
extends DirtyableComposite {
    private Grid outer;
    private Scenario scenario;
    private SuggestionCompletionEngine sce;
    private String type;
    private ScenarioWidget parent;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public DataInputWidget(String factType, List<FactData> defList, boolean isGlobal, Scenario sc, SuggestionCompletionEngine sce, ScenarioWidget parent) {
        this.outer = new Grid(2, 1);
        this.scenario = sc;
        this.sce = sce;
        this.type = factType;
        this.parent = parent;
        this.outer.getCellFormatter().setStyleName(0, 0, "modeller-fact-TypeHeader");
        this.outer.getCellFormatter().setAlignment(0, 0, HasHorizontalAlignment.ALIGN_CENTER, HasVerticalAlignment.ALIGN_MIDDLE);
        this.outer.setStyleName("modeller-fact-pattern-Widget");
        if (isGlobal) {
            this.outer.setWidget(0, 0, this.getLabel(Format.format((String)this.constants.globalForScenario(), (String)factType), defList, parent, sc));
        } else {
            FactData first = defList.get(0);
            if (first.isModify) {
                this.outer.setWidget(0, 0, this.getLabel(Format.format((String)this.constants.modifyForScenario(), (String)factType), defList, parent, sc));
            } else {
                this.outer.setWidget(0, 0, this.getLabel(Format.format((String)this.constants.insertForScenario(), (String)factType), defList, parent, sc));
            }
        }
        FlexTable t = this.render(defList, parent, sc);
        this.outer.setWidget(1, 0, (Widget)t);
        this.initWidget((Widget)this.outer);
    }

    private Widget getLabel(String text, List defList, ScenarioWidget parent, Scenario sc) {
        ClickableLabel clbl = new ClickableLabel(text, this.addFieldCL(defList, parent, sc));
        return clbl;
    }

    private ClickListener addFieldCL(List<FactData> defList, ScenarioWidget parent, Scenario sc) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private FlexTable render(List defList, ScenarioWidget parent, Scenario sc) {
        DirtyableFlexTable t = new DirtyableFlexTable();
        if (defList.size() == 0) {
            parent.renderEditor();
        }
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        int col = 0;
        int totalCols = defList.size();
        for (FactData d : defList) {
            for (int i = 0; i < d.fieldData.size(); ++i) {
                FieldData fd = (FieldData)d.fieldData.get(i);
                if (fields.containsKey(fd.name)) continue;
                int idx = fields.size() + 1;
                fields.put(fd.name, new Integer(idx));
                t.setWidget(idx, 0, (Widget)new SmallLabel(fd.name + ":"));
                ImageButton del = new ImageButton("images/delete_item_small.gif", this.constants.RemoveThisRow(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                t.setWidget(idx, totalCols + 1, (Widget)del);
                t.getCellFormatter().setHorizontalAlignment(idx, 0, HasHorizontalAlignment.ALIGN_RIGHT);
            }
        }
        int totalRows = fields.size();
        t.getFlexCellFormatter().setHorizontalAlignment(totalRows + 1, 0, HasHorizontalAlignment.ALIGN_RIGHT);
        col = 0;
        for (FactData d : defList) {
            int fldRow;
            t.setWidget(0, ++col, (Widget)new SmallLabel("[" + d.name + "]"));
            ImageButton del = new ImageButton("images/delete_item_small.gif", Format.format((String)this.constants.RemoveTheColumnForScenario(), (String)d.name), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            t.setWidget(totalRows + 1, col, (Widget)del);
            HashMap presentFields = new HashMap(fields);
            for (int i = 0; i < d.fieldData.size(); ++i) {
                FieldData fd = (FieldData)d.fieldData.get(i);
                fldRow = (Integer)fields.get(fd.name);
                t.setWidget(fldRow, col, this.editableCell(fd, d.type));
                presentFields.remove(fd.name);
            }
            for (Map.Entry e : presentFields.entrySet()) {
                fldRow = (Integer)e.getValue();
                FieldData fd = new FieldData((String)e.getKey(), "");
                d.fieldData.add(fd);
                t.setWidget(fldRow, col, this.editableCell(fd, d.type));
            }
        }
        if (fields.size() == 0) {
            Button b = new Button(this.constants.AddAField());
            b.addClickListener(this.addFieldCL(defList, parent, sc));
            t.setWidget(1, 1, (Widget)b);
        }
        return t;
    }

    private Widget editableCell(FieldData fd, String factType) {
        return ScenarioWidget.editableCell((ValueChanged)new /* Unavailable Anonymous Inner Class!! */, (String)factType, (String)fd.name, (String)fd.value, (SuggestionCompletionEngine)this.sce);
    }

    static /* synthetic */ String access$000(DataInputWidget x0) {
        return x0.type;
    }

    static /* synthetic */ SuggestionCompletionEngine access$100(DataInputWidget x0) {
        return x0.sce;
    }

    static /* synthetic */ Constants access$200(DataInputWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ FlexTable access$300(DataInputWidget x0, List x1, ScenarioWidget x2, Scenario x3) {
        return x0.render(x1, x2, x3);
    }

    static /* synthetic */ Grid access$400(DataInputWidget x0) {
        return x0.outer;
    }

    static /* synthetic */ Scenario access$500(DataInputWidget x0) {
        return x0.scenario;
    }
}

