/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import com.gwtext.client.widgets.QuickTipsConfig;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.ToolbarItem;
import com.gwtext.client.widgets.ToolbarTextItem;
import com.gwtext.client.widgets.event.ButtonListener;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.StatusChangePopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.ActionToolbar;
import org.drools.guvnor.client.ruleeditor.CheckinPopup;

public class ActionToolbar
extends Composite {
    private Toolbar toolbar;
    private CheckinAction checkinAction;
    private CheckinAction archiveAction;
    private Command deleteAction;
    private ToolbarTextItem state;
    private final RuleAsset asset;
    private Command afterCheckinEvent;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public ActionToolbar(RuleAsset asset, CheckinAction checkin, CheckinAction archiv, Command delete, boolean readOnly) {
        this.checkinAction = checkin;
        this.archiveAction = archiv;
        this.deleteAction = delete;
        this.asset = asset;
        this.state = new ToolbarTextItem(this.constants.Status() + " ");
        this.toolbar = new Toolbar();
        String status = asset.metaData.status;
        this.setState(status);
        if (!readOnly && !asset.isreadonly) {
            this.controls();
        }
        this.toolbar.addItem((ToolbarItem)this.state);
        this.initWidget((Widget)this.toolbar);
    }

    private void setState(String status) {
        this.state.setText(Format.format((String)this.constants.statusIs(), (String)status));
    }

    private void controls() {
        ToolbarButton save = new ToolbarButton();
        save.setText(this.constants.SaveChanges());
        save.setTooltip(this.getTip(this.constants.CommitAnyChangesForThisAsset()));
        save.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.addButton(save);
        this.toolbar.addFill();
        this.toolbar.addSeparator();
        ToolbarButton copy = new ToolbarButton();
        copy.setText(this.constants.Copy());
        copy.setTooltip(this.constants.CopyThisAsset());
        copy.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.addButton(copy);
        ToolbarButton archive = new ToolbarButton();
        archive.setText(this.constants.Archive());
        archive.setTooltip(this.getTip(this.constants.ArchiveThisAssetThisWillNotPermanentlyDeleteIt()));
        archive.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.addButton(archive);
        if (this.notCheckedInYet()) {
            ToolbarButton delete = new ToolbarButton();
            delete.setText(this.constants.Delete());
            delete.setTooltip(this.getTip(this.constants.DeleteAssetTooltip()));
            delete.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
            this.toolbar.addButton(delete);
            this.afterCheckinEvent = new /* Unavailable Anonymous Inner Class!! */;
        }
        ToolbarButton stateChange = new ToolbarButton();
        stateChange.setText(this.constants.ChangeStatus());
        stateChange.setTooltip(this.getTip(this.constants.ChangeStatusTip()));
        stateChange.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.toolbar.addButton(stateChange);
    }

    private boolean notCheckedInYet() {
        return this.asset.metaData.versionNumber == 0L;
    }

    private QuickTipsConfig getTip(String t) {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void doCopyDialog(Widget w) {
        FormStylePopup form = new FormStylePopup("images/rule_asset.gif", this.constants.CopyThisItem());
        TextBox newName = new TextBox();
        form.addAttribute(this.constants.NewName(), (Widget)newName);
        Button ok = new Button(this.constants.CreateCopy());
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute("", (Widget)ok);
        form.show();
    }

    private void completedCopying(String name, String pkg) {
        Window.alert((String)Format.format((String)this.constants.CreatedANewItemSuccess(), (String)name, (String)pkg));
    }

    protected void doCheckinConfirm(Widget w) {
        CheckinPopup pop = new CheckinPopup(w.getAbsoluteLeft(), w.getAbsoluteTop(), this.constants.CheckInChanges());
        pop.setCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    private void showStatusChanger(Widget w) {
        StatusChangePopup pop = new StatusChangePopup(this.asset.uuid, false);
        pop.setChangeStatusEvent((Command)new /* Unavailable Anonymous Inner Class!! */);
        pop.show();
    }

    static /* synthetic */ Constants access$000(ActionToolbar x0) {
        return x0.constants;
    }

    static /* synthetic */ CheckinAction access$100(ActionToolbar x0) {
        return x0.archiveAction;
    }

    static /* synthetic */ Command access$200(ActionToolbar x0) {
        return x0.deleteAction;
    }

    static /* synthetic */ void access$300(ActionToolbar x0, Widget x1) {
        x0.showStatusChanger(x1);
    }

    static /* synthetic */ RuleAsset access$400(ActionToolbar x0) {
        return x0.asset;
    }

    static /* synthetic */ void access$500(ActionToolbar x0, String x1, String x2) {
        x0.completedCopying(x1, x2);
    }

    static /* synthetic */ CheckinAction access$600(ActionToolbar x0) {
        return x0.checkinAction;
    }

    static /* synthetic */ Command access$700(ActionToolbar x0) {
        return x0.afterCheckinEvent;
    }

    static /* synthetic */ void access$800(ActionToolbar x0, String x1) {
        x0.setState(x1);
    }
}

