/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.contenthandler;

import com.google.gwt.user.client.rpc.SerializableException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.drools.compiler.DroolsParserException;
import org.drools.compiler.PackageBuilderConfiguration;
import org.drools.definition.process.WorkflowProcess;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.rpc.RuleFlowContentModel;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.builder.ContentPackageAssembler;
import org.drools.guvnor.server.builder.RuleFlowContentModelBuilder;
import org.drools.guvnor.server.builder.RuleFlowProcessBuilder;
import org.drools.guvnor.server.contenthandler.ContentHandler;
import org.drools.guvnor.server.contenthandler.IRuleAsset;
import org.drools.repository.AssetItem;
import org.drools.repository.PackageItem;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.xml.XmlProcessReader;
import org.drools.xml.XmlRuleFlowProcessDumper;

public class RuleFlowHandler
extends ContentHandler
implements IRuleAsset {
    public void retrieveAssetContent(RuleAsset asset, PackageItem pkg, AssetItem item) throws SerializableException {
        RuleFlowProcess process = this.readProcess((InputStream)new ByteArrayInputStream(item.getContent().getBytes()));
        if (process != null) {
            RuleFlowContentModel content = RuleFlowContentModelBuilder.createModel((RuleFlowProcess)process);
            content.setXml(item.getContent());
            asset.content = content;
        } else if (process == null && !"".equals(item.getContent())) {
            asset.content = new RuleFlowContentModel();
            ((RuleFlowContentModel)asset.content).setXml(item.getContent());
        }
    }

    protected RuleFlowProcess readProcess(InputStream is) {
        RuleFlowProcess process = null;
        try {
            InputStreamReader reader = new InputStreamReader(is);
            PackageBuilderConfiguration configuration = new PackageBuilderConfiguration();
            XmlProcessReader xmlReader = new XmlProcessReader(configuration.getSemanticModules());
            try {
                process = (RuleFlowProcess)xmlReader.read((Reader)reader);
            }
            catch (Exception e) {
                reader.close();
                throw new Exception("Unable to read rule flow XML.");
            }
            reader.close();
        }
        catch (Exception e) {
            return null;
        }
        return process;
    }

    public void storeAssetContent(RuleAsset asset, AssetItem repoAsset) throws SerializableException {
        RuleFlowContentModel content = (RuleFlowContentModel)asset.content;
        if (content != null && content.getXml() != null) {
            RuleFlowProcess process = this.readProcess((InputStream)new ByteArrayInputStream(content.getXml().getBytes()));
            if (process != null) {
                RuleFlowProcessBuilder.updateProcess((RuleFlowProcess)process, (Collection)content.getNodes());
                XmlRuleFlowProcessDumper dumper = XmlRuleFlowProcessDumper.INSTANCE;
                String out = dumper.dump((WorkflowProcess)process);
                repoAsset.updateContent(out);
            } else {
                repoAsset.updateContent(content.getXml());
            }
        }
    }

    public void ruleFlowAttached(AssetItem item) {
        String originalPackageName;
        String packageName;
        RuleFlowProcess process;
        String content = item.getContent();
        if (content != null && !content.equals("") && (process = this.readProcess((InputStream)new ByteArrayInputStream(content.getBytes()))) != null && !(packageName = item.getPackageName()).equals(originalPackageName = process.getPackageName())) {
            process.setPackageName(packageName);
            XmlRuleFlowProcessDumper dumper = XmlRuleFlowProcessDumper.INSTANCE;
            String out = dumper.dump((WorkflowProcess)process);
            item.updateContent(out);
            item.checkin("Changed rule flow package from " + originalPackageName + " to " + packageName);
        }
    }

    public void assembleDRL(BRMSPackageBuilder builder, AssetItem asset, StringBuffer buf) {
    }

    public void compile(BRMSPackageBuilder builder, AssetItem asset, ContentPackageAssembler.ErrorLogger logger) throws DroolsParserException, IOException {
        InputStream ins = asset.getBinaryContentAttachment();
        if (ins != null) {
            builder.addRuleFlow((Reader)new InputStreamReader(asset.getBinaryContentAttachment()));
        }
    }
}

