/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.selector;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.drools.guvnor.server.selector.AssetSelector;
import org.drools.guvnor.server.selector.RuleBasedSelector;

public class SelectorManager {
    private static final Logger log = Logger.getLogger(SelectorManager.class);
    public static String SELECTOR_CONFIG_PROPERTIES = "/selectors.properties";
    private static final SelectorManager INSTANCE = new SelectorManager(SELECTOR_CONFIG_PROPERTIES);
    public final Map<String, AssetSelector> selectors = new HashMap();

    SelectorManager(String configPath) {
        log.debug((Object)"Loading selectors");
        Properties props = new Properties();
        try {
            props.load(this.getClass().getResourceAsStream(configPath));
            for (String string : props.keySet()) {
                String val = props.getProperty(string);
                try {
                    if (val.endsWith("drl")) {
                        this.selectors.put(string, this.loadRuleSelector(val));
                        continue;
                    }
                    this.selectors.put(string, this.loadSelectorImplementation(val));
                }
                catch (RuntimeException e) {
                    log.error((Object)("Unable to load a selector [" + val + "]"), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Unable to load selectors.", (Throwable)e);
        }
    }

    public AssetSelector getSelector(String name) {
        if (name == null || "".equals(name.trim())) {
            return this.nilSelector();
        }
        if (this.selectors.containsKey(name)) {
            return (AssetSelector)this.selectors.get(name);
        }
        log.debug((Object)("No selector found by the name of " + name));
        return null;
    }

    private AssetSelector nilSelector() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    private AssetSelector loadSelectorImplementation(String val) throws IOException {
        try {
            return (AssetSelector)Thread.currentThread().getContextClassLoader().loadClass(val).newInstance();
        }
        catch (InstantiationException e) {
            log.error((Object)e);
            return null;
        }
        catch (IllegalAccessException e) {
            log.error((Object)e);
            return null;
        }
        catch (ClassNotFoundException e) {
            log.error((Object)e);
            return null;
        }
    }

    private AssetSelector loadRuleSelector(String val) {
        return new RuleBasedSelector(val);
    }

    public static SelectorManager getInstance() {
        return INSTANCE;
    }
}

