/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.util.ArrayList;
import java.util.List;
import java.util.jar.JarInputStream;
import org.drools.guvnor.client.modeldriven.SuggestionCompletionEngine;
import org.drools.guvnor.server.ServiceImplementation;
import org.drools.guvnor.server.builder.BRMSPackageBuilder;
import org.drools.guvnor.server.rules.SuggestionCompletionLoader;
import org.drools.lang.dsl.DSLTokenizedMappingFile;
import org.drools.repository.AssetItem;
import org.drools.repository.AssetItemIterator;
import org.drools.repository.PackageItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BRMSSuggestionCompletionLoader
extends SuggestionCompletionLoader {
    public SuggestionCompletionEngine getSuggestionEngine(PackageItem pkg) {
        StringBuilder buf = new StringBuilder();
        AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"model.drl"});
        while (it.hasNext()) {
            AssetItem as = it.next();
            buf.append(as.getContent());
            buf.append('\n');
        }
        return super.getSuggestionEngine(ServiceImplementation.getDroolsHeader((PackageItem)pkg) + "\n" + buf.toString(), this.getJars(pkg), this.getDSLMappingFiles(pkg), this.getDataEnums(pkg));
    }

    public BRMSSuggestionCompletionLoader() {
    }

    public BRMSSuggestionCompletionLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    private List<String> getDataEnums(PackageItem pkg) {
        AssetItemIterator it = pkg.listAssetsByFormat(new String[]{"enumeration"});
        ArrayList<String> list = new ArrayList<String>();
        while (it.hasNext()) {
            AssetItem item = (AssetItem)it.next();
            list.add(item.getContent());
        }
        return list;
    }

    private List<DSLTokenizedMappingFile> getDSLMappingFiles(PackageItem pkg) {
        return BRMSPackageBuilder.getDSLMappingFiles((PackageItem)pkg, (BRMSPackageBuilder.DSLErrorEvent)new /* Unavailable Anonymous Inner Class!! */);
    }

    private List<JarInputStream> getJars(PackageItem pkg) {
        return BRMSPackageBuilder.getJars((PackageItem)pkg);
    }

    static /* synthetic */ List access$000(BRMSSuggestionCompletionLoader x0) {
        return x0.errors;
    }
}

