/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.KeyboardListener;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.EventObject;
import com.gwtext.client.core.SortDir;
import com.gwtext.client.data.ArrayReader;
import com.gwtext.client.data.DataProxy;
import com.gwtext.client.data.FieldDef;
import com.gwtext.client.data.GroupingStore;
import com.gwtext.client.data.IntegerFieldDef;
import com.gwtext.client.data.MemoryProxy;
import com.gwtext.client.data.Reader;
import com.gwtext.client.data.Record;
import com.gwtext.client.data.RecordDef;
import com.gwtext.client.data.SortState;
import com.gwtext.client.data.Store;
import com.gwtext.client.data.StringFieldDef;
import com.gwtext.client.util.Format;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.ToolbarMenuButton;
import com.gwtext.client.widgets.Window;
import com.gwtext.client.widgets.form.FieldSet;
import com.gwtext.client.widgets.form.FormPanel;
import com.gwtext.client.widgets.grid.BaseColumnConfig;
import com.gwtext.client.widgets.grid.ColumnModel;
import com.gwtext.client.widgets.grid.GridPanel;
import com.gwtext.client.widgets.grid.GridView;
import com.gwtext.client.widgets.grid.GroupingView;
import com.gwtext.client.widgets.grid.event.ColumnModelListener;
import com.gwtext.client.widgets.grid.event.GridCellListener;
import com.gwtext.client.widgets.grid.event.GridColumnListener;
import com.gwtext.client.widgets.menu.BaseItem;
import com.gwtext.client.widgets.menu.Item;
import com.gwtext.client.widgets.menu.Menu;
import com.gwtext.client.widgets.menu.event.BaseItemListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.PrettyFormLayout;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.ActionValueEditor;
import org.drools.guvnor.client.modeldriven.ui.DatePickerTextBox;
import org.drools.guvnor.client.packages.SuggestionCompletionCache;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.RuleViewer;
import org.drools.guvnor.client.ruleeditor.SaveEventListener;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.ActionCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.ui.ConstraintValueEditorHelper;

public class GuidedDecisionTableWidget
extends Composite
implements SaveEventListener {
    private GuidedDecisionTable dt;
    private VerticalPanel layout;
    private GridPanel grid;
    private FieldDef[] fds;
    private VerticalPanel attributeConfigWidget;
    private VerticalPanel conditionsConfigWidget;
    private String packageName;
    private VerticalPanel actionsConfigWidget;
    private Map<String, DTColumnConfig> colMap;
    private SuggestionCompletionEngine sce;
    private GroupingStore store;
    private Constants constants = (Constants)GWT.create(Constants.class);
    RecordDef recordDef;

    public GuidedDecisionTableWidget(RuleAsset asset, RuleViewer viewer) {
        this(asset);
    }

    public GuidedDecisionTableWidget(RuleAsset asset) {
        this.dt = (GuidedDecisionTable)asset.content;
        this.packageName = asset.metaData.packageName;
        this.dt.tableName = asset.metaData.name;
        this.layout = new VerticalPanel();
        FormPanel config = new FormPanel();
        config.setTitle(this.constants.DecisionTable());
        config.setBodyBorder(false);
        config.setCollapsed(true);
        config.setCollapsible(true);
        FieldSet conditions = new FieldSet(this.constants.ConditionColumns());
        conditions.setCollapsible(true);
        conditions.add(this.getConditions());
        config.add((Component)conditions);
        FieldSet actions = new FieldSet(this.constants.ActionColumns());
        actions.setCollapsible(true);
        actions.add(this.getActions());
        config.add((Component)actions);
        FieldSet grouping = new FieldSet(this.constants.options());
        grouping.setCollapsible(true);
        grouping.setCollapsed(true);
        grouping.add(this.getGrouping());
        grouping.add(this.getAttributes());
        config.add((Component)grouping);
        this.layout.add((Widget)config);
        VerticalPanel buttonPanel = new VerticalPanel();
        buttonPanel.add((Widget)this.getToolbarMenuButton());
        this.layout.add((Widget)buttonPanel);
        this.refreshGrid();
        this.initWidget((Widget)this.layout);
    }

    private Widget getGrouping() {
        ListBox list = new ListBox();
        list.addItem(this.constants.Description(), "desc");
        if (this.dt.getMetadataCols() == null) {
            this.dt.setMetadataCols(new ArrayList());
        }
        for (MetadataCol c : this.dt.getMetadataCols()) {
            list.addItem(c.attr, c.attr);
            if (!c.attr.equals(this.dt.groupField)) continue;
            list.setSelectedIndex(list.getItemCount() - 1);
        }
        for (MetadataCol c : this.dt.attributeCols) {
            list.addItem(c.attr, c.attr);
            if (!c.attr.equals(this.dt.groupField)) continue;
            list.setSelectedIndex(list.getItemCount() - 1);
        }
        for (MetadataCol c : this.dt.conditionCols) {
            list.addItem(c.header, c.header);
            if (!c.header.equals(this.dt.groupField)) continue;
            list.setSelectedIndex(list.getItemCount() - 1);
        }
        for (MetadataCol c : this.dt.actionCols) {
            list.addItem(c.header, c.header);
            if (!c.header.equals(this.dt.groupField)) continue;
            list.setSelectedIndex(list.getItemCount() - 1);
        }
        list.addItem(this.constants.none(), "");
        if (this.dt.groupField == null) {
            list.setSelectedIndex(list.getItemCount() - 1);
        }
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)new SmallLabel(this.constants.GroupByColumn()));
        h.add((Widget)list);
        Button ok = new Button(this.constants.Apply());
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        h.add((Widget)ok);
        return h;
    }

    private Widget getActions() {
        this.actionsConfigWidget = new VerticalPanel();
        this.refreshActionsWidget();
        return this.actionsConfigWidget;
    }

    private void refreshActionsWidget() {
        this.actionsConfigWidget.clear();
        for (ActionCol c : this.dt.actionCols) {
            HorizontalPanel hp = new HorizontalPanel();
            hp.add(this.removeAction(c));
            hp.add(this.editAction(c));
            hp.add((Widget)new SmallLabel(c.header));
            this.actionsConfigWidget.add((Widget)hp);
        }
        this.actionsConfigWidget.add(this.newAction());
    }

    private Widget editAction(ActionCol c) {
        return new ImageButton("images/edit.gif", this.constants.EditThisActionColumnConfiguration(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget newAction() {
        return new ImageButton("images/new_item.gif", this.constants.CreateANewActionColumn(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget removeAction(ActionCol c) {
        ImageButton del = new ImageButton("images/delete_item_small.gif", this.constants.RemoveThisActionColumn(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return del;
    }

    private Widget getConditions() {
        this.conditionsConfigWidget = new VerticalPanel();
        this.refreshConditionsWidget();
        return this.conditionsConfigWidget;
    }

    private void refreshConditionsWidget() {
        this.conditionsConfigWidget.clear();
        for (int i = 0; i < this.dt.conditionCols.size(); ++i) {
            ConditionCol c = (ConditionCol)this.dt.conditionCols.get(i);
            HorizontalPanel hp = new HorizontalPanel();
            hp.add(this.removeCondition(c));
            hp.add(this.editCondition(c));
            hp.add((Widget)new SmallLabel(c.header));
            this.conditionsConfigWidget.add((Widget)hp);
        }
        this.conditionsConfigWidget.add(this.newCondition());
    }

    private Widget newCondition() {
        ConditionCol newCol = new ConditionCol();
        newCol.constraintValueType = 1;
        return new ImageButton("images/new_item.gif", this.constants.AddANewConditionColumn(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private Widget editCondition(ConditionCol c) {
        return new ImageButton("images/edit.gif", this.constants.EditThisColumnsConfiguration(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private SuggestionCompletionEngine getSCE() {
        if (this.sce == null) {
            this.sce = SuggestionCompletionCache.getInstance().getEngineFromCache(this.packageName);
        }
        return this.sce;
    }

    private Widget removeCondition(ConditionCol c) {
        ImageButton del = new ImageButton("images/delete_item_small.gif", this.constants.RemoveThisConditionColumn(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return del;
    }

    private Widget getAttributes() {
        this.attributeConfigWidget = new VerticalPanel();
        this.refreshAttributeWidget();
        return this.attributeConfigWidget;
    }

    private void refreshAttributeWidget() {
        HorizontalPanel hp;
        this.attributeConfigWidget.clear();
        this.attributeConfigWidget.add(this.newAttr());
        if (this.dt.getMetadataCols().size() > 0) {
            hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;&nbsp;"));
            hp.add((Widget)new SmallLabel(this.constants.Metadata()));
            this.attributeConfigWidget.add((Widget)hp);
        }
        for (MetadataCol at : this.dt.getMetadataCols()) {
            HorizontalPanel hp2 = new HorizontalPanel();
            hp2.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
            hp2.add(this.removeMeta(at));
            hp2.add((Widget)new SmallLabel(at.attr));
            this.attributeConfigWidget.add((Widget)hp2);
        }
        if (this.dt.attributeCols.size() > 0) {
            hp = new HorizontalPanel();
            hp.add((Widget)new HTML("&nbsp;&nbsp;"));
            hp.add((Widget)new SmallLabel(this.constants.Attributes()));
            this.attributeConfigWidget.add((Widget)hp);
        }
        Iterator i$ = this.dt.attributeCols.iterator();
        while (i$.hasNext()) {
            AttributeCol atc;
            AttributeCol at = atc = (AttributeCol)i$.next();
            HorizontalPanel hp3 = new HorizontalPanel();
            hp3.add((Widget)new SmallLabel(at.attr));
            hp3.add(this.removeAttr(at));
            TextBox defaultValue = new TextBox();
            defaultValue.setText(at.defaultValue);
            defaultValue.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
            hp3.add((Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
            hp3.add((Widget)new SmallLabel(this.constants.DefaultValue()));
            hp3.add((Widget)defaultValue);
            CheckBox hide = new CheckBox();
            hide.setChecked(at.hideColumn);
            hide.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            hp3.add((Widget)hide);
            hp3.add((Widget)new SmallLabel(this.constants.HideThisColumn()));
            this.attributeConfigWidget.add((Widget)hp3);
        }
    }

    private Widget newAttr() {
        ImageButton but = new ImageButton("images/new_item.gif", this.constants.AddANewAttributeMetadata(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        HorizontalPanel h = new HorizontalPanel();
        h.add((Widget)new SmallLabel(this.constants.AddAttributeMetadata()));
        h.add((Widget)but);
        return h;
    }

    private Widget removeAttr(AttributeCol at) {
        ImageButton del = new ImageButton("images/delete_item_small.gif", this.constants.RemoveThisAttribute(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return del;
    }

    private Widget removeMeta(MetadataCol md) {
        ImageButton del = new ImageButton("images/delete_item_small.gif", this.constants.RemoveThisMetadata(), (ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        return del;
    }

    private void scrapeData(int insertCol) {
        Record[] recs = this.grid.getStore().getRecords();
        this.dt.data = new String[recs.length][];
        for (int i = 0; i < recs.length; ++i) {
            int j;
            String[] row;
            Record r = recs[i];
            if (insertCol == -1) {
                row = new String[this.fds.length];
                this.dt.data[i] = row;
                for (j = 0; j < this.fds.length; ++j) {
                    row[j] = r.getAsString(this.fds[j].getName());
                }
                continue;
            }
            row = new String[this.fds.length + 1];
            this.dt.data[i] = row;
            for (j = 0; j < this.fds.length; ++j) {
                if (j < insertCol) {
                    row[j] = r.getAsString(this.fds[j].getName());
                    continue;
                }
                if (j < insertCol) continue;
                row[j + 1] = r.getAsString(this.fds[j].getName());
            }
        }
    }

    private void removeField(String headerName) {
        FieldDef[] fds_ = new FieldDef[this.fds.length - 1];
        int new_i = 0;
        for (int i = 0; i < this.fds.length; ++i) {
            FieldDef fd = this.fds[i];
            if (fd.getName().equals(headerName)) continue;
            fds_[new_i] = fd;
            ++new_i;
        }
        this.fds = fds_;
    }

    private void refreshGrid() {
        if (this.layout.getWidgetCount() > 2) {
            this.layout.remove(2);
        }
        if (this.dt.actionCols.size() == 0 && this.dt.conditionCols.size() == 0 && this.dt.actionCols.size() == 0) {
            VerticalPanel vp = new VerticalPanel();
            vp.setWidth("100%");
            PrettyFormLayout pfl = new PrettyFormLayout();
            pfl.startSection();
            pfl.addRow((Widget)new HTML("<img src='images/information.gif'/>&nbsp;" + this.constants.ConfigureColumnsNote()));
            pfl.endSection();
            vp.add((Widget)pfl);
            this.grid = this.doGrid();
            vp.add((Widget)this.grid);
            this.layout.add((Widget)vp);
        } else {
            this.grid = this.doGrid();
            this.layout.add((Widget)this.grid);
        }
    }

    private GridPanel doGrid() {
        ConditionCol c;
        MetadataCol attr;
        int i;
        this.fds = new FieldDef[this.dt.getMetadataCols().size() + this.dt.attributeCols.size() + this.dt.actionCols.size() + this.dt.conditionCols.size() + 2];
        this.colMap = new HashMap();
        this.fds[0] = new IntegerFieldDef("num");
        this.fds[1] = new StringFieldDef("desc");
        int colCount = 0;
        BaseColumnConfig[] cols = new BaseColumnConfig[this.fds.length];
        cols[0] = new /* Unavailable Anonymous Inner Class!! */;
        ++colCount;
        cols[1] = new /* Unavailable Anonymous Inner Class!! */;
        ++colCount;
        for (i = 0; i < this.dt.getMetadataCols().size(); ++i) {
            attr = (MetadataCol)this.dt.getMetadataCols().get(i);
            this.fds[colCount] = new StringFieldDef(attr.attr);
            cols[colCount] = new /* Unavailable Anonymous Inner Class!! */;
            this.colMap.put(attr.attr, attr);
            ++colCount;
        }
        for (i = 0; i < this.dt.attributeCols.size(); ++i) {
            attr = (AttributeCol)this.dt.attributeCols.get(i);
            this.fds[colCount] = new StringFieldDef(attr.attr);
            cols[colCount] = new /* Unavailable Anonymous Inner Class!! */;
            this.colMap.put(attr.attr, attr);
            ++colCount;
        }
        for (i = 0; i < this.dt.conditionCols.size(); ++i) {
            c = (ConditionCol)this.dt.conditionCols.get(i);
            this.fds[colCount] = new StringFieldDef(c.header);
            cols[colCount] = new /* Unavailable Anonymous Inner Class!! */;
            this.colMap.put(c.header, c);
            ++colCount;
        }
        for (i = 0; i < this.dt.actionCols.size(); ++i) {
            c = (ActionCol)this.dt.actionCols.get(i);
            this.fds[colCount] = new StringFieldDef(c.header);
            cols[colCount] = new /* Unavailable Anonymous Inner Class!! */;
            this.colMap.put(c.header, c);
            ++colCount;
        }
        this.recordDef = new RecordDef(this.fds);
        ArrayReader reader = new ArrayReader(this.recordDef);
        MemoryProxy proxy = new MemoryProxy((Object[][])this.dt.data);
        ColumnModel cm = new ColumnModel(cols);
        this.store = new GroupingStore();
        this.store.setReader((Reader)reader);
        this.store.setDataProxy((DataProxy)proxy);
        this.store.setSortInfo(new SortState("num", SortDir.ASC));
        if (this.dt.groupField != null) {
            this.store.setGroupField(this.dt.groupField);
        }
        cm.addListener((ColumnModelListener)new /* Unavailable Anonymous Inner Class!! */);
        this.store.load();
        GridPanel grid = new GridPanel((Store)this.store, cm);
        grid.setStripeRows(true);
        grid.addGridColumnListener((GridColumnListener)new /* Unavailable Anonymous Inner Class!! */);
        GroupingView gv = new GroupingView();
        gv.setForceFit(true);
        gv.setGroupTextTpl("{text} ({[values.rs.length]} {[values.rs.length > 1 ? \"" + this.constants.Items() + "\" : \"" + this.constants.Item() + "\"]})");
        grid.setView((GridView)gv);
        grid.setStore((Store)this.store);
        int width = 900;
        if (cm.getColumnCount() > 10) {
            width = 900 + 90 * (cm.getColumnCount() - 10);
        }
        grid.setWidth(width);
        grid.setHeight(500);
        grid.addGridCellListener((GridCellListener)new /* Unavailable Anonymous Inner Class!! */);
        grid.addGridColumnListener((GridColumnListener)new /* Unavailable Anonymous Inner Class!! */);
        return grid;
    }

    private ToolbarMenuButton getToolbarMenuButton() {
        Menu menu = new Menu();
        menu.addItem((BaseItem)new Item(this.constants.AddRow(), (BaseItemListener)new /* Unavailable Anonymous Inner Class!! */));
        menu.addItem((BaseItem)new Item(this.constants.AddRowBeforeSelectedRow(), (BaseItemListener)new /* Unavailable Anonymous Inner Class!! */));
        menu.addItem((BaseItem)new Item(this.constants.RemoveSelectedRowS(), (BaseItemListener)new /* Unavailable Anonymous Inner Class!! */));
        menu.addItem((BaseItem)new Item(this.constants.CopySelectedRowS(), (BaseItemListener)new /* Unavailable Anonymous Inner Class!! */));
        ToolbarMenuButton tbb = new ToolbarMenuButton(this.constants.Modify(), menu);
        return tbb;
    }

    private void showDropDownEditor(EventObject e, String dataIdx, Record r, String val, String[] vals) {
        Window w = new Window();
        w.setWidth(200);
        w.setPlain(true);
        w.setBodyBorder(false);
        w.setAutoDestroy(true);
        w.setTitle(dataIdx);
        ListBox drop = new ListBox();
        for (int i = 0; i < vals.length; ++i) {
            String v = vals[i].trim();
            if (v.indexOf(61) > 0) {
                String[] splut = ConstraintValueEditorHelper.splitValue((String)v);
                drop.addItem(splut[1], splut[0]);
                if (!splut[0].equals(val)) continue;
                drop.setSelectedIndex(i);
                continue;
            }
            drop.addItem(v, v);
            if (!v.equals(val)) continue;
            drop.setSelectedIndex(i);
        }
        drop.addKeyboardListener((KeyboardListener)new /* Unavailable Anonymous Inner Class!! */);
        Panel p = new Panel();
        p.add((Widget)drop);
        w.add((Component)p);
        w.setBorder(false);
        Button ok = new Button(this.constants.OK());
        ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        p.add((Widget)ok);
        w.setPosition(e.getPageX(), e.getPageY());
        w.show();
    }

    private void renumber(Record[] rs) {
        for (int i = 0; i < rs.length; ++i) {
            rs[i].set("num", "" + (i + 1));
        }
    }

    private void showTextEditor(EventObject e, String dta, Record r, String val, DTColumnConfig colConf) {
        Window w = new Window();
        w.setWidth(200);
        w.setAutoDestroy(true);
        w.setPlain(true);
        w.setBodyBorder(false);
        w.setTitle(dta);
        String typeDescription = this.dt.getType(colConf, this.getSCE());
        Panel p = new Panel();
        if (typeDescription != null && typeDescription.equals("Date")) {
            DatePickerTextBox datePicker = new DatePickerTextBox(val);
            String m = Format.format((String)((Constants)GWT.create(Constants.class)).ValueFor0(), (String)dta);
            datePicker.setTitle(m);
            datePicker.addValueChanged((ValueChanged)new /* Unavailable Anonymous Inner Class!! */);
            p.add((Widget)datePicker);
            p.add((Widget)new InfoPopup(this.constants.CategoryParentRules(), Format.format((String)this.constants.FillInColumnWithValue(), (String)typeDescription)));
            w.add((Component)p);
            w.setBorder(false);
            Button ok = new Button(this.constants.OK());
            ok.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            p.add((Widget)ok);
        } else {
            TextBox box = new TextBox();
            box.setText(val);
            box.addKeyboardListener((KeyboardListener)new /* Unavailable Anonymous Inner Class!! */);
            if (this.dt.isNumeric(colConf, this.getSCE())) {
                box.addKeyboardListener(ActionValueEditor.getNumericFilter((TextBox)box));
            }
            p.add((Widget)box);
            if (typeDescription != null) {
                p.add((Widget)new InfoPopup(this.constants.CategoryParentRules(), Format.format((String)this.constants.FillInColumnWithValue(), (String)typeDescription)));
            }
            w.add((Component)p);
            w.setBorder(false);
            Button ok = new Button(this.constants.OK());
            ok.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
            p.add((Widget)ok);
        }
        w.setPosition(e.getPageX(), e.getPageY());
        w.show();
    }

    public void onSave() {
        String[] fields = this.store.getFields();
        for (int i = 0; i < fields.length; ++i) {
            System.out.print(fields[i] + " | ");
        }
        this.scrapeData(-1);
    }

    public void onAfterSave() {
    }

    private void changeRowPositions(Record from, Record to) {
        int fromNum = from.getAsInteger("num");
        int toNum = to.getAsInteger("num");
        from.set("num", toNum);
        to.set("num", fromNum);
        this.scrapeData(-1);
        this.refreshGrid();
    }

    static /* synthetic */ GuidedDecisionTable access$000(GuidedDecisionTableWidget x0) {
        return x0.dt;
    }

    static /* synthetic */ void access$100(GuidedDecisionTableWidget x0, int x1) {
        x0.scrapeData(x1);
    }

    static /* synthetic */ void access$200(GuidedDecisionTableWidget x0) {
        x0.refreshGrid();
    }

    static /* synthetic */ SuggestionCompletionEngine access$300(GuidedDecisionTableWidget x0) {
        return x0.getSCE();
    }

    static /* synthetic */ void access$400(GuidedDecisionTableWidget x0) {
        x0.refreshActionsWidget();
    }

    static /* synthetic */ Constants access$500(GuidedDecisionTableWidget x0) {
        return x0.constants;
    }

    static /* synthetic */ void access$700(GuidedDecisionTableWidget x0, String x1) {
        x0.removeField(x1);
    }

    static /* synthetic */ void access$800(GuidedDecisionTableWidget x0) {
        x0.refreshConditionsWidget();
    }

    static /* synthetic */ void access$900(GuidedDecisionTableWidget x0) {
        x0.refreshAttributeWidget();
    }

    static /* synthetic */ Map access$1000(GuidedDecisionTableWidget x0) {
        return x0.colMap;
    }

    static /* synthetic */ GridPanel access$1100(GuidedDecisionTableWidget x0) {
        return x0.doGrid();
    }

    static /* synthetic */ GroupingStore access$1200(GuidedDecisionTableWidget x0) {
        return x0.store;
    }

    static /* synthetic */ void access$1300(GuidedDecisionTableWidget x0, EventObject x1, String x2, Record x3, String x4, DTColumnConfig x5) {
        x0.showTextEditor(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ void access$1400(GuidedDecisionTableWidget x0, EventObject x1, String x2, Record x3, String x4, String[] x5) {
        x0.showDropDownEditor(x1, x2, x3, x4, x5);
    }

    static /* synthetic */ GridPanel access$1500(GuidedDecisionTableWidget x0) {
        return x0.grid;
    }

    static /* synthetic */ void access$1600(GuidedDecisionTableWidget x0, Record[] x1) {
        x0.renumber(x1);
    }

    static /* synthetic */ FieldDef[] access$1700(GuidedDecisionTableWidget x0) {
        return x0.fds;
    }
}

