/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.explorer;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.History;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.core.Ext;
import com.gwtext.client.core.Margins;
import com.gwtext.client.core.RegionPosition;
import com.gwtext.client.util.Format;
import com.gwtext.client.widgets.Button;
import com.gwtext.client.widgets.Component;
import com.gwtext.client.widgets.Panel;
import com.gwtext.client.widgets.TabPanel;
import com.gwtext.client.widgets.event.ButtonListener;
import com.gwtext.client.widgets.event.PanelListener;
import com.gwtext.client.widgets.event.TabPanelListener;
import com.gwtext.client.widgets.layout.BorderLayoutData;
import com.gwtext.client.widgets.layout.LayoutData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.explorer.ExplorerViewCenterPanel;
import org.drools.guvnor.client.explorer.MultiKeyMap;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.PackageEditor;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.SnapshotInfo;
import org.drools.guvnor.client.ruleeditor.GuvnorEditor;
import org.drools.guvnor.client.ruleeditor.MultiViewEditor;
import org.drools.guvnor.client.ruleeditor.MultiViewRow;
import org.drools.guvnor.client.rulelist.EditItemEvent;
import org.drools.guvnor.client.rulelist.QueryWidget;

public class ExplorerViewCenterPanel {
    final TabPanel tp;
    private MultiKeyMap<Panel> openedTabs = new MultiKeyMap();
    private String id = Ext.generateId();
    private BorderLayoutData centerLayoutData;
    private Map<String, GuvnorEditor> openedAssetEditors = new HashMap();
    private Map<String, PackageEditor> openedPackageEditors = new HashMap();
    private Button closeAllButton;
    private Constants constants = (Constants)GWT.create(Constants.class);

    public ExplorerViewCenterPanel() {
        this.tp = new TabPanel();
        this.tp.setBodyBorder(false);
        this.tp.setEnableTabScroll(true);
        this.tp.setAutoDestroy(true);
        this.tp.setResizeTabs(true);
        this.tp.setLayoutOnTabChange(true);
        this.tp.setActiveTab(0);
        this.tp.setEnableTabScroll(true);
        this.tp.setMinTabWidth(90);
        this.centerLayoutData = new BorderLayoutData(RegionPosition.CENTER);
        this.centerLayoutData.setMargins(new Margins(5, 0, 5, 5));
        this.tp.addListener((TabPanelListener)new /* Unavailable Anonymous Inner Class!! */);
        this.addCloseAllButton();
    }

    private void addCloseAllButton() {
        this.closeAllButton = new Button(this.constants.CloseAllItems());
        this.closeAllButton.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        this.tp.addButton(this.closeAllButton);
    }

    public TabPanel getPanel() {
        return this.tp;
    }

    public void addTab(String tabname, boolean closeable, Widget widget, String key) {
        this.addTab(tabname, closeable, widget, new String[]{key});
    }

    public void addTab(String tabname, boolean closeable, Widget widget, String[] keys) {
        String panelId = keys.length == 1 ? keys[0] + this.id : Arrays.toString(keys) + this.id;
        Panel localTP = new Panel();
        localTP.setClosable(closeable);
        localTP.setTitle(tabname);
        localTP.setId(panelId);
        localTP.setAutoScroll(true);
        localTP.add(widget);
        this.tp.add((Component)localTP, (LayoutData)this.centerLayoutData);
        localTP.addListener((PanelListener)new /* Unavailable Anonymous Inner Class!! */);
        if (widget instanceof GuvnorEditor) {
            this.openedAssetEditors.put(panelId, (GuvnorEditor)widget);
        } else if (widget instanceof PackageEditor) {
            this.openedPackageEditors.put(tabname, (PackageEditor)widget);
        }
        this.tp.activate(localTP.getId());
        this.openedTabs.put(keys, (Object)localTP);
    }

    public boolean showIfOpen(String key) {
        if (this.openedTabs.containsKey(key)) {
            LoadingPopup.close();
            Panel tpi = (Panel)this.openedTabs.get(key);
            this.tp.activate(tpi.getId());
            return true;
        }
        return false;
    }

    public void close(String key) {
        this.tp.remove(key + this.id);
        Panel p = (Panel)this.openedTabs.remove(key);
        if (p != null) {
            p.destroy();
        }
    }

    public void openAsset(String uuid) {
        if (uuid.contains("<")) {
            return;
        }
        History.newItem((String)("asset=" + uuid));
        if (!this.showIfOpen(uuid)) {
            boolean[] loading = new boolean[]{true};
            4 t = new /* Unavailable Anonymous Inner Class!! */;
            t.schedule(200);
            RepositoryServiceFactory.getService().loadRuleAsset(uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void openAssets(MultiViewRow[] rows) {
        String blockingAssetName = null;
        String[] uuids = new String[rows.length];
        Object[] names = new String[rows.length];
        for (int i = 0; i < rows.length; ++i) {
            if (this.showIfOpen(rows[i].uuid)) {
                blockingAssetName = rows[i].name;
                break;
            }
            uuids[i] = rows[i].uuid;
            names[i] = rows[i].name;
        }
        if (blockingAssetName != null) {
            FormStylePopup popup = new FormStylePopup("images/information.gif", Format.format((String)this.constants.Asset0IsAlreadyOpenPleaseCloseItBeforeOpeningMultiview(), blockingAssetName));
            popup.show();
            return;
        }
        MultiViewEditor multiview = new MultiViewEditor(rows, (EditItemEvent)new /* Unavailable Anonymous Inner Class!! */);
        multiview.setCloseCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        this.addTab(Arrays.toString(names), true, (Widget)multiview, uuids);
    }

    public void openPackageEditor(String uuid, Command refPackageList) {
        if (!this.showIfOpen(uuid)) {
            LoadingPopup.showMessage((String)this.constants.LoadingPackageInformation());
            RepositoryServiceFactory.getService().loadPackageConfig(uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void openFind() {
        if (!this.showIfOpen("FIND")) {
            this.addTab(this.constants.Find(), true, (Widget)new QueryWidget((EditItemEvent)new /* Unavailable Anonymous Inner Class!! */), "FIND");
        }
    }

    public void openSnapshot(SnapshotInfo snap) {
        if (!this.showIfOpen(snap.name + snap.uuid)) {
            LoadingPopup.showMessage((String)this.constants.LoadingSnapshot());
            RepositoryServiceFactory.getService().loadPackageConfig(snap.uuid, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ Map access$000(ExplorerViewCenterPanel x0) {
        return x0.openedAssetEditors;
    }

    static /* synthetic */ Constants access$100(ExplorerViewCenterPanel x0) {
        return x0.constants;
    }

    static /* synthetic */ Map access$200(ExplorerViewCenterPanel x0) {
        return x0.openedPackageEditors;
    }

    static /* synthetic */ MultiKeyMap access$300(ExplorerViewCenterPanel x0) {
        return x0.openedTabs;
    }
}

