/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.DirtyableVerticalPane;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.CompositeFactPatternWidget;
import org.drools.guvnor.client.modeldriven.ui.FactPatternWidget;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.CompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;

public class CompositeFactPatternWidget
extends RuleModellerWidget {
    protected final SuggestionCompletionEngine completions;
    protected CompositeFactPattern pattern;
    protected DirtyableFlexTable layout;
    protected Constants constants = (Constants)GWT.create(Constants.class);
    protected boolean readOnly;
    private List<FactPatternWidget> childWidgets;

    public CompositeFactPatternWidget(RuleModeller modeller, CompositeFactPattern pattern) {
        this(modeller, pattern, null);
    }

    public CompositeFactPatternWidget(RuleModeller modeller, CompositeFactPattern pattern, Boolean readOnly) {
        super(modeller);
        this.completions = modeller.getSuggestionCompletions();
        this.pattern = pattern;
        this.layout = new DirtyableFlexTable();
        this.layout.setStyleName("model-builderInner-Background");
        if (readOnly != null) {
            this.readOnly = readOnly;
        } else {
            this.readOnly = false;
            if (this.pattern != null && this.pattern.patterns != null) {
                for (int i = 0; i < this.pattern.patterns.length; ++i) {
                    FactPattern factPattern = this.pattern.patterns[i];
                    if (this.completions.containsFactType(factPattern.factType)) continue;
                    this.readOnly = true;
                    break;
                }
            }
        }
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    protected void doLayout() {
        this.childWidgets = new ArrayList();
        this.layout.setWidget(0, 0, this.getCompositeLabel());
        this.layout.getFlexCellFormatter().setColSpan(0, 0, 2);
        this.layout.setWidget(1, 0, (Widget)new HTML("&nbsp;&nbsp;&nbsp;&nbsp;"));
        if (this.pattern.patterns != null) {
            DirtyableVerticalPane vert = new DirtyableVerticalPane();
            FactPattern[] facts = this.pattern.patterns;
            for (int i = 0; i < facts.length; ++i) {
                FactPatternWidget factPatternWidget = new FactPatternWidget(this.getModeller(), (IPattern)facts[i], false, Boolean.valueOf(this.readOnly));
                factPatternWidget.addOnModifiedCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
                this.childWidgets.add(factPatternWidget);
                vert.add((Widget)factPatternWidget);
            }
            this.layout.setWidget(1, 1, (Widget)vert);
        }
    }

    protected Widget getCompositeLabel() {
        2 click = new /* Unavailable Anonymous Inner Class!! */;
        String lbl = HumanReadable.getCEDisplayName((String)this.pattern.type);
        if (this.pattern.patterns == null || this.pattern.patterns.length == 0) {
            lbl = lbl + " <font color='red'>" + this.constants.clickToAddPatterns() + "</font>";
        }
        return new ClickableLabel(lbl + ":", (ClickListener)click, !this.readOnly);
    }

    protected void showFactTypeSelector(Widget w) {
        ListBox box = new ListBox();
        String[] facts = this.completions.getFactTypes();
        box.addItem(this.constants.Choose());
        for (int i = 0; i < facts.length; ++i) {
            box.addItem(facts[i]);
        }
        box.setSelectedIndex(0);
        FormStylePopup popup = new FormStylePopup();
        popup.setTitle(this.constants.NewFactPattern());
        popup.addAttribute(this.constants.chooseFactType(), (Widget)box);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

