/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import org.drools.guvnor.client.common.ClickableLabel;
import org.drools.guvnor.client.common.DirtyableFlexTable;
import org.drools.guvnor.client.common.DirtyableHorizontalPane;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.ImageButton;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.HumanReadable;
import org.drools.guvnor.client.modeldriven.ui.ExpressionBuilder;
import org.drools.guvnor.client.modeldriven.ui.FactPatternWidget;
import org.drools.guvnor.client.modeldriven.ui.FromCompositeFactPatternWidget;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.modeldriven.ui.RuleModellerWidget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.FromCompositeFactPattern;
import org.drools.ide.common.client.modeldriven.brl.IPattern;

public class FromCompositeFactPatternWidget
extends RuleModellerWidget {
    protected FromCompositeFactPattern pattern;
    protected DirtyableFlexTable layout;
    protected Constants constants = (Constants)GWT.create(Constants.class);
    protected boolean readOnly;
    private FactPatternWidget factPatternWidget;
    private ExpressionBuilder expressionBuilder;

    public FromCompositeFactPatternWidget(RuleModeller modeller, FromCompositeFactPattern pattern) {
        this(modeller, pattern, null);
    }

    public FromCompositeFactPatternWidget(RuleModeller modeller, FromCompositeFactPattern pattern, Boolean readOnly) {
        super(modeller);
        this.pattern = pattern;
        if (readOnly == null) {
            this.calculateReadOnly();
        } else {
            this.readOnly = readOnly;
        }
        this.layout = new DirtyableFlexTable();
        if (this.readOnly) {
            this.layout.addStyleName("editor-disabled-widget");
        }
        this.layout.addStyleName("model-builderInner-Background");
        this.doLayout();
        this.initWidget((Widget)this.layout);
    }

    protected void doLayout() {
        FactPattern fact;
        int r = 0;
        if (this.pattern.getFactPattern() != null && (fact = this.pattern.getFactPattern()) != null) {
            if (this.readOnly) {
                this.factPatternWidget = new FactPatternWidget(this.getModeller(), (IPattern)fact, false, Boolean.valueOf(true));
                this.layout.setWidget(r, 0, (Widget)this.factPatternWidget);
            } else {
                this.factPatternWidget = new FactPatternWidget(this.getModeller(), (IPattern)fact, true, Boolean.valueOf(false));
                this.factPatternWidget.addOnModifiedCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
                this.layout.setWidget(r, 0, this.addRemoveButton((Widget)this.factPatternWidget, (ClickListener)new /* Unavailable Anonymous Inner Class!! */));
            }
            ++r;
        }
        this.layout.setWidget(r, 0, this.getCompositeLabel());
    }

    protected Widget getCompositeLabel() {
        3 click = new /* Unavailable Anonymous Inner Class!! */;
        String lbl = "<div class='x-form-field'>" + HumanReadable.getCEDisplayName((String)"from") + "</div>";
        DirtyableFlexTable panel = new DirtyableFlexTable();
        int r = 0;
        if (this.pattern.getFactPattern() == null) {
            panel.setWidget(r, 0, (Widget)new ClickableLabel("<br> <font color='red'>" + this.constants.clickToAddPatterns() + "</font>", (ClickListener)click, !this.readOnly));
            ++r;
        }
        panel.setWidget(r, 0, (Widget)new HTML(lbl));
        this.expressionBuilder = new ExpressionBuilder(this.getModeller(), this.pattern.getExpression(), Boolean.valueOf(this.readOnly));
        this.expressionBuilder.addOnModifiedCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        panel.setWidget(r, 1, (Widget)this.expressionBuilder);
        return panel;
    }

    protected void showFactTypeSelector(Widget w) {
        SuggestionCompletionEngine completions = this.getModeller().getSuggestionCompletions();
        ListBox box = new ListBox();
        String[] facts = completions.getFactTypes();
        box.addItem(this.constants.Choose());
        for (int i = 0; i < facts.length; ++i) {
            box.addItem(facts[i]);
        }
        box.setSelectedIndex(0);
        FormStylePopup popup = new FormStylePopup();
        popup.setTitle(this.constants.NewFactPattern());
        popup.addAttribute(this.constants.chooseFactType(), (Widget)box);
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        popup.show();
    }

    protected Widget addRemoveButton(Widget w, ClickListener listener) {
        DirtyableHorizontalPane horiz = new DirtyableHorizontalPane();
        ImageButton remove = new ImageButton("images/delete_item_small.gif");
        remove.setTitle(this.constants.RemoveThisBlockOfData());
        remove.addClickListener(listener);
        horiz.setWidth("100%");
        w.setWidth("100%");
        horiz.add(w);
        if (!this.readOnly) {
            horiz.add((Widget)remove);
        }
        return horiz;
    }

    public boolean isDirty() {
        return this.layout.hasDirty();
    }

    protected void calculateReadOnly() {
        if (this.pattern.factPattern != null) {
            this.readOnly = !this.getModeller().getSuggestionCompletions().containsFactType(this.pattern.factPattern.factType);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }
}

