/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.qa;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ChangeListener;
import com.google.gwt.user.client.ui.ClickListener;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.util.Format;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.DropDownValueChanged;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.ActionValueEditor;
import org.drools.guvnor.client.modeldriven.ui.DatePickerTextBox;
import org.drools.guvnor.client.modeldriven.ui.EnumDropDown;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.testing.ExecutionTrace;
import org.drools.ide.common.client.modeldriven.testing.FactData;
import org.drools.ide.common.client.modeldriven.testing.Scenario;
import org.drools.ide.common.client.modeldriven.testing.VerifyField;

/*
 * Exception performing whole class analysis ignored.
 */
public class VerifyFieldConstraintEditor
extends DirtyableComposite {
    private String factType;
    private VerifyField field;
    private final Panel panel;
    private Scenario scenario;
    private SuggestionCompletionEngine sce;
    private ValueChanged callback;
    private Constants constants = (Constants)GWT.create(Constants.class);
    private ExecutionTrace executionTrace;

    public VerifyFieldConstraintEditor(String factType, ValueChanged callback, VerifyField field, SuggestionCompletionEngine sce, Scenario scenario, ExecutionTrace executionTrace) {
        this.field = field;
        this.sce = sce;
        this.factType = factType;
        this.callback = callback;
        this.scenario = scenario;
        this.executionTrace = executionTrace;
        this.panel = new SimplePanel();
        this.refreshEditor();
        this.initWidget((Widget)this.panel);
    }

    private void refreshEditor() {
        String key = this.factType + "." + this.field.fieldName;
        String flType = this.sce.getFieldType(key);
        this.panel.clear();
        if (flType.equals("Numeric")) {
            TextBox box = VerifyFieldConstraintEditor.editableTextBox((ValueChanged)this.callback, (String)this.field.fieldName, (String)this.field.expected);
            box.addKeyboardListener(ActionValueEditor.getNumericFilter((TextBox)box));
            this.panel.add((Widget)box);
        } else if (flType.equals("Boolean")) {
            String[] c = new String[]{"true", "false"};
            this.panel.add((Widget)new EnumDropDown(this.field.expected, (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, DropDownData.create((String[])c)));
        } else if (flType != null && flType.equals("Date")) {
            DatePickerTextBox datePicker = new DatePickerTextBox(this.field.expected);
            String m = Format.format((String)((Constants)GWT.create(Constants.class)).ValueFor0(), (String)this.field.fieldName);
            datePicker.setTitle(m);
            datePicker.addValueChanged((ValueChanged)new /* Unavailable Anonymous Inner Class!! */);
            this.panel.add((Widget)datePicker);
        } else {
            String[] enums = this.sce.getDataEnumList(key);
            if (enums != null) {
                this.panel.add((Widget)new EnumDropDown(this.field.expected, (DropDownValueChanged)new /* Unavailable Anonymous Inner Class!! */, DropDownData.create((String[])enums)));
            } else {
                if (this.field.expected != null && this.field.expected.length() > 0 && this.field.nature == 0L) {
                    this.field.nature = this.field.expected.charAt(0) == '=' ? 2L : 1L;
                }
                if (this.field.nature == 0L && this.isThereABoundVariableToSet()) {
                    Image clickme = new Image("images/edit.gif");
                    clickme.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
                    this.panel.add((Widget)clickme);
                } else if (this.field.nature == 2L) {
                    this.panel.add(this.variableEditor());
                } else {
                    this.panel.add((Widget)VerifyFieldConstraintEditor.editableTextBox((ValueChanged)this.callback, (String)this.field.fieldName, (String)this.field.expected));
                }
            }
        }
    }

    private Widget variableEditor() {
        List vars = this.scenario.getFactNamesInScope(this.executionTrace, true);
        ListBox box = new ListBox();
        if (this.field.expected == null) {
            box.addItem(this.constants.Choose());
        }
        int j = 0;
        for (int i = 0; i < vars.size(); ++i) {
            String var = (String)vars.get(i);
            Map m = this.scenario.getVariableTypes();
            FactData f = (FactData)this.scenario.getFactTypes().get(var);
            String fieldType = this.sce.getFieldType(this.factType, this.field.fieldName);
            if (!f.type.equals(fieldType)) continue;
            if (box.getItemCount() == 0) {
                box.addItem("...");
                ++j;
            }
            box.addItem("=" + var);
            if (this.field.expected != null && this.field.expected.equals("=" + var)) {
                box.setSelectedIndex(j);
            }
            ++j;
        }
        box.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private static TextBox editableTextBox(ValueChanged changed, String fieldName, String initialValue) {
        TextBox tb = new TextBox();
        tb.setText(initialValue);
        String m = Format.format((String)((Constants)GWT.create(Constants.class)).ValueFor0(), (String)fieldName);
        tb.setTitle(m);
        tb.addChangeListener((ChangeListener)new /* Unavailable Anonymous Inner Class!! */);
        return tb;
    }

    private void showTypeChoice(Widget w, VerifyField con) {
        FormStylePopup form = new FormStylePopup("images/newex_wiz.gif", this.constants.FieldValue());
        Button lit = new Button(this.constants.LiteralValue());
        lit.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.LiteralValue() + ":", (Widget)this.widgets((Widget)lit, (Widget)new InfoPopup(this.constants.LiteralValue(), this.constants.LiteralValTip())));
        form.addRow((Widget)new HTML("<hr/>"));
        form.addRow((Widget)new SmallLabel(this.constants.AdvancedOptions()));
        Button variable = new Button(this.constants.BoundVariable());
        variable.addClickListener((ClickListener)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.AVariable(), (Widget)this.widgets((Widget)variable, (Widget)new InfoPopup(this.constants.ABoundVariable(), this.constants.BoundVariableTip())));
        form.show();
    }

    private boolean isThereABoundVariableToSet() {
        boolean retour = false;
        List vars = this.scenario.getFactNamesInScope(this.executionTrace, true);
        if (vars.size() > 0) {
            for (int i = 0; i < vars.size(); ++i) {
                String var = (String)vars.get(i);
                Map m = this.scenario.getVariableTypes();
                FactData f = (FactData)this.scenario.getFactTypes().get(var);
                String fieldType = this.sce.getFieldType(this.factType, this.field.fieldName);
                if (!f.type.equals(fieldType)) continue;
                retour = true;
                break;
            }
        }
        return retour;
    }

    private void doTypeChosen(FormStylePopup form) {
        this.refreshEditor();
        form.hide();
    }

    private Panel widgets(Widget left, Widget right) {
        HorizontalPanel panel = new HorizontalPanel();
        panel.add(left);
        panel.add(right);
        panel.setWidth("100%");
        return panel;
    }

    static /* synthetic */ ValueChanged access$000(VerifyFieldConstraintEditor x0) {
        return x0.callback;
    }

    static /* synthetic */ VerifyField access$100(VerifyFieldConstraintEditor x0) {
        return x0.field;
    }

    static /* synthetic */ void access$200(VerifyFieldConstraintEditor x0, Widget x1, VerifyField x2) {
        x0.showTypeChoice(x1, x2);
    }

    static /* synthetic */ void access$300(VerifyFieldConstraintEditor x0, FormStylePopup x1) {
        x0.doTypeChosen(x1);
    }
}

