/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.ruleeditor;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ScrollPanel;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.gwtext.client.widgets.Toolbar;
import com.gwtext.client.widgets.ToolbarButton;
import com.gwtext.client.widgets.event.ButtonListener;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.LoadingPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.explorer.ExplorerLayoutManager;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.packages.PackageBuilderWidget;
import org.drools.guvnor.client.rpc.BuilderResult;
import org.drools.guvnor.client.rpc.BuilderResultLine;
import org.drools.guvnor.client.rpc.RepositoryServiceFactory;
import org.drools.guvnor.client.rpc.RuleAsset;
import org.drools.guvnor.client.ruleeditor.SaveEventListener;
import org.drools.guvnor.client.security.Capabilities;

public class RuleValidatorWrapper
extends DirtyableComposite
implements SaveEventListener {
    private RuleAsset asset;
    private VerticalPanel layout = new VerticalPanel();
    private Widget editor;
    private static Constants constants = (Constants)GWT.create(Constants.class);

    public RuleValidatorWrapper(Widget editor, RuleAsset asset) {
        this.asset = asset;
        this.editor = editor;
        this.layout.add(editor);
        if (!asset.isreadonly) {
            this.validatorActions();
        }
        this.layout.setWidth("100%");
        this.layout.setHeight("100%");
        this.initWidget((Widget)this.layout);
    }

    private void validatorActions() {
        Toolbar tb = new Toolbar();
        this.layout.setCellHeight(this.editor, "95%");
        this.layout.add((Widget)tb);
        ToolbarButton viewSource = new ToolbarButton();
        viewSource.setText(constants.ViewSource());
        viewSource.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        if (ExplorerLayoutManager.shouldShow((Integer[])new Integer[]{Capabilities.SHOW_PACKAGE_VIEW})) {
            tb.addButton(viewSource);
            tb.addSeparator();
        }
        ToolbarButton validate = new ToolbarButton();
        validate.setText(constants.Validate());
        validate.addListener((ButtonListener)new /* Unavailable Anonymous Inner Class!! */);
        tb.addButton(validate);
    }

    private void doValidate() {
        this.onSave();
        LoadingPopup.showMessage((String)constants.ValidatingItemPleaseWait());
        RepositoryServiceFactory.getService().buildAsset(this.asset, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void doViewsource() {
        this.onSave();
        LoadingPopup.showMessage((String)constants.CalculatingSource());
        RepositoryServiceFactory.getService().buildAssetSource(this.asset, (AsyncCallback)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void showSource(String src) {
        PackageBuilderWidget.showSource((String)src, (String)this.asset.metaData.name);
        LoadingPopup.close();
    }

    public static void showBuilderErrors(BuilderResult result) {
        if (result == null || result.lines == null || result.lines.length == 0) {
            FormStylePopup pop = new FormStylePopup();
            pop.setWidth(200);
            pop.setTitle(constants.ValidationResultsDotDot());
            HorizontalPanel h = new HorizontalPanel();
            h.add((Widget)new SmallLabel("<img src='images/tick_green.gif'/><i>" + constants.ItemValidatedSuccessfully() + "</i>"));
            pop.addRow((Widget)h);
            pop.show();
        } else {
            FormStylePopup pop = new FormStylePopup("images/package_builder.png", constants.ValidationResults());
            FlexTable errTable = new FlexTable();
            errTable.setStyleName("build-Results");
            for (int i = 0; i < result.lines.length; ++i) {
                int row = i;
                BuilderResultLine res = result.lines[i];
                errTable.setWidget(row, 0, (Widget)new Image("images/error.gif"));
                if (res.assetFormat.equals("package")) {
                    errTable.setText(row, 1, constants.packageConfigurationProblem() + res.message);
                    continue;
                }
                errTable.setText(row, 1, "[" + res.assetName + "] " + res.message);
            }
            ScrollPanel scroll = new ScrollPanel((Widget)errTable);
            scroll.setWidth("100%");
            pop.addRow((Widget)scroll);
            pop.show();
        }
        LoadingPopup.close();
    }

    public void onSave() {
        if (this.editor instanceof SaveEventListener) {
            SaveEventListener el = (SaveEventListener)this.editor;
            el.onSave();
        }
    }

    public void onAfterSave() {
        if (this.editor instanceof SaveEventListener) {
            SaveEventListener el = (SaveEventListener)this.editor;
            el.onAfterSave();
        }
    }

    static /* synthetic */ void access$000(RuleValidatorWrapper x0) {
        x0.doViewsource();
    }

    static /* synthetic */ void access$100(RuleValidatorWrapper x0) {
        x0.doValidate();
    }

    static /* synthetic */ void access$200(RuleValidatorWrapper x0, String x1) {
        x0.showSource(x1);
    }
}

