/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.server.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.DrlParser;
import org.drools.compiler.DroolsParserException;
import org.drools.guvnor.server.util.ClassicDRLImporter;
import org.drools.lang.descr.RuleDescr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class ClassicDRLImporter {
    private String source;
    private String packageName;
    private List<Asset> assets = new ArrayList();
    private StringBuffer header;
    private boolean usesDSL;
    private static Pattern functionPattern = Pattern.compile("function\\s+.*\\s+(.*)\\(.*\\).*");

    public ClassicDRLImporter(InputStream in) throws IOException, DroolsParserException {
        String line = "";
        StringBuffer drl = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(in));
        while ((line = reader.readLine()) != null) {
            drl.append("\n" + line);
        }
        this.source = drl.toString();
        this.parse();
    }

    private void parse() throws DroolsParserException {
        StringTokenizer lines = new StringTokenizer(this.source, "\r\n");
        this.header = new StringBuffer();
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken().trim();
            if (line.startsWith("package")) {
                this.packageName = this.getPackage(line);
                continue;
            }
            if (line.startsWith("rule")) {
                String ruleName = ClassicDRLImporter.getRuleName((String)line);
                StringBuffer currentRule = new StringBuffer();
                this.laConsumeToEnd(lines, currentRule, "end", false);
                this.addRule(ruleName, currentRule);
                continue;
            }
            if (line.startsWith("function")) {
                String functionName = this.getFuncName(line);
                StringBuffer currentFunc = new StringBuffer();
                int counter = 0;
                currentFunc.append(line + "\n");
                counter = this.countBrackets(counter, line);
                if (counter > 0) {
                    this.laConsumeBracketsToEnd(counter, lines, currentFunc);
                }
                this.addFunction(functionName, currentFunc);
                continue;
            }
            if (line.startsWith("/*")) {
                StringBuffer comment = new StringBuffer();
                comment.append(line + "\n");
                this.laConsumeToEnd(lines, comment, "*/", true);
                this.header.append(comment);
                continue;
            }
            if (line.startsWith("expander")) {
                this.usesDSL = true;
                continue;
            }
            this.header.append(line);
            this.header.append("\n");
        }
    }

    private void addFunction(String functionName, StringBuffer currentFunc) {
        this.assets.add(new Asset(functionName, currentFunc.toString(), "function"));
    }

    private String getFuncName(String line) {
        Matcher m = functionPattern.matcher(line);
        m.matches();
        return m.group(1);
    }

    private void laConsumeBracketsToEnd(int counter, StringTokenizer lines, StringBuffer currentFunc) {
        boolean multilineIsOpen = false;
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            currentFunc.append(line);
            currentFunc.append("\n");
            if (multilineIsOpen) {
                int commentEnd = line.indexOf("*/");
                if (commentEnd != -1) {
                    multilineIsOpen = false;
                    line = line.substring(commentEnd);
                }
            } else {
                multilineIsOpen = this.checkIfMultilineCommentStarts(line);
                line = this.removeComments(line);
            }
            if (!multilineIsOpen) {
                counter = this.countBrackets(counter, line);
            }
            if (counter != 0) continue;
            break;
        }
    }

    private boolean checkIfMultilineCommentStarts(String line) {
        int commentMultiLineStart = line.indexOf("/*");
        int commentMultiLineEnd = line.indexOf("*/");
        return commentMultiLineStart != -1 && commentMultiLineEnd == -1;
    }

    private int countBrackets(int counter, String line) {
        char[] chars = line.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '{') {
                ++counter;
                continue;
            }
            if (chars[i] != '}') continue;
            --counter;
        }
        return counter;
    }

    private String removeComments(String line) {
        int commentMultiLineStart = line.indexOf("/*");
        int commentMultiLineEnd = line.indexOf("*/");
        int commentSingleLine = line.indexOf("//");
        if (commentSingleLine != -1 && commentMultiLineStart > commentSingleLine) {
            return line.substring(0, commentSingleLine);
        }
        if (commentMultiLineStart != -1 && commentMultiLineEnd == -1) {
            return line.substring(0, commentMultiLineStart);
        }
        if (commentMultiLineStart != -1 && commentMultiLineEnd != -1) {
            line = line.substring(commentMultiLineEnd);
            line = line.substring(0, commentMultiLineStart);
            return line;
        }
        return line;
    }

    private void laConsumeToEnd(StringTokenizer lines, StringBuffer currentRule, String end, boolean addLastLine) {
        while (lines.hasMoreTokens()) {
            String line = lines.nextToken();
            if (line.trim().startsWith(end)) {
                if (!addLastLine) break;
                currentRule.append(line + "\n");
                break;
            }
            currentRule.append(line);
            currentRule.append("\n");
        }
    }

    private void addRule(String ruleName, StringBuffer currentRule) {
        ruleName = ruleName.replace('\'', ' ');
        if (this.isDSLEnabled()) {
            this.assets.add(new Asset(ruleName, currentRule.toString(), "dslr"));
        } else {
            this.assets.add(new Asset(ruleName, currentRule.toString(), "drl"));
        }
    }

    public static String getRuleName(String line) throws DroolsParserException {
        DrlParser parser = new DrlParser();
        line = line + "\n when\n then \n end";
        RuleDescr rule = (RuleDescr)parser.parse(line).getRules().get(0);
        return rule.getName();
    }

    private String getPackage(String line) throws DroolsParserException {
        DrlParser parser = new DrlParser();
        return parser.parse(line).getName();
    }

    public List<Asset> getAssets() {
        return this.assets;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getPackageHeader() {
        return this.header.toString();
    }

    public boolean isDSLEnabled() {
        return this.usesDSL;
    }

    public static String mergeLines(String existing, String toMerge) {
        if (toMerge == null || toMerge.equals("")) {
            return existing;
        }
        if (existing == null || existing.equals("")) {
            return toMerge;
        }
        HashSet<String> existingLines = new HashSet<String>(Arrays.asList(existing.split("\n")));
        String[] newLines = toMerge.split("\n");
        for (int i = 0; i < newLines.length; ++i) {
            String newLine = newLines[i].trim();
            if (newLine.equals("") || existingLines.contains(newLines[i].trim())) continue;
            existing = existing + "\n" + newLines[i];
        }
        return existing;
    }
}

