/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import com.google.gwt.cell.client.AbstractCell;
import com.google.gwt.cell.client.CheckboxCell;
import com.google.gwt.i18n.client.DateTimeFormat;
import org.drools.guvnor.client.decisiontable.cells.PopupDateEditCell;
import org.drools.guvnor.client.decisiontable.cells.PopupDropDownEditCell;
import org.drools.guvnor.client.decisiontable.cells.PopupNumericEditCell;
import org.drools.guvnor.client.decisiontable.cells.PopupTextEditCell;
import org.drools.guvnor.client.decisiontable.cells.RowNumberCell;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellValueAdaptor;
import org.drools.guvnor.client.decisiontable.widget.VerticalDecisionTableWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridWidget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.ide.common.client.modeldriven.dt.RowNumberCol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTableCellFactory {
    private static String[] DIALECTS = new String[]{"java", "mvel"};
    private DecoratedGridWidget<DTColumnConfig> grid;
    private SuggestionCompletionEngine sce;
    private GuidedDecisionTable model;

    public DecisionTableCellFactory(VerticalDecisionTableWidget dtable, DecoratedGridWidget<DTColumnConfig> grid) {
        if (dtable == null) {
            throw new IllegalArgumentException("dtable cannot be null");
        }
        if (grid == null) {
            throw new IllegalArgumentException("grid cannot be null");
        }
        this.model = dtable.getModel();
        this.sce = dtable.getSCE();
        this.grid = grid;
    }

    public DecisionTableCellValueAdaptor<? extends Comparable<?>, DTColumnConfig> getCell(DTColumnConfig column) {
        DecisionTableCellValueAdaptor cell = this.makeTextCell();
        if (column instanceof RowNumberCol) {
            cell = this.makeRowNumberCell();
        } else if (column instanceof AttributeCol) {
            AttributeCol attrCol = (AttributeCol)column;
            String attrName = attrCol.getAttribute();
            if (attrName.equals("salience")) {
                cell = attrCol.isUseRowNumber() ? this.makeRowNumberCell() : this.makeNumericCell();
            } else if (attrName.equals("enabled")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("no-loop")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("duration")) {
                cell = this.makeNumericCell();
            } else if (attrName.equals("auto-focus")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("lock-on-active")) {
                cell = this.makeBooleanCell();
            } else if (attrName.equals("date-effective")) {
                cell = this.makeDateCell();
            } else if (attrName.equals("date-expires")) {
                cell = this.makeDateCell();
            } else if (attrName.equals("dialect")) {
                cell = this.makeDialectCell();
            }
        } else if (column instanceof ConditionCol) {
            cell = this.makeNewCell(column);
        } else if (column instanceof ActionSetFieldCol) {
            cell = this.makeNewCell(column);
        } else if (column instanceof ActionInsertFactCol) {
            cell = this.makeNewCell(column);
        }
        cell.setDecoratedGridWidget(this.grid);
        return cell;
    }

    private DecisionTableCellValueAdaptor<? extends Comparable<?>, DTColumnConfig> makeBooleanCell() {
        return new DecisionTableCellValueAdaptor((AbstractCell)new CheckboxCell());
    }

    private DecisionTableCellValueAdaptor<? extends Comparable<?>, DTColumnConfig> makeDateCell() {
        return new DecisionTableCellValueAdaptor((AbstractCell)new PopupDateEditCell(DateTimeFormat.getFormat((DateTimeFormat.PredefinedFormat)DateTimeFormat.PredefinedFormat.DATE_SHORT)));
    }

    private DecisionTableCellValueAdaptor<? extends Comparable<?>, DTColumnConfig> makeDialectCell() {
        PopupDropDownEditCell pudd = new PopupDropDownEditCell();
        pudd.setItems(DIALECTS);
        return new DecisionTableCellValueAdaptor((AbstractCell)pudd);
    }

    private DecisionTableCellValueAdaptor<? extends Comparable<?>, DTColumnConfig> makeNewCell(DTColumnConfig col) {
        DecisionTableCellValueAdaptor cell = this.makeTextCell();
        String[] vals = this.model.getValueList(col, this.sce);
        if (vals.length == 0) {
            if (this.model.isNumeric(col, this.sce)) {
                cell = this.makeNumericCell();
            } else if (this.model.isBoolean(col, this.sce)) {
                cell = this.makeBooleanCell();
            } else if (this.model.isDate(col, this.sce)) {
                cell = this.makeDateCell();
            }
        } else {
            PopupDropDownEditCell pudd = new PopupDropDownEditCell();
            pudd.setItems(vals);
            cell = new DecisionTableCellValueAdaptor((AbstractCell)pudd);
        }
        return cell;
    }

    private DecisionTableCellValueAdaptor<? extends Comparable<?>, DTColumnConfig> makeNumericCell() {
        return new DecisionTableCellValueAdaptor((AbstractCell)new PopupNumericEditCell());
    }

    private DecisionTableCellValueAdaptor<? extends Comparable<?>, DTColumnConfig> makeRowNumberCell() {
        return new DecisionTableCellValueAdaptor((AbstractCell)new RowNumberCell());
    }

    private DecisionTableCellValueAdaptor<? extends Comparable<?>, DTColumnConfig> makeTextCell() {
        return new DecisionTableCellValueAdaptor((AbstractCell)new PopupTextEditCell());
    }
}

