/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.decisiontable.widget;

import com.google.gwt.core.client.Scheduler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellFactory;
import org.drools.guvnor.client.decisiontable.widget.DecisionTableCellValueFactory;
import org.drools.guvnor.client.decisiontable.widget.VerticalDecisionTableHeaderWidget;
import org.drools.guvnor.client.decisiontable.widget.VerticalDecisionTableSidebarWidget;
import org.drools.guvnor.client.decisiontable.widget.VerticalDecisionTableWidget;
import org.drools.guvnor.client.table.SortDirection;
import org.drools.guvnor.client.widgets.decoratedgrid.CellValue;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridHeaderWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridSidebarWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DecoratedGridWidget;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicColumn;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicData;
import org.drools.guvnor.client.widgets.decoratedgrid.DynamicDataRow;
import org.drools.guvnor.client.widgets.decoratedgrid.HasColumns;
import org.drools.guvnor.client.widgets.decoratedgrid.HasRows;
import org.drools.guvnor.client.widgets.decoratedgrid.HasSystemControlledColumns;
import org.drools.guvnor.client.widgets.decoratedgrid.VerticalDecoratedGridWidget;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.dt.ActionCol;
import org.drools.ide.common.client.modeldriven.dt.ActionInsertFactCol;
import org.drools.ide.common.client.modeldriven.dt.ActionSetFieldCol;
import org.drools.ide.common.client.modeldriven.dt.AttributeCol;
import org.drools.ide.common.client.modeldriven.dt.ConditionCol;
import org.drools.ide.common.client.modeldriven.dt.DTColumnConfig;
import org.drools.ide.common.client.modeldriven.dt.DescriptionCol;
import org.drools.ide.common.client.modeldriven.dt.GuidedDecisionTable;
import org.drools.ide.common.client.modeldriven.dt.MetadataCol;
import org.drools.ide.common.client.modeldriven.dt.RowNumberCol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VerticalDecisionTableWidget
extends Composite
implements HasRows,
HasColumns<DTColumnConfig>,
HasSystemControlledColumns {
    protected GuidedDecisionTable model;
    protected DecoratedGridWidget<DTColumnConfig> widget;
    protected SuggestionCompletionEngine sce;
    protected DecisionTableCellFactory cellFactory;
    protected DecisionTableCellValueFactory cellValueFactory;

    public VerticalDecisionTableWidget(SuggestionCompletionEngine sce) {
        if (sce == null) {
            throw new IllegalArgumentException("sce cannot be null");
        }
        this.sce = sce;
        this.widget = new VerticalDecoratedGridWidget();
        VerticalDecisionTableHeaderWidget header = new VerticalDecisionTableHeaderWidget(this.widget);
        VerticalDecisionTableSidebarWidget sidebar = new VerticalDecisionTableSidebarWidget(this.widget, (HasRows)this);
        this.widget.setHeaderWidget((DecoratedGridHeaderWidget)header);
        this.widget.setSidebarWidget((DecoratedGridSidebarWidget)sidebar);
        this.widget.setHasSystemControlledColumns((HasSystemControlledColumns)this);
        this.initWidget((Widget)this.widget);
    }

    public void addColumn(DTColumnConfig modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        this.addColumn(modelColumn, true);
    }

    public void appendRow() {
        DynamicDataRow row = this.makeNewRow();
        this.widget.appendRow(row);
        this.updateSystemControlledColumnValues();
        this.redrawSystemControlledColumns();
    }

    public void deleteColumn(DTColumnConfig modelColumn) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null.");
        }
        DynamicColumn col = this.getDynamicColumn(modelColumn);
        this.widget.deleteColumn(col);
    }

    public void deleteRow(DynamicDataRow row) {
        if (row == null) {
            throw new IllegalArgumentException("row cannot be null");
        }
        this.widget.deleteRow(row);
        this.updateSystemControlledColumnValues();
        this.redrawSystemControlledColumns();
    }

    public GuidedDecisionTable getModel() {
        return this.model;
    }

    public SuggestionCompletionEngine getSCE() {
        return this.sce;
    }

    public void insertRowBefore(DynamicDataRow rowBefore) {
        if (rowBefore == null) {
            throw new IllegalArgumentException("rowBefore cannot be null");
        }
        DynamicDataRow newRow = this.makeNewRow();
        this.widget.insertRowBefore(rowBefore, newRow);
        this.updateSystemControlledColumnValues();
        this.redrawSystemControlledColumns();
    }

    public void redrawSystemControlledColumns() {
        this.widget.redrawSystemControlledColumns();
    }

    public void scrapeColumns() {
        this.model.getMetadataCols().clear();
        this.model.getAttributeCols().clear();
        this.model.getConditionCols().clear();
        this.model.getActionCols().clear();
        RowNumberCol rnCol = null;
        DescriptionCol descCol = null;
        for (DynamicColumn column : this.widget.getColumns()) {
            MetadataCol tc;
            DTColumnConfig modelCol = (DTColumnConfig)column.getModelColumn();
            if (modelCol instanceof RowNumberCol) {
                rnCol = (RowNumberCol)modelCol;
                this.model.setRowNumberCol(rnCol);
                continue;
            }
            if (modelCol instanceof DescriptionCol) {
                descCol = (DescriptionCol)modelCol;
                this.model.setDescriptionCol(descCol);
                continue;
            }
            if (modelCol instanceof MetadataCol) {
                tc = (MetadataCol)modelCol;
                this.model.getMetadataCols().add(tc);
                continue;
            }
            if (modelCol instanceof AttributeCol) {
                tc = (AttributeCol)modelCol;
                this.model.getAttributeCols().add(tc);
                continue;
            }
            if (modelCol instanceof ConditionCol) {
                tc = (ConditionCol)modelCol;
                this.model.getConditionCols().add(tc);
                continue;
            }
            if (!(modelCol instanceof ActionCol)) continue;
            tc = (ActionCol)modelCol;
            this.model.getActionCols().add(tc);
        }
    }

    public void scrapeData() {
        DynamicData data = this.widget.getData();
        List columns = this.widget.getColumns();
        int GRID_ROWS = data.size();
        String[][] grid = new String[GRID_ROWS][];
        for (int iRow = 0; iRow < GRID_ROWS; ++iRow) {
            DynamicDataRow dataRow = (DynamicDataRow)data.get(iRow);
            String[] row = new String[dataRow.size()];
            for (int iCol = 0; iCol < columns.size(); ++iCol) {
                String serialisedValue;
                CellValue cv = (CellValue)dataRow.get(iCol);
                DynamicColumn column = (DynamicColumn)columns.get(iCol);
                row[iCol] = serialisedValue = this.cellValueFactory.serialiseValue((DTColumnConfig)column.getModelColumn(), cv);
            }
            grid[iRow] = row;
        }
        this.model.setData(grid);
    }

    public void setColumnVisibility(DTColumnConfig modelColumn, boolean isVisible) {
        if (modelColumn == null) {
            throw new IllegalArgumentException("modelColumn cannot be null");
        }
        DynamicColumn col = this.getDynamicColumn(modelColumn);
        this.widget.setColumnVisibility(col.getColumnIndex(), isVisible);
    }

    public void setModel(GuidedDecisionTable model) {
        DynamicColumn column;
        if (model == null) {
            throw new IllegalArgumentException("model cannot be null");
        }
        this.model = model;
        this.cellFactory = new DecisionTableCellFactory(this, this.widget);
        this.cellValueFactory = new DecisionTableCellValueFactory(this);
        this.widget.getData().clear();
        this.widget.getColumns().clear();
        for (int iRow = 0; iRow < model.getData().length; ++iRow) {
            this.widget.getData().add((Object)new DynamicDataRow());
        }
        int colIndex = 0;
        RowNumberCol colStatic = model.getRowNumberCol();
        DynamicColumn columnStatic = new DynamicColumn((Object)colStatic, this.cellFactory.getCell((DTColumnConfig)colStatic), colIndex, true, false);
        columnStatic.setWidth(24);
        this.widget.appendColumn(columnStatic, this.makeColumnData((DTColumnConfig)colStatic, colIndex++), false);
        colStatic = model.getDescriptionCol();
        columnStatic = new DynamicColumn((Object)colStatic, this.cellFactory.getCell((DTColumnConfig)colStatic), colIndex);
        this.widget.appendColumn(columnStatic, this.makeColumnData((DTColumnConfig)colStatic, colIndex++), false);
        for (MetadataCol col : model.getMetadataCols()) {
            column = new DynamicColumn((Object)col, this.cellFactory.getCell((DTColumnConfig)col), colIndex);
            column.setVisible(!col.isHideColumn());
            this.widget.appendColumn(column, this.makeColumnData((DTColumnConfig)col, colIndex++), false);
        }
        for (MetadataCol col : model.getAttributeCols()) {
            column = new DynamicColumn((Object)col, this.cellFactory.getCell((DTColumnConfig)col), colIndex);
            column.setVisible(!col.isHideColumn());
            column.setSystemControlled(col.isUseRowNumber());
            column.setSortable(!col.isUseRowNumber());
            this.widget.appendColumn(column, this.makeColumnData((DTColumnConfig)col, colIndex++), false);
        }
        this.assertConditionColumnGrouping(model);
        for (MetadataCol col : model.getConditionCols()) {
            column = new DynamicColumn((Object)col, this.cellFactory.getCell((DTColumnConfig)col), colIndex);
            column.setVisible(!col.isHideColumn());
            this.widget.appendColumn(column, this.makeColumnData((DTColumnConfig)col, colIndex++), false);
        }
        for (MetadataCol col : model.getActionCols()) {
            column = new DynamicColumn((Object)col, this.cellFactory.getCell((DTColumnConfig)col), colIndex);
            column.setVisible(!col.isHideColumn());
            this.widget.appendColumn(column, this.makeColumnData((DTColumnConfig)col, colIndex++), false);
        }
        this.widget.assertModelIndexes();
        this.widget.getHeaderWidget().redraw();
        Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
    }

    public void setPixelSize(int width, int height) {
        if (width < 0) {
            throw new IllegalArgumentException("width cannot be less than zero");
        }
        if (height < 0) {
            throw new IllegalArgumentException("height cannot be less than zero");
        }
        super.setPixelSize(width, height);
        this.widget.setPixelSize(width, height);
    }

    public void updateColumn(ActionInsertFactCol origColumn, ActionInsertFactCol editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bRedrawColumn = false;
        boolean bRedrawHeader = false;
        DynamicColumn column = this.getDynamicColumn((DTColumnConfig)origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig)origColumn, !editColumn.isHideColumn());
        }
        if (!this.isEqualOrNull(origColumn.getBoundName(), editColumn.getBoundName())) {
            if (!this.isEqualOrNull(origColumn.getFactType(), editColumn.getFactType()) || !this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField())) {
                bRedrawColumn = true;
                this.updateCellsForDataType((DTColumnConfig)editColumn, column);
            }
        } else if (!this.isEqualOrNull(origColumn.getFactType(), editColumn.getFactType()) || !this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField())) {
            bRedrawColumn = true;
            this.updateCellsForDataType((DTColumnConfig)editColumn, column);
        }
        if (!this.isEqualOrNull(origColumn.getValueList(), editColumn.getValueList())) {
            bRedrawColumn = this.updateCellsForOptionValueList((DTColumnConfig)editColumn, column);
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bRedrawHeader = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bRedrawColumn) {
            this.widget.getGridWidget().redrawColumn(column.getColumnIndex());
        }
        if (bRedrawHeader) {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void updateColumn(ActionSetFieldCol origColumn, ActionSetFieldCol editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bRedrawColumn = false;
        boolean bRedrawHeader = false;
        DynamicColumn column = this.getDynamicColumn((DTColumnConfig)origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig)origColumn, !editColumn.isHideColumn());
        }
        if (!this.isEqualOrNull(origColumn.getBoundName(), editColumn.getBoundName())) {
            if (!this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField())) {
                bRedrawColumn = true;
                this.updateCellsForDataType((DTColumnConfig)editColumn, column);
            }
        } else if (!this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField())) {
            bRedrawColumn = true;
            this.updateCellsForDataType((DTColumnConfig)editColumn, column);
        }
        if (!this.isEqualOrNull(origColumn.getValueList(), editColumn.getValueList())) {
            bRedrawColumn = this.updateCellsForOptionValueList((DTColumnConfig)editColumn, column);
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bRedrawHeader = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bRedrawColumn) {
            this.widget.getGridWidget().redrawColumn(column.getColumnIndex());
        }
        if (bRedrawHeader) {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void updateColumn(ConditionCol origColumn, ConditionCol editColumn) {
        if (origColumn == null) {
            throw new IllegalArgumentException("origColumn cannot be null");
        }
        if (editColumn == null) {
            throw new IllegalArgumentException("editColumn cannot be null");
        }
        boolean bRedrawColumn = false;
        boolean bRedrawHeader = false;
        DynamicColumn column = this.getDynamicColumn((DTColumnConfig)origColumn);
        if (origColumn.isHideColumn() != editColumn.isHideColumn()) {
            this.setColumnVisibility((DTColumnConfig)origColumn, !editColumn.isHideColumn());
        }
        if (!this.isEqualOrNull(origColumn.getOperator(), editColumn.getOperator())) {
            bRedrawHeader = true;
        }
        if (!this.isEqualOrNull(origColumn.getBoundName(), editColumn.getBoundName())) {
            bRedrawHeader = true;
            this.addColumn((DTColumnConfig)editColumn, false);
            DynamicColumn origCol = this.getDynamicColumn((DTColumnConfig)origColumn);
            DynamicColumn editCol = this.getDynamicColumn((DTColumnConfig)editColumn);
            int origColIndex = this.widget.getColumns().indexOf(origCol);
            int editColIndex = this.widget.getColumns().indexOf(editCol);
            if (this.isEqualOrNull(origColumn.getFactType(), editColumn.getFactType()) && this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField()) && origColumn.getConstraintValueType() == editColumn.getConstraintValueType()) {
                for (int iRow = 0; iRow < this.widget.getData().size(); ++iRow) {
                    DynamicDataRow row = (DynamicDataRow)this.widget.getData().get(iRow);
                    CellValue oldCell = (CellValue)row.get(origColIndex);
                    CellValue newCell = (CellValue)row.get(editColIndex);
                    newCell.setValue((Object)oldCell.getValue());
                }
            }
            this.widget.deleteColumn(origCol);
            if (editColIndex > origColIndex) {
                int temp = origColIndex;
                origColIndex = editColIndex;
                editColIndex = temp;
            }
            this.widget.assertModelIndexes();
            this.widget.getGridWidget().redrawColumns(editColIndex, origColIndex);
        } else if (!this.isEqualOrNull(origColumn.getFactType(), editColumn.getFactType()) || !this.isEqualOrNull(origColumn.getFactField(), editColumn.getFactField()) || origColumn.getConstraintValueType() != editColumn.getConstraintValueType()) {
            bRedrawColumn = true;
            this.updateCellsForDataType((DTColumnConfig)editColumn, column);
        }
        if (!this.isEqualOrNull(origColumn.getValueList(), editColumn.getValueList())) {
            bRedrawColumn = this.updateCellsForOptionValueList((DTColumnConfig)editColumn, column);
        }
        if (!origColumn.getHeader().equals(editColumn.getHeader())) {
            bRedrawHeader = true;
        }
        this.populateModelColumn(origColumn, editColumn);
        if (bRedrawColumn) {
            this.widget.getGridWidget().redrawColumn(column.getColumnIndex());
        }
        if (bRedrawHeader) {
            Scheduler.get().scheduleDeferred((Scheduler.ScheduledCommand)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    public void updateSystemControlledColumnValues() {
        DynamicData data = this.widget.getData();
        List columns = this.widget.getColumns();
        for (DynamicColumn col : columns) {
            AttributeCol attrCol;
            DTColumnConfig modelColumn = (DTColumnConfig)col.getModelColumn();
            if (modelColumn instanceof RowNumberCol) {
                for (int iRow = 0; iRow < data.size(); ++iRow) {
                    ((CellValue)((DynamicDataRow)data.get(iRow)).get(col.getColumnIndex())).setValue((Object)(iRow + 1));
                }
                continue;
            }
            if (!(modelColumn instanceof AttributeCol) || !(attrCol = (AttributeCol)modelColumn).getAttribute().equals("salience")) continue;
            if (attrCol.isUseRowNumber()) {
                col.setSortDirection(SortDirection.NONE);
                int MAX_ROWS = data.size();
                for (int iRow = 0; iRow < data.size(); ++iRow) {
                    int salience = iRow + 1;
                    if (attrCol.isReverseOrder()) {
                        salience = Math.abs(iRow - MAX_ROWS);
                    }
                    ((CellValue)((DynamicDataRow)data.get(iRow)).get(col.getColumnIndex())).setValue((Object)salience);
                }
            }
            col.setCell(this.cellFactory.getCell((DTColumnConfig)attrCol));
            col.setSystemControlled(attrCol.isUseRowNumber());
            col.setSortable(!attrCol.isUseRowNumber());
        }
    }

    private void addColumn(DTColumnConfig modelColumn, boolean bRedraw) {
        int index = 0;
        if (modelColumn instanceof MetadataCol) {
            index = this.findMetadataColumnIndex();
        } else if (modelColumn instanceof AttributeCol) {
            index = this.findAttributeColumnIndex();
        } else if (modelColumn instanceof ConditionCol) {
            index = this.findConditionColumnIndex((ConditionCol)modelColumn);
        } else if (modelColumn instanceof ActionCol) {
            index = this.findActionColumnIndex();
        }
        this.insertColumnBefore(modelColumn, index, bRedraw);
    }

    private void assertConditionColumnGrouping(GuidedDecisionTable model) {
        int iRow;
        int colIndex;
        int iCol;
        int DATA_COLUMN_OFFSET = model.getMetadataCols().size() + model.getAttributeCols().size() + 2;
        HashMap groups = new HashMap();
        int DATA_ROWS = model.getData().length;
        for (iCol = 0; iCol < model.getConditionCols().size(); ++iCol) {
            List<ConditionColData> groupCols;
            ConditionCol col = (ConditionCol)model.getConditionCols().get(iCol);
            String pattern = col.getBoundName();
            if (!groups.containsKey(pattern)) {
                groupCols = new ArrayList();
                groups.put(pattern, groupCols);
            }
            groupCols = (List)groups.get(pattern);
            ConditionColData ccd = new ConditionColData(this);
            colIndex = DATA_COLUMN_OFFSET + iCol;
            ccd.data = new String[DATA_ROWS];
            for (iRow = 0; iRow < DATA_ROWS; ++iRow) {
                ccd.data[iRow] = model.getData()[iRow][colIndex];
            }
            ccd.col = col;
            groupCols.add(ccd);
        }
        iCol = 0;
        model.getConditionCols().clear();
        for (Map.Entry me : groups.entrySet()) {
            for (ConditionColData ccd : (List)me.getValue()) {
                model.getConditionCols().add(ccd.col);
                colIndex = DATA_COLUMN_OFFSET + iCol;
                for (iRow = 0; iRow < DATA_ROWS; ++iRow) {
                    model.getData()[iRow][colIndex] = ccd.data[iRow];
                }
                ++iCol;
            }
        }
    }

    private int findActionColumnIndex() {
        int index = this.widget.getColumns().size() - 1;
        return index;
    }

    private int findAttributeColumnIndex() {
        int index = 0;
        List columns = this.widget.getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            DynamicColumn column = (DynamicColumn)columns.get(iCol);
            DTColumnConfig modelColumn = (DTColumnConfig)column.getModelColumn();
            if (modelColumn instanceof RowNumberCol) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof DescriptionCol) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof MetadataCol) {
                index = iCol;
                continue;
            }
            if (!(modelColumn instanceof AttributeCol)) continue;
            index = iCol;
        }
        return index;
    }

    private int findConditionColumnIndex(ConditionCol col) {
        int index = 0;
        boolean bMatched = false;
        List columns = this.widget.getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            DynamicColumn column = (DynamicColumn)columns.get(iCol);
            DTColumnConfig modelColumn = (DTColumnConfig)column.getModelColumn();
            if (modelColumn instanceof RowNumberCol) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof DescriptionCol) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof MetadataCol) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof AttributeCol) {
                index = iCol;
                continue;
            }
            if (!(modelColumn instanceof ConditionCol)) continue;
            if (this.isEquivalentConditionColumn((ConditionCol)modelColumn, col)) {
                index = iCol;
                bMatched = true;
                continue;
            }
            if (bMatched) continue;
            index = iCol;
        }
        return index;
    }

    private int findMetadataColumnIndex() {
        int index = 0;
        List columns = this.widget.getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            DynamicColumn column = (DynamicColumn)columns.get(iCol);
            DTColumnConfig modelColumn = (DTColumnConfig)column.getModelColumn();
            if (modelColumn instanceof RowNumberCol) {
                index = iCol;
                continue;
            }
            if (modelColumn instanceof DescriptionCol) {
                index = iCol;
                continue;
            }
            if (!(modelColumn instanceof MetadataCol)) continue;
            index = iCol;
        }
        return index;
    }

    private DynamicColumn<DTColumnConfig> getDynamicColumn(DTColumnConfig modelCol) {
        DynamicColumn column = null;
        List columns = this.widget.getColumns();
        for (DynamicColumn dc : columns) {
            if (!((DTColumnConfig)dc.getModelColumn()).equals((Object)modelCol)) continue;
            column = dc;
            break;
        }
        return column;
    }

    private void insertColumnBefore(DTColumnConfig modelColumn, int index, boolean bRedraw) {
        DynamicColumn column = new DynamicColumn((Object)modelColumn, this.cellFactory.getCell(modelColumn), index);
        column.setVisible(!modelColumn.isHideColumn());
        DynamicColumn columnBefore = (DynamicColumn)this.widget.getColumns().get(index);
        DynamicData data = this.widget.getData();
        ArrayList<CellValue> columnData = new ArrayList<CellValue>();
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            CellValue cell = this.cellValueFactory.getCellValue(modelColumn, iRow, index, modelColumn.getDefaultValue());
            columnData.add(cell);
        }
        this.widget.insertColumnBefore(columnBefore, column, columnData, bRedraw);
    }

    private boolean isEqualOrNull(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        return s1 != null && s2 != null && s1.equals(s2);
    }

    private boolean isEquivalentConditionColumn(ConditionCol c1, ConditionCol c2) {
        return this.isEqualOrNull(c1.getFactType(), c2.getFactType()) && this.isEqualOrNull(c1.getBoundName(), c2.getBoundName());
    }

    private List<CellValue<?>> makeColumnData(DTColumnConfig column, int colIndex) {
        int dataSize = this.model.getData().length;
        ArrayList columnData = new ArrayList();
        for (int iRow = 0; iRow < dataSize; ++iRow) {
            String[] row = this.model.getData()[iRow];
            CellValue cv = this.cellValueFactory.getCellValue(column, iRow, colIndex, row[colIndex]);
            columnData.add(cv);
        }
        return columnData;
    }

    private DynamicDataRow makeNewRow() {
        DynamicDataRow row = new DynamicDataRow();
        List columns = this.widget.getColumns();
        for (int iCol = 0; iCol < columns.size(); ++iCol) {
            DTColumnConfig col = (DTColumnConfig)((DynamicColumn)columns.get(iCol)).getModelColumn();
            CellValue cv = this.cellValueFactory.getCellValue(col, 0, iCol, col.getDefaultValue());
            row.add((Object)cv);
        }
        return row;
    }

    private void populateModelColumn(ActionInsertFactCol col, ActionInsertFactCol editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setType(editingCol.getType());
        col.setFactField(editingCol.getFactField());
        col.setHeader(editingCol.getHeader());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setFactType(editingCol.getFactType());
    }

    private void populateModelColumn(ActionSetFieldCol col, ActionSetFieldCol editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setType(editingCol.getType());
        col.setFactField(editingCol.getFactField());
        col.setHeader(editingCol.getHeader());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
        col.setUpdate(editingCol.isUpdate());
    }

    private void populateModelColumn(ConditionCol col, ConditionCol editingCol) {
        col.setBoundName(editingCol.getBoundName());
        col.setConstraintValueType(editingCol.getConstraintValueType());
        col.setFactField(editingCol.getFactField());
        col.setFactType(editingCol.getFactType());
        col.setHeader(editingCol.getHeader());
        col.setOperator(editingCol.getOperator());
        col.setValueList(editingCol.getValueList());
        col.setDefaultValue(editingCol.getDefaultValue());
        col.setHideColumn(editingCol.isHideColumn());
    }

    private void updateCellsForDataType(DTColumnConfig editColumn, DynamicColumn<DTColumnConfig> column) {
        DynamicData data = this.widget.getData();
        column.setCell(this.cellFactory.getCell(editColumn));
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            DynamicDataRow row = (DynamicDataRow)data.get(iRow);
            row.set(column.getColumnIndex(), (Object)this.cellValueFactory.getCellValue(editColumn, iRow, column.getColumnIndex(), null));
        }
        this.widget.assertModelIndexes();
    }

    private boolean updateCellsForOptionValueList(DTColumnConfig editColumn, DynamicColumn<DTColumnConfig> column) {
        boolean bRedrawRequired = false;
        DynamicData data = this.widget.getData();
        List<String> vals = Arrays.asList(this.model.getValueList(editColumn, this.sce));
        column.setCell(this.cellFactory.getCell(editColumn));
        int iCol = column.getColumnIndex();
        for (int iRow = 0; iRow < data.size(); ++iRow) {
            DynamicDataRow row = (DynamicDataRow)data.get(iRow);
            if (vals.contains(((CellValue)row.get(iCol)).getValue())) continue;
            ((CellValue)row.get(iCol)).setValue(null);
            bRedrawRequired = true;
        }
        return bRedrawRequired;
    }
}

