/*
 * Decompiled with CFR 0.152.
 */
package org.drools.guvnor.client.modeldriven.ui;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.HasVerticalAlignment;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.SimplePanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.List;
import org.drools.factconstraints.client.customform.CustomFormConfiguration;
import org.drools.guvnor.client.common.DirtyableComposite;
import org.drools.guvnor.client.common.FormStylePopup;
import org.drools.guvnor.client.common.InfoPopup;
import org.drools.guvnor.client.common.SmallLabel;
import org.drools.guvnor.client.common.ValueChanged;
import org.drools.guvnor.client.messages.Constants;
import org.drools.guvnor.client.modeldriven.ui.BoundTextBox;
import org.drools.guvnor.client.modeldriven.ui.CustomFormPopUp;
import org.drools.guvnor.client.modeldriven.ui.DatePickerLabel;
import org.drools.guvnor.client.modeldriven.ui.DefaultLiteralEditor;
import org.drools.guvnor.client.modeldriven.ui.EnumDropDownLabel;
import org.drools.guvnor.client.modeldriven.ui.ExpressionBuilder;
import org.drools.guvnor.client.modeldriven.ui.ExpressionTypeChangeHandler;
import org.drools.guvnor.client.modeldriven.ui.RuleModeller;
import org.drools.guvnor.client.packages.WorkingSetManager;
import org.drools.guvnor.client.resources.Images;
import org.drools.ide.common.client.modeldriven.DropDownData;
import org.drools.ide.common.client.modeldriven.SuggestionCompletionEngine;
import org.drools.ide.common.client.modeldriven.brl.BaseSingleFieldConstraint;
import org.drools.ide.common.client.modeldriven.brl.FactPattern;
import org.drools.ide.common.client.modeldriven.brl.RuleModel;
import org.drools.ide.common.client.modeldriven.brl.SingleFieldConstraint;

public class ConstraintValueEditor
extends DirtyableComposite {
    private Constants constants = (Constants)GWT.create(Constants.class);
    private static Images images = (Images)GWT.create(Images.class);
    private final FactPattern pattern;
    private final String fieldName;
    private final SuggestionCompletionEngine sce;
    private final BaseSingleFieldConstraint constraint;
    private final Panel panel;
    private final RuleModel model;
    private final RuleModeller modeller;
    private final boolean numericValue;
    private DropDownData dropDownData;
    private String fieldType;
    private boolean readOnly;
    private Command onValueChangeCommand;
    private boolean isDropDownDataEnum;

    public ConstraintValueEditor(FactPattern pattern, String fieldName, BaseSingleFieldConstraint con, RuleModeller modeller, String valueType, boolean readOnly) {
        this.pattern = pattern;
        this.fieldName = fieldName;
        this.sce = modeller.getSuggestionCompletions();
        this.constraint = con;
        this.panel = new SimplePanel();
        this.model = modeller.getModel();
        this.modeller = modeller;
        this.fieldType = valueType = this.sce.getFieldType(pattern.getFactType(), fieldName);
        this.numericValue = "Numeric".equals(valueType);
        this.readOnly = readOnly;
        if ("Boolean".equals(valueType)) {
            this.dropDownData = DropDownData.create((String[])new String[]{"true", "false"});
            this.isDropDownDataEnum = false;
        } else {
            this.dropDownData = this.sce.getEnums(pattern, fieldName);
            this.isDropDownDataEnum = true;
        }
        this.refreshEditor();
        this.initWidget((Widget)this.panel);
    }

    private void refreshEditor() {
        this.panel.clear();
        Widget constraintWidget = null;
        if (this.constraint.getConstraintValueType() == 0) {
            Image clickme = new Image(images.edit());
            clickme.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            constraintWidget = clickme;
        } else {
            switch (this.constraint.getConstraintValueType()) {
                case 1: 
                case 4: {
                    if (this.constraint instanceof SingleFieldConstraint) {
                        SingleFieldConstraint con = (SingleFieldConstraint)this.constraint;
                        CustomFormConfiguration customFormConfiguration = WorkingSetManager.getInstance().getCustomFormConfiguration(this.modeller.getAsset().metaData.packageName, this.pattern.getFactType(), this.fieldName);
                        if (customFormConfiguration != null) {
                            constraintWidget = new Button(con.getValue(), (ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                            break;
                        }
                    }
                    if (this.dropDownData != null) {
                        constraintWidget = new EnumDropDownLabel(this.pattern, this.fieldName, this.sce, this.constraint);
                        ((EnumDropDownLabel)constraintWidget).setOnValueChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
                        break;
                    }
                    if ("Date".equals(this.fieldType)) {
                        DatePickerLabel datePicker = new DatePickerLabel(this.constraint.getValue());
                        this.constraint.setValue(datePicker.getDateString());
                        if (!this.readOnly) {
                            datePicker.addValueChanged((ValueChanged)new /* Unavailable Anonymous Inner Class!! */);
                            constraintWidget = datePicker;
                            break;
                        }
                        constraintWidget = new SmallLabel(this.constraint.getValue());
                        break;
                    }
                    if (!this.readOnly) {
                        constraintWidget = new DefaultLiteralEditor(this.constraint, this.numericValue);
                        ((DefaultLiteralEditor)constraintWidget).setOnValueChangeCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
                        break;
                    }
                    constraintWidget = new SmallLabel(this.constraint.getValue());
                    break;
                }
                case 3: {
                    constraintWidget = this.returnValueEditor();
                    break;
                }
                case 6: {
                    constraintWidget = this.expressionEditor();
                    break;
                }
                case 2: {
                    constraintWidget = this.variableEditor();
                    break;
                }
                case 7: {
                    constraintWidget = new DefaultLiteralEditor(this.constraint, false);
                    break;
                }
            }
        }
        this.panel.add(constraintWidget);
    }

    private Widget variableEditor() {
        if (this.readOnly) {
            return new SmallLabel(this.constraint.getValue());
        }
        List vars = this.model.getBoundVariablesInScope(this.constraint);
        ListBox box = new ListBox();
        if (this.constraint.getValue() == null) {
            box.addItem(this.constants.Choose());
        }
        int j = 0;
        for (String var : vars) {
            FactPattern f = this.model.getBoundFact(var);
            String fv = this.model.getBindingType(var);
            if (f != null && f.getFactType().equals(this.fieldType) || fv != null && fv.equals(this.fieldType)) {
                box.addItem(var);
                if (this.constraint.getValue() != null && this.constraint.getValue().equals(var)) {
                    box.setSelectedIndex(j);
                }
                ++j;
                continue;
            }
            String factCollectionType = this.sce.getParametricFieldType(this.pattern.getFactType(), this.fieldName);
            if ((f == null || factCollectionType == null || !f.getFactType().equals(factCollectionType)) && (factCollectionType == null || !factCollectionType.equals(fv))) continue;
            box.addItem(var);
            if (this.constraint.getValue() != null && this.constraint.getValue().equals(var)) {
                box.setSelectedIndex(j);
            }
            ++j;
        }
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        return box;
    }

    private Widget returnValueEditor() {
        BoundTextBox box = new BoundTextBox(this.constraint);
        String msg = this.constants.FormulaEvaluateToAValue();
        Image img = new Image(images.functionAssets());
        img.setTitle(msg);
        box.setTitle(msg);
        box.addChangeHandler((ChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        Panel ed = this.widgets((Widget)img, (Widget)box);
        return ed;
    }

    private Widget expressionEditor() {
        if (!(this.constraint instanceof SingleFieldConstraint)) {
            throw new IllegalArgumentException("Expected SingleFieldConstraint, but " + this.constraint.getClass().getName() + " found.");
        }
        ExpressionBuilder builder = new ExpressionBuilder(this.modeller, ((SingleFieldConstraint)this.constraint).getExpressionValue());
        builder.addExpressionTypeChangeHandler((ExpressionTypeChangeHandler)new /* Unavailable Anonymous Inner Class!! */);
        builder.addOnModifiedCommand((Command)new /* Unavailable Anonymous Inner Class!! */);
        Panel ed = this.widgets((Widget)new HTML("&nbsp;"), (Widget)builder);
        return ed;
    }

    private void showTypeChoice(Widget w, BaseSingleFieldConstraint con) {
        CustomFormConfiguration customFormConfiguration = WorkingSetManager.getInstance().getCustomFormConfiguration(this.modeller.getAsset().metaData.packageName, this.pattern.getFactType(), this.fieldName);
        if (customFormConfiguration != null) {
            if (!(con instanceof SingleFieldConstraint)) {
                Window.alert((String)"Unexpected constraint type!");
                return;
            }
            CustomFormPopUp customFormPopUp = new CustomFormPopUp(images.newexWiz(), this.constants.FieldValue(), customFormConfiguration);
            SingleFieldConstraint sfc = (SingleFieldConstraint)con;
            customFormPopUp.addOkButtonHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            customFormPopUp.show(sfc.getId(), sfc.getValue());
            return;
        }
        FormStylePopup form = new FormStylePopup(images.newexWiz(), this.constants.FieldValue());
        Button lit = new Button(this.constants.LiteralValue());
        lit.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.LiteralValue() + ":", (Widget)this.widgets((Widget)lit, (Widget)new InfoPopup(this.constants.LiteralValue(), this.constants.LiteralValTip())));
        if (this.modeller.isTemplate()) {
            String templateKeyLabel = this.constants.TemplateKey();
            Button templateKeyButton = new Button(templateKeyLabel);
            templateKeyButton.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
            form.addAttribute(templateKeyLabel + ":", (Widget)this.widgets((Widget)templateKeyButton, (Widget)new InfoPopup(templateKeyLabel, this.constants.LiteralValTip())));
        }
        form.addRow((Widget)new HTML("<hr/>"));
        form.addRow((Widget)new SmallLabel(this.constants.AdvancedOptions()));
        if (this.model.getBoundVariablesInScope(this.constraint).size() > 0 || "Collection".equals(this.fieldType)) {
            List vars = this.model.getBoundFacts();
            boolean foundABouncVariableThatMatches = false;
            for (String var : vars) {
                FactPattern f = this.model.getBoundFact(var);
                String fieldConstraint = this.model.getBindingType(var);
                if (f != null && f.getFactType() != null && f.getFactType().equals(this.fieldType) || this.fieldType != null && this.fieldType.equals(fieldConstraint)) {
                    foundABouncVariableThatMatches = true;
                    break;
                }
                String factCollectionType = this.sce.getParametricFieldType(this.pattern.getFactType(), this.fieldName);
                if ((f == null || factCollectionType == null || !f.getFactType().equals(factCollectionType)) && (factCollectionType == null || !factCollectionType.equals(fieldConstraint))) continue;
                foundABouncVariableThatMatches = true;
                break;
            }
            if (foundABouncVariableThatMatches) {
                Button variable = new Button(this.constants.BoundVariable());
                variable.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
                form.addAttribute(this.constants.AVariable(), (Widget)this.widgets((Widget)variable, (Widget)new InfoPopup(this.constants.ABoundVariable(), this.constants.BoundVariableTip())));
            }
        }
        Button formula = new Button(this.constants.NewFormula());
        formula.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.AFormula() + ":", (Widget)this.widgets((Widget)formula, (Widget)new InfoPopup(this.constants.AFormula(), this.constants.FormulaExpressionTip())));
        Button expression = new Button(this.constants.ExpressionEditor());
        expression.addClickHandler((ClickHandler)new /* Unavailable Anonymous Inner Class!! */);
        form.addAttribute(this.constants.ExpressionEditor() + ":", (Widget)this.widgets((Widget)expression, (Widget)new InfoPopup(this.constants.ExpressionEditor(), this.constants.ExpressionEditor())));
        form.show();
    }

    private void doTypeChosen(FormStylePopup form) {
        this.executeOnValueChangeCommand();
        this.refreshEditor();
        form.hide();
    }

    private Panel widgets(Widget left, Widget right) {
        HorizontalPanel panel = new HorizontalPanel();
        panel.setVerticalAlignment(HasVerticalAlignment.ALIGN_MIDDLE);
        panel.add(left);
        panel.add(right);
        panel.setWidth("100%");
        return panel;
    }

    private void executeOnValueChangeCommand() {
        if (this.onValueChangeCommand != null) {
            this.onValueChangeCommand.execute();
        }
    }

    public boolean isDirty() {
        return super.isDirty();
    }

    public void setOnValueChangeCommand(Command onValueChangeCommand) {
        this.onValueChangeCommand = onValueChangeCommand;
    }

    static /* synthetic */ BaseSingleFieldConstraint access$000(ConstraintValueEditor x0) {
        return x0.constraint;
    }

    static /* synthetic */ void access$100(ConstraintValueEditor x0, Widget x1, BaseSingleFieldConstraint x2) {
        x0.showTypeChoice(x1, x2);
    }

    static /* synthetic */ void access$200(ConstraintValueEditor x0) {
        x0.executeOnValueChangeCommand();
    }

    static /* synthetic */ void access$300(ConstraintValueEditor x0, FormStylePopup x1) {
        x0.doTypeChosen(x1);
    }

    static /* synthetic */ boolean access$400(ConstraintValueEditor x0) {
        return x0.isDropDownDataEnum;
    }
}

